/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.PolicyTags;
import com.google.cloud.bigquery.Schema;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SchemaTest {
    private static PolicyTags POLICY_TAGS = PolicyTags.newBuilder().setNames((List)ImmutableList.of((Object)"someTag")).build();
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").setPrecision(Long.valueOf(20L)).setScale(Long.valueOf(20L)).setMaxLength(Long.valueOf(10L)).build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").setPolicyTags(POLICY_TAGS).build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final List<Field> FIELDS = ImmutableList.of((Object)FIELD_SCHEMA1, (Object)FIELD_SCHEMA2, (Object)FIELD_SCHEMA3);
    private static final Schema TABLE_SCHEMA = Schema.of(FIELDS);

    @Test
    public void testOf() {
        this.compareTableSchema(TABLE_SCHEMA, Schema.of(FIELDS));
    }

    @Test
    public void testToAndFromPb() {
        this.compareTableSchema(TABLE_SCHEMA, Schema.fromPb((TableSchema)TABLE_SCHEMA.toPb()));
    }

    private void compareTableSchema(Schema expected, Schema value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getFields(), (Object)value.getFields());
    }

    @Test
    public void testEmptySchema() {
        TableSchema tableSchema = new TableSchema();
        Schema schema = Schema.fromPb((TableSchema)tableSchema);
        Assert.assertEquals((long)0L, (long)schema.getFields().size());
    }
}

