/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.cloud.BaseSerializationTest;
import com.google.cloud.NoCredentials;
import com.google.cloud.PageImpl;
import com.google.cloud.Restorable;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class SerializationTest
extends BaseSerializationTest {
    private static final Acl DOMAIN_ACCESS = Acl.of((Acl.Entity)new Acl.Domain("domain"), (Acl.Role)Acl.Role.WRITER);
    private static final Acl GROUP_ACCESS = Acl.of((Acl.Entity)Acl.Group.ofAllAuthenticatedUsers(), (Acl.Role)Acl.Role.READER);
    private static final Acl USER_ACCESS = Acl.of((Acl.Entity)new Acl.User("user"), (Acl.Role)Acl.Role.OWNER);
    private static final Acl VIEW_ACCESS = Acl.of((Acl.Entity)new Acl.View(TableId.of((String)"project", (String)"dataset", (String)"table")), (Acl.Role)Acl.Role.WRITER);
    private static final Acl ROUTINE_ACCESS = Acl.of((Acl.Entity)new Acl.Routine(RoutineId.of((String)"project", (String)"dataset", (String)"routine")), (Acl.Role)Acl.Role.WRITER);
    private static final Long CREATION_TIME = System.currentTimeMillis() - 10L;
    private static final Long DEFAULT_TABLE_EXPIRATION = 100L;
    private static final String DESCRIPTION = "Description";
    private static final String ETAG = "0xFF00";
    private static final String FRIENDLY_NAME = "friendlyDataset";
    private static final String GENERATED_ID = "P/D:1";
    private static final Long LAST_MODIFIED = CREATION_TIME + 50L;
    private static final String LOCATION = "";
    private static final String SELF_LINK = "http://bigquery/p/d";
    private static final DatasetId DATASET_ID = DatasetId.of((String)"project", (String)"dataset");
    private static final List<String> TARGET_TYPES = ImmutableList.of((Object)"VIEWS");
    private static final Acl DATASET_ACCESS = Acl.of((Acl.DatasetAclEntity)new Acl.DatasetAclEntity(DATASET_ID, TARGET_TYPES));
    private static final List<Acl> ACCESS_RULES = ImmutableList.of((Object)DOMAIN_ACCESS, (Object)GROUP_ACCESS, (Object)VIEW_ACCESS, (Object)ROUTINE_ACCESS, (Object)USER_ACCESS, (Object)DATASET_ACCESS);
    private static final DatasetInfo DATASET_INFO = DatasetInfo.newBuilder((DatasetId)DATASET_ID).setAcl(ACCESS_RULES).setCreationTime(CREATION_TIME).setDefaultTableLifetime(DEFAULT_TABLE_EXPIRATION).setDescription("Description").setEtag("0xFF00").setFriendlyName("friendlyDataset").setGeneratedId("P/D:1").setLastModified(LAST_MODIFIED).setLocation("").setSelfLink("http://bigquery/p/d").build();
    private static final TableId TABLE_ID = TableId.of((String)"project", (String)"dataset", (String)"table");
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().setAllowJaggedRows(true).setAllowQuotedNewLines(false).setEncoding(StandardCharsets.ISO_8859_1).setFieldDelimiter(",").setQuote("\"").setSkipLeadingRows(42L).build();
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final StandardTableDefinition.StreamingBuffer STREAMING_BUFFER = new StandardTableDefinition.StreamingBuffer(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L));
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(42)).build();
    private static final UserDefinedFunction INLINE_FUNCTION = new UserDefinedFunction.InlineFunction("inline");
    private static final UserDefinedFunction URI_FUNCTION = new UserDefinedFunction.UriFunction("URI");
    private static final TableDefinition TABLE_DEFINITION = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setLocation("").setStreamingBuffer(STREAMING_BUFFER).build();
    private static final TableInfo TABLE_INFO = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION).setCreationTime(CREATION_TIME).setDescription("Description").setEtag("0xFF00").setGeneratedId("P/D:1").build();
    private static final TableDefinition VIEW_DEFINITION = ViewDefinition.of((String)"QUERY");
    private static final TableInfo VIEW_INFO = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)VIEW_DEFINITION).setCreationTime(CREATION_TIME).setDescription("Description").setEtag("0xFF00").setGeneratedId("P/D:1").build();
    private static final TableInfo EXTERNAL_TABLE_INFO = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)EXTERNAL_TABLE_DEFINITION).setCreationTime(CREATION_TIME).setDescription("Description").setEtag("0xFF00").setGeneratedId("P/D:1").build();
    private static final JobStatistics.CopyStatistics COPY_STATISTICS = ((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)((JobStatistics.CopyStatistics.Builder)JobStatistics.CopyStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).build();
    private static final JobStatistics.ExtractStatistics EXTRACT_STATISTICS = ((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)((JobStatistics.ExtractStatistics.Builder)JobStatistics.ExtractStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).setDestinationUriFileCounts((List)ImmutableList.of((Object)42L)).build();
    private static final JobStatistics.LoadStatistics LOAD_STATISTICS = ((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)((JobStatistics.LoadStatistics.Builder)JobStatistics.LoadStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).setInputFiles(Long.valueOf(42L)).setOutputBytes(Long.valueOf(1024L)).setInputBytes(Long.valueOf(2048L)).setOutputRows(Long.valueOf(24L)).build();
    private static final JobStatistics.QueryStatistics QUERY_STATISTICS = ((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)((JobStatistics.QueryStatistics.Builder)JobStatistics.QueryStatistics.newBuilder().setCreationTimestamp(Long.valueOf(1L))).setEndTime(Long.valueOf(3L))).setStartTime(Long.valueOf(2L))).setTotalBytesProcessed(Long.valueOf(2048L)).setTotalBytesBilled(Long.valueOf(1024L)).setCacheHit(Boolean.valueOf(false)).setBillingTier(Integer.valueOf(42)).build();
    private static final BigQueryError BIGQUERY_ERROR = new BigQueryError("reason", "location", "message", "debugInfo");
    private static final JobStatus JOB_STATUS = new JobStatus(JobStatus.State.DONE, BIGQUERY_ERROR, (List)ImmutableList.of((Object)BIGQUERY_ERROR));
    private static final JobId JOB_ID = JobId.of((String)"project", (String)"job");
    private static final Long NUM_DL_AFFECTED_ROWS = 24L;
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID, (TableId)TABLE_ID);
    private static final ExtractJobConfiguration EXTRACT_JOB_CONFIGURATION = ExtractJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
    private static final WriteChannelConfiguration LOAD_CONFIGURATION = WriteChannelConfiguration.newBuilder((TableId)TABLE_ID).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(JobInfo.WriteDisposition.WRITE_APPEND).setFormatOptions((FormatOptions)CSV_OPTIONS).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(10)).setSchema(TABLE_SCHEMA).build();
    private static final LoadJobConfiguration LOAD_JOB_CONFIGURATION = LoadJobConfiguration.of((TableId)TABLE_ID, SOURCE_URIS);
    private static final QueryJobConfiguration QUERY_JOB_CONFIGURATION = QueryJobConfiguration.of((String)"query");
    private static final JobInfo JOB_INFO = JobInfo.of((JobConfiguration)COPY_JOB_CONFIGURATION);
    private static final Map<String, Object> CONTENT1 = ImmutableMap.of((Object)"key", (Object)"val1");
    private static final Map<String, Object> CONTENT2 = ImmutableMap.of((Object)"key", (Object)"val2");
    private static final InsertAllRequest INSERT_ALL_REQUEST = InsertAllRequest.newBuilder((TableId)TABLE_ID).addRow(CONTENT1).addRow(CONTENT2).setIgnoreUnknownValues(true).setSkipInvalidRows(false).build();
    private static final Map<Long, List<BigQueryError>> ERRORS_MAP = ImmutableMap.of((Object)0L, (Object)ImmutableList.of((Object)BIGQUERY_ERROR));
    private static final InsertAllResponse INSERT_ALL_RESPONSE = new InsertAllResponse(ERRORS_MAP);
    private static final FieldValue FIELD_VALUE = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"value");
    private static final TableResult TABLE_RESULT = TableResult.newBuilder().setSchema(Schema.of((Field[])new Field[0])).setTotalRows(Long.valueOf(0L)).setPageNoSchema((Page)new PageImpl(null, "", (Iterable)ImmutableList.of())).build();
    private static final BigQuery BIGQUERY = (BigQuery)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId("p1")).build().getService();
    private static final Dataset DATASET = new Dataset(BIGQUERY, new DatasetInfo.BuilderImpl(DATASET_INFO));
    private static final Table TABLE = new Table(BIGQUERY, new TableInfo.BuilderImpl(TABLE_INFO));
    private static final Job JOB = new Job(BIGQUERY, new JobInfo.BuilderImpl(JOB_INFO));
    private static final BigQueryException BIG_QUERY_EXCEPTION = new BigQueryException(42, "message", BIGQUERY_ERROR);
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY, (long)42L);

    protected Serializable[] serializableObjects() {
        BigQueryOptions options = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId("p1")).setCredentials((Credentials)NoCredentials.getInstance())).build();
        BigQueryOptions otherOptions = ((BigQueryOptions.Builder)options.toBuilder().setProjectId("p2")).build();
        return new Serializable[]{DOMAIN_ACCESS, GROUP_ACCESS, USER_ACCESS, VIEW_ACCESS, ROUTINE_ACCESS, DATASET_ACCESS, DATASET_ID, DATASET_INFO, TABLE_ID, CSV_OPTIONS, STREAMING_BUFFER, TABLE_DEFINITION, EXTERNAL_TABLE_DEFINITION, VIEW_DEFINITION, TABLE_SCHEMA, TABLE_INFO, VIEW_INFO, EXTERNAL_TABLE_INFO, INLINE_FUNCTION, URI_FUNCTION, COPY_STATISTICS, EXTRACT_STATISTICS, LOAD_STATISTICS, QUERY_STATISTICS, BIGQUERY_ERROR, JOB_STATUS, JOB_ID, COPY_JOB_CONFIGURATION, EXTRACT_JOB_CONFIGURATION, LOAD_CONFIGURATION, LOAD_JOB_CONFIGURATION, QUERY_JOB_CONFIGURATION, JOB_INFO, INSERT_ALL_REQUEST, INSERT_ALL_RESPONSE, FIELD_VALUE, BIG_QUERY_EXCEPTION, TIME_PARTITIONING, TABLE_RESULT, BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[0]), BigQuery.DatasetDeleteOption.deleteContents(), BigQuery.DatasetListOption.all(), BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0]), BigQuery.TableListOption.pageSize((long)42L), BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[0]), BigQuery.JobListOption.allUsers(), DATASET, TABLE, JOB, options, otherOptions};
    }

    protected Restorable<?>[] restorableObjects() {
        BigQueryOptions options = ((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId("p2")).build();
        TableDataWriteChannel writer = new TableDataWriteChannel(options, LOAD_CONFIGURATION, "upload-id");
        return new Restorable[]{writer};
    }
}

