/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.SnapshotTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotTableDefinitionTest {
    private static final TableId BASE_TABLE_ID = TableId.of((String)"DATASET_NAME", (String)"BASE_TABLE_NAME");
    private static final String SNAPSHOT_TIME = "2021-05-19T11:32:26.553Z";
    private static final SnapshotTableDefinition SNAPSHOTTABLE_DEFINITION = SnapshotTableDefinition.newBuilder().setBaseTableId(BASE_TABLE_ID).setSnapshotTime("2021-05-19T11:32:26.553Z").build();

    @Test
    public void testToBuilder() {
        this.compareSnapshotTableDefinition(SNAPSHOTTABLE_DEFINITION, SNAPSHOTTABLE_DEFINITION.toBuilder().build());
        SnapshotTableDefinition snapshotTableDefinition = SNAPSHOTTABLE_DEFINITION.toBuilder().setSnapshotTime("2021-05-20T11:32:26.553Z").build();
        Assert.assertEquals((Object)"2021-05-20T11:32:26.553Z", (Object)snapshotTableDefinition.getSnapshotTime());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TableDefinition.Type.SNAPSHOT, (Object)SNAPSHOTTABLE_DEFINITION.getType());
        Assert.assertEquals((Object)BASE_TABLE_ID, (Object)SNAPSHOTTABLE_DEFINITION.getBaseTableId());
        Assert.assertEquals((Object)SNAPSHOT_TIME, (Object)SNAPSHOTTABLE_DEFINITION.getSnapshotTime());
        SnapshotTableDefinition snapshotTableDefinition = SnapshotTableDefinition.newBuilder().setBaseTableId(BASE_TABLE_ID).setSnapshotTime(SNAPSHOT_TIME).build();
        Assert.assertEquals((Object)SNAPSHOTTABLE_DEFINITION, (Object)snapshotTableDefinition);
    }

    @Test
    public void testToAndFromPb() {
        SnapshotTableDefinition snapshotTableDefinition = SNAPSHOTTABLE_DEFINITION.toBuilder().build();
        Assert.assertTrue((boolean)(TableDefinition.fromPb((Table)snapshotTableDefinition.toPb()) instanceof SnapshotTableDefinition));
        this.compareSnapshotTableDefinition(snapshotTableDefinition, (SnapshotTableDefinition)TableDefinition.fromPb((Table)snapshotTableDefinition.toPb()));
    }

    private void compareSnapshotTableDefinition(SnapshotTableDefinition expected, SnapshotTableDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getBaseTableId(), (Object)value.getBaseTableId());
        Assert.assertEquals((Object)expected.getSnapshotTime(), (Object)value.getSnapshotTime());
    }
}

