/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.StandardSqlDataType;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardSQLField;
import com.google.cloud.bigquery.StandardSQLStructType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StandardSQLDataTypeTest {
    private static final String STRING_TYPEKIND = "STRING";
    private static final String ARRAY_TYPEKIND = "ARRAY";
    private static final String STRUCT_TYPEKIND = "STRUCT";
    private static final StandardSQLDataType STRING_DATA_TYPE = StandardSQLDataType.newBuilder((String)"STRING").build();
    private static final StandardSQLDataType ARRAY_OF_STRING_DATA_TYPE = StandardSQLDataType.newBuilder((String)"ARRAY").setArrayElementType(STRING_DATA_TYPE).build();
    private static final List<StandardSQLField> FIELD_LIST = ImmutableList.of((Object)StandardSQLField.newBuilder((StandardSQLDataType)STRING_DATA_TYPE).build(), (Object)StandardSQLField.newBuilder((StandardSQLDataType)ARRAY_OF_STRING_DATA_TYPE).build());
    private static final StandardSQLStructType STRUCT_TYPE = StandardSQLStructType.newBuilder(FIELD_LIST).build();
    private static final StandardSQLDataType STRUCT_DATA_TYPE = StandardSQLDataType.newBuilder((String)"STRUCT").setStructType(STRUCT_TYPE).build();

    @Test
    public void testToBuilder() {
        this.compareStandardSQLDataType(STRING_DATA_TYPE, STRING_DATA_TYPE.toBuilder().build());
        this.compareStandardSQLDataType(ARRAY_OF_STRING_DATA_TYPE, ARRAY_OF_STRING_DATA_TYPE.toBuilder().build());
        this.compareStandardSQLDataType(STRUCT_DATA_TYPE, STRUCT_DATA_TYPE.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)STRING_TYPEKIND, (Object)STRING_DATA_TYPE.getTypeKind());
        Assert.assertEquals((Object)ARRAY_TYPEKIND, (Object)ARRAY_OF_STRING_DATA_TYPE.getTypeKind());
        Assert.assertEquals((Object)STRING_DATA_TYPE, (Object)ARRAY_OF_STRING_DATA_TYPE.getArrayElementType());
        Assert.assertEquals((Object)STRUCT_TYPE, (Object)STRUCT_DATA_TYPE.getStructType());
    }

    @Test
    public void testToAndFromPb() {
        this.compareStandardSQLDataType(ARRAY_OF_STRING_DATA_TYPE, StandardSQLDataType.fromPb((StandardSqlDataType)ARRAY_OF_STRING_DATA_TYPE.toPb()));
    }

    private void compareStandardSQLDataType(StandardSQLDataType expected, StandardSQLDataType value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getTypeKind(), (Object)value.getTypeKind());
        Assert.assertEquals((Object)expected.getArrayElementType(), (Object)value.getArrayElementType());
        Assert.assertEquals((Object)expected.getStructType(), (Object)value.getStructType());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

