/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.StandardSqlField;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardSQLField;
import org.junit.Assert;
import org.junit.Test;

public class StandardSQLFieldTest {
    private static final String NAME = "field_name";
    private static final StandardSQLDataType STRING_DATA_TYPE = StandardSQLDataType.newBuilder((String)"STRING").build();
    private static final StandardSQLDataType ARRAY_OF_STRING_DATA_TYPE = StandardSQLDataType.newBuilder((String)"ARRAY").setArrayElementType(STRING_DATA_TYPE).build();
    private static final StandardSQLField STANDARD_SQL_FIELD_1 = StandardSQLField.newBuilder((StandardSQLDataType)STRING_DATA_TYPE).build();
    private static final StandardSQLField STANDARD_SQL_FIELD_2 = StandardSQLField.newBuilder((String)"field_name", (StandardSQLDataType)ARRAY_OF_STRING_DATA_TYPE).build();

    @Test
    public void testToBuilder() {
        this.compareStandardSQLField(STANDARD_SQL_FIELD_1, STANDARD_SQL_FIELD_1.toBuilder().build());
        this.compareStandardSQLField(STANDARD_SQL_FIELD_2, STANDARD_SQL_FIELD_2.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals(null, (Object)STANDARD_SQL_FIELD_1.getName());
        Assert.assertEquals((Object)STRING_DATA_TYPE, (Object)STANDARD_SQL_FIELD_1.getDataType());
        Assert.assertEquals((Object)ARRAY_OF_STRING_DATA_TYPE, (Object)STANDARD_SQL_FIELD_2.getDataType());
    }

    @Test
    public void testToAndFromPb() {
        this.compareStandardSQLField(STANDARD_SQL_FIELD_1, StandardSQLField.fromPb((StandardSqlField)STANDARD_SQL_FIELD_1.toPb()));
    }

    private void compareStandardSQLField(StandardSQLField expected, StandardSQLField value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getName(), (Object)value.getName());
        Assert.assertEquals((Object)expected.getDataType(), (Object)value.getDataType());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

