/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.StandardSqlStructType;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardSQLField;
import com.google.cloud.bigquery.StandardSQLStructType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StandardSQLStructTypeTest {
    private static final StandardSQLField FIELD_1 = StandardSQLField.newBuilder((String)"FIELD_1", (StandardSQLDataType)StandardSQLDataType.newBuilder((String)"STRING").build()).build();
    private static final StandardSQLField FIELD_2 = StandardSQLField.newBuilder((String)"FIELD_2", (StandardSQLDataType)StandardSQLDataType.newBuilder((String)"FLOAT64").build()).build();
    private static final List<StandardSQLField> FIELD_LIST = ImmutableList.of((Object)FIELD_1, (Object)FIELD_2);
    private static final StandardSQLStructType STRUCT_TYPE = StandardSQLStructType.newBuilder(FIELD_LIST).build();

    @Test
    public void testToBuilder() {
        this.compareStandardSQLStructType(STRUCT_TYPE, STRUCT_TYPE.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)FIELD_1, STRUCT_TYPE.getFields().get(0));
        Assert.assertEquals((Object)FIELD_2, STRUCT_TYPE.getFields().get(1));
    }

    @Test
    public void testToAndFromPb() {
        this.compareStandardSQLStructType(STRUCT_TYPE, StandardSQLStructType.fromPb((StandardSqlStructType)STRUCT_TYPE.toPb()));
    }

    private void compareStandardSQLStructType(StandardSQLStructType expected, StandardSQLStructType value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getFields(), (Object)value.getFields());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

