/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.StandardSqlTableType;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardSQLField;
import com.google.cloud.bigquery.StandardSQLTableType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StandardSQLTableTypeTest {
    private static final StandardSQLField COLUMN_1 = StandardSQLField.newBuilder((String)"COLUMN_1", (StandardSQLDataType)StandardSQLDataType.newBuilder((String)"STRING").build()).build();
    private static final StandardSQLField COLUMN_2 = StandardSQLField.newBuilder((String)"COLUMN_2", (StandardSQLDataType)StandardSQLDataType.newBuilder((String)"FLOAT64").build()).build();
    private static final List<StandardSQLField> COLUMN_LIST = ImmutableList.of((Object)COLUMN_1, (Object)COLUMN_2);
    private static final StandardSQLTableType TABLE_TYPE = StandardSQLTableType.newBuilder(COLUMN_LIST).build();

    @Test
    public void testToBuilder() {
        this.compareStandardSQLTableType(TABLE_TYPE, TABLE_TYPE.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)COLUMN_1, TABLE_TYPE.getColumns().get(0));
        Assert.assertEquals((Object)COLUMN_2, TABLE_TYPE.getColumns().get(1));
    }

    @Test
    public void testToAndFromPb() {
        this.compareStandardSQLTableType(TABLE_TYPE, StandardSQLTableType.fromPb((StandardSqlTableType)TABLE_TYPE.toPb()));
    }

    private void compareStandardSQLTableType(StandardSQLTableType expected, StandardSQLTableType value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getColumns(), (Object)value.getColumns());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

