/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Streamingbuffer;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.BigLakeConfiguration;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StandardTableDefinitionTest {
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Long NUM_BYTES = 42L;
    private static final Long NUM_LONG_TERM_BYTES = 18L;
    private static final Long NUM_TIME_TRAVEL_PHYSICAL_BYTES = 21L;
    private static final Long NUM_TOTAL_LOGICAL_BYTES = 22L;
    private static final Long NUM_ACTIVE_LOGICAL_BYTES = 23L;
    private static final Long NUM_LONG_TERM_LOGICAL_BYTES = 24L;
    private static final Long NUM_TOTAL_PHYSICAL_BYTES = 25L;
    private static final Long NUM_ACTIVE_PHYSICAL_BYTES = 26L;
    private static final Long NUM_LONG_TERM_PHYSICAL_BYTES = 27L;
    private static final Long NUM_ROWS = 43L;
    private static final String LOCATION = "US";
    private static final StandardTableDefinition.StreamingBuffer STREAMING_BUFFER = new StandardTableDefinition.StreamingBuffer(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L));
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY, (long)42L);
    private static final Clustering CLUSTERING = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)"Foo", (Object)"Bar")).build();
    private static final BigLakeConfiguration BIG_LAKE_CONFIGURATION = BigLakeConfiguration.newBuilder().setConnectionId("us.connection-test").setTableFormat("ICEBERG").setFileFormat("PARQUET").setStorageUri("gs://java-bigquery-test/standard-table-def").build();
    private static final StandardTableDefinition TABLE_DEFINITION = StandardTableDefinition.newBuilder().setLocation("US").setNumBytes(NUM_BYTES).setNumRows(NUM_ROWS).setNumLongTermBytes(NUM_LONG_TERM_BYTES).setNumTimeTravelPhysicalBytes(NUM_TIME_TRAVEL_PHYSICAL_BYTES).setNumTotalLogicalBytes(NUM_TOTAL_LOGICAL_BYTES).setNumActiveLogicalBytes(NUM_ACTIVE_LOGICAL_BYTES).setNumLongTermLogicalBytes(NUM_LONG_TERM_LOGICAL_BYTES).setNumTotalPhysicalBytes(NUM_TOTAL_PHYSICAL_BYTES).setNumActivePhysicalBytes(NUM_ACTIVE_PHYSICAL_BYTES).setNumLongTermPhysicalBytes(NUM_LONG_TERM_PHYSICAL_BYTES).setStreamingBuffer(STREAMING_BUFFER).setSchema(TABLE_SCHEMA).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setBigLakeConfiguration(BIG_LAKE_CONFIGURATION).build();

    @Test
    public void testToBuilder() {
        this.compareStandardTableDefinition(TABLE_DEFINITION, TABLE_DEFINITION.toBuilder().build());
        StandardTableDefinition tableDefinition = TABLE_DEFINITION.toBuilder().setLocation("EU").build();
        Assert.assertEquals((Object)"EU", (Object)tableDefinition.getLocation());
        tableDefinition = tableDefinition.toBuilder().setLocation(LOCATION).build();
        this.compareStandardTableDefinition(TABLE_DEFINITION, tableDefinition);
    }

    @Test
    public void testToBuilderIncomplete() {
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        Assert.assertEquals((Object)tableDefinition, (Object)tableDefinition.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)TABLE_DEFINITION.getType());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)TABLE_DEFINITION.getSchema());
        Assert.assertEquals((Object)LOCATION, (Object)TABLE_DEFINITION.getLocation());
        Assert.assertEquals((Object)NUM_BYTES, (Object)TABLE_DEFINITION.getNumBytes());
        Assert.assertEquals((Object)NUM_LONG_TERM_BYTES, (Object)TABLE_DEFINITION.getNumLongTermBytes());
        Assert.assertEquals((Object)NUM_TIME_TRAVEL_PHYSICAL_BYTES, (Object)TABLE_DEFINITION.getNumTimeTravelPhysicalBytes());
        Assert.assertEquals((Object)NUM_TOTAL_LOGICAL_BYTES, (Object)TABLE_DEFINITION.getNumTotalLogicalBytes());
        Assert.assertEquals((Object)NUM_ACTIVE_LOGICAL_BYTES, (Object)TABLE_DEFINITION.getNumActiveLogicalBytes());
        Assert.assertEquals((Object)NUM_LONG_TERM_LOGICAL_BYTES, (Object)TABLE_DEFINITION.getNumLongTermLogicalBytes());
        Assert.assertEquals((Object)NUM_TOTAL_PHYSICAL_BYTES, (Object)TABLE_DEFINITION.getNumTotalPhysicalBytes());
        Assert.assertEquals((Object)NUM_ACTIVE_PHYSICAL_BYTES, (Object)TABLE_DEFINITION.getNumActivePhysicalBytes());
        Assert.assertEquals((Object)NUM_LONG_TERM_PHYSICAL_BYTES, (Object)TABLE_DEFINITION.getNumLongTermPhysicalBytes());
        Assert.assertEquals((Object)NUM_ROWS, (Object)TABLE_DEFINITION.getNumRows());
        Assert.assertEquals((Object)STREAMING_BUFFER, (Object)TABLE_DEFINITION.getStreamingBuffer());
        Assert.assertEquals((Object)TIME_PARTITIONING, (Object)TABLE_DEFINITION.getTimePartitioning());
        Assert.assertEquals((Object)CLUSTERING, (Object)TABLE_DEFINITION.getClustering());
        Assert.assertNotEquals((Object)TABLE_DEFINITION, (Object)TableDefinition.Type.TABLE);
    }

    @Test
    public void testTypeNullPointerException() {
        try {
            TABLE_DEFINITION.toBuilder().setType(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testOf() {
        StandardTableDefinition definition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)TABLE_DEFINITION.getType());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)TABLE_DEFINITION.getSchema());
        Assert.assertNull((Object)definition.getLocation());
        Assert.assertNull((Object)definition.getNumBytes());
        Assert.assertNull((Object)definition.getNumLongTermBytes());
        Assert.assertNull((Object)definition.getNumTimeTravelPhysicalBytes());
        Assert.assertNull((Object)definition.getNumTotalLogicalBytes());
        Assert.assertNull((Object)definition.getNumActiveLogicalBytes());
        Assert.assertNull((Object)definition.getNumLongTermLogicalBytes());
        Assert.assertNull((Object)definition.getNumTotalPhysicalBytes());
        Assert.assertNull((Object)definition.getNumActivePhysicalBytes());
        Assert.assertNull((Object)definition.getNumLongTermPhysicalBytes());
        Assert.assertNull((Object)definition.getNumRows());
        Assert.assertNull((Object)definition.getStreamingBuffer());
        Assert.assertNull((Object)definition.getTimePartitioning());
        Assert.assertNull((Object)definition.getClustering());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(TableDefinition.fromPb((Table)TABLE_DEFINITION.toPb()) instanceof StandardTableDefinition));
        this.compareStandardTableDefinition(TABLE_DEFINITION, (StandardTableDefinition)TableDefinition.fromPb((Table)TABLE_DEFINITION.toPb()));
        StandardTableDefinition definition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        Assert.assertTrue((boolean)(TableDefinition.fromPb((Table)definition.toPb()) instanceof StandardTableDefinition));
        this.compareStandardTableDefinition(definition, (StandardTableDefinition)TableDefinition.fromPb((Table)definition.toPb()));
    }

    @Test
    public void testFromPbWithUnexpectedTimePartitioningTypeRaisesInvalidArgumentException() {
        Table invalidTable = new Table().setType("TABLE").setTableReference(new TableReference().setProjectId("ILLEGAL_ARG_TEST_PROJECT").setDatasetId("ILLEGAL_ARG_TEST_DATASET").setTableId("ILLEGAL_ARG_TEST_TABLE")).setTimePartitioning(new com.google.api.services.bigquery.model.TimePartitioning().setType("GHURRY"));
        try {
            StandardTableDefinition.fromPb((Table)invalidTable);
        }
        catch (IllegalArgumentException ie) {
            Truth.assertThat((String)ie.getMessage()).contains((CharSequence)"Illegal Argument - Got unexpected time partitioning GHURRY in project ILLEGAL_ARG_TEST_PROJECT in dataset ILLEGAL_ARG_TEST_DATASET in table ILLEGAL_ARG_TEST_TABLE");
            return;
        }
        Assert.fail((String)"testFromPb illegal argument exception did not throw!");
    }

    @Test
    public void testFromPbWithNullEstimatedRowsAndBytes() {
        StandardTableDefinition.fromPb((Table)TABLE_DEFINITION.toPb().setStreamingBuffer(new Streamingbuffer()));
    }

    @Test
    public void testStreamingBufferWithNullFieldsToPb() {
        new StandardTableDefinition.StreamingBuffer(null, null, null).toPb();
    }

    private void compareStandardTableDefinition(StandardTableDefinition expected, StandardTableDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getSchema(), (Object)value.getSchema());
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((Object)expected.getNumBytes(), (Object)value.getNumBytes());
        Assert.assertEquals((Object)expected.getNumLongTermBytes(), (Object)value.getNumLongTermBytes());
        Assert.assertEquals((Object)expected.getNumTimeTravelPhysicalBytes(), (Object)value.getNumTimeTravelPhysicalBytes());
        Assert.assertEquals((Object)expected.getNumTotalLogicalBytes(), (Object)value.getNumTotalLogicalBytes());
        Assert.assertEquals((Object)expected.getNumActiveLogicalBytes(), (Object)value.getNumActiveLogicalBytes());
        Assert.assertEquals((Object)expected.getNumLongTermLogicalBytes(), (Object)value.getNumLongTermLogicalBytes());
        Assert.assertEquals((Object)expected.getNumTotalPhysicalBytes(), (Object)value.getNumTotalPhysicalBytes());
        Assert.assertEquals((Object)expected.getNumActivePhysicalBytes(), (Object)value.getNumActivePhysicalBytes());
        Assert.assertEquals((Object)expected.getNumLongTermPhysicalBytes(), (Object)value.getNumLongTermPhysicalBytes());
        Assert.assertEquals((Object)expected.getNumRows(), (Object)value.getNumRows());
        Assert.assertEquals((Object)expected.getLocation(), (Object)value.getLocation());
        Assert.assertEquals((Object)expected.getStreamingBuffer(), (Object)value.getStreamingBuffer());
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((Object)expected.getTimePartitioning(), (Object)value.getTimePartitioning());
        Assert.assertEquals((Object)expected.getClustering(), (Object)value.getClustering());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

