/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.ColumnReference;
import com.google.cloud.bigquery.ForeignKey;
import com.google.cloud.bigquery.PrimaryKey;
import com.google.cloud.bigquery.TableConstraints;
import com.google.cloud.bigquery.TableId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TableConstraintsTest {
    private static final List<String> COLUMNS_PK = Arrays.asList("column1", "column2");
    private static final PrimaryKey PRIMARY_KEY = PrimaryKey.newBuilder().setColumns(COLUMNS_PK).build();
    private static final TableId TABLE_ID_PK = TableId.of((String)"project", (String)"dataset", (String)"table");
    private static final ColumnReference COLUMN_REFERENCE = ColumnReference.newBuilder().setReferencingColumn("column1").setReferencedColumn("column2").build();
    private static final ForeignKey FOREIGN_KEY = ForeignKey.newBuilder().setName("foreign_key").setReferencedTable(TABLE_ID_PK).setColumnReferences(Collections.singletonList(COLUMN_REFERENCE)).build();
    private static final TableConstraints TABLE_CONSTRAINTS = TableConstraints.newBuilder().setPrimaryKey(PRIMARY_KEY).setForeignKeys(Collections.singletonList(FOREIGN_KEY)).build();

    @Test
    public void testToBuilder() {
        this.compareTableConstraintsDefinition(TABLE_CONSTRAINTS, TABLE_CONSTRAINTS.toBuilder().build());
        List<String> columnsPk = Arrays.asList("col1", "col2", "col3");
        PrimaryKey primaryKey = PrimaryKey.newBuilder().setColumns(columnsPk).build();
        TableId referencedTable = TableId.of((String)"project1", (String)"dataset1", (String)"table1");
        TableId referencedTable2 = TableId.of((String)"project2", (String)"dataset2", (String)"table2");
        ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>();
        columnReferences.add(ColumnReference.newBuilder().setReferencingColumn("from").setReferencedColumn("to").build());
        columnReferences.add(ColumnReference.newBuilder().setReferencingColumn("from2").setReferencedColumn("to2").build());
        ForeignKey foreignKey1 = ForeignKey.newBuilder().setName("test").setReferencedTable(referencedTable).setColumnReferences(columnReferences).build();
        ForeignKey foreignKey2 = ForeignKey.newBuilder().setName("test").setReferencedTable(referencedTable2).setColumnReferences(columnReferences).build();
        TableConstraints tableConstraints = TABLE_CONSTRAINTS.toBuilder().setForeignKeys(Arrays.asList(foreignKey1, foreignKey2)).setPrimaryKey(primaryKey).build();
        Assert.assertEquals(Arrays.asList(foreignKey1, foreignKey2), (Object)tableConstraints.getForeignKeys());
        Assert.assertEquals((Object)primaryKey, (Object)tableConstraints.getPrimaryKey());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals(Collections.singletonList(FOREIGN_KEY), (Object)TABLE_CONSTRAINTS.getForeignKeys());
        Assert.assertEquals((Object)PRIMARY_KEY, (Object)TABLE_CONSTRAINTS.getPrimaryKey());
        TableConstraints tableConstraints = TABLE_CONSTRAINTS.newBuilder().setForeignKeys(Collections.singletonList(FOREIGN_KEY)).setPrimaryKey(PRIMARY_KEY).build();
        Assert.assertEquals((Object)TABLE_CONSTRAINTS, (Object)tableConstraints);
    }

    @Test
    public void testToAndFromPb() {
        TableConstraints tableConstraints = TABLE_CONSTRAINTS.toBuilder().build();
        Assert.assertTrue((boolean)(TableConstraints.fromPb((com.google.api.services.bigquery.model.TableConstraints)tableConstraints.toPb()) instanceof TableConstraints));
        this.compareTableConstraintsDefinition(tableConstraints, TableConstraints.fromPb((com.google.api.services.bigquery.model.TableConstraints)tableConstraints.toPb()));
    }

    private void compareTableConstraintsDefinition(TableConstraints expected, TableConstraints value) {
        Assert.assertEquals((Object)expected.getForeignKeys(), (Object)value.getForeignKeys());
        Assert.assertEquals((Object)expected.getPrimaryKey(), (Object)value.getPrimaryKey());
    }
}

