/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.RestorableState;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryFactory;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.spi.ServiceRpcFactory;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TableDataWriteChannelTest {
    private static final String UPLOAD_ID = "uploadid";
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final WriteChannelConfiguration LOAD_CONFIGURATION = WriteChannelConfiguration.newBuilder((TableId)TABLE_ID).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(JobInfo.WriteDisposition.WRITE_APPEND).setFormatOptions(FormatOptions.json()).setIgnoreUnknownValues(Boolean.valueOf(true)).setMaxBadRecords(Integer.valueOf(10)).build();
    private static final int MIN_CHUNK_SIZE = 262144;
    private static final int DEFAULT_CHUNK_SIZE = 0xF00000;
    private static final int CUSTOM_CHUNK_SIZE = 0x100000;
    private static final Random RANDOM = new Random();
    private static final LoadJobConfiguration JOB_CONFIGURATION = LoadJobConfiguration.of((TableId)TABLE_ID, (String)"URI");
    private static final JobInfo JOB_INFO = JobInfo.of((JobId)JobId.of(), (JobConfiguration)JOB_CONFIGURATION);
    private BigQueryOptions options;
    private BigQueryRpcFactory rpcFactoryMock;
    private BigQueryRpc bigqueryRpcMock;
    private BigQueryFactory bigqueryFactoryMock;
    private BigQuery bigqueryMock;
    private Job job;
    @Captor
    private ArgumentCaptor<byte[]> capturedBuffer;
    @Captor
    private ArgumentCaptor<Long> capturedPosition;
    private TableDataWriteChannel writer;

    @Before
    public void setUp() {
        this.rpcFactoryMock = (BigQueryRpcFactory)Mockito.mock(BigQueryRpcFactory.class);
        this.bigqueryRpcMock = (BigQueryRpc)Mockito.mock(BigQueryRpc.class);
        this.bigqueryFactoryMock = (BigQueryFactory)Mockito.mock(BigQueryFactory.class);
        this.bigqueryMock = (BigQuery)Mockito.mock(BigQuery.class);
        Mockito.when((Object)((BigQueryOptions)this.bigqueryMock.getOptions())).thenReturn((Object)this.options);
        this.job = new Job(this.bigqueryMock, new JobInfo.BuilderImpl(JOB_INFO));
        Mockito.when((Object)this.rpcFactoryMock.create((ServiceOptions)((BigQueryOptions)Mockito.any(BigQueryOptions.class)))).thenReturn((Object)this.bigqueryRpcMock);
        Mockito.when((Object)((BigQuery)this.bigqueryFactoryMock.create((ServiceOptions)((BigQueryOptions)Mockito.any(BigQueryOptions.class))))).thenReturn((Object)this.bigqueryMock);
        this.options = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId("projectid")).setServiceRpcFactory((ServiceRpcFactory)this.rpcFactoryMock)).setServiceFactory((ServiceFactory)this.bigqueryFactoryMock)).build();
    }

    @Test
    public void testCreate() {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        Assert.assertTrue((boolean)this.writer.isOpen());
        Assert.assertNull((Object)this.writer.getJob());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
    }

    @Test
    public void testCreateRetryableError() {
        BigQueryException exception = new BigQueryException((IOException)new SocketException("Socket closed"));
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenThrow(new Throwable[]{exception}).thenReturn((Object)UPLOAD_ID);
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        Assert.assertTrue((boolean)this.writer.isOpen());
        Assert.assertNull((Object)this.writer.getJob());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)2))).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
    }

    @Test
    public void testCreateNonRetryableError() throws IOException {
        RuntimeException ex = new RuntimeException("expected");
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenThrow(new Throwable[]{ex});
        try (TableDataWriteChannel channel = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);){
            Assert.fail();
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((Object)"java.lang.RuntimeException: expected", (Object)expected.getMessage());
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
    }

    @Test
    public void testWriteWithoutFlush() throws IOException {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        Assert.assertEquals((long)262144L, (long)this.writer.write(ByteBuffer.allocate(262144)));
        Assert.assertNull((Object)this.writer.getJob());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
    }

    @Test
    public void testWriteWithFlush() throws IOException {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0x100000), Mockito.eq((boolean)false))).thenReturn(null);
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        this.writer.setChunkSize(0x100000);
        ByteBuffer buffer = TableDataWriteChannelTest.randomBuffer(0x100000);
        Assert.assertEquals((long)0x100000L, (long)this.writer.write(buffer));
        Assert.assertArrayEquals((byte[])buffer.array(), (byte[])((byte[])this.capturedBuffer.getValue()));
        Assert.assertNull((Object)this.writer.getJob());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0x100000), Mockito.eq((boolean)false));
    }

    @Test
    public void testWritesAndFlush() throws IOException {
        int i;
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0xF00000), Mockito.eq((boolean)false))).thenReturn(null);
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        ByteBuffer[] buffers = new ByteBuffer[60];
        for (i = 0; i < buffers.length; ++i) {
            buffers[i] = TableDataWriteChannelTest.randomBuffer(262144);
            Assert.assertEquals((long)262144L, (long)this.writer.write(buffers[i]));
        }
        for (i = 0; i < buffers.length; ++i) {
            Assert.assertArrayEquals((byte[])buffers[i].array(), (byte[])Arrays.copyOfRange((byte[])this.capturedBuffer.getValue(), 262144 * i, 262144 * (i + 1)));
        }
        Assert.assertNull((Object)this.writer.getJob());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0xF00000), Mockito.eq((boolean)false));
    }

    @Test
    public void testCloseWithoutFlush() throws IOException {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true))).thenReturn((Object)this.job.toPb());
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        Assert.assertTrue((boolean)this.writer.isOpen());
        this.writer.close();
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])this.capturedBuffer.getValue()));
        Assert.assertTrue((!this.writer.isOpen() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.job, (Object)this.writer.getJob());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void testCloseWithFlush() throws IOException {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        ByteBuffer buffer = TableDataWriteChannelTest.randomBuffer(262144);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)262144), Mockito.eq((boolean)true))).thenReturn((Object)this.job.toPb());
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        Assert.assertTrue((boolean)this.writer.isOpen());
        this.writer.write(buffer);
        this.writer.close();
        Assert.assertEquals((long)0xF00000L, (long)((byte[])this.capturedBuffer.getValue()).length);
        Assert.assertArrayEquals((byte[])buffer.array(), (byte[])Arrays.copyOf((byte[])this.capturedBuffer.getValue(), 262144));
        Assert.assertTrue((!this.writer.isOpen() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.job, (Object)this.writer.getJob());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)262144), Mockito.eq((boolean)true));
    }

    @Test
    public void testWriteClosed() throws IOException {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true))).thenReturn((Object)this.job.toPb());
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        this.writer.close();
        Assert.assertEquals((Object)this.job, (Object)this.writer.getJob());
        try {
            this.writer.write(ByteBuffer.allocate(262144));
            Assert.fail((String)"Expected TableDataWriteChannel write to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void testSaveAndRestore() throws IOException {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), ((Long)this.capturedPosition.capture()).longValue(), Mockito.eq((int)0xF00000), Mockito.eq((boolean)false))).thenReturn(null);
        ByteBuffer buffer1 = TableDataWriteChannelTest.randomBuffer(0xF00000);
        ByteBuffer buffer2 = TableDataWriteChannelTest.randomBuffer(0xF00000);
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        Assert.assertEquals((long)0xF00000L, (long)this.writer.write(buffer1));
        Assert.assertArrayEquals((byte[])buffer1.array(), (byte[])((byte[])this.capturedBuffer.getAllValues().get(0)));
        Assert.assertEquals((Object)new Long(0L), this.capturedPosition.getAllValues().get(0));
        Assert.assertNull((Object)this.writer.getJob());
        RestorableState writerState = this.writer.capture();
        WriteChannel restoredWriter = (WriteChannel)writerState.restore();
        Assert.assertEquals((long)0xF00000L, (long)restoredWriter.write(buffer2));
        Assert.assertArrayEquals((byte[])buffer2.array(), (byte[])((byte[])this.capturedBuffer.getAllValues().get(1)));
        Assert.assertEquals((Object)new Long(0xF00000L), this.capturedPosition.getAllValues().get(1));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)2))).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), ((Long)this.capturedPosition.capture()).longValue(), Mockito.eq((int)0xF00000), Mockito.eq((boolean)false));
    }

    @Test
    public void testSaveAndRestoreClosed() throws IOException {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        Mockito.when((Object)this.bigqueryRpcMock.write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true))).thenReturn((Object)this.job.toPb());
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        this.writer.close();
        Assert.assertEquals((Object)this.job, (Object)this.writer.getJob());
        RestorableState writerState = this.writer.capture();
        RestorableState expectedWriterState = TableDataWriteChannel.StateImpl.builder((BigQueryOptions)this.options, (WriteChannelConfiguration)LOAD_CONFIGURATION, (String)UPLOAD_ID, (Job)this.job).setBuffer(null).setChunkSize(0xF00000).setIsOpen(false).setPosition(0L).build();
        WriteChannel restoredWriter = (WriteChannel)writerState.restore();
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])this.capturedBuffer.getValue()));
        Assert.assertEquals((Object)expectedWriterState, (Object)restoredWriter.capture());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock)).write((String)Mockito.eq((Object)UPLOAD_ID), (byte[])this.capturedBuffer.capture(), Mockito.eq((int)0), Mockito.eq((long)0L), Mockito.eq((int)0), Mockito.eq((boolean)true));
    }

    @Test
    public void testStateEquals() {
        Mockito.when((Object)this.bigqueryRpcMock.open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()))).thenReturn((Object)UPLOAD_ID);
        this.writer = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        TableDataWriteChannel writer2 = new TableDataWriteChannel(this.options, JOB_INFO.getJobId(), LOAD_CONFIGURATION);
        RestorableState state = this.writer.capture();
        RestorableState state2 = writer2.capture();
        Assert.assertEquals((Object)state, (Object)state2);
        Assert.assertEquals((long)state.hashCode(), (long)state2.hashCode());
        Assert.assertEquals((Object)state.toString(), (Object)state2.toString());
        ((BigQueryRpc)Mockito.verify((Object)this.bigqueryRpcMock, (VerificationMode)Mockito.times((int)2))).open(new com.google.api.services.bigquery.model.Job().setJobReference(JOB_INFO.getJobId().toPb()).setConfiguration(LOAD_CONFIGURATION.toPb()));
    }

    private static ByteBuffer randomBuffer(int size) {
        byte[] byteArray = new byte[size];
        RANDOM.nextBytes(byteArray);
        return ByteBuffer.wrap(byteArray);
    }
}

