/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.TableId;
import org.junit.Assert;
import org.junit.Test;

public class TableIdTest {
    private static final TableId TABLE = TableId.of((String)"dataset", (String)"table");
    private static final TableId TABLE_COMPLETE = TableId.of((String)"project", (String)"dataset", (String)"table");
    private static final String TABLE_IAM_RESOURCE_NAME = "projects/project/datasets/dataset/tables/table";

    @Test
    public void testOf() {
        Assert.assertEquals(null, (Object)TABLE.getProject());
        Assert.assertEquals((Object)"dataset", (Object)TABLE.getDataset());
        Assert.assertEquals((Object)"table", (Object)TABLE.getTable());
        Assert.assertEquals((Object)"project", (Object)TABLE_COMPLETE.getProject());
        Assert.assertEquals((Object)"dataset", (Object)TABLE_COMPLETE.getDataset());
        Assert.assertEquals((Object)"table", (Object)TABLE_COMPLETE.getTable());
        Assert.assertEquals((Object)TABLE_IAM_RESOURCE_NAME, (Object)TABLE_COMPLETE.getIAMResourceName());
    }

    @Test
    public void testEquals() {
        this.compareTableIds(TABLE, TableId.of((String)"dataset", (String)"table"));
        this.compareTableIds(TABLE_COMPLETE, TableId.of((String)"project", (String)"dataset", (String)"table"));
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareTableIds(TABLE, TableId.fromPb((TableReference)TABLE.toPb()));
        this.compareTableIds(TABLE_COMPLETE, TableId.fromPb((TableReference)TABLE_COMPLETE.toPb()));
    }

    @Test
    public void testSetProjectId() {
        TableId differentProjectTable = TableId.of((String)"differentProject", (String)"dataset", (String)"table");
        Assert.assertEquals((Object)differentProjectTable, (Object)TABLE.setProjectId("differentProject"));
    }

    private void compareTableIds(TableId expected, TableId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getProject(), (Object)value.getProject());
        Assert.assertEquals((Object)expected.getDataset(), (Object)value.getDataset());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

