/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TableInfoTest {
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "project:dataset:table";
    private static final String SELF_LINK = "selfLink";
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String DESCRIPTION = "description";
    private static final Long CREATION_TIME = 10L;
    private static final Long EXPIRATION_TIME = 100L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final Boolean REQUIRE_PARTITION_FILTER = true;
    private static final EncryptionConfiguration ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final Field FIELD_SCHEMA1 = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FieldDescription1").build();
    private static final Field FIELD_SCHEMA2 = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("FieldDescription2").build();
    private static final Field FIELD_SCHEMA3 = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2}).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription3").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA1, FIELD_SCHEMA2, FIELD_SCHEMA3});
    private static final Long NUM_BYTES = 42L;
    private static final Long NUM_LONG_TERM_BYTES = 21L;
    private static final Long NUM_TIME_TRAVEL_PHYSICAL_BYTES = 21L;
    private static final Long NUM_TOTAL_LOGICAL_BYTES = 22L;
    private static final Long NUM_ACTIVE_LOGICAL_BYTES = 23L;
    private static final Long NUM_LONG_TERM_LOGICAL_BYTES = 24L;
    private static final Long NUM_TOTAL_PHYSICAL_BYTES = 25L;
    private static final Long NUM_ACTIVE_PHYSICAL_BYTES = 26L;
    private static final Long NUM_LONG_TERM_PHYSICAL_BYTES = 27L;
    private static final Long NUM_ROWS = 43L;
    private static final String LOCATION = "US";
    private static final StandardTableDefinition.StreamingBuffer STREAMING_BUFFER = new StandardTableDefinition.StreamingBuffer(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L));
    private static final StandardTableDefinition TABLE_DEFINITION = StandardTableDefinition.newBuilder().setLocation("US").setNumBytes(NUM_BYTES).setNumLongTermBytes(NUM_LONG_TERM_BYTES).setNumTimeTravelPhysicalBytes(NUM_TIME_TRAVEL_PHYSICAL_BYTES).setNumTotalLogicalBytes(NUM_TOTAL_LOGICAL_BYTES).setNumActiveLogicalBytes(NUM_ACTIVE_LOGICAL_BYTES).setNumLongTermLogicalBytes(NUM_LONG_TERM_LOGICAL_BYTES).setNumTotalPhysicalBytes(NUM_TOTAL_PHYSICAL_BYTES).setNumActivePhysicalBytes(NUM_ACTIVE_PHYSICAL_BYTES).setNumLongTermPhysicalBytes(NUM_LONG_TERM_PHYSICAL_BYTES).setNumRows(NUM_ROWS).setStreamingBuffer(STREAMING_BUFFER).setSchema(TABLE_SCHEMA).build();
    private static final List<String> SOURCE_URIS = ImmutableList.of((Object)"uri1", (Object)"uri2");
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final String COMPRESSION = "GZIP";
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().build();
    private static final ExternalTableDefinition EXTERNAL_TABLE_DEFINITION = ExternalTableDefinition.newBuilder(SOURCE_URIS, (Schema)TABLE_SCHEMA, (FormatOptions)CSV_OPTIONS).setCompression("GZIP").setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).build();
    private static final String VIEW_QUERY = "VIEW QUERY";
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final ViewDefinition VIEW_DEFINITION = ViewDefinition.newBuilder((String)"VIEW QUERY", USER_DEFINED_FUNCTIONS).build();
    private static final TableInfo TABLE_INFO = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION).setCreationTime(CREATION_TIME).setDescription("description").setEncryptionConfiguration(ENCRYPTION_CONFIGURATION).setEtag("etag").setExpirationTime(EXPIRATION_TIME).setFriendlyName("friendlyName").setGeneratedId("project:dataset:table").setLastModifiedTime(LAST_MODIFIED_TIME).setNumBytes(NUM_BYTES).setNumLongTermBytes(NUM_LONG_TERM_BYTES).setNumTimeTravelPhysicalBytes(NUM_TIME_TRAVEL_PHYSICAL_BYTES).setNumTotalLogicalBytes(NUM_TOTAL_LOGICAL_BYTES).setNumActiveLogicalBytes(NUM_ACTIVE_LOGICAL_BYTES).setNumLongTermLogicalBytes(NUM_LONG_TERM_LOGICAL_BYTES).setNumTotalPhysicalBytes(NUM_TOTAL_PHYSICAL_BYTES).setNumActivePhysicalBytes(NUM_ACTIVE_PHYSICAL_BYTES).setNumLongTermPhysicalBytes(NUM_LONG_TERM_PHYSICAL_BYTES).setNumRows(BigInteger.valueOf(NUM_ROWS)).setSelfLink("selfLink").setLabels(Collections.singletonMap("a", "b")).setResourceTags(Collections.singletonMap("resourceTagA", "resourceTagB")).setRequirePartitionFilter(REQUIRE_PARTITION_FILTER).build();
    private static final TableInfo VIEW_INFO = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)VIEW_DEFINITION).setCreationTime(CREATION_TIME).setDescription("description").setEtag("etag").setExpirationTime(EXPIRATION_TIME).setFriendlyName("friendlyName").setGeneratedId("project:dataset:table").setLastModifiedTime(LAST_MODIFIED_TIME).setSelfLink("selfLink").build();
    private static final TableInfo EXTERNAL_TABLE_INFO = TableInfo.newBuilder((TableId)TABLE_ID, (TableDefinition)EXTERNAL_TABLE_DEFINITION).setCreationTime(CREATION_TIME).setDescription("description").setEtag("etag").setExpirationTime(EXPIRATION_TIME).setFriendlyName("friendlyName").setGeneratedId("project:dataset:table").setLastModifiedTime(LAST_MODIFIED_TIME).setSelfLink("selfLink").build();

    @Test
    public void testToBuilder() {
        this.compareTableInfo(TABLE_INFO, TABLE_INFO.toBuilder().build());
        this.compareTableInfo(VIEW_INFO, VIEW_INFO.toBuilder().build());
        this.compareTableInfo(EXTERNAL_TABLE_INFO, EXTERNAL_TABLE_INFO.toBuilder().build());
        TableInfo tableInfo = TABLE_INFO.toBuilder().setDescription("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)tableInfo.getDescription());
        tableInfo = tableInfo.toBuilder().setDescription(DESCRIPTION).build();
        this.compareTableInfo(TABLE_INFO, tableInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        TableInfo tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION);
        Assert.assertEquals((Object)tableInfo, (Object)tableInfo.toBuilder().build());
        tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)VIEW_DEFINITION);
        Assert.assertEquals((Object)tableInfo, (Object)tableInfo.toBuilder().build());
        tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)EXTERNAL_TABLE_DEFINITION);
        Assert.assertEquals((Object)tableInfo, (Object)tableInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TABLE_ID, (Object)TABLE_INFO.getTableId());
        Assert.assertEquals((Object)CREATION_TIME, (Object)TABLE_INFO.getCreationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)TABLE_INFO.getDescription());
        Assert.assertEquals((Object)ENCRYPTION_CONFIGURATION, (Object)TABLE_INFO.getEncryptionConfiguration());
        Assert.assertEquals((Object)ETAG, (Object)TABLE_INFO.getEtag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)TABLE_INFO.getExpirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)TABLE_INFO.getFriendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)TABLE_INFO.getGeneratedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)TABLE_INFO.getLastModifiedTime());
        Assert.assertEquals((Object)TABLE_DEFINITION, (Object)TABLE_INFO.getDefinition());
        Assert.assertEquals((Object)SELF_LINK, (Object)TABLE_INFO.getSelfLink());
        Assert.assertEquals((Object)NUM_BYTES, (Object)TABLE_INFO.getNumBytes());
        Assert.assertEquals((Object)NUM_LONG_TERM_BYTES, (Object)TABLE_INFO.getNumLongTermBytes());
        Assert.assertEquals((Object)NUM_TIME_TRAVEL_PHYSICAL_BYTES, (Object)TABLE_INFO.getNumTimeTravelPhysicalBytes());
        Assert.assertEquals((Object)NUM_TOTAL_LOGICAL_BYTES, (Object)TABLE_INFO.getNumTotalLogicalBytes());
        Assert.assertEquals((Object)NUM_ACTIVE_LOGICAL_BYTES, (Object)TABLE_INFO.getNumActiveLogicalBytes());
        Assert.assertEquals((Object)NUM_LONG_TERM_LOGICAL_BYTES, (Object)TABLE_INFO.getNumLongTermLogicalBytes());
        Assert.assertEquals((Object)NUM_TOTAL_PHYSICAL_BYTES, (Object)TABLE_INFO.getNumTotalPhysicalBytes());
        Assert.assertEquals((Object)NUM_ACTIVE_PHYSICAL_BYTES, (Object)TABLE_INFO.getNumActivePhysicalBytes());
        Assert.assertEquals((Object)NUM_LONG_TERM_PHYSICAL_BYTES, (Object)TABLE_INFO.getNumLongTermPhysicalBytes());
        Assert.assertEquals((Object)BigInteger.valueOf(NUM_ROWS), (Object)TABLE_INFO.getNumRows());
        Assert.assertEquals((Object)REQUIRE_PARTITION_FILTER, (Object)TABLE_INFO.getRequirePartitionFilter());
        Assert.assertEquals((Object)TABLE_ID, (Object)VIEW_INFO.getTableId());
        Assert.assertEquals((Object)VIEW_DEFINITION, (Object)VIEW_INFO.getDefinition());
        Assert.assertEquals((Object)CREATION_TIME, (Object)VIEW_INFO.getCreationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)VIEW_INFO.getDescription());
        Assert.assertEquals((Object)ETAG, (Object)VIEW_INFO.getEtag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)VIEW_INFO.getExpirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)VIEW_INFO.getFriendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)VIEW_INFO.getGeneratedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)VIEW_INFO.getLastModifiedTime());
        Assert.assertEquals((Object)VIEW_DEFINITION, (Object)VIEW_INFO.getDefinition());
        Assert.assertEquals((Object)SELF_LINK, (Object)VIEW_INFO.getSelfLink());
        Assert.assertEquals((Object)TABLE_ID, (Object)EXTERNAL_TABLE_INFO.getTableId());
        Assert.assertEquals((Object)CREATION_TIME, (Object)EXTERNAL_TABLE_INFO.getCreationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)EXTERNAL_TABLE_INFO.getDescription());
        Assert.assertEquals((Object)ETAG, (Object)EXTERNAL_TABLE_INFO.getEtag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)EXTERNAL_TABLE_INFO.getExpirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)EXTERNAL_TABLE_INFO.getFriendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)EXTERNAL_TABLE_INFO.getGeneratedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)EXTERNAL_TABLE_INFO.getLastModifiedTime());
        Assert.assertEquals((Object)EXTERNAL_TABLE_DEFINITION, (Object)EXTERNAL_TABLE_INFO.getDefinition());
        Assert.assertEquals((Object)SELF_LINK, (Object)EXTERNAL_TABLE_INFO.getSelfLink());
    }

    @Test
    public void testOf() {
        TableInfo tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION);
        Assert.assertEquals((Object)TABLE_ID, (Object)tableInfo.getTableId());
        Assert.assertNull((Object)tableInfo.getCreationTime());
        Assert.assertNull((Object)tableInfo.getDescription());
        Assert.assertNull((Object)tableInfo.getEncryptionConfiguration());
        Assert.assertNull((Object)tableInfo.getEtag());
        Assert.assertNull((Object)tableInfo.getExpirationTime());
        Assert.assertNull((Object)tableInfo.getFriendlyName());
        Assert.assertNull((Object)tableInfo.getGeneratedId());
        Assert.assertNull((Object)tableInfo.getLastModifiedTime());
        Assert.assertNull((Object)tableInfo.getRequirePartitionFilter());
        Assert.assertEquals((Object)TABLE_DEFINITION, (Object)tableInfo.getDefinition());
        Assert.assertNull((Object)tableInfo.getSelfLink());
        tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)VIEW_DEFINITION);
        Assert.assertEquals((Object)TABLE_ID, (Object)tableInfo.getTableId());
        Assert.assertNull((Object)tableInfo.getCreationTime());
        Assert.assertNull((Object)tableInfo.getDescription());
        Assert.assertNull((Object)tableInfo.getEncryptionConfiguration());
        Assert.assertNull((Object)tableInfo.getEtag());
        Assert.assertNull((Object)tableInfo.getExpirationTime());
        Assert.assertNull((Object)tableInfo.getFriendlyName());
        Assert.assertNull((Object)tableInfo.getGeneratedId());
        Assert.assertNull((Object)tableInfo.getLastModifiedTime());
        Assert.assertNull((Object)tableInfo.getRequirePartitionFilter());
        Assert.assertEquals((Object)VIEW_DEFINITION, (Object)tableInfo.getDefinition());
        Assert.assertNull((Object)tableInfo.getSelfLink());
        tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)EXTERNAL_TABLE_DEFINITION);
        Assert.assertEquals((Object)TABLE_ID, (Object)tableInfo.getTableId());
        Assert.assertNull((Object)tableInfo.getCreationTime());
        Assert.assertNull((Object)tableInfo.getDescription());
        Assert.assertNull((Object)tableInfo.getEncryptionConfiguration());
        Assert.assertNull((Object)tableInfo.getEtag());
        Assert.assertNull((Object)tableInfo.getExpirationTime());
        Assert.assertNull((Object)tableInfo.getFriendlyName());
        Assert.assertNull((Object)tableInfo.getGeneratedId());
        Assert.assertNull((Object)tableInfo.getLastModifiedTime());
        Assert.assertNull((Object)tableInfo.getRequirePartitionFilter());
        Assert.assertEquals((Object)EXTERNAL_TABLE_DEFINITION, (Object)tableInfo.getDefinition());
        Assert.assertNull((Object)tableInfo.getSelfLink());
    }

    @Test
    public void testToAndFromPb() {
        this.compareTableInfo(TABLE_INFO, TableInfo.fromPb((Table)TABLE_INFO.toPb()));
        this.compareTableInfo(VIEW_INFO, TableInfo.fromPb((Table)VIEW_INFO.toPb()));
        this.compareTableInfo(EXTERNAL_TABLE_INFO, TableInfo.fromPb((Table)EXTERNAL_TABLE_INFO.toPb()));
    }

    @Test
    public void testSetProjectId() {
        Assert.assertEquals((Object)"project", (Object)TABLE_INFO.setProjectId("project").getTableId().getProject());
        Assert.assertEquals((Object)"project", (Object)EXTERNAL_TABLE_INFO.setProjectId("project").getTableId().getProject());
        Assert.assertEquals((Object)"project", (Object)VIEW_INFO.setProjectId("project").getTableId().getProject());
    }

    @Test
    public void testSetProjectIdDoNotOverride() {
        TableInfo tableInfo = TableInfo.of((TableId)TABLE_ID, (TableDefinition)TABLE_DEFINITION).setProjectId("project");
        tableInfo.setProjectId("not-override-project").toBuilder();
        Assert.assertEquals((Object)"project", (Object)tableInfo.getTableId().getProject());
    }

    private void compareTableInfo(TableInfo expected, TableInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getTableId(), (Object)value.getTableId());
        Assert.assertEquals((Object)expected.getDefinition(), (Object)value.getDefinition());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getEncryptionConfiguration(), (Object)value.getEncryptionConfiguration());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getExpirationTime(), (Object)value.getExpirationTime());
        Assert.assertEquals((Object)expected.getFriendlyName(), (Object)value.getFriendlyName());
        Assert.assertEquals((Object)expected.getGeneratedId(), (Object)value.getGeneratedId());
        Assert.assertEquals((Object)expected.getLastModifiedTime(), (Object)value.getLastModifiedTime());
        Assert.assertEquals((Object)expected.getNumBytes(), (Object)value.getNumBytes());
        Assert.assertEquals((Object)expected.getNumLongTermBytes(), (Object)value.getNumLongTermBytes());
        Assert.assertEquals((Object)expected.getNumTimeTravelPhysicalBytes(), (Object)value.getNumTimeTravelPhysicalBytes());
        Assert.assertEquals((Object)expected.getNumTotalLogicalBytes(), (Object)value.getNumTotalLogicalBytes());
        Assert.assertEquals((Object)expected.getNumActiveLogicalBytes(), (Object)value.getNumActiveLogicalBytes());
        Assert.assertEquals((Object)expected.getNumLongTermLogicalBytes(), (Object)value.getNumLongTermLogicalBytes());
        Assert.assertEquals((Object)expected.getNumTotalPhysicalBytes(), (Object)value.getNumTotalPhysicalBytes());
        Assert.assertEquals((Object)expected.getNumActivePhysicalBytes(), (Object)value.getNumActivePhysicalBytes());
        Assert.assertEquals((Object)expected.getNumLongTermPhysicalBytes(), (Object)value.getNumLongTermPhysicalBytes());
        Assert.assertEquals((Object)expected.getNumRows(), (Object)value.getNumRows());
        Assert.assertEquals((Object)expected.getSelfLink(), (Object)value.getSelfLink());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getResourceTags(), (Object)value.getResourceTags());
        Assert.assertEquals((Object)expected.getRequirePartitionFilter(), (Object)value.getRequirePartitionFilter());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

