/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;

public class TableResultTest {
    private static final Page<FieldValueList> INNER_PAGE_0 = new PageImpl((PageImpl.NextPageFetcher)new PageImpl.NextPageFetcher<FieldValueList>(){

        public Page<FieldValueList> getNextPage() {
            return INNER_PAGE_1;
        }
    }, "abc", (Iterable)ImmutableList.of((Object)TableResultTest.newFieldValueList("0"), (Object)TableResultTest.newFieldValueList("1")));
    private static final Page<FieldValueList> INNER_PAGE_1 = new PageImpl((PageImpl.NextPageFetcher)new PageImpl.NextPageFetcher<FieldValueList>(){

        public Page<FieldValueList> getNextPage() {
            return null;
        }
    }, null, (Iterable)ImmutableList.of((Object)TableResultTest.newFieldValueList("2")));
    private static final Schema SCHEMA = Schema.of((Field[])new Field[]{Field.of((String)"field", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0])});

    private static FieldValueList newFieldValueList(String s) {
        return FieldValueList.of((List)ImmutableList.of((Object)FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)s)), (Field[])new Field[0]);
    }

    @Test
    public void testNullSchema() {
        TableResult result = TableResult.newBuilder().setTotalRows(Long.valueOf(3L)).setPageNoSchema(INNER_PAGE_0).build();
        Truth.assertThat((Object)result.getSchema()).isNull();
        Truth.assertThat((Boolean)result.hasNextPage()).isTrue();
        Truth.assertThat((String)result.getNextPageToken()).isNotNull();
        Truth.assertThat((Iterable)result.getValues()).containsExactly(new Object[]{TableResultTest.newFieldValueList("0"), TableResultTest.newFieldValueList("1")}).inOrder();
        TableResult next = result.getNextPage();
        Truth.assertThat((Object)next.getSchema()).isNull();
        Truth.assertThat((Boolean)next.hasNextPage()).isFalse();
        Truth.assertThat((String)next.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)next.getValues()).containsExactly(new Object[]{TableResultTest.newFieldValueList("2")});
        Truth.assertThat((Object)next.getNextPage()).isNull();
        Truth.assertThat((Iterable)result.iterateAll()).containsExactly(new Object[]{TableResultTest.newFieldValueList("0"), TableResultTest.newFieldValueList("1"), TableResultTest.newFieldValueList("2")}).inOrder();
    }

    @Test
    public void testSchema() {
        TableResult result = TableResult.newBuilder().setSchema(SCHEMA).setTotalRows(Long.valueOf(3L)).setPageNoSchema(INNER_PAGE_0).build();
        Truth.assertThat((Object)result.getSchema()).isEqualTo((Object)SCHEMA);
        Truth.assertThat((Boolean)result.hasNextPage()).isTrue();
        Truth.assertThat((String)result.getNextPageToken()).isNotNull();
        Truth.assertThat((Iterable)result.getValues()).containsExactly(new Object[]{TableResultTest.newFieldValueList("0").withSchema(SCHEMA.getFields()), TableResultTest.newFieldValueList("1").withSchema(SCHEMA.getFields())}).inOrder();
        TableResult next = result.getNextPage();
        Truth.assertThat((Object)next.getSchema()).isEqualTo((Object)SCHEMA);
        Truth.assertThat((Boolean)next.hasNextPage()).isFalse();
        Truth.assertThat((String)next.getNextPageToken()).isNull();
        Truth.assertThat((Iterable)next.getValues()).containsExactly(new Object[]{TableResultTest.newFieldValueList("2").withSchema(SCHEMA.getFields())});
        Truth.assertThat((Object)next.getNextPage()).isNull();
        Truth.assertThat((Iterable)result.iterateAll()).containsExactly(new Object[]{TableResultTest.newFieldValueList("0").withSchema(SCHEMA.getFields()), TableResultTest.newFieldValueList("1").withSchema(SCHEMA.getFields()), TableResultTest.newFieldValueList("2").withSchema(SCHEMA.getFields())}).inOrder();
    }
}

