/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.junit.MockitoRule;

@RunWith(value=MockitoJUnitRunner.class)
public class TableTest {
    private static final String ETAG = "etag";
    private static final String GENERATED_ID = "project:dataset:table1";
    private static final String SELF_LINK = "selfLink";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String DESCRIPTION = "description";
    private static final Long CREATION_TIME = 10L;
    private static final Long EXPIRATION_TIME = 100L;
    private static final Long LAST_MODIFIED_TIME = 20L;
    private static final Long NUM_BYTES = 42L;
    private static final Long NUM_LONG_TERM_BYTES = 21L;
    private static final Long NUM_ROWS = 43L;
    private static final TableId TABLE_ID1 = TableId.of((String)"dataset", (String)"table1");
    private static final TableId TABLE_ID2 = TableId.of((String)"dataset", (String)"table2");
    private static final Boolean REQUIRE_PARTITION_FILTER = true;
    private static final EncryptionConfiguration ENCRYPTION_CONFIGURATION = EncryptionConfiguration.newBuilder().setKmsKeyName("KMS_KEY_1").build();
    private static final CopyJobConfiguration COPY_JOB_CONFIGURATION = CopyJobConfiguration.of((TableId)TABLE_ID2, (TableId)TABLE_ID1);
    private static final JobInfo COPY_JOB_INFO = JobInfo.of((JobConfiguration)COPY_JOB_CONFIGURATION);
    private static final JobInfo LOAD_JOB_INFO = JobInfo.of((JobConfiguration)LoadJobConfiguration.of((TableId)TABLE_ID1, (List)ImmutableList.of((Object)"URI"), (FormatOptions)FormatOptions.json()));
    private static final JobInfo EXTRACT_JOB_INFO = JobInfo.of((JobConfiguration)ExtractJobConfiguration.of((TableId)TABLE_ID1, (List)ImmutableList.of((Object)"URI"), (String)"CSV"));
    private static final Field FIELD = Field.of((String)"FieldName", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]);
    private static final Schema SCHEMA = Schema.of((Field[])new Field[]{FIELD});
    private static final TableDefinition TABLE_DEFINITION = StandardTableDefinition.of((Schema)SCHEMA);
    private static final TableInfo TABLE_INFO = TableInfo.of((TableId)TABLE_ID1, (TableDefinition)TABLE_DEFINITION);
    private static final List<InsertAllRequest.RowToInsert> ROWS_TO_INSERT = ImmutableList.of((Object)InsertAllRequest.RowToInsert.of((String)"id1", (Map)ImmutableMap.of((Object)"key", (Object)"val1")), (Object)InsertAllRequest.RowToInsert.of((String)"id2", (Map)ImmutableMap.of((Object)"key", (Object)"val2")));
    private static final InsertAllRequest INSERT_ALL_REQUEST = InsertAllRequest.of((TableId)TABLE_ID1, ROWS_TO_INSERT);
    private static final InsertAllRequest INSERT_ALL_REQUEST_COMPLETE = InsertAllRequest.newBuilder((TableId)TABLE_ID1, ROWS_TO_INSERT).setSkipInvalidRows(true).setIgnoreUnknownValues(true).build();
    private static final InsertAllResponse EMPTY_INSERT_ALL_RESPONSE = new InsertAllResponse((Map)ImmutableMap.of());
    private static final FieldValue FIELD_VALUE1 = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"val1");
    private static final FieldValue FIELD_VALUE2 = FieldValue.of((FieldValue.Attribute)FieldValue.Attribute.PRIMITIVE, (Object)"val1");
    private static final List<FieldValueList> ROWS = ImmutableList.of((Object)FieldValueList.of((List)ImmutableList.of((Object)FIELD_VALUE1), (Field[])new Field[0]), (Object)FieldValueList.of((List)ImmutableList.of((Object)FIELD_VALUE2), (Field[])new Field[0]));
    private static final List<FieldValueList> ROWS_WITH_SCHEMA = ImmutableList.of((Object)FieldValueList.of((List)ImmutableList.of((Object)FIELD_VALUE1), (Field[])new Field[0]).withSchema(SCHEMA.getFields()), (Object)FieldValueList.of((List)ImmutableList.of((Object)FIELD_VALUE2), (Field[])new Field[0]).withSchema(SCHEMA.getFields()));
    @Rule
    public MockitoRule rule;
    private BigQuery bigquery;
    private BigQueryOptions mockOptions;
    private Table expectedTable;
    private Table table;

    @Before
    public void setUp() {
        this.bigquery = (BigQuery)Mockito.mock(BigQuery.class);
        this.mockOptions = (BigQueryOptions)Mockito.mock(BigQueryOptions.class);
        Mockito.when((Object)((BigQueryOptions)this.bigquery.getOptions())).thenReturn((Object)this.mockOptions);
        this.expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO));
        this.table = new Table(this.bigquery, new TableInfo.BuilderImpl(TABLE_INFO));
    }

    @Test
    public void testBuilder() {
        Table builtTable = new Table.Builder(this.bigquery, TABLE_ID1, TABLE_DEFINITION).setCreationTime(CREATION_TIME).setDescription(DESCRIPTION).setEtag(ETAG).setExpirationTime(EXPIRATION_TIME).setFriendlyName(FRIENDLY_NAME).setGeneratedId(GENERATED_ID).setLastModifiedTime(LAST_MODIFIED_TIME).setSelfLink(SELF_LINK).setNumBytes(NUM_BYTES).setNumLongTermBytes(NUM_LONG_TERM_BYTES).setNumRows(BigInteger.valueOf(NUM_ROWS)).setRequirePartitionFilter(REQUIRE_PARTITION_FILTER).build();
        Assert.assertEquals((Object)TABLE_ID1, (Object)builtTable.getTableId());
        Assert.assertEquals((Object)CREATION_TIME, (Object)builtTable.getCreationTime());
        Assert.assertEquals((Object)DESCRIPTION, (Object)builtTable.getDescription());
        Assert.assertEquals((Object)ETAG, (Object)builtTable.getEtag());
        Assert.assertEquals((Object)EXPIRATION_TIME, (Object)builtTable.getExpirationTime());
        Assert.assertEquals((Object)FRIENDLY_NAME, (Object)builtTable.getFriendlyName());
        Assert.assertEquals((Object)GENERATED_ID, (Object)builtTable.getGeneratedId());
        Assert.assertEquals((Object)LAST_MODIFIED_TIME, (Object)builtTable.getLastModifiedTime());
        Assert.assertEquals((Object)TABLE_DEFINITION, (Object)builtTable.getDefinition());
        Assert.assertEquals((Object)SELF_LINK, (Object)builtTable.getSelfLink());
        Assert.assertEquals((Object)NUM_BYTES, (Object)builtTable.getNumBytes());
        Assert.assertEquals((Object)NUM_LONG_TERM_BYTES, (Object)builtTable.getNumLongTermBytes());
        Assert.assertEquals((Object)BigInteger.valueOf(NUM_ROWS), (Object)builtTable.getNumRows());
        Assert.assertEquals((Object)REQUIRE_PARTITION_FILTER, (Object)builtTable.getRequirePartitionFilter());
        Assert.assertSame((Object)this.bigquery, (Object)builtTable.getBigQuery());
    }

    @Test
    public void testToBuilder() {
        this.compareTable(this.expectedTable, this.expectedTable.toBuilder().build());
    }

    @Test
    public void testExists_True() {
        BigQuery.TableOption[] expectedOptions = new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])};
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO.getTableId(), expectedOptions)).thenReturn((Object)this.expectedTable);
        Assert.assertTrue((boolean)this.table.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO.getTableId(), expectedOptions);
    }

    @Test
    public void testExists_False() {
        BigQuery.TableOption[] expectedOptions = new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])};
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO.getTableId(), expectedOptions)).thenReturn(null);
        Assert.assertFalse((boolean)this.table.exists());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO.getTableId(), expectedOptions);
    }

    @Test
    public void testReload() {
        TableInfo updatedInfo = TABLE_INFO.toBuilder().setDescription("Description").build();
        Table expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO.getTableId(), new BigQuery.TableOption[0])).thenReturn((Object)expectedTable);
        Table updatedTable = this.table.reload(new BigQuery.TableOption[0]);
        this.compareTable(expectedTable, updatedTable);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO.getTableId(), new BigQuery.TableOption[0]);
    }

    @Test
    public void testReloadNull() {
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO.getTableId(), new BigQuery.TableOption[0])).thenReturn(null);
        Assert.assertNull((Object)this.table.reload(new BigQuery.TableOption[0]));
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO.getTableId(), new BigQuery.TableOption[0]);
    }

    @Test
    public void testReloadWithOptions() {
        TableInfo updatedInfo = TABLE_INFO.toBuilder().setDescription("Description").build();
        Table expectedTable = new Table(this.bigquery, new TableInfo.BuilderImpl(updatedInfo));
        Mockito.when((Object)this.bigquery.getTable(TABLE_INFO.getTableId(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])})).thenReturn((Object)expectedTable);
        Table updatedTable = this.table.reload(new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        this.compareTable(expectedTable, updatedTable);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).getTable(TABLE_INFO.getTableId(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
    }

    @Test
    public void testUpdate() {
        Table expectedUpdatedTable = this.expectedTable.toBuilder().setDescription("Description").build();
        Mockito.when((Object)this.bigquery.update((TableInfo)Mockito.eq((Object)this.expectedTable), new BigQuery.TableOption[0])).thenReturn((Object)expectedUpdatedTable);
        Table actualUpdatedTable = this.table.update(new BigQuery.TableOption[0]);
        this.compareTable(expectedUpdatedTable, actualUpdatedTable);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((TableInfo)Mockito.eq((Object)this.expectedTable), new BigQuery.TableOption[0]);
    }

    @Test
    public void testUpdateWithOptions() {
        Table expectedUpdatedTable = this.expectedTable.toBuilder().setDescription("Description").build();
        Mockito.when((Object)this.bigquery.update((TableInfo)Mockito.eq((Object)this.expectedTable), new BigQuery.TableOption[]{(BigQuery.TableOption)Mockito.eq((Object)BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0]))})).thenReturn((Object)expectedUpdatedTable);
        Table actualUpdatedTable = this.table.update(new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        this.compareTable(expectedUpdatedTable, actualUpdatedTable);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).update((TableInfo)Mockito.eq((Object)this.expectedTable), new BigQuery.TableOption[]{(BigQuery.TableOption)Mockito.eq((Object)BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0]))});
    }

    @Test
    public void testDeleteTrue() {
        Mockito.when((Object)this.bigquery.delete(TABLE_INFO.getTableId())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.table.delete());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(TABLE_INFO.getTableId());
    }

    @Test
    public void testDeleteFalse() {
        Mockito.when((Object)this.bigquery.delete(TABLE_INFO.getTableId())).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.table.delete());
        ((BigQuery)Mockito.verify((Object)this.bigquery)).delete(TABLE_INFO.getTableId());
    }

    @Test
    public void testInsert() {
        Mockito.when((Object)this.bigquery.insertAll(INSERT_ALL_REQUEST)).thenReturn((Object)EMPTY_INSERT_ALL_RESPONSE);
        InsertAllResponse response = this.table.insert(ROWS_TO_INSERT);
        Assert.assertSame((Object)EMPTY_INSERT_ALL_RESPONSE, (Object)response);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).insertAll(INSERT_ALL_REQUEST);
    }

    @Test
    public void testInsertComplete() {
        Mockito.when((Object)this.bigquery.insertAll(INSERT_ALL_REQUEST_COMPLETE)).thenReturn((Object)EMPTY_INSERT_ALL_RESPONSE);
        InsertAllResponse response = this.table.insert(ROWS_TO_INSERT, true, true);
        Assert.assertSame((Object)EMPTY_INSERT_ALL_RESPONSE, (Object)response);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).insertAll(INSERT_ALL_REQUEST_COMPLETE);
    }

    @Test
    public void testList() {
        PageImpl page = new PageImpl(null, "c", ROWS);
        Mockito.when((Object)this.bigquery.listTableData(TABLE_ID1, new BigQuery.TableDataListOption[0])).thenReturn((Object)TableResult.newBuilder().setTotalRows(Long.valueOf(ROWS.size())).setPageNoSchema((Page)page).build());
        Mockito.when((Object)this.bigquery.listTableData(TABLE_ID1, SCHEMA, new BigQuery.TableDataListOption[0])).thenReturn((Object)TableResult.newBuilder().setSchema(SCHEMA).setTotalRows(Long.valueOf(ROWS.size())).setPageNoSchema((Page)page).build());
        TableResult dataPage = this.table.list(new BigQuery.TableDataListOption[0]);
        Truth.assertThat((Iterable)dataPage.getValues()).containsExactlyElementsIn(ROWS).inOrder();
        dataPage = this.table.list(SCHEMA, new BigQuery.TableDataListOption[0]);
        Truth.assertThat((Iterable)dataPage.getValues()).containsExactlyElementsIn(ROWS_WITH_SCHEMA).inOrder();
        ((BigQuery)Mockito.verify((Object)this.bigquery)).listTableData(TABLE_ID1, new BigQuery.TableDataListOption[0]);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).listTableData(TABLE_ID1, SCHEMA, new BigQuery.TableDataListOption[0]);
    }

    @Test
    public void testListWithOptions() {
        PageImpl page = new PageImpl(null, "c", ROWS);
        Mockito.when((Object)this.bigquery.listTableData(TABLE_ID1, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)})).thenReturn((Object)TableResult.newBuilder().setTotalRows(Long.valueOf(ROWS.size())).setPageNoSchema((Page)page).build());
        Mockito.when((Object)this.bigquery.listTableData(TABLE_ID1, SCHEMA, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)})).thenReturn((Object)TableResult.newBuilder().setSchema(SCHEMA).setTotalRows(Long.valueOf(ROWS.size())).setPageNoSchema((Page)page).build());
        TableResult dataPage = this.table.list(new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)});
        Truth.assertThat((Iterable)dataPage.getValues()).containsExactlyElementsIn(ROWS).inOrder();
        dataPage = this.table.list(SCHEMA, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)});
        Truth.assertThat((Iterable)dataPage.getValues()).containsExactlyElementsIn(ROWS_WITH_SCHEMA).inOrder();
        ((BigQuery)Mockito.verify((Object)this.bigquery)).listTableData(TABLE_ID1, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)});
        ((BigQuery)Mockito.verify((Object)this.bigquery)).listTableData(TABLE_ID1, SCHEMA, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.pageSize((long)10L)});
    }

    @Test
    public void testCopyFromString() {
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(COPY_JOB_INFO));
        Mockito.when((Object)this.bigquery.create(COPY_JOB_INFO, new BigQuery.JobOption[0])).thenReturn((Object)expectedJob);
        Job job = this.table.copy(TABLE_ID2.getDataset(), TABLE_ID2.getTable(), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(COPY_JOB_INFO, new BigQuery.JobOption[0]);
    }

    @Test
    public void testCopyFromId() {
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(COPY_JOB_INFO));
        Mockito.when((Object)this.bigquery.create(COPY_JOB_INFO, new BigQuery.JobOption[0])).thenReturn((Object)expectedJob);
        Job job = this.table.copy(TABLE_ID2.getDataset(), TABLE_ID2.getTable(), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(COPY_JOB_INFO, new BigQuery.JobOption[0]);
    }

    @Test
    public void testLoadDataUri() {
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(LOAD_JOB_INFO));
        Mockito.when((Object)this.bigquery.create(LOAD_JOB_INFO, new BigQuery.JobOption[0])).thenReturn((Object)expectedJob);
        Job job = this.table.load(FormatOptions.json(), "URI", new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(LOAD_JOB_INFO, new BigQuery.JobOption[0]);
    }

    @Test
    public void testLoadDataUris() {
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(LOAD_JOB_INFO));
        Mockito.when((Object)this.bigquery.create(LOAD_JOB_INFO, new BigQuery.JobOption[0])).thenReturn((Object)expectedJob);
        Job job = this.table.load(FormatOptions.json(), (List)ImmutableList.of((Object)"URI"), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(LOAD_JOB_INFO, new BigQuery.JobOption[0]);
    }

    @Test
    public void testExtractDataUri() {
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(EXTRACT_JOB_INFO));
        Mockito.when((Object)this.bigquery.create(EXTRACT_JOB_INFO, new BigQuery.JobOption[0])).thenReturn((Object)expectedJob);
        Job job = this.table.extract("CSV", "URI", new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(EXTRACT_JOB_INFO, new BigQuery.JobOption[0]);
    }

    @Test
    public void testExtractDataUris() {
        Job expectedJob = new Job(this.bigquery, new JobInfo.BuilderImpl(EXTRACT_JOB_INFO));
        Mockito.when((Object)this.bigquery.create(EXTRACT_JOB_INFO, new BigQuery.JobOption[0])).thenReturn((Object)expectedJob);
        Job job = this.table.extract("CSV", (List)ImmutableList.of((Object)"URI"), new BigQuery.JobOption[0]);
        Assert.assertSame((Object)expectedJob, (Object)job);
        ((BigQuery)Mockito.verify((Object)this.bigquery)).create(EXTRACT_JOB_INFO, new BigQuery.JobOption[0]);
    }

    @Test
    public void testBigQuery() {
        Assert.assertSame((Object)this.bigquery, (Object)this.expectedTable.getBigQuery());
    }

    @Test
    public void testToAndFromPb() {
        this.compareTable(this.expectedTable, Table.fromPb((BigQuery)this.bigquery, (com.google.api.services.bigquery.model.Table)this.expectedTable.toPb()));
    }

    private void compareTable(Table expected, Table value) {
        Assert.assertEquals((Object)expected, (Object)value);
        this.compareTableInfo((TableInfo)expected, (TableInfo)value);
        Assert.assertEquals((Object)expected.getBigQuery().getOptions(), (Object)value.getBigQuery().getOptions());
    }

    private void compareTableInfo(TableInfo expected, TableInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getTableId(), (Object)value.getTableId());
        Assert.assertEquals((Object)expected.getDefinition(), (Object)value.getDefinition());
        Assert.assertEquals((Object)expected.getCreationTime(), (Object)value.getCreationTime());
        Assert.assertEquals((Object)expected.getDescription(), (Object)value.getDescription());
        Assert.assertEquals((Object)expected.getEtag(), (Object)value.getEtag());
        Assert.assertEquals((Object)expected.getExpirationTime(), (Object)value.getExpirationTime());
        Assert.assertEquals((Object)expected.getFriendlyName(), (Object)value.getFriendlyName());
        Assert.assertEquals((Object)expected.getGeneratedId(), (Object)value.getGeneratedId());
        Assert.assertEquals((Object)expected.getLastModifiedTime(), (Object)value.getLastModifiedTime());
        Assert.assertEquals((Object)expected.getSelfLink(), (Object)value.getSelfLink());
        Assert.assertEquals((Object)expected.getDefinition(), (Object)value.getDefinition());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

