/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.TimePartitioning;
import org.junit.Assert;
import org.junit.Test;

public class TimePartitioningTest {
    private static final TimePartitioning.Type TYPE_DAY = TimePartitioning.Type.DAY;
    private static final TimePartitioning.Type TYPE_HOUR = TimePartitioning.Type.HOUR;
    private static final TimePartitioning.Type TYPE_MONTH = TimePartitioning.Type.MONTH;
    private static final TimePartitioning.Type TYPE_YEAR = TimePartitioning.Type.YEAR;
    private static final long EXPIRATION_MS = 42L;
    private static final boolean REQUIRE_PARTITION_FILTER = false;
    private static final String FIELD = "field";
    private static final TimePartitioning TIME_PARTITIONING_DAY = TimePartitioning.newBuilder((TimePartitioning.Type)TYPE_DAY).setExpirationMs(Long.valueOf(42L)).setRequirePartitionFilter(Boolean.valueOf(false)).setField("field").build();
    private static final TimePartitioning TIME_PARTITIONING_HOUR = TimePartitioning.newBuilder((TimePartitioning.Type)TYPE_HOUR).setExpirationMs(Long.valueOf(42L)).setRequirePartitionFilter(Boolean.valueOf(false)).setField("field").build();
    private static final TimePartitioning TIME_PARTITIONING_MONTH = TimePartitioning.newBuilder((TimePartitioning.Type)TYPE_MONTH).setExpirationMs(Long.valueOf(42L)).setRequirePartitionFilter(Boolean.valueOf(false)).setField("field").build();
    private static final TimePartitioning TIME_PARTITIONING_YEAR = TimePartitioning.newBuilder((TimePartitioning.Type)TYPE_YEAR).setExpirationMs(Long.valueOf(42L)).setRequirePartitionFilter(Boolean.valueOf(false)).setField("field").build();

    @Test
    public void testOf() {
        Assert.assertEquals((Object)TYPE_DAY, (Object)TIME_PARTITIONING_DAY.getType());
        Assert.assertEquals((Object)TYPE_HOUR, (Object)TIME_PARTITIONING_HOUR.getType());
        Assert.assertEquals((Object)TYPE_MONTH, (Object)TIME_PARTITIONING_MONTH.getType());
        Assert.assertEquals((Object)TYPE_YEAR, (Object)TIME_PARTITIONING_YEAR.getType());
        Assert.assertEquals((long)42L, (long)TIME_PARTITIONING_DAY.getExpirationMs());
        Assert.assertEquals((Object)false, (Object)TIME_PARTITIONING_DAY.getRequirePartitionFilter());
        Assert.assertEquals((Object)FIELD, (Object)TIME_PARTITIONING_DAY.getField());
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TYPE_DAY);
        Assert.assertEquals((Object)TYPE_DAY, (Object)partitioning.getType());
        Assert.assertNull((Object)partitioning.getExpirationMs());
    }

    @Test
    public void testBuilder() {
        TimePartitioning partitioning = TimePartitioning.newBuilder((TimePartitioning.Type)TYPE_DAY).build();
        Assert.assertEquals((Object)TYPE_DAY, (Object)partitioning.getType());
        Assert.assertNull((Object)partitioning.getExpirationMs());
        Assert.assertNull((Object)partitioning.getRequirePartitionFilter());
        Assert.assertNull((Object)partitioning.getField());
        partitioning = TimePartitioning.newBuilder((TimePartitioning.Type)TYPE_DAY).setExpirationMs(Long.valueOf(100L)).build();
        Assert.assertEquals((Object)TYPE_DAY, (Object)partitioning.getType());
        Assert.assertEquals((long)100L, (long)partitioning.getExpirationMs());
        Assert.assertNull((Object)partitioning.getRequirePartitionFilter());
        Assert.assertNull((Object)partitioning.getField());
        this.compareTimePartitioning(TIME_PARTITIONING_HOUR, TIME_PARTITIONING_HOUR.toBuilder().build());
        Assert.assertNotEquals((Object)TIME_PARTITIONING_DAY, (Object)TYPE_DAY);
    }

    @Test
    public void testTypeOf_Npe() {
        try {
            TimePartitioning.of(null);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testTypeAndExpirationOf_Npe() {
        try {
            TimePartitioning.of(null, (long)42L);
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testToAndFromPb() {
        this.compareTimePartitioning(TIME_PARTITIONING_DAY, TimePartitioning.fromPb((com.google.api.services.bigquery.model.TimePartitioning)TIME_PARTITIONING_DAY.toPb()));
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TYPE_DAY);
        this.compareTimePartitioning(partitioning, TimePartitioning.fromPb((com.google.api.services.bigquery.model.TimePartitioning)partitioning.toPb()));
    }

    private void compareTimePartitioning(TimePartitioning expected, TimePartitioning value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getType(), (Object)value.getType());
        Assert.assertEquals((Object)expected.getExpirationMs(), (Object)value.getExpirationMs());
        Assert.assertEquals((Object)expected.getRequirePartitionFilter(), (Object)value.getRequirePartitionFilter());
        Assert.assertEquals((Object)expected.getField(), (Object)value.getField());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
    }
}

