/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.UserDefinedFunction;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ViewDefinitionTest {
    private static final String VIEW_QUERY = "VIEW QUERY";
    private static final List<UserDefinedFunction> USER_DEFINED_FUNCTIONS = ImmutableList.of((Object)UserDefinedFunction.inline((String)"Function"), (Object)UserDefinedFunction.fromUri((String)"URI"));
    private static final ViewDefinition VIEW_DEFINITION = ViewDefinition.newBuilder((String)"VIEW QUERY", USER_DEFINED_FUNCTIONS).setSchema(Schema.of((Field[])new Field[0])).build();

    @Test
    public void testToBuilder() {
        this.compareViewDefinition(VIEW_DEFINITION, VIEW_DEFINITION.toBuilder().build());
        ViewDefinition viewDefinition = VIEW_DEFINITION.toBuilder().setQuery("NEW QUERY").build();
        Assert.assertEquals((Object)"NEW QUERY", (Object)viewDefinition.getQuery());
        viewDefinition = viewDefinition.toBuilder().setQuery(VIEW_QUERY).build();
        this.compareViewDefinition(VIEW_DEFINITION, viewDefinition);
        viewDefinition = viewDefinition.toBuilder().setUseLegacySql(Boolean.valueOf(true)).build();
        Assert.assertTrue((boolean)viewDefinition.useLegacySql());
        Assert.assertNotEquals((Object)VIEW_DEFINITION, (Object)VIEW_QUERY);
    }

    @Test
    public void testTypeNullPointerException() {
        try {
            VIEW_DEFINITION.toBuilder().setType(null).build();
            Assert.fail();
        }
        catch (NullPointerException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testToBuilderIncomplete() {
        ViewDefinition viewDefinition = ViewDefinition.of((String)VIEW_QUERY);
        Assert.assertEquals((Object)viewDefinition, (Object)viewDefinition.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)VIEW_QUERY, (Object)VIEW_DEFINITION.getQuery());
        Assert.assertEquals((Object)TableDefinition.Type.VIEW, (Object)VIEW_DEFINITION.getType());
        Assert.assertEquals(USER_DEFINED_FUNCTIONS, (Object)VIEW_DEFINITION.getUserDefinedFunctions());
        ViewDefinition viewDefinition = ViewDefinition.newBuilder((String)VIEW_QUERY).setUserDefinedFunctions(new UserDefinedFunction[]{UserDefinedFunction.inline((String)"Function"), UserDefinedFunction.fromUri((String)"URI")}).build();
        Assert.assertEquals((Object)VIEW_QUERY, (Object)viewDefinition.getQuery());
        Assert.assertEquals((Object)TableDefinition.Type.VIEW, (Object)viewDefinition.getType());
        Assert.assertEquals(USER_DEFINED_FUNCTIONS, (Object)viewDefinition.getUserDefinedFunctions());
        Assert.assertFalse((boolean)viewDefinition.useLegacySql());
        viewDefinition = ViewDefinition.newBuilder((String)VIEW_QUERY, (UserDefinedFunction[])new UserDefinedFunction[]{UserDefinedFunction.inline((String)"Function"), UserDefinedFunction.fromUri((String)"URI")}).build();
        Assert.assertEquals((Object)VIEW_QUERY, (Object)viewDefinition.getQuery());
        Assert.assertEquals((Object)TableDefinition.Type.VIEW, (Object)viewDefinition.getType());
        Assert.assertEquals(USER_DEFINED_FUNCTIONS, (Object)viewDefinition.getUserDefinedFunctions());
        Assert.assertFalse((boolean)viewDefinition.useLegacySql());
        viewDefinition = ViewDefinition.newBuilder((String)VIEW_QUERY).build();
        Assert.assertEquals((Object)VIEW_QUERY, (Object)viewDefinition.getQuery());
        Assert.assertEquals((Object)TableDefinition.Type.VIEW, (Object)viewDefinition.getType());
        Assert.assertNull((Object)viewDefinition.getUserDefinedFunctions());
        Assert.assertFalse((boolean)viewDefinition.useLegacySql());
        viewDefinition = ViewDefinition.newBuilder((String)VIEW_QUERY).setUseLegacySql(Boolean.valueOf(true)).build();
        Assert.assertEquals((Object)VIEW_QUERY, (Object)viewDefinition.getQuery());
        Assert.assertEquals((Object)TableDefinition.Type.VIEW, (Object)viewDefinition.getType());
        Assert.assertNull((Object)viewDefinition.getUserDefinedFunctions());
        Assert.assertTrue((boolean)viewDefinition.useLegacySql());
    }

    @Test
    public void testToAndFromPb() {
        ViewDefinition viewDefinition = VIEW_DEFINITION.toBuilder().setUseLegacySql(Boolean.valueOf(false)).build();
        Assert.assertTrue((boolean)(TableDefinition.fromPb((Table)viewDefinition.toPb()) instanceof ViewDefinition));
        this.compareViewDefinition(viewDefinition, (ViewDefinition)TableDefinition.fromPb((Table)viewDefinition.toPb()));
    }

    private void compareViewDefinition(ViewDefinition expected, ViewDefinition value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.getQuery(), (Object)value.getQuery());
        Assert.assertEquals((Object)expected.useLegacySql(), (Object)value.useLegacySql());
        Assert.assertEquals((Object)expected.getUserDefinedFunctions(), (Object)value.getUserDefinedFunctions());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

