/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class WriteChannelConfigurationTest {
    private static final CsvOptions CSV_OPTIONS = CsvOptions.newBuilder().setAllowJaggedRows(true).setAllowQuotedNewLines(false).setEncoding(StandardCharsets.UTF_8).build();
    private static final TableId TABLE_ID = TableId.of((String)"dataset", (String)"table");
    private static final JobInfo.CreateDisposition CREATE_DISPOSITION = JobInfo.CreateDisposition.CREATE_IF_NEEDED;
    private static final JobInfo.WriteDisposition WRITE_DISPOSITION = JobInfo.WriteDisposition.WRITE_APPEND;
    private static final String NULL_MARKER = "\\N";
    private static final Integer MAX_BAD_RECORDS = 42;
    private static final String FORMAT = "CSV";
    private static final Boolean IGNORE_UNKNOWN_VALUES = true;
    private static final Field FIELD_SCHEMA = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).setDescription("FieldDescription").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{FIELD_SCHEMA});
    private static final Boolean AUTODETECT = true;
    private static final Boolean USERAVROLOGICALTYPES = true;
    private static final List<JobInfo.SchemaUpdateOption> SCHEMA_UPDATE_OPTIONS = ImmutableList.of((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
    private static final TimePartitioning TIME_PARTITIONING = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
    private static final Clustering CLUSTERING = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)"Foo", (Object)"Bar")).build();
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"test-job-name", (Object)"test-write-channel");
    private static final List<String> DECIMAL_TARGET_TYPES = ImmutableList.of((Object)"NUMERIC", (Object)"BIGNUMERIC");
    private static final boolean CREATE_SESSION = true;
    private static final String KEY = "session_id";
    private static final String VALUE = "session_id_1234567890";
    private static final ConnectionProperty CONNECTION_PROPERTY = ConnectionProperty.newBuilder().setKey("session_id").setValue("session_id_1234567890").build();
    private static final List<ConnectionProperty> CONNECTION_PROPERTIES = ImmutableList.of((Object)CONNECTION_PROPERTY);
    private static final WriteChannelConfiguration LOAD_CONFIGURATION_CSV = WriteChannelConfiguration.newBuilder((TableId)TABLE_ID).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setNullMarker("\\N").setFormatOptions((FormatOptions)CSV_OPTIONS).setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchema(TABLE_SCHEMA).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setAutodetect(AUTODETECT).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setLabels(LABELS).setDecimalTargetTypes(DECIMAL_TARGET_TYPES).setConnectionProperties(CONNECTION_PROPERTIES).setCreateSession(Boolean.valueOf(true)).build();
    private static final DatastoreBackupOptions BACKUP_OPTIONS = DatastoreBackupOptions.newBuilder().setProjectionFields((List)ImmutableList.of((Object)"field_1", (Object)"field_2")).build();
    private static final WriteChannelConfiguration LOAD_CONFIGURATION_BACKUP = WriteChannelConfiguration.newBuilder((TableId)TABLE_ID).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setFormatOptions((FormatOptions)BACKUP_OPTIONS).setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchema(TABLE_SCHEMA).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setAutodetect(AUTODETECT).build();
    private static final WriteChannelConfiguration LOAD_CONFIGURATION_AVRO = WriteChannelConfiguration.newBuilder((TableId)TABLE_ID).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setNullMarker("\\N").setFormatOptions((FormatOptions)FormatOptions.avro()).setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchema(TABLE_SCHEMA).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setAutodetect(AUTODETECT).setTimePartitioning(TIME_PARTITIONING).setClustering(CLUSTERING).setUseAvroLogicalTypes(USERAVROLOGICALTYPES).setDecimalTargetTypes(DECIMAL_TARGET_TYPES).build();

    @Test
    public void testToBuilder() {
        this.compareLoadConfiguration(LOAD_CONFIGURATION_CSV, LOAD_CONFIGURATION_CSV.toBuilder().build());
        WriteChannelConfiguration configuration = LOAD_CONFIGURATION_CSV.toBuilder().setDestinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)configuration.getDestinationTable().getTable());
        configuration = configuration.toBuilder().setDestinationTable(TABLE_ID).build();
        this.compareLoadConfiguration(LOAD_CONFIGURATION_CSV, configuration);
        this.compareLoadConfiguration(LOAD_CONFIGURATION_AVRO, LOAD_CONFIGURATION_AVRO.toBuilder().build());
        WriteChannelConfiguration configurationAvro = LOAD_CONFIGURATION_AVRO.toBuilder().setDestinationTable(TableId.of((String)"dataset", (String)"newTable")).build();
        Assert.assertEquals((Object)"newTable", (Object)configurationAvro.getDestinationTable().getTable());
        configurationAvro = configurationAvro.toBuilder().setDestinationTable(TABLE_ID).build();
        this.compareLoadConfiguration(LOAD_CONFIGURATION_AVRO, configurationAvro);
    }

    @Test
    public void testOf() {
        WriteChannelConfiguration configuration = WriteChannelConfiguration.of((TableId)TABLE_ID);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.getDestinationTable());
        configuration = WriteChannelConfiguration.of((TableId)TABLE_ID, (FormatOptions)CSV_OPTIONS);
        Assert.assertEquals((Object)TABLE_ID, (Object)configuration.getDestinationTable());
        Assert.assertEquals((Object)FORMAT, (Object)configuration.getFormat());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)configuration.getCsvOptions());
    }

    @Test
    public void testToBuilderIncomplete() {
        WriteChannelConfiguration configuration = WriteChannelConfiguration.of((TableId)TABLE_ID);
        this.compareLoadConfiguration(configuration, configuration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)TABLE_ID, (Object)LOAD_CONFIGURATION_CSV.getDestinationTable());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)LOAD_CONFIGURATION_CSV.getCreateDisposition());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)LOAD_CONFIGURATION_CSV.getWriteDisposition());
        Assert.assertEquals((Object)NULL_MARKER, (Object)LOAD_CONFIGURATION_CSV.getNullMarker());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)LOAD_CONFIGURATION_CSV.getCsvOptions());
        Assert.assertEquals((Object)FORMAT, (Object)LOAD_CONFIGURATION_CSV.getFormat());
        Assert.assertEquals((Object)IGNORE_UNKNOWN_VALUES, (Object)LOAD_CONFIGURATION_CSV.ignoreUnknownValues());
        Assert.assertEquals((Object)MAX_BAD_RECORDS, (Object)LOAD_CONFIGURATION_CSV.getMaxBadRecords());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)LOAD_CONFIGURATION_CSV.getSchema());
        Assert.assertEquals(LABELS, (Object)LOAD_CONFIGURATION_CSV.getLabels());
        Assert.assertEquals((Object)BACKUP_OPTIONS, (Object)LOAD_CONFIGURATION_BACKUP.getDatastoreBackupOptions());
        Assert.assertEquals(SCHEMA_UPDATE_OPTIONS, (Object)LOAD_CONFIGURATION_CSV.getSchemaUpdateOptions());
        Assert.assertEquals(SCHEMA_UPDATE_OPTIONS, (Object)LOAD_CONFIGURATION_BACKUP.getSchemaUpdateOptions());
        WriteChannelConfiguration.Builder builder = WriteChannelConfiguration.newBuilder((TableId)TABLE_ID, (FormatOptions)CSV_OPTIONS).setCreateDisposition(CREATE_DISPOSITION).setWriteDisposition(WRITE_DISPOSITION).setNullMarker(NULL_MARKER).setIgnoreUnknownValues(IGNORE_UNKNOWN_VALUES).setMaxBadRecords(MAX_BAD_RECORDS).setSchemaUpdateOptions(SCHEMA_UPDATE_OPTIONS).setSchema(TABLE_SCHEMA).setAutodetect(AUTODETECT).setDecimalTargetTypes(DECIMAL_TARGET_TYPES);
        WriteChannelConfiguration loadConfigurationCSV = builder.build();
        Assert.assertEquals((Object)TABLE_ID, (Object)loadConfigurationCSV.getDestinationTable());
        Assert.assertEquals((Object)CREATE_DISPOSITION, (Object)loadConfigurationCSV.getCreateDisposition());
        Assert.assertEquals((Object)WRITE_DISPOSITION, (Object)loadConfigurationCSV.getWriteDisposition());
        Assert.assertEquals((Object)NULL_MARKER, (Object)loadConfigurationCSV.getNullMarker());
        Assert.assertEquals((Object)CSV_OPTIONS, (Object)loadConfigurationCSV.getCsvOptions());
        Assert.assertEquals((Object)FORMAT, (Object)loadConfigurationCSV.getFormat());
        Assert.assertEquals((Object)IGNORE_UNKNOWN_VALUES, (Object)loadConfigurationCSV.ignoreUnknownValues());
        Assert.assertEquals((Object)MAX_BAD_RECORDS, (Object)loadConfigurationCSV.getMaxBadRecords());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)loadConfigurationCSV.getSchema());
        Assert.assertEquals(SCHEMA_UPDATE_OPTIONS, (Object)loadConfigurationCSV.getSchemaUpdateOptions());
        Assert.assertEquals((Object)AUTODETECT, (Object)loadConfigurationCSV.getAutodetect());
        Assert.assertEquals(DECIMAL_TARGET_TYPES, (Object)loadConfigurationCSV.getDecimalTargetTypes());
        builder.setFormatOptions((FormatOptions)BACKUP_OPTIONS);
        WriteChannelConfiguration loadConfigurationBackup = builder.build();
        Assert.assertEquals((Object)BACKUP_OPTIONS, (Object)loadConfigurationBackup.getDatastoreBackupOptions());
    }

    @Test
    public void testToPbAndFromPb() {
        Assert.assertNull((Object)LOAD_CONFIGURATION_CSV.toPb().getLoad().getSourceUris());
        this.compareLoadConfiguration(LOAD_CONFIGURATION_CSV, WriteChannelConfiguration.fromPb((JobConfiguration)LOAD_CONFIGURATION_CSV.toPb()));
        WriteChannelConfiguration configuration = WriteChannelConfiguration.of((TableId)TABLE_ID);
        this.compareLoadConfiguration(configuration, WriteChannelConfiguration.fromPb((JobConfiguration)configuration.toPb()));
    }

    @Test
    public void testSetProjectIdDoNotOverride() {
        WriteChannelConfiguration configuration = WriteChannelConfiguration.of((TableId)TABLE_ID).setProjectId("project");
        configuration.setProjectId("different-project").toBuilder();
        Assert.assertEquals((Object)"project", (Object)configuration.getDestinationTable().getProject());
    }

    private void compareLoadConfiguration(WriteChannelConfiguration expected, WriteChannelConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)value.toString());
        Assert.assertEquals((Object)expected.getDestinationTable(), (Object)value.getDestinationTable());
        Assert.assertEquals((Object)expected.getCreateDisposition(), (Object)value.getCreateDisposition());
        Assert.assertEquals((Object)expected.getWriteDisposition(), (Object)value.getWriteDisposition());
        Assert.assertEquals((Object)expected.getNullMarker(), (Object)value.getNullMarker());
        Assert.assertEquals((Object)expected.getCsvOptions(), (Object)value.getCsvOptions());
        Assert.assertEquals((Object)expected.getFormat(), (Object)value.getFormat());
        Assert.assertEquals((Object)expected.ignoreUnknownValues(), (Object)value.ignoreUnknownValues());
        Assert.assertEquals((Object)expected.getMaxBadRecords(), (Object)value.getMaxBadRecords());
        Assert.assertEquals((Object)expected.getDatastoreBackupOptions(), (Object)value.getDatastoreBackupOptions());
        Assert.assertEquals((Object)expected.getSchema(), (Object)value.getSchema());
        Assert.assertEquals((Object)expected.getSchemaUpdateOptions(), (Object)value.getSchemaUpdateOptions());
        Assert.assertEquals((Object)expected.getAutodetect(), (Object)value.getAutodetect());
        Assert.assertEquals((Object)expected.getTimePartitioning(), (Object)value.getTimePartitioning());
        Assert.assertEquals((Object)expected.getClustering(), (Object)value.getClustering());
        Assert.assertEquals((Object)expected.getUseAvroLogicalTypes(), (Object)value.getUseAvroLogicalTypes());
        Assert.assertEquals((Object)expected.getLabels(), (Object)value.getLabels());
        Assert.assertEquals((Object)expected.getDecimalTargetTypes(), (Object)value.getDecimalTargetTypes());
        Assert.assertEquals((Object)expected.getConnectionProperties(), (Object)value.getConnectionProperties());
        Assert.assertEquals((Object)expected.getCreateSession(), (Object)value.getCreateSession());
    }
}

