/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.it;

import com.google.api.client.util.IOUtils;
import com.google.api.gax.paging.Page;
import com.google.api.services.bigquery.model.TrainingRun;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.Date;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.RetryOption;
import com.google.cloud.Role;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.Acl;
import com.google.cloud.bigquery.BiEngineReason;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryDryRunResult;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryResult;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.bigquery.CloneDefinition;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ColumnReference;
import com.google.cloud.bigquery.Connection;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.ConnectionSettings;
import com.google.cloud.bigquery.CopyJobConfiguration;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.ExecuteSelectResponse;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldElementType;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.ForeignKey;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.IndexUnusedReason;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.MaterializedViewDefinition;
import com.google.cloud.bigquery.Model;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.ModelInfo;
import com.google.cloud.bigquery.Parameter;
import com.google.cloud.bigquery.ParquetOptions;
import com.google.cloud.bigquery.PolicyTags;
import com.google.cloud.bigquery.PrimaryKey;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Range;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Routine;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.SnapshotTableDefinition;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardSQLField;
import com.google.cloud.bigquery.StandardSQLTableType;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableConstraints;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableMetadataCacheUsage;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.cloud.datacatalog.v1.CreatePolicyTagRequest;
import com.google.cloud.datacatalog.v1.CreateTaxonomyRequest;
import com.google.cloud.datacatalog.v1.PolicyTag;
import com.google.cloud.datacatalog.v1.PolicyTagManagerClient;
import com.google.cloud.datacatalog.v1.Taxonomy;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.testing.RemoteStorageHelper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.threeten.extra.PeriodDuration;

public class ITBigQueryTest {
    private static final byte[] BYTES = new byte[]{13, 14, 10, 13};
    private static final String BYTES_BASE64 = BaseEncoding.base64().encode(BYTES);
    private static final Long EXPIRATION_MS = 86400000L;
    private static final Logger LOG = Logger.getLogger(ITBigQueryTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String UK_DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String DESCRIPTION = "Test dataset";
    private static final String OTHER_DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String MODEL_DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String ROUTINE_DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String PROJECT_ID = ServiceOptions.getDefaultProjectId();
    private static final String RANDOM_ID = UUID.randomUUID().toString().substring(0, 8);
    private static final String STORAGE_BILLING_MODEL = "LOGICAL";
    private static final Long MAX_TIME_TRAVEL_HOURS = 120L;
    private static final Long MAX_TIME_TRAVEL_HOURS_DEFAULT = 168L;
    private static final String CLOUD_SAMPLES_DATA = (String)Optional.fromNullable((Object)System.getenv("CLOUD_SAMPLES_DATA_BUCKET")).or((Object)"cloud-samples-data");
    private static final Map<String, String> LABELS = ImmutableMap.of((Object)"example-label1", (Object)"example-value1", (Object)"example-label2", (Object)"example-value2");
    private static final Field TIMESTAMP_FIELD_SCHEMA = Field.newBuilder((String)"TimestampField", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("TimestampDescription").build();
    private static final Field STRING_FIELD_SCHEMA = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("StringDescription").build();
    private static final Field INTEGER_ARRAY_FIELD_SCHEMA = Field.newBuilder((String)"IntegerArrayField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("IntegerArrayDescription").build();
    private static final Field BOOLEAN_FIELD_SCHEMA = Field.newBuilder((String)"BooleanField", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BooleanDescription").build();
    private static final Field BYTES_FIELD_SCHEMA = Field.newBuilder((String)"BytesField", (LegacySQLTypeName)LegacySQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BytesDescription").build();
    private static final Field RECORD_FIELD_SCHEMA = Field.newBuilder((String)"RecordField", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{TIMESTAMP_FIELD_SCHEMA, STRING_FIELD_SCHEMA, INTEGER_ARRAY_FIELD_SCHEMA, BOOLEAN_FIELD_SCHEMA, BYTES_FIELD_SCHEMA}).setMode(Field.Mode.REQUIRED).setDescription("RecordDescription").build();
    private static final Field REPEATED_RECORD_FIELD_SCHEMA = Field.newBuilder((String)"Addresses", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{Field.newBuilder((String)"Status", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"Address", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"City", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"State", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"Zip", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"NumberOfYears", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()}).setMode(Field.Mode.REPEATED).build();
    private static final Field INTEGER_FIELD_SCHEMA = Field.newBuilder((String)"IntegerField", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("IntegerDescription").build();
    private static final Field FLOAT_FIELD_SCHEMA = Field.newBuilder((String)"FloatField", (LegacySQLTypeName)LegacySQLTypeName.FLOAT, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FloatDescription").build();
    private static final Field GEOGRAPHY_FIELD_SCHEMA = Field.newBuilder((String)"GeographyField", (LegacySQLTypeName)LegacySQLTypeName.GEOGRAPHY, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("GeographyDescription").build();
    private static final Field NUMERIC_FIELD_SCHEMA = Field.newBuilder((String)"NumericField", (LegacySQLTypeName)LegacySQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("NumericDescription").build();
    private static final Field BIGNUMERIC_FIELD_SCHEMA = Field.newBuilder((String)"BigNumericField", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumericDescription").build();
    private static final Field BIGNUMERIC_FIELD_SCHEMA1 = Field.newBuilder((String)"BigNumericField1", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric1Description").build();
    private static final Field BIGNUMERIC_FIELD_SCHEMA2 = Field.newBuilder((String)"BigNumericField2", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric2Description").build();
    private static final Field BIGNUMERIC_FIELD_SCHEMA3 = Field.newBuilder((String)"BigNumericField3", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric3Description").build();
    private static final Field BIGNUMERIC_FIELD_SCHEMA4 = Field.newBuilder((String)"BigNumericField4", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric4Description").build();
    private static final Schema TABLE_SCHEMA = Schema.of((Field[])new Field[]{TIMESTAMP_FIELD_SCHEMA, STRING_FIELD_SCHEMA, INTEGER_ARRAY_FIELD_SCHEMA, BOOLEAN_FIELD_SCHEMA, BYTES_FIELD_SCHEMA, RECORD_FIELD_SCHEMA, INTEGER_FIELD_SCHEMA, FLOAT_FIELD_SCHEMA, GEOGRAPHY_FIELD_SCHEMA, NUMERIC_FIELD_SCHEMA, BIGNUMERIC_FIELD_SCHEMA, BIGNUMERIC_FIELD_SCHEMA1, BIGNUMERIC_FIELD_SCHEMA2, BIGNUMERIC_FIELD_SCHEMA3, BIGNUMERIC_FIELD_SCHEMA4});
    private static final Schema BQ_RESULTSET_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"TimestampField", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("TimestampDescription").build(), Field.newBuilder((String)"StringField", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("StringDescription").build(), Field.newBuilder((String)"IntegerArrayField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("IntegerArrayDescription").build(), Field.newBuilder((String)"BooleanField", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BooleanDescription").build(), Field.newBuilder((String)"BytesField", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BytesDescription").build(), Field.newBuilder((String)"RecordField", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"TimestampField", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("TimestampDescription").build(), Field.newBuilder((String)"StringField", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("StringDescription").build(), Field.newBuilder((String)"IntegerArrayField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("IntegerArrayDescription").build(), Field.newBuilder((String)"BooleanField", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BooleanDescription").build(), Field.newBuilder((String)"BytesField", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BytesDescription").build()}).setMode(Field.Mode.REQUIRED).setDescription("RecordDescription").build(), Field.newBuilder((String)"IntegerField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("IntegerDescription").build(), Field.newBuilder((String)"FloatField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("FloatDescription").build(), Field.newBuilder((String)"GeographyField", (StandardSQLTypeName)StandardSQLTypeName.GEOGRAPHY, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("GeographyDescription").build(), Field.newBuilder((String)"NumericField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("NumericDescription").build(), Field.newBuilder((String)"BigNumericField", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumericDescription").build(), Field.newBuilder((String)"BigNumericField1", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric1Description").build(), Field.newBuilder((String)"BigNumericField2", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric2Description").build(), Field.newBuilder((String)"BigNumericField3", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric3Description").build(), Field.newBuilder((String)"BigNumericField4", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumeric4Description").build(), Field.newBuilder((String)"TimeField", (StandardSQLTypeName)StandardSQLTypeName.TIME, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("TimeDescription").build(), Field.newBuilder((String)"DateField", (StandardSQLTypeName)StandardSQLTypeName.DATE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("DateDescription").build(), Field.newBuilder((String)"DateTimeField", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("DateTimeDescription").build()});
    private static final Field DDL_TIMESTAMP_FIELD_SCHEMA = Field.newBuilder((String)"TimestampField", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setDescription("TimestampDescription").build();
    private static final Field DDL_STRING_FIELD_SCHEMA = Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setDescription("StringDescription").build();
    private static final Field DDL_BOOLEAN_FIELD_SCHEMA = Field.newBuilder((String)"BooleanField", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]).setDescription("BooleanDescription").build();
    private static final Schema DDL_TABLE_SCHEMA = Schema.of((Field[])new Field[]{DDL_TIMESTAMP_FIELD_SCHEMA, DDL_STRING_FIELD_SCHEMA, DDL_BOOLEAN_FIELD_SCHEMA});
    private static final Schema LARGE_TABLE_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"date", (LegacySQLTypeName)LegacySQLTypeName.DATE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"county", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"state_name", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"county_fips_code", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"confirmed_cases", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"deaths", (LegacySQLTypeName)LegacySQLTypeName.INTEGER, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final Schema REPEATED_RECORD_TABLE_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"ID", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"FirstName", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"LastName", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"DOB", (LegacySQLTypeName)LegacySQLTypeName.DATE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), REPEATED_RECORD_FIELD_SCHEMA});
    private static final Schema SIMPLE_SCHEMA = Schema.of((Field[])new Field[]{STRING_FIELD_SCHEMA});
    private static final Schema QUERY_RESULT_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"TimestampField", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BooleanField", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final Schema BQ_RESULTSET_EXPECTED_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"StringField", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BigNumericField", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BooleanField", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BytesField", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"IntegerField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"TimestampField", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"FloatField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"NumericField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"TimeField", (StandardSQLTypeName)StandardSQLTypeName.TIME, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"DateField", (StandardSQLTypeName)StandardSQLTypeName.DATE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"DateTimeField", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"GeographyField", (StandardSQLTypeName)StandardSQLTypeName.GEOGRAPHY, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BytesField_1", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BooleanField_1", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"IntegerArrayField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build()});
    private static final Schema QUERY_RESULT_SCHEMA_BIGNUMERIC = Schema.of((Field[])new Field[]{Field.newBuilder((String)"TimestampField", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BooleanField", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BigNumericField", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BigNumericField1", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BigNumericField2", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BigNumericField3", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BigNumericField4", (LegacySQLTypeName)LegacySQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final Schema VIEW_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"TimestampField", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"StringField", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"BooleanField", (LegacySQLTypeName)LegacySQLTypeName.BOOLEAN, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final RangePartitioning.Range RANGE = RangePartitioning.Range.newBuilder().setStart(Long.valueOf(1L)).setInterval(Long.valueOf(2L)).setEnd(Long.valueOf(20L)).build();
    private static final RangePartitioning RANGE_PARTITIONING = RangePartitioning.newBuilder().setField("IntegerField").setRange(RANGE).build();
    private static final String LOAD_FILE = "load.csv";
    private static final String LOAD_FILE_LARGE = "load_large.csv";
    private static final String LOAD_FILE_FLEXIBLE_COLUMN_NAME = "load_flexible_column_name.csv";
    private static final String JSON_LOAD_FILE = "load.json";
    private static final String JSON_LOAD_FILE_BQ_RESULTSET = "load_bq_resultset.json";
    private static final String JSON_LOAD_FILE_SIMPLE = "load_simple.json";
    private static final String EXTRACT_FILE = "extract.csv";
    private static final String EXTRACT_MODEL_FILE = "extract_model.csv";
    private static final String BUCKET = RemoteStorageHelper.generateBucketName();
    private static final TableId TABLE_ID = TableId.of((String)DATASET, (String)"testing_table");
    private static final TableId TABLE_ID_DDL = TableId.of((String)DATASET, (String)"ddl_testing_table");
    private static final TableId TABLE_ID_FASTQUERY = TableId.of((String)DATASET, (String)"fastquery_testing_table");
    private static final TableId TABLE_ID_FASTQUERY_UK = TableId.of((String)UK_DATASET, (String)"fastquery_testing_table");
    private static final TableId TABLE_ID_LARGE = TableId.of((String)DATASET, (String)"large_data_testing_table");
    private static final TableId TABLE_ID_FASTQUERY_BQ_RESULTSET = TableId.of((String)DATASET, (String)"fastquery_testing_bq_resultset");
    private static final String CSV_CONTENT = "StringValue1\nStringValue2\n";
    private static final String CSV_CONTENT_FLEXIBLE_COLUMN = "name,&ampersand\nrow_name,1";
    private static final String JSON_CONTENT = "{  \"TimestampField\": \"2014-08-19 07:41:35.220 -05:00\",  \"StringField\": \"stringValue\",  \"IntegerArrayField\": [\"0\", \"1\"],  \"BooleanField\": \"false\",  \"BytesField\": \"" + BYTES_BASE64 + "\",  \"RecordField\": {    \"TimestampField\": \"1969-07-20 20:18:04 UTC\",    \"StringField\": null,    \"IntegerArrayField\": [\"1\",\"0\"],    \"BooleanField\": \"true\",    \"BytesField\": \"" + BYTES_BASE64 + "\"  },  \"IntegerField\": \"3\",  \"FloatField\": \"1.2\",  \"GeographyField\": \"POINT(-122.35022 47.649154)\",  \"NumericField\": \"123456.789012345\",  \"BigNumericField\": \"0.33333333333333333333333333333333333333\",  \"BigNumericField1\": \"1e-38\",  \"BigNumericField2\": \"-1e38\",  \"BigNumericField3\": \"578960446186580977117854925043439539266.34992332820282019728792003956564819967\",  \"BigNumericField4\": \"-578960446186580977117854925043439539266.34992332820282019728792003956564819968\"}\n{  \"TimestampField\": \"2014-08-19 07:41:35.220 -05:00\",  \"StringField\": \"stringValue\",  \"IntegerArrayField\": [\"0\", \"1\"],  \"BooleanField\": \"false\",  \"BytesField\": \"" + BYTES_BASE64 + "\",  \"RecordField\": {    \"TimestampField\": \"1969-07-20 20:18:04 UTC\",    \"StringField\": null,    \"IntegerArrayField\": [\"1\",\"0\"],    \"BooleanField\": \"true\",    \"BytesField\": \"" + BYTES_BASE64 + "\"  },  \"IntegerField\": \"3\",  \"FloatField\": \"1.2\",  \"GeographyField\": \"POINT(-122.35022 47.649154)\",  \"NumericField\": \"123456.789012345\",  \"BigNumericField\": \"0.33333333333333333333333333333333333333\",  \"BigNumericField1\": \"1e-38\",  \"BigNumericField2\": \"-1e38\",  \"BigNumericField3\": \"578960446186580977117854925043439539266.34992332820282019728792003956564819967\",  \"BigNumericField4\": \"-578960446186580977117854925043439539266.34992332820282019728792003956564819968\"}";
    private static final String JSON_CONTENT_BQ_RESULTSET = "{  \"TimestampField\": null,  \"StringField\": null,  \"IntegerArrayField\": null,  \"BooleanField\": null,  \"BytesField\": null,  \"RecordField\": {    \"TimestampField\": null,    \"StringField\": null,    \"IntegerArrayField\": null,    \"BooleanField\": null,    \"BytesField\": null  },  \"IntegerField\": null,  \"FloatField\": null,  \"GeographyField\": null,  \"NumericField\": null,  \"BigNumericField\": null,  \"BigNumericField1\": null,  \"BigNumericField2\": null,  \"BigNumericField3\": null,  \"BigNumericField4\": null,  \"TimeField\": null,  \"DateField\": null,  \"DateTimeField\": null}\n{  \"TimestampField\": \"2018-08-19 12:11:35.123456 UTC\",  \"StringField\": \"StringValue1\",  \"IntegerArrayField\": [1,2,3,4],  \"BooleanField\": \"false\",  \"BytesField\": \"" + BYTES_BASE64 + "\",  \"RecordField\": {    \"TimestampField\": \"1969-07-20 20:18:04 UTC\",    \"StringField\": null,    \"IntegerArrayField\": [1,0],    \"BooleanField\": \"true\",    \"BytesField\": \"" + BYTES_BASE64 + "\"  },  \"IntegerField\": \"1\",  \"FloatField\": \"10.1\",  \"GeographyField\": \"POINT(-122.35022 47.649154)\",  \"NumericField\": \"100\",  \"BigNumericField\": \"0.33333333333333333333333333333333333333\",  \"BigNumericField1\": \"1e-38\",  \"BigNumericField2\": \"-1e38\",  \"BigNumericField3\": \"578960446186580977117854925043439539266.34992332820282019728792003956564819967\",  \"BigNumericField4\": \"-578960446186580977117854925043439539266.34992332820282019728792003956564819968\",  \"TimeField\": \"12:11:35.123456\",  \"DateField\": \"2018-08-19\",  \"DateTimeField\": \"2018-08-19 12:11:35.123456\"}";
    private static final String JSON_CONTENT_SIMPLE = "{  \"TimestampField\": \"2014-08-19 07:41:35.220 -05:00\",  \"StringField\": \"stringValue\",  \"BooleanField\": \"false\"}\n{  \"TimestampField\": \"2014-08-19 07:41:35.220 -05:00\",  \"StringField\": \"stringValue\",  \"BooleanField\": \"false\"}";
    private static final String KEY = "time_zone";
    private static final String VALUE = "US/Eastern";
    private static final ConnectionProperty CONNECTION_PROPERTY = ConnectionProperty.newBuilder().setKey("time_zone").setValue("US/Eastern").build();
    private static final List<ConnectionProperty> CONNECTION_PROPERTIES = ImmutableList.of((Object)CONNECTION_PROPERTY);
    private static final Field ID_SCHEMA = Field.newBuilder((String)"id", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).setDescription("id").build();
    private static final Field FIRST_NAME_SCHEMA = Field.newBuilder((String)"firstname", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("First Name").build();
    private static final Field LAST_NAME_SCHEMA = Field.newBuilder((String)"lastname", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("LAST NAME").build();
    private static final Field EMAIL_SCHEMA = Field.newBuilder((String)"email", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("email").build();
    private static final Field PROFESSION_SCHEMA = Field.newBuilder((String)"profession", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("profession").build();
    private static final Schema SESSION_TABLE_SCHEMA = Schema.of((Field[])new Field[]{ID_SCHEMA, FIRST_NAME_SCHEMA, LAST_NAME_SCHEMA, EMAIL_SCHEMA, PROFESSION_SCHEMA});
    private static final Schema CONSTRAINTS_TABLE_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"ID", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REQUIRED).build(), Field.newBuilder((String)"FirstName", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"LastName", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
    private static final Path csvPath = FileSystems.getDefault().getPath("src/test/resources", "sessionTest.csv").toAbsolutePath();
    private static final Set<String> PUBLIC_DATASETS = ImmutableSet.of((Object)"github_repos", (Object)"hacker_news", (Object)"noaa_gsod", (Object)"samples", (Object)"usa_names");
    private static final Map<String, String> PUBLIC_DATASETS_LOCATION = ImmutableMap.builder().put((Object)"github_repos", (Object)"US").put((Object)"hacker_news", (Object)"US").put((Object)"noaa_gsod", (Object)"US").put((Object)"samples", (Object)"US").put((Object)"usa_names", (Object)"US").put((Object)"gnomAD_asiane1", (Object)"asia-northeast1").put((Object)"gnomAD_eu", (Object)"EU").build();
    private static final String PUBLIC_PROJECT = "bigquery-public-data";
    private static final String PUBLIC_DATASET = "census_bureau_international";
    private static final String FAKE_JSON_CRED_WITH_GOOGLE_DOMAIN = "{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"project_id\": \"someprojectid\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\",\n  \"universe_domain\": \"googleapis.com\"\n}";
    private static final String FAKE_JSON_CRED_WITH_INVALID_DOMAIN = "{\n  \"private_key_id\": \"somekeyid\",\n  \"private_key\": \"-----BEGIN PRIVATE KEY-----\\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC+K2hSuFpAdrJI\\nnCgcDz2M7t7bjdlsadsasad+fvRSW6TjNQZ3p5LLQY1kSZRqBqylRkzteMOyHgaR\\n0Pmxh3ILCND5men43j3h4eDbrhQBuxfEMalkG92sL+PNQSETY2tnvXryOvmBRwa/\\nQP/9dJfIkIDJ9Fw9N4Bhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nknddadwkwewcVxHFhcZJO+XWf6ofLUXpRwiTZakGMn8EE1uVa2LgczOjwWHGi99MFjxSer5m9\\n1tCa3/KEGKiS/YL71JvjwX3mb+cewlkcmweBKZHM2JPTk0ZednFSpVZMtycjkbLa\\ndYOS8V85AgMBewECggEBAKksaldajfDZDV6nGqbFjMiizAKJolr/M3OQw16K6o3/\\n0S31xIe3sSlgW0+UbYlF4U8KifhManD1apVSC3csafaspP4RZUHFhtBywLO9pR5c\\nr6S5aLp+gPWFyIp1pfXbWGvc5VY/v9x7ya1VEa6rXvLsKupSeWAW4tMj3eo/64ge\\nsdaceaLYw52KeBYiT6+vpsnYrEkAHO1fF/LavbLLOFJmFTMxmsNaG0tuiJHgjshB\\n82DpMCbXG9YcCgI/DbzuIjsdj2JC1cascSP//3PmefWysucBQe7Jryb6NQtASmnv\\nCdDw/0jmZTEjpe4S1lxfHplAhHFtdgYTvyYtaLZiVVkCgYEA8eVpof2rceecw/I6\\n5ng1q3Hl2usdWV/4mZMvR0fOemacLLfocX6IYxT1zA1FFJlbXSRsJMf/Qq39mOR2\\nSpW+hr4jCoHeRVYLgsbggtrevGmILAlNoqCMpGZ6vDmJpq6ECV9olliDvpPgWOP+\\nmYPDreFBGxWvQrADNbRt2dmGsrsCgYEAyUHqB2wvJHFqdmeBsaacewzV8x9WgmeX\\ngUIi9REwXlGDW0Mz50dxpxcKCAYn65+7TCnY5O/jmL0VRxU1J2mSWyWTo1C+17L0\\n3fUqjxL1pkefwecxwecvC+gFFYdJ4CQ/MHHXU81Lwl1iWdFCd2UoGddYaOF+KNeM\\nHC7cmqra+JsCgYEAlUNywzq8nUg7282E+uICfCB0LfwejuymR93CtsFgb7cRd6ak\\nECR8FGfCpH8ruWJINllbQfcHVCX47ndLZwqv3oVFKh6pAS/vVI4dpOepP8++7y1u\\ncoOvtreXCX6XqfrWDtKIvv0vjlHBhhhp6mCcRpdQjV38H7JsyJ7lih/oNjECgYAt\\nkndj5uNl5SiuVxHFhcZJO+XWf6ofLUregtevZakGMn8EE1uVa2AY7eafmoU/nZPT\\n00YB0TBATdCbn/nBSuKDESkhSg9s2GEKQZG5hBmL5uCMfo09z3SfxZIhJdlerreP\\nJ7gSidI12N+EZxYd4xIJh/HFDgp7RRO87f+WJkofMQKBgGTnClK1VMaCRbJZPriw\\nEfeFCoOX75MxKwXs6xgrw4W//AYGGUjDt83lD6AZP6tws7gJ2IwY/qP7+lyhjEqN\\nHtfPZRGFkGZsdaksdlaksd323423d+15/UvrlRSFPNj1tWQmNKkXyRDW4IG1Oa2p\\nrALStNBx5Y9t0/LQnFI4w3aG\\n-----END PRIVATE KEY-----\\n\",\n  \"project_id\": \"someprojectid\",\n  \"client_email\": \"someclientid@developer.gserviceaccount.com\",\n  \"client_id\": \"someclientid.apps.googleusercontent.com\",\n  \"type\": \"service_account\",\n  \"universe_domain\": \"fake.domain\"\n}";
    private static final Schema RANGE_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"name", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("Name of the row").build(), Field.newBuilder((String)"date", (StandardSQLTypeName)StandardSQLTypeName.RANGE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("Range field with DATE").setRangeElementType(FieldElementType.newBuilder().setType("DATE").build()).build(), Field.newBuilder((String)"datetime", (StandardSQLTypeName)StandardSQLTypeName.RANGE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("Range field with DATETIME").setRangeElementType(FieldElementType.newBuilder().setType("DATETIME").build()).build(), Field.newBuilder((String)"timestamp", (StandardSQLTypeName)StandardSQLTypeName.RANGE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("Range field with TIMESTAMP").setRangeElementType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()});
    private static final ImmutableMap<String, Range> RANGE_TEST_VALUES_DATES = new ImmutableMap.Builder().put((Object)"bounded", (Object)Range.newBuilder().setStart("2020-01-01").setEnd("2020-12-31").setType(FieldElementType.newBuilder().setType("DATE").build()).build()).put((Object)"unboundedStart", (Object)Range.newBuilder().setStart(null).setEnd("2020-12-31").setType(FieldElementType.newBuilder().setType("DATE").build()).build()).put((Object)"unboundedEnd", (Object)Range.newBuilder().setStart("2020-01-01").setEnd(null).setType(FieldElementType.newBuilder().setType("DATE").build()).build()).put((Object)"unbounded", (Object)Range.newBuilder().setStart(null).setEnd(null).setType(FieldElementType.newBuilder().setType("DATE").build()).build()).build();
    private static final ImmutableMap<String, Range> RANGE_TEST_VALUES_DATETIME = new ImmutableMap.Builder().put((Object)"bounded", (Object)Range.newBuilder().setStart("2014-08-19T05:41:35.220000").setEnd("2015-09-20T06:41:35.220000").setType(FieldElementType.newBuilder().setType("DATETIME").build()).build()).put((Object)"unboundedStart", (Object)Range.newBuilder().setStart(null).setEnd("2015-09-20T06:41:35.220000").setType(FieldElementType.newBuilder().setType("DATETIME").build()).build()).put((Object)"unboundedEnd", (Object)Range.newBuilder().setStart("2014-08-19T05:41:35.220000").setEnd(null).setType(FieldElementType.newBuilder().setType("DATETIME").build()).build()).put((Object)"unbounded", (Object)Range.newBuilder().setStart(null).setEnd(null).setType(FieldElementType.newBuilder().setType("DATETIME").build()).build()).build();
    private static final ImmutableMap<String, Range> RANGE_TEST_VALUES_TIMESTAMP = new ImmutableMap.Builder().put((Object)"bounded", (Object)Range.newBuilder().setStart("2014-08-19 12:41:35.220000+00:00").setEnd("2015-09-20 13:41:35.220000+01:00").setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).put((Object)"unboundedStart", (Object)Range.newBuilder().setStart(null).setEnd("2015-09-20 13:41:35.220000+01:00").setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).put((Object)"unboundedEnd", (Object)Range.newBuilder().setStart("2014-08-19 12:41:35.220000+00:00").setEnd(null).setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).put((Object)"unbounded", (Object)Range.newBuilder().setStart(null).setEnd(null).setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).build();
    private static final ImmutableMap<String, Range> RANGE_TEST_VALUES_EXPECTED_TIMESTAMP = new ImmutableMap.Builder().put((Object)"bounded", (Object)Range.newBuilder().setStart("1408452095.220000").setEnd("1442752895.220000").setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).put((Object)"unboundedStart", (Object)Range.newBuilder().setStart(null).setEnd("1442752895.220000").setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).put((Object)"unboundedEnd", (Object)Range.newBuilder().setStart("1408452095.220000").setEnd(null).setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).put((Object)"unbounded", (Object)Range.newBuilder().setStart(null).setEnd(null).setType(FieldElementType.newBuilder().setType("TIMESTAMP").build()).build()).build();
    private static BigQuery bigquery;
    private static Storage storage;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    @BeforeClass
    public static void beforeClass() throws InterruptedException, IOException {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        RemoteStorageHelper storageHelper = RemoteStorageHelper.create();
        ImmutableMap labels = ImmutableMap.of((Object)"test-job-name", (Object)"test-load-job");
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        storage = (Storage)storageHelper.getOptions().getService();
        storage.create(BucketInfo.of((String)BUCKET), new Storage.BucketTargetOption[0]);
        storage.create(BlobInfo.newBuilder((String)BUCKET, (String)LOAD_FILE).setContentType("text/plain").build(), CSV_CONTENT.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        storage.create(BlobInfo.newBuilder((String)BUCKET, (String)LOAD_FILE_FLEXIBLE_COLUMN_NAME).setContentType("text/plain").build(), CSV_CONTENT_FLEXIBLE_COLUMN.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        storage.create(BlobInfo.newBuilder((String)BUCKET, (String)JSON_LOAD_FILE).setContentType("application/json").build(), JSON_CONTENT.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        storage.create(BlobInfo.newBuilder((String)BUCKET, (String)JSON_LOAD_FILE_SIMPLE).setContentType("application/json").build(), JSON_CONTENT_SIMPLE.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        InputStream stream = ITBigQueryTest.class.getClassLoader().getResourceAsStream("QueryTestData.csv");
        storage.createFrom(BlobInfo.newBuilder((String)BUCKET, (String)LOAD_FILE_LARGE).setContentType("text/plain").build(), stream, new Storage.BlobWriteOption[0]);
        storage.create(BlobInfo.newBuilder((String)BUCKET, (String)JSON_LOAD_FILE_BQ_RESULTSET).setContentType("application/json").build(), JSON_CONTENT_BQ_RESULTSET.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        DatasetInfo info = DatasetInfo.newBuilder((String)DATASET).setDescription(DESCRIPTION).setLabels(LABELS).build();
        bigquery.create(info, new BigQuery.DatasetOption[0]);
        DatasetInfo info2 = DatasetInfo.newBuilder((String)MODEL_DATASET).setDescription("java model lifecycle").build();
        bigquery.create(info2, new BigQuery.DatasetOption[0]);
        DatasetInfo info3 = DatasetInfo.newBuilder((String)ROUTINE_DATASET).setDescription("java routine lifecycle").build();
        bigquery.create(info3, new BigQuery.DatasetOption[0]);
        LoadJobConfiguration configuration = LoadJobConfiguration.newBuilder((TableId)TABLE_ID, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(TABLE_SCHEMA).setLabels((Map)labels).build();
        Job job = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        job = job.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)job.getStatus().getError());
        LoadJobConfiguration loadJobConfiguration = (LoadJobConfiguration)job.getConfiguration();
        Assert.assertEquals((Object)labels, (Object)loadJobConfiguration.getLabels());
        LoadJobConfiguration configurationFastQuery = LoadJobConfiguration.newBuilder((TableId)TABLE_ID_FASTQUERY, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(TABLE_SCHEMA).setLabels((Map)labels).build();
        Job jobFastQuery = bigquery.create(JobInfo.of((JobConfiguration)configurationFastQuery), new BigQuery.JobOption[0]);
        jobFastQuery = jobFastQuery.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)jobFastQuery.getStatus().getError());
        LoadJobConfiguration configFastQueryBQResultset = LoadJobConfiguration.newBuilder((TableId)TABLE_ID_FASTQUERY_BQ_RESULTSET, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE_BQ_RESULTSET), (FormatOptions)FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(BQ_RESULTSET_SCHEMA).setLabels((Map)labels).build();
        Job jobFastQueryBQResultSet = bigquery.create(JobInfo.of((JobConfiguration)configFastQueryBQResultset), new BigQuery.JobOption[0]);
        jobFastQueryBQResultSet = jobFastQueryBQResultSet.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)jobFastQueryBQResultSet.getStatus().getError());
        LoadJobConfiguration configurationDDL = LoadJobConfiguration.newBuilder((TableId)TABLE_ID_DDL, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE_SIMPLE), (FormatOptions)FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(DDL_TABLE_SCHEMA).setLabels((Map)labels).build();
        Job jobDDL = bigquery.create(JobInfo.of((JobConfiguration)configurationDDL), new BigQuery.JobOption[0]);
        jobDDL = jobDDL.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)jobDDL.getStatus().getError());
        LoadJobConfiguration configurationLargeTable = LoadJobConfiguration.newBuilder((TableId)TABLE_ID_LARGE, (String)("gs://" + BUCKET + "/" + LOAD_FILE_LARGE), (FormatOptions)FormatOptions.csv()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(LARGE_TABLE_SCHEMA).setLabels((Map)labels).build();
        Job jobLargeTable = bigquery.create(JobInfo.of((JobConfiguration)configurationLargeTable), new BigQuery.JobOption[0]);
        jobLargeTable = jobLargeTable.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)jobLargeTable.getStatus().getError());
    }

    @AfterClass
    public static void afterClass() throws ExecutionException, InterruptedException {
        boolean wasDeleted;
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)UK_DATASET);
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)MODEL_DATASET);
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)ROUTINE_DATASET);
        }
        if (storage != null && !(wasDeleted = RemoteStorageHelper.forceDelete((Storage)storage, (String)BUCKET, (long)10L, (TimeUnit)TimeUnit.SECONDS).booleanValue()) && LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Deletion of bucket {0} timed out, bucket is not empty", BUCKET);
        }
    }

    @Test
    public void testListDatasets() {
        Page datasets = bigquery.listDatasets(PUBLIC_PROJECT, new BigQuery.DatasetListOption[0]);
        Iterator iterator = datasets.iterateAll().iterator();
        HashSet<String> datasetNames = new HashSet<String>();
        HashMap<String, String> datasetLocation = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Dataset dataset = (Dataset)iterator.next();
            String name = dataset.getDatasetId().getDataset();
            datasetNames.add(name);
            datasetLocation.put(name, dataset.getLocation());
        }
        for (String type : PUBLIC_DATASETS) {
            Assert.assertTrue((boolean)datasetNames.contains(type));
            Assert.assertEquals((Object)PUBLIC_DATASETS_LOCATION.get(type), datasetLocation.get(type));
        }
    }

    @Test
    public void testListDatasetsWithFilter() {
        String labelFilter = "labels.example-label1:example-value1";
        Page datasets = bigquery.listDatasets(new BigQuery.DatasetListOption[]{BigQuery.DatasetListOption.labelFilter((String)labelFilter)});
        int count = 0;
        for (Dataset dataset : datasets.getValues()) {
            Assert.assertTrue((String)"failed to find label key in dataset", (boolean)dataset.getLabels().containsKey("example-label1"));
            Assert.assertTrue((String)"failed to find label value in dataset", (boolean)((String)dataset.getLabels().get("example-label1")).equals("example-value1"));
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetDataset() {
        Dataset dataset = bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)((BigQueryOptions)bigquery.getOptions()).getProjectId(), (Object)dataset.getDatasetId().getProject());
        Assert.assertEquals((Object)DATASET, (Object)dataset.getDatasetId().getDataset());
        Assert.assertEquals((Object)DESCRIPTION, (Object)dataset.getDescription());
        Assert.assertEquals(LABELS, (Object)dataset.getLabels());
        Assert.assertNotNull((Object)dataset.getAcl());
        Assert.assertNotNull((Object)dataset.getEtag());
        Assert.assertNotNull((Object)dataset.getGeneratedId());
        Assert.assertNotNull((Object)dataset.getLastModified());
        Assert.assertNotNull((Object)dataset.getSelfLink());
    }

    @Test
    public void testDatasetUpdateAccess() throws IOException {
        Dataset dataset = bigquery.getDataset(DATASET, new BigQuery.DatasetOption[0]);
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.getApplicationDefault();
        ImmutableList acl = ImmutableList.of((Object)Acl.of((Acl.Entity)new Acl.Group("projectOwners"), (Acl.Role)Acl.Role.OWNER), (Object)Acl.of((Acl.Entity)new Acl.User(credentials.getClientEmail()), (Acl.Role)Acl.Role.OWNER), (Object)Acl.of((Acl.Entity)new Acl.IamMember("allUsers"), (Acl.Role)Acl.Role.READER));
        Dataset remoteDataset = dataset.toBuilder().setAcl((List)acl).build().update(new BigQuery.DatasetOption[0]);
        Assert.assertNotNull((Object)remoteDataset);
        Assert.assertEquals((long)3L, (long)remoteDataset.getAcl().size());
    }

    @Test
    public void testGetDatasetWithSelectedFields() {
        Dataset dataset = bigquery.getDataset(DATASET, new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[]{BigQuery.DatasetField.CREATION_TIME, BigQuery.DatasetField.LABELS})});
        Assert.assertEquals((Object)((BigQueryOptions)bigquery.getOptions()).getProjectId(), (Object)dataset.getDatasetId().getProject());
        Assert.assertEquals((Object)DATASET, (Object)dataset.getDatasetId().getDataset());
        Assert.assertEquals(LABELS, (Object)dataset.getLabels());
        Assert.assertNotNull((Object)dataset.getCreationTime());
        Assert.assertNull((Object)dataset.getDescription());
        Assert.assertNull((Object)dataset.getDefaultTableLifetime());
        Assert.assertNull((Object)dataset.getAcl());
        Assert.assertNull((Object)dataset.getEtag());
        Assert.assertNull((Object)dataset.getFriendlyName());
        Assert.assertNull((Object)dataset.getGeneratedId());
        Assert.assertNull((Object)dataset.getLastModified());
        Assert.assertNull((Object)dataset.getLocation());
        Assert.assertNull((Object)dataset.getSelfLink());
        Assert.assertNull((Object)dataset.getStorageBillingModel());
        Assert.assertNull((Object)dataset.getMaxTimeTravelHours());
    }

    @Test
    public void testGetDatasetWithAccessPolicyVersion() throws IOException {
        String accessPolicyDataset = RemoteBigQueryHelper.generateDatasetName();
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.getApplicationDefault();
        Acl.User user = new Acl.User(credentials.getClientEmail());
        Acl.Role role = Acl.Role.WRITER;
        Acl.Expr condition = new Acl.Expr("request.time > timestamp('2024-01-01T00:00:00Z')", "test condition", "requests after the year 2024", "location");
        Acl acl = Acl.of((Acl.Entity)user, (Acl.Role)role, (Acl.Expr)condition);
        BigQuery.DatasetOption datasetOption = BigQuery.DatasetOption.accessPolicyVersion((Integer)3);
        Dataset dataset = bigquery.create(DatasetInfo.newBuilder((String)accessPolicyDataset).setDescription("Some Description").setAcl((List)ImmutableList.of((Object)acl)).build(), new BigQuery.DatasetOption[]{datasetOption});
        Truth.assertThat((Object)dataset).isNotNull();
        Dataset remoteDataset = bigquery.getDataset(accessPolicyDataset, new BigQuery.DatasetOption[]{datasetOption});
        Assert.assertNotNull((Object)remoteDataset);
        Assert.assertEquals((Object)dataset.getDescription(), (Object)remoteDataset.getDescription());
        Assert.assertNotNull((Object)remoteDataset.getCreationTime());
        Acl remoteAclWithCond = null;
        for (Acl remoteAcl : remoteDataset.getAcl()) {
            if (remoteAcl.getCondition() == null) continue;
            remoteAclWithCond = remoteAcl;
        }
        Assert.assertNotNull(remoteAclWithCond);
        Assert.assertEquals((Object)remoteAclWithCond.getCondition(), (Object)condition);
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)accessPolicyDataset);
    }

    @Test
    public void testUpdateDataset() {
        Dataset dataset = bigquery.create(DatasetInfo.newBuilder((String)OTHER_DATASET).setDescription("Some Description").setLabels(Collections.singletonMap("a", "b")).build(), new BigQuery.DatasetOption[0]);
        Truth.assertThat((Object)dataset).isNotNull();
        Truth.assertThat((String)dataset.getDatasetId().getProject()).isEqualTo((Object)((BigQueryOptions)bigquery.getOptions()).getProjectId());
        Truth.assertThat((String)dataset.getDatasetId().getDataset()).isEqualTo((Object)OTHER_DATASET);
        Truth.assertThat((String)dataset.getDescription()).isEqualTo((Object)"Some Description");
        Truth.assertThat((Map)dataset.getLabels()).containsExactly((Object)"a", (Object)"b", new Object[0]);
        Truth.assertThat((String)dataset.getStorageBillingModel()).isNull();
        Truth.assertThat((Long)dataset.getMaxTimeTravelHours()).isNull();
        HashMap<String, String> updateLabels = new HashMap<String, String>();
        updateLabels.put("x", "y");
        updateLabels.put("a", null);
        Dataset updatedDataset = bigquery.update((DatasetInfo)dataset.toBuilder().setDescription("Updated Description").setLabels(updateLabels).setStorageBillingModel(STORAGE_BILLING_MODEL).setMaxTimeTravelHours(MAX_TIME_TRAVEL_HOURS).build(), new BigQuery.DatasetOption[0]);
        Truth.assertThat((String)updatedDataset.getDescription()).isEqualTo((Object)"Updated Description");
        Truth.assertThat((Map)updatedDataset.getLabels()).containsExactly((Object)"x", (Object)"y", new Object[0]);
        Truth.assertThat((String)updatedDataset.getStorageBillingModel()).isEqualTo((Object)STORAGE_BILLING_MODEL);
        Truth.assertThat((Long)updatedDataset.getMaxTimeTravelHours()).isEqualTo((Object)MAX_TIME_TRAVEL_HOURS);
        updatedDataset = bigquery.update((DatasetInfo)updatedDataset.toBuilder().setLabels(null).build(), new BigQuery.DatasetOption[0]);
        Truth.assertThat((Map)updatedDataset.getLabels()).isEmpty();
        Truth.assertThat((Boolean)dataset.delete(new BigQuery.DatasetDeleteOption[0])).isTrue();
    }

    @Test
    public void testUpdateDatasetWithSelectedFields() {
        Dataset dataset = bigquery.create(DatasetInfo.newBuilder((String)OTHER_DATASET).setDescription("Some Description").build(), new BigQuery.DatasetOption[0]);
        Assert.assertNotNull((Object)dataset);
        Assert.assertEquals((Object)((BigQueryOptions)bigquery.getOptions()).getProjectId(), (Object)dataset.getDatasetId().getProject());
        Assert.assertEquals((Object)OTHER_DATASET, (Object)dataset.getDatasetId().getDataset());
        Assert.assertEquals((Object)"Some Description", (Object)dataset.getDescription());
        Dataset updatedDataset = bigquery.update((DatasetInfo)dataset.toBuilder().setDescription("Updated Description").build(), new BigQuery.DatasetOption[]{BigQuery.DatasetOption.fields((BigQuery.DatasetField[])new BigQuery.DatasetField[]{BigQuery.DatasetField.DESCRIPTION})});
        Assert.assertEquals((Object)"Updated Description", (Object)updatedDataset.getDescription());
        Assert.assertNull((Object)updatedDataset.getCreationTime());
        Assert.assertNull((Object)updatedDataset.getDefaultTableLifetime());
        Assert.assertNull((Object)updatedDataset.getAcl());
        Assert.assertNull((Object)updatedDataset.getEtag());
        Assert.assertNull((Object)updatedDataset.getFriendlyName());
        Assert.assertNull((Object)updatedDataset.getGeneratedId());
        Assert.assertNull((Object)updatedDataset.getLastModified());
        Assert.assertNull((Object)updatedDataset.getLocation());
        Assert.assertNull((Object)updatedDataset.getSelfLink());
        Assert.assertNull((Object)updatedDataset.getStorageBillingModel());
        Assert.assertNull((Object)updatedDataset.getMaxTimeTravelHours());
        Assert.assertTrue((boolean)dataset.delete(new BigQuery.DatasetDeleteOption[0]));
    }

    @Test
    public void testUpdateDatabaseWithAccessPolicyVersion() throws IOException {
        String accessPolicyDataset = RemoteBigQueryHelper.generateDatasetName();
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.getApplicationDefault();
        Dataset dataset = bigquery.create(DatasetInfo.newBuilder((String)accessPolicyDataset).setDescription("Some Description").setLabels(Collections.singletonMap("a", "b")).build(), new BigQuery.DatasetOption[0]);
        Truth.assertThat((Object)dataset).isNotNull();
        Acl.User user = new Acl.User(credentials.getClientEmail());
        Acl.Role role = Acl.Role.WRITER;
        Acl.Expr condition = new Acl.Expr("request.time > timestamp('2024-01-01T00:00:00Z')", "test condition", "requests after the year 2024", "location");
        Acl acl = Acl.of((Acl.Entity)user, (Acl.Role)role, (Acl.Expr)condition);
        ArrayList<Acl> acls = new ArrayList<Acl>();
        acls.addAll(dataset.getAcl());
        acls.add(acl);
        BigQuery.DatasetOption datasetOption = BigQuery.DatasetOption.accessPolicyVersion((Integer)3);
        Dataset updatedDataset = bigquery.update((DatasetInfo)dataset.toBuilder().setDescription("Updated Description").setLabels(null).setAcl(acls).build(), new BigQuery.DatasetOption[]{datasetOption});
        Assert.assertNotNull((Object)updatedDataset);
        Assert.assertEquals((Object)updatedDataset.getDescription(), (Object)"Updated Description");
        Truth.assertThat((Boolean)updatedDataset.getLabels().isEmpty());
        Acl updatedAclWithCond = null;
        for (Acl updatedAcl : updatedDataset.getAcl()) {
            if (updatedAcl.getCondition() == null) continue;
            updatedAclWithCond = updatedAcl;
        }
        Assert.assertNotNull(updatedAclWithCond);
        Assert.assertEquals((Object)updatedAclWithCond.getCondition(), (Object)condition);
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)accessPolicyDataset);
    }

    @Test
    public void testGetNonExistingTable() {
        Assert.assertNull((Object)bigquery.getTable(DATASET, "test_get_non_existing_table", new BigQuery.TableOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithRangePartitioning() {
        String tableName = "test_create_table_rangepartitioning";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        try {
            StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setRangePartitioning(RANGE_PARTITIONING).build();
            Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTable);
            Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)RANGE, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getRangePartitioning().getRange());
            Assert.assertEquals((Object)RANGE_PARTITIONING, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getRangePartitioning());
        }
        finally {
            bigquery.delete(tableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJsonType() throws InterruptedException {
        String tableName = "test_create_table_jsontype";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"jsonField", (StandardSQLTypeName)StandardSQLTypeName.JSON, (Field[])new Field[0])});
        StandardTableDefinition standardTableDefinition = StandardTableDefinition.of((Schema)schema);
        try {
            Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)standardTableDefinition), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTable);
            Map<String, String> jsonRow1 = Collections.singletonMap("jsonField", "{\"student\" : {\"name\" : \"Jane\", \"id\": 10}}");
            Map<String, String> jsonRow2 = Collections.singletonMap("jsonField", "{\"student\" : {\"name\" : \"Joy\", \"id\": 11}}");
            Map<String, String> jsonRow3 = Collections.singletonMap("jsonField", "{\"student\" : {\"name\" : \"Alice\", \"id\": 12}}");
            Map<String, String> jsonRow4 = Collections.singletonMap("jsonField", "{\"student\" : {\"name\" : \"Bijoy\", \"id\": 14}}");
            InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableId).addRow(jsonRow1).addRow(jsonRow2).addRow(jsonRow3).addRow(jsonRow4).build();
            InsertAllResponse response = bigquery.insertAll(request);
            Assert.assertFalse((boolean)response.hasErrors());
            Assert.assertEquals((long)0L, (long)response.getInsertErrors().size());
            String sql = "SELECT jsonField.class.student.id FROM " + tableId.getTable() + " WHERE JSON_VALUE(jsonField, \"$.class.student.name\")  = ? ";
            QueryParameterValue stringParameter = QueryParameterValue.string((String)"Jane");
            QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)sql).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(stringParameter).build();
            TableResult result = bigquery.query(queryJobConfiguration, new BigQuery.JobOption[0]);
            Assert.assertNotNull((Object)result.getJobId());
            for (FieldValueList values : result.iterateAll()) {
                Assert.assertEquals((Object)"10", (Object)values.get(0).getValue());
            }
            String dml = "INSERT INTO " + tableId.getTable() + " (jsonField) VALUES(?)";
            QueryParameterValue jsonParameter = QueryParameterValue.json((String)"{\"class\" : {\"student\" : [{\"name\" : \"Amy\"}]}}");
            QueryJobConfiguration dmlQueryJobConfiguration = QueryJobConfiguration.newBuilder((String)dml).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(jsonParameter).build();
            bigquery.query(dmlQueryJobConfiguration, new BigQuery.JobOption[0]);
            TableResult rows = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
            Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)rows.getValues()));
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("class", "student");
            QueryParameterValue jsonParameter1 = QueryParameterValue.json((JsonObject)jsonObject);
            QueryJobConfiguration dmlQueryJobConfiguration1 = QueryJobConfiguration.newBuilder((String)dml).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(jsonParameter1).build();
            bigquery.query(dmlQueryJobConfiguration1, new BigQuery.JobOption[0]);
            TableResult rows1 = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
            Assert.assertEquals((long)6L, (long)Iterables.size((Iterable)rows1.getValues()));
            int rowCount = 0;
            for (FieldValueList row : rows1.iterateAll()) {
                FieldValue jsonCell = row.get(0);
                if (rowCount == 1) {
                    Assert.assertEquals((Object)"{\"class\":\"student\"}", (Object)jsonCell.getStringValue());
                }
                ++rowCount;
            }
            QueryParameterValue badJsonParameter = QueryParameterValue.json((String)"{\"class\" : {\"student\" : [{\"name\" : \"BadBoy\"}}");
            QueryJobConfiguration dmlQueryJobConfiguration2 = QueryJobConfiguration.newBuilder((String)dml).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(badJsonParameter).build();
            try {
                bigquery.query(dmlQueryJobConfiguration2, new BigQuery.JobOption[0]);
                Assert.fail((String)"Querying with malformed JSON shouldn't work");
            }
            catch (BigQueryException e) {
                BigQueryError error = e.getError();
                Assert.assertNotNull((Object)error);
                Assert.assertEquals((Object)"invalidQuery", (Object)error.getReason());
            }
        }
        finally {
            Assert.assertTrue((boolean)bigquery.delete(tableId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIntervalType() throws InterruptedException {
        String tableName = "test_create_table_intervaltype";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"intervalField", (StandardSQLTypeName)StandardSQLTypeName.INTERVAL, (Field[])new Field[0])});
        StandardTableDefinition standardTableDefinition = StandardTableDefinition.of((Schema)schema);
        try {
            Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)standardTableDefinition), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTable);
            Map<String, String> intervalRow1 = Collections.singletonMap("intervalField", "123-7 -19 0:24:12.000006");
            Map<String, String> intervalRow2 = Collections.singletonMap("intervalField", "P123Y7M-19DT0H24M12.000006S");
            InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableId).addRow(intervalRow1).addRow(intervalRow2).build();
            InsertAllResponse response = bigquery.insertAll(request);
            Assert.assertFalse((boolean)response.hasErrors());
            Assert.assertEquals((long)0L, (long)response.getInsertErrors().size());
            String dml = "INSERT INTO " + tableId.getTable() + " (intervalField) VALUES(?)";
            QueryParameterValue intervalParameter = QueryParameterValue.interval((String)"P125Y7M-19DT0H24M12.000006S");
            QueryJobConfiguration dmlQueryJobConfiguration = QueryJobConfiguration.newBuilder((String)dml).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(intervalParameter).build();
            bigquery.query(dmlQueryJobConfiguration, new BigQuery.JobOption[0]);
            TableResult rows = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
            Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rows.getValues()));
            QueryParameterValue intervalParameter1 = QueryParameterValue.interval((PeriodDuration)PeriodDuration.of((Period)Period.of(1, 2, 25), (Duration)Duration.ofHours(8L)));
            QueryJobConfiguration dmlQueryJobConfiguration1 = QueryJobConfiguration.newBuilder((String)dml).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(intervalParameter1).build();
            bigquery.query(dmlQueryJobConfiguration1, new BigQuery.JobOption[0]);
            TableResult rows1 = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
            Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)rows1.getValues()));
            String sql = "SELECT intervalField FROM " + tableId.getTable() + " WHERE intervalField = ? ";
            QueryParameterValue intervalParameter2 = QueryParameterValue.interval((String)"P125Y7M-19DT0H24M12.000006S");
            QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)sql).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(intervalParameter2).build();
            TableResult result = bigquery.query(queryJobConfiguration, new BigQuery.JobOption[0]);
            Assert.assertNotNull((Object)result.getJobId());
            PeriodDuration periodDuration = PeriodDuration.of((Period)Period.of(125, 7, -19), (Duration)Duration.parse("PT24M12.000006S"));
            for (FieldValueList values : result.iterateAll()) {
                Assert.assertEquals((Object)"125-7 -19 0:24:12.000006", (Object)values.get(0).getValue());
                Assert.assertEquals((Object)periodDuration, (Object)values.get(0).getPeriodDuration());
            }
        }
        finally {
            Assert.assertTrue((boolean)bigquery.delete(tableId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangeType() throws InterruptedException {
        String tableName = "test_range_type_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        StandardTableDefinition standardTableDefinition = StandardTableDefinition.of((Schema)RANGE_SCHEMA);
        try {
            Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)standardTableDefinition), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTable);
            Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
            Schema remoteSchema = ((StandardTableDefinition)remoteTable.getDefinition()).getSchema();
            Assert.assertEquals((Object)RANGE_SCHEMA, (Object)remoteSchema);
            InsertAllRequest.Builder request = InsertAllRequest.newBuilder((TableId)tableId);
            for (Object name : RANGE_TEST_VALUES_DATES.keySet()) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"name", name);
                builder.put((Object)"date", (Object)((Range)RANGE_TEST_VALUES_DATES.get(name)).getValues());
                builder.put((Object)"datetime", (Object)((Range)RANGE_TEST_VALUES_DATETIME.get(name)).getValues());
                builder.put((Object)"timestamp", (Object)((Range)RANGE_TEST_VALUES_TIMESTAMP.get(name)).getValues());
                request.addRow((Map)builder.build());
            }
            bigquery.insertAll(request.build());
            TableResult result = bigquery.listTableData(DATASET, tableName, RANGE_SCHEMA, new BigQuery.TableDataListOption[0]);
            Assert.assertEquals((long)RANGE_TEST_VALUES_DATES.size(), (long)Iterables.size((Iterable)result.getValues()));
            for (FieldValueList values : result.iterateAll()) {
                String name = values.get("name").getStringValue();
                Assert.assertEquals((Object)RANGE_TEST_VALUES_DATES.get((Object)name), (Object)values.get("date").getRangeValue());
                Assert.assertEquals((Object)RANGE_TEST_VALUES_DATETIME.get((Object)name), (Object)values.get("datetime").getRangeValue());
                Assert.assertEquals((Object)RANGE_TEST_VALUES_EXPECTED_TIMESTAMP.get((Object)name), (Object)values.get("timestamp").getRangeValue());
            }
            String query = String.format("SELECT name, date, datetime, timestamp\nFROM %s.%s\nWHERE date = @dateParam\nAND datetime = @datetimeParam\nAND timestamp = @timestampParam", DATASET, tableName);
            QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).addNamedParameter("dateParam", QueryParameterValue.range((Range)((Range)RANGE_TEST_VALUES_DATES.get((Object)"bounded")))).addNamedParameter("datetimeParam", QueryParameterValue.range((Range)((Range)RANGE_TEST_VALUES_DATETIME.get((Object)"bounded")))).addNamedParameter("timestampParam", QueryParameterValue.range((Range)((Range)RANGE_TEST_VALUES_TIMESTAMP.get((Object)"bounded")))).build();
            result = bigquery.query(config, new BigQuery.JobOption[0]);
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result.getValues()));
            for (FieldValueList values : result.iterateAll()) {
                String name = values.get("name").getStringValue();
                Assert.assertEquals((Object)RANGE_TEST_VALUES_DATES.get((Object)name), (Object)values.get("date").getRangeValue());
                Assert.assertEquals((Object)RANGE_TEST_VALUES_DATETIME.get((Object)name), (Object)values.get("datetime").getRangeValue());
                Assert.assertEquals((Object)RANGE_TEST_VALUES_EXPECTED_TIMESTAMP.get((Object)name), (Object)values.get("timestamp").getRangeValue());
            }
        }
        finally {
            Assert.assertTrue((boolean)bigquery.delete(tableId));
        }
    }

    @Test
    public void testCreateTableWithConstraints() {
        String tableName = "test_create_table_with_constraints";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field stringFieldWithConstraint = Field.newBuilder((String)"stringFieldWithConstraint", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("field has a constraint").setMaxLength(Long.valueOf(10L)).build();
        Field byteFieldWithConstraint = Field.newBuilder((String)"byteFieldWithConstraint", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("field has a constraint").setMaxLength(Long.valueOf(150L)).build();
        Field numericFieldWithConstraint = Field.newBuilder((String)"numericFieldWithConstraint", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("field has a constraint").setPrecision(Long.valueOf(20L)).build();
        Field bigNumericFieldWithConstraint = Field.newBuilder((String)"bigNumericFieldWithConstraint", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("field has a constraint").setPrecision(Long.valueOf(30L)).setScale(Long.valueOf(5L)).build();
        Schema schema = Schema.of((Field[])new Field[]{stringFieldWithConstraint, byteFieldWithConstraint, numericFieldWithConstraint, bigNumericFieldWithConstraint});
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(schema).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)schema, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getSchema());
        bigquery.delete(tableId);
    }

    @Test
    public void testCreateDatasetWithSpecifiedStorageBillingModel() {
        String billingModelDataset = RemoteBigQueryHelper.generateDatasetName();
        DatasetInfo info = DatasetInfo.newBuilder((String)billingModelDataset).setDescription(DESCRIPTION).setStorageBillingModel(STORAGE_BILLING_MODEL).setLabels(LABELS).build();
        bigquery.create(info, new BigQuery.DatasetOption[0]);
        Dataset dataset = bigquery.getDataset(DatasetId.of((String)billingModelDataset), new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)STORAGE_BILLING_MODEL, (Object)dataset.getStorageBillingModel());
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)billingModelDataset);
    }

    @Test
    public void testCreateDatasetWithSpecificMaxTimeTravelHours() {
        String timeTravelDataset = RemoteBigQueryHelper.generateDatasetName();
        DatasetInfo info = DatasetInfo.newBuilder((String)timeTravelDataset).setDescription(DESCRIPTION).setMaxTimeTravelHours(MAX_TIME_TRAVEL_HOURS).setLabels(LABELS).build();
        bigquery.create(info, new BigQuery.DatasetOption[0]);
        Dataset dataset = bigquery.getDataset(DatasetId.of((String)timeTravelDataset), new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)MAX_TIME_TRAVEL_HOURS, (Object)dataset.getMaxTimeTravelHours());
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)timeTravelDataset);
    }

    @Test
    public void testCreateDatasetWithDefaultMaxTimeTravelHours() {
        String timeTravelDataset = RemoteBigQueryHelper.generateDatasetName();
        DatasetInfo info = DatasetInfo.newBuilder((String)timeTravelDataset).setDescription(DESCRIPTION).setLabels(LABELS).build();
        bigquery.create(info, new BigQuery.DatasetOption[0]);
        Dataset dataset = bigquery.getDataset(DatasetId.of((String)timeTravelDataset), new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)MAX_TIME_TRAVEL_HOURS_DEFAULT, (Object)dataset.getMaxTimeTravelHours());
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)timeTravelDataset);
    }

    @Test
    public void testCreateDatasetWithDefaultCollation() {
        String collationDataset = RemoteBigQueryHelper.generateDatasetName();
        DatasetInfo info = DatasetInfo.newBuilder((String)collationDataset).setDescription(DESCRIPTION).setDefaultCollation("und:ci").setLabels(LABELS).build();
        bigquery.create(info, new BigQuery.DatasetOption[0]);
        Dataset dataset = bigquery.getDataset(DatasetId.of((String)collationDataset), new BigQuery.DatasetOption[0]);
        Assert.assertEquals((Object)"und:ci", (Object)dataset.getDefaultCollation());
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)collationDataset);
    }

    @Test
    public void testCreateDatasetWithAccessPolicyVersion() throws IOException {
        String accessPolicyDataset = RemoteBigQueryHelper.generateDatasetName();
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.getApplicationDefault();
        Acl.User user = new Acl.User(credentials.getClientEmail());
        Acl.Role role = Acl.Role.OWNER;
        Acl.Expr condition = new Acl.Expr("request.time > timestamp('2024-01-01T00:00:00Z')", "test condition", "requests after the year 2024", "location");
        Acl acl = Acl.of((Acl.Entity)user, (Acl.Role)role, (Acl.Expr)condition);
        DatasetInfo info = DatasetInfo.newBuilder((String)accessPolicyDataset).setDescription(DESCRIPTION).setLabels(LABELS).setAcl((List)ImmutableList.of((Object)acl)).build();
        BigQuery.DatasetOption datasetOption = BigQuery.DatasetOption.accessPolicyVersion((Integer)3);
        Dataset dataset = bigquery.create(info, new BigQuery.DatasetOption[]{datasetOption});
        Assert.assertNotNull((Object)dataset);
        Assert.assertEquals((Object)dataset.getDescription(), (Object)DESCRIPTION);
        Acl remoteAclWithCond = null;
        for (Acl remoteAcl : dataset.getAcl()) {
            if (remoteAcl.getCondition() == null) continue;
            remoteAclWithCond = remoteAcl;
        }
        Assert.assertNotNull(remoteAclWithCond);
        Assert.assertEquals((Object)remoteAclWithCond.getCondition(), (Object)condition);
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)accessPolicyDataset);
    }

    @Test(expected=BigQueryException.class)
    public void testCreateDatabaseWithInvalidAccessPolicyVersion() throws IOException {
        String accessPolicyDataset = RemoteBigQueryHelper.generateDatasetName();
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.getApplicationDefault();
        Acl.User user = new Acl.User(credentials.getClientEmail());
        Acl.Role role = Acl.Role.READER;
        Acl.Expr condition = new Acl.Expr("request.time > timestamp('2024-01-01T00:00:00Z')", "test condition", "requests after the year 2024", "location");
        Acl acl = Acl.of((Acl.Entity)user, (Acl.Role)role, (Acl.Expr)condition);
        DatasetInfo info = DatasetInfo.newBuilder((String)accessPolicyDataset).setDescription(DESCRIPTION).setLabels(LABELS).setAcl((List)ImmutableList.of((Object)acl)).build();
        BigQuery.DatasetOption datasetOption = BigQuery.DatasetOption.accessPolicyVersion((Integer)4);
        Dataset dataset = bigquery.create(info, new BigQuery.DatasetOption[]{datasetOption});
        Assert.assertNotNull((Object)dataset);
        RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)accessPolicyDataset);
    }

    @Test
    public void testCreateTableWithDefaultCollation() {
        String tableName = "test_create_table_with_default_collation";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field stringFieldWithoutCollation = Field.newBuilder((String)"stringFieldWithoutDefaultCollation", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("String field").setMaxLength(Long.valueOf(150L)).build();
        Schema schema = Schema.of((Field[])new Field[]{stringFieldWithoutCollation});
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(schema).build();
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).setDefaultCollation("und:ci").build();
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Schema remoteSchema = ((StandardTableDefinition)remoteTable.getDefinition()).getSchema();
        Assert.assertNotEquals((Object)schema, (Object)remoteSchema);
        Assert.assertEquals((Object)"und:ci", (Object)remoteTable.getDefaultCollation());
        FieldList fieldList = remoteSchema.getFields();
        for (Field field : fieldList) {
            if (!field.getName().equals("stringFieldWithoutDefaultCollation")) continue;
            Assert.assertEquals((Object)"und:ci", (Object)field.getCollation());
        }
        bigquery.delete(tableId);
    }

    @Test
    public void testCreateFieldWithDefaultCollation() {
        String tableName = "test_create_field_with_default_collation";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field stringFieldWithCollation = Field.newBuilder((String)"stringFieldWithDefaultCollation", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("String field").setCollation("und:ci").setMaxLength(Long.valueOf(150L)).build();
        Schema schema = Schema.of((Field[])new Field[]{stringFieldWithCollation});
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(schema).build();
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Schema remoteSchema = ((StandardTableDefinition)remoteTable.getDefinition()).getSchema();
        Assert.assertEquals((Object)schema, (Object)remoteSchema);
        Assert.assertEquals(null, (Object)remoteTable.getDefaultCollation());
        FieldList fieldList = remoteSchema.getFields();
        for (Field field : fieldList) {
            if (!field.getName().equals("stringFieldWithoutDefaultCollation")) continue;
            Assert.assertEquals((Object)"und:ci", (Object)field.getCollation());
        }
        bigquery.delete(tableId);
    }

    @Test
    public void testCreateTableWithDefaultValueExpression() {
        String tableName = "test_create_table_with_default_value_expression";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field stringFieldWithDefaultValueExpression = Field.newBuilder((String)"stringFieldWithDefaultValueExpression", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("String field with default value expression").setDefaultValueExpression("'FOO'").setMaxLength(Long.valueOf(150L)).build();
        Field timestampFieldWithDefaultValueExpression = Field.newBuilder((String)"timestampFieldWithDefaultValueExpression", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("Timestamp field with default value expression").setDefaultValueExpression("CURRENT_TIMESTAMP").build();
        Schema schema = Schema.of((Field[])new Field[]{stringFieldWithDefaultValueExpression, timestampFieldWithDefaultValueExpression});
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(schema).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Schema remoteSchema = ((StandardTableDefinition)remoteTable.getDefinition()).getSchema();
        Assert.assertEquals((Object)schema, (Object)remoteSchema);
        FieldList fieldList = remoteSchema.getFields();
        for (Field field : fieldList) {
            if (field.getName().equals("timestampFieldWithDefaultValueExpression")) {
                Assert.assertEquals((Object)"CURRENT_TIMESTAMP", (Object)field.getDefaultValueExpression());
            }
            if (!field.getName().equals("stringFieldWithDefaultValueExpression")) continue;
            Assert.assertEquals((Object)"'FOO'", (Object)field.getDefaultValueExpression());
        }
        String rowId1 = "rowId1";
        String rowId2 = "rowId2";
        ArrayList<InsertAllRequest.RowToInsert> rows = new ArrayList<InsertAllRequest.RowToInsert>();
        HashMap<String, String> row1 = new HashMap<String, String>();
        row1.put("timestampFieldWithDefaultValueExpression", "2022-08-22 00:45:12 UTC");
        HashMap<String, String> row2 = new HashMap<String, String>();
        row2.put("timestampFieldWithDefaultValueExpression", "2022-08-23 00:44:33 UTC");
        rows.add(InsertAllRequest.RowToInsert.of((String)rowId1, row1));
        rows.add(InsertAllRequest.RowToInsert.of((String)rowId2, row2));
        InsertAllResponse response1 = remoteTable.insert(rows);
        TableResult tableData = bigquery.listTableData(DATASET, tableName, schema, new BigQuery.TableDataListOption[0]);
        String insertedField = "stringFieldWithDefaultValueExpression";
        for (FieldValueList row : tableData.iterateAll()) {
            Assert.assertEquals((Object)"FOO", (Object)row.get(insertedField).getValue());
        }
        bigquery.delete(tableId);
    }

    @Test
    public void testCreateAndUpdateTableWithPolicyTags() throws IOException {
        try (PolicyTagManagerClient policyTagManagerClient = PolicyTagManagerClient.create();){
            CreateTaxonomyRequest createTaxonomyRequest = CreateTaxonomyRequest.newBuilder().setParent(String.format("projects/%s/locations/%s", PROJECT_ID, "us")).setTaxonomy(Taxonomy.newBuilder().setDisplayName(String.format("testing taxonomy %s", Instant.now().getNano())).setDescription("taxonomy created for integration tests").addActivatedPolicyTypes(Taxonomy.PolicyType.FINE_GRAINED_ACCESS_CONTROL).build()).build();
            Taxonomy taxonomyResponse = policyTagManagerClient.createTaxonomy(createTaxonomyRequest);
            String taxonomyId = taxonomyResponse.getName();
            CreatePolicyTagRequest createPolicyTagRequest = CreatePolicyTagRequest.newBuilder().setParent(taxonomyId).setPolicyTag(PolicyTag.newBuilder().setDisplayName("ExamplePolicyTag").build()).build();
            PolicyTag policyTagResponse = policyTagManagerClient.createPolicyTag(createPolicyTagRequest);
            String policyTagId = policyTagResponse.getName();
            PolicyTags policyTags = PolicyTags.newBuilder().setNames((List)ImmutableList.of((Object)policyTagId)).build();
            Field stringFieldWithPolicy = Field.newBuilder((String)"StringFieldWithPolicy", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("field has a policy").setPolicyTags(policyTags).build();
            Schema policySchema = Schema.of((Field[])new Field[]{STRING_FIELD_SCHEMA, stringFieldWithPolicy, INTEGER_FIELD_SCHEMA});
            String tableNameForUpdate = "test_update_table_policytags";
            TableId tableIdForUpdate = TableId.of((String)DATASET, (String)tableNameForUpdate);
            TableInfo tableInfo = TableInfo.newBuilder((TableId)tableIdForUpdate, (TableDefinition)StandardTableDefinition.of((Schema)TABLE_SCHEMA)).setDescription("policy tag update test table").build();
            Table createdTableForUpdate = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTableForUpdate);
            Schema schema = createdTableForUpdate.getDefinition().getSchema();
            FieldList fields = schema.getFields();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Field field : fields) {
                fieldList.add(field);
            }
            fieldList.add(stringFieldWithPolicy);
            Schema updatedSchemaWithPolicyTag = Schema.of(fieldList);
            Table updatedTable = createdTableForUpdate.toBuilder().setDefinition((TableDefinition)StandardTableDefinition.of((Schema)updatedSchemaWithPolicyTag)).build();
            updatedTable.update(new BigQuery.TableOption[0]);
            Table remoteUpdatedTable = bigquery.getTable(DATASET, tableNameForUpdate, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)updatedSchemaWithPolicyTag, (Object)((StandardTableDefinition)remoteUpdatedTable.getDefinition()).getSchema());
            bigquery.delete(tableIdForUpdate);
            String tableName = "test_create_table_policytags";
            TableId tableId = TableId.of((String)DATASET, (String)tableName);
            StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(policySchema).build();
            Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTable);
            Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)policySchema, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getSchema());
            bigquery.delete(tableId);
            policyTagManagerClient.deletePolicyTag(policyTagId);
            policyTagManagerClient.deleteTaxonomy(taxonomyId);
        }
    }

    @Test
    public void testCreateAndGetTable() {
        String tableName = "test_create_and_get_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
        Clustering clustering = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)STRING_FIELD_SCHEMA.getName())).build();
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(partitioning).setClustering(clustering).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.getDefinition().getType());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        Assert.assertNotNull((Object)remoteTable.getCreationTime());
        Assert.assertNotNull((Object)remoteTable.getLastModifiedTime());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumTotalLogicalBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumActiveLogicalBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermLogicalBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumRows());
        Assert.assertEquals((Object)partitioning, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getTimePartitioning());
        Assert.assertEquals((Object)clustering, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getClustering());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateAndListTable() {
        String tableName = "test_create_and_list_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
        Clustering clustering = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)STRING_FIELD_SCHEMA.getName())).build();
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(partitioning).setClustering(clustering).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Page tables = bigquery.listTables(DATASET, new BigQuery.TableListOption[0]);
        boolean found = false;
        Iterator tableIterator = tables.getValues().iterator();
        while (tableIterator.hasNext() && !found) {
            Table table = (Table)tableIterator.next();
            if (!table.getTableId().equals((Object)createdTable.getTableId())) continue;
            StandardTableDefinition definition = (StandardTableDefinition)table.getDefinition();
            Truth.assertThat((Object)definition.getClustering()).isNotNull();
            Truth.assertThat((Object)definition.getTimePartitioning()).isNotNull();
            found = true;
        }
        Assert.assertTrue((boolean)found);
        Assert.assertTrue((boolean)createdTable.delete());
    }

    @Test
    public void testCreateAndGetTableWithBasicTableMetadataView() {
        String tableName = "test_create_and_get_table_with_basic_metadata_view";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
        Clustering clustering = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)STRING_FIELD_SCHEMA.getName())).build();
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(partitioning).setClustering(clustering).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        BigQuery.TableOption tableOption = BigQuery.TableOption.tableMetadataView((BigQuery.TableMetadataView)BigQuery.TableMetadataView.BASIC);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[]{tableOption});
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.getDefinition().getType());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        Assert.assertNull((Object)remoteTable.getLastModifiedTime());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumRows());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateAndGetTableWithFullTableMetadataView() {
        String tableName = "test_create_and_get_table_with_full_metadata_view";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
        Clustering clustering = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)STRING_FIELD_SCHEMA.getName())).build();
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(partitioning).setClustering(clustering).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        BigQuery.TableOption tableOption = BigQuery.TableOption.tableMetadataView((BigQuery.TableMetadataView)BigQuery.TableMetadataView.FULL);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[]{tableOption});
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.getDefinition().getType());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        Assert.assertNotNull((Object)remoteTable.getLastModifiedTime());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumRows());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateAndGetTableWithStorageStatsTableMetadataView() {
        String tableName = "test_create_and_get_table_with_storage_stats_metadata_view";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
        Clustering clustering = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)STRING_FIELD_SCHEMA.getName())).build();
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(partitioning).setClustering(clustering).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        BigQuery.TableOption tableOption = BigQuery.TableOption.tableMetadataView((BigQuery.TableMetadataView)BigQuery.TableMetadataView.STORAGE_STATS);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[]{tableOption});
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.getDefinition().getType());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        Assert.assertNotNull((Object)remoteTable.getLastModifiedTime());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumRows());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateAndGetTableWithUnspecifiedTableMetadataView() {
        String tableName = "test_create_and_get_table_with_unspecified_metadata_view";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        TimePartitioning partitioning = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY);
        Clustering clustering = Clustering.newBuilder().setFields((List)ImmutableList.of((Object)STRING_FIELD_SCHEMA.getName())).build();
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(partitioning).setClustering(clustering).build();
        Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        BigQuery.TableOption tableOption = BigQuery.TableOption.tableMetadataView((BigQuery.TableMetadataView)BigQuery.TableMetadataView.TABLE_METADATA_VIEW_UNSPECIFIED);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[]{tableOption});
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.getDefinition().getType());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        Assert.assertNotNull((Object)remoteTable.getLastModifiedTime());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermBytes());
        Assert.assertNotNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumRows());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateAndGetTableWithSelectedField() {
        String tableName = "test_create_and_get_selected_fields_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        Table createdTable = bigquery.create(TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).setLabels(Collections.singletonMap("a", "b")).build(), new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.CREATION_TIME, BigQuery.TableField.LABELS})});
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)remoteTable.getDefinition().getType());
        Truth.assertThat((Map)remoteTable.getLabels()).containsExactly((Object)"a", (Object)"b", new Object[0]);
        Assert.assertNotNull((Object)remoteTable.getCreationTime());
        Assert.assertNull((Object)remoteTable.getDefinition().getSchema());
        Assert.assertNull((Object)remoteTable.getLastModifiedTime());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumTimeTravelPhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumTotalLogicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumActiveLogicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermLogicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumTotalPhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumActivePhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumLongTermPhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getNumRows());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getTimePartitioning());
        Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getClustering());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateExternalTable() throws InterruptedException {
        String tableName = "test_create_external_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.of((String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (Schema)TABLE_SCHEMA, (FormatOptions)FormatOptions.json()).toBuilder().setMaxStaleness("INTERVAL 15 MINUTE").build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof ExternalTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)("SELECT TimestampField, StringField, IntegerArrayField, BooleanField FROM " + DATASET + "." + tableName)).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(true)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        long integerValue = 0L;
        int rowCount = 0;
        for (FieldValueList row : result.getValues()) {
            FieldValue timestampCell = row.get(0);
            Assert.assertEquals((Object)timestampCell, (Object)row.get("TimestampField"));
            FieldValue stringCell = row.get(1);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            FieldValue integerCell = row.get(2);
            Assert.assertEquals((Object)integerCell, (Object)row.get("IntegerArrayField"));
            FieldValue booleanCell = row.get(3);
            Assert.assertEquals((Object)booleanCell, (Object)row.get("BooleanField"));
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)integerCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((long)integerValue, (long)integerCell.getLongValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
            integerValue = (integerValue ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
            ++rowCount;
        }
        Assert.assertEquals((long)4L, (long)rowCount);
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testSetPermExternalTableSchema() {
        String tableName = "test_create_external_table_perm";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder((String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).setSchema(TABLE_SCHEMA).setConnectionId("projects/java-docs-samples-testing/locations/us/connections/DEVREL_TEST_CONNECTION").build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testUpdatePermExternableTableWithAutodetectSchemaUpdatesSchema() {
        String tableName = "test_create_external_table_perm_with_auto_detect";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Schema setSchema = Schema.of((Field[])new Field[]{TIMESTAMP_FIELD_SCHEMA, STRING_FIELD_SCHEMA});
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder((String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).setSchema(setSchema).build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertEquals((Object)setSchema, (Object)remoteTable.getDefinition().getSchema());
        Table updatedTable = bigquery.update((TableInfo)createdTable.toBuilder().setDefinition((TableDefinition)((ExternalTableDefinition)createdTable.getDefinition()).toBuilder().setSchema(null).setAutodetect(Boolean.valueOf(true)).build()).build(), new BigQuery.TableOption[]{BigQuery.TableOption.autodetectSchema((boolean)true)});
        Assert.assertTrue((!updatedTable.getDefinition().getSchema().equals((Object)setSchema) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateViewTable() throws InterruptedException {
        String tableName = "test_create_view_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ViewDefinition viewDefinition = ViewDefinition.newBuilder((String)String.format("SELECT TimestampField, StringField, BooleanField FROM %s.%s", DATASET, TABLE_ID.getTable())).setUseLegacySql(Boolean.valueOf(true)).build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof ViewDefinition));
        Assert.assertEquals((Object)VIEW_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)("SELECT * FROM " + tableName)).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(true)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        int rowCount = 0;
        for (FieldValueList row : result.getValues()) {
            FieldValue timestampCell = row.get(0);
            Assert.assertEquals((Object)timestampCell, (Object)row.get("TimestampField"));
            FieldValue stringCell = row.get(1);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            FieldValue booleanCell = row.get(2);
            Assert.assertEquals((Object)booleanCell, (Object)row.get("BooleanField"));
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCreateMaterializedViewTable() {
        String tableName = "test_materialized_view_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        MaterializedViewDefinition viewDefinition = MaterializedViewDefinition.newBuilder((String)String.format("SELECT MAX(TimestampField) AS TimestampField,StringField, MAX(BooleanField) AS BooleanField FROM %s.%s.%s GROUP BY StringField", PROJECT_ID, DATASET, TABLE_ID.getTable())).build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)viewDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof MaterializedViewDefinition));
        Assert.assertEquals((Object)VIEW_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testTableIAM() {
        String tableName = "test_iam_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).build();
        bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        ImmutableList checkedPerms = ImmutableList.of((Object)"bigquery.tables.get", (Object)"bigquery.tables.getData", (Object)"bigquery.tables.update");
        List grantedPerms = bigquery.testIamPermissions(tableId, (List)checkedPerms, new BigQuery.IAMOption[0]);
        Assert.assertEquals((Object)checkedPerms, (Object)grantedPerms);
        Policy policy = bigquery.getIamPolicy(tableId, new BigQuery.IAMOption[0]);
        Policy editedPolicy = policy.toBuilder().addIdentity(Role.of((String)"roles/bigquery.dataViewer"), Identity.allUsers(), new Identity[0]).build();
        Policy updatedPolicy = bigquery.setIamPolicy(tableId, editedPolicy, new BigQuery.IAMOption[0]);
        Assert.assertNotEquals((Object)updatedPolicy, (Object)editedPolicy);
        Assert.assertEquals((Object)updatedPolicy.getBindingsList(), (Object)editedPolicy.getBindingsList());
    }

    @Test
    public void testListTables() {
        String tableName = "test_list_tables";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Page tables = bigquery.listTables(DATASET, new BigQuery.TableListOption[0]);
        boolean found = false;
        Iterator tableIterator = tables.getValues().iterator();
        while (tableIterator.hasNext() && !found) {
            if (!((Table)tableIterator.next()).getTableId().equals((Object)createdTable.getTableId())) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        Assert.assertTrue((boolean)createdTable.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListTablesWithPartitioning() {
        String tableName = "test_list_tables_partitioning";
        TimePartitioning timePartitioning = TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY, (long)EXPIRATION_MS);
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(timePartitioning).build();
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Table createdPartitioningTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdPartitioningTable);
        try {
            Page tables = bigquery.listTables(DATASET, new BigQuery.TableListOption[0]);
            boolean found = false;
            Iterator tableIterator = tables.getValues().iterator();
            while (tableIterator.hasNext() && !found) {
                StandardTableDefinition standardTableDefinition = (StandardTableDefinition)((Table)tableIterator.next()).getDefinition();
                if (standardTableDefinition.getTimePartitioning() == null || !standardTableDefinition.getTimePartitioning().getType().equals((Object)TimePartitioning.Type.DAY) || !standardTableDefinition.getTimePartitioning().getExpirationMs().equals(EXPIRATION_MS)) continue;
                found = true;
            }
            Assert.assertTrue((boolean)found);
        }
        finally {
            createdPartitioningTable.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListTablesWithRangePartitioning() {
        String tableName = "test_list_tables_range_partitioning";
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setRangePartitioning(RANGE_PARTITIONING).build();
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Table createdRangePartitioningTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdRangePartitioningTable);
        try {
            Page tables = bigquery.listTables(DATASET, new BigQuery.TableListOption[0]);
            boolean found = false;
            Iterator tableIterator = tables.getValues().iterator();
            while (tableIterator.hasNext() && !found) {
                StandardTableDefinition standardTableDefinition = (StandardTableDefinition)((Table)tableIterator.next()).getDefinition();
                if (standardTableDefinition.getRangePartitioning() == null) continue;
                Assert.assertEquals((Object)RANGE_PARTITIONING, (Object)standardTableDefinition.getRangePartitioning());
                Assert.assertEquals((Object)RANGE, (Object)standardTableDefinition.getRangePartitioning().getRange());
                Assert.assertEquals((Object)"IntegerField", (Object)standardTableDefinition.getRangePartitioning().getField());
                found = true;
            }
            Assert.assertTrue((boolean)found);
        }
        finally {
            createdRangePartitioningTable.delete();
        }
    }

    @Test
    public void testListPartitions() throws InterruptedException {
        String tableName = "test_table_partitions_" + UUID.randomUUID().toString().substring(0, 8);
        Date date = Date.fromJavaUtilDate((java.util.Date)new java.util.Date());
        String partitionDate = date.toString().replaceAll("-", "");
        TableId tableId = TableId.of((String)DATASET, (String)(tableName + "$" + partitionDate));
        String query = String.format("CREATE OR REPLACE TABLE  %s.%s ( StringField STRING ) PARTITION BY DATE(_PARTITIONTIME) OPTIONS( partition_expiration_days=1)", DATASET, tableName);
        Job job = bigquery.create(JobInfo.of((JobConfiguration)QueryJobConfiguration.newBuilder((String)query).build()), new BigQuery.JobOption[0]);
        job.waitFor(new RetryOption[0]);
        Assert.assertTrue((boolean)job.isDone());
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("StringField", "StringValue");
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableId).addRow(row).build();
        InsertAllResponse response = bigquery.insertAll(request);
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals((long)0L, (long)response.getInsertErrors().size());
        List partitions = bigquery.listPartitions(TableId.of((String)DATASET, (String)tableName));
        Assert.assertEquals((long)1L, (long)partitions.size());
        bigquery.delete(tableId);
    }

    @Test
    public void testUpdateTable() {
        String tableName = "test_update_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition).setDescription("Some Description").setLabels(Collections.singletonMap("a", "b")).build();
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Truth.assertThat((String)createdTable.getDescription()).isEqualTo((Object)"Some Description");
        Truth.assertThat((Map)createdTable.getLabels()).containsExactly((Object)"a", (Object)"b", new Object[0]);
        HashMap<String, String> updateLabels = new HashMap<String, String>();
        updateLabels.put("x", "y");
        updateLabels.put("a", null);
        Table updatedTable = bigquery.update((TableInfo)createdTable.toBuilder().setDescription("Updated Description").setLabels(updateLabels).build(), new BigQuery.TableOption[0]);
        Truth.assertThat((String)updatedTable.getDescription()).isEqualTo((Object)"Updated Description");
        Truth.assertThat((Map)updatedTable.getLabels()).containsExactly((Object)"x", (Object)"y", new Object[0]);
        updatedTable = bigquery.update((TableInfo)updatedTable.toBuilder().setLabels(null).build(), new BigQuery.TableOption[0]);
        Truth.assertThat((Map)updatedTable.getLabels()).isEmpty();
        Truth.assertThat((Boolean)createdTable.delete()).isTrue();
    }

    @Test
    public void testUpdateTimePartitioning() {
        String tableName = "testUpdateTimePartitioning";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(TABLE_SCHEMA).setTimePartitioning(TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY)).build();
        Table table = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
        TableDefinition definition = table.getDefinition();
        Truth.assertThat((Object)definition).isInstanceOf(StandardTableDefinition.class);
        Truth.assertThat((Long)((StandardTableDefinition)definition).getTimePartitioning().getExpirationMs()).isNull();
        table = table.toBuilder().setDefinition((TableDefinition)tableDefinition.toBuilder().setTimePartitioning(TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY, (long)42L)).build()).build().update(new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.TIME_PARTITIONING})});
        TableDefinition updatedDefinition = table.getDefinition();
        Truth.assertThat((Long)((StandardTableDefinition)updatedDefinition).getTimePartitioning().getExpirationMs()).isEqualTo((Object)42L);
        table = table.toBuilder().setDefinition((TableDefinition)tableDefinition.toBuilder().setTimePartitioning(TimePartitioning.of((TimePartitioning.Type)TimePartitioning.Type.DAY)).build()).build().update(new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.TIME_PARTITIONING})});
        Truth.assertThat((Long)((StandardTableDefinition)definition).getTimePartitioning().getExpirationMs()).isNull();
        table.delete();
    }

    @Test
    public void testUpdateTableWithSelectedFields() {
        String tableName = "test_update_with_selected_fields_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table updatedTable = bigquery.update(tableInfo.toBuilder().setDescription("newDescr").build(), new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[]{BigQuery.TableField.DESCRIPTION})});
        Assert.assertTrue((boolean)(updatedTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)DATASET, (Object)updatedTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)updatedTable.getTableId().getTable());
        Assert.assertEquals((Object)"newDescr", (Object)updatedTable.getDescription());
        Assert.assertNull((Object)updatedTable.getDefinition().getSchema());
        Assert.assertNull((Object)updatedTable.getLastModifiedTime());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumLongTermBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumTimeTravelPhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumTotalLogicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumActiveLogicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumLongTermLogicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumTotalPhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumActivePhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumLongTermPhysicalBytes());
        Assert.assertNull((Object)((StandardTableDefinition)updatedTable.getDefinition()).getNumRows());
        Assert.assertTrue((boolean)createdTable.delete());
    }

    @Test
    public void testUpdateNonExistingTable() {
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)"test_update_non_existing_table"), (TableDefinition)StandardTableDefinition.of((Schema)SIMPLE_SCHEMA));
        try {
            bigquery.update(tableInfo, new BigQuery.TableOption[0]);
            Assert.fail((String)"BigQueryException was expected");
        }
        catch (BigQueryException e) {
            BigQueryError error = e.getError();
            Assert.assertNotNull((Object)error);
            Assert.assertEquals((Object)"notFound", (Object)error.getReason());
            Assert.assertNotNull((Object)error.getMessage());
        }
    }

    @Test
    public void testDeleteNonExistingTable() {
        Assert.assertFalse((boolean)bigquery.delete("test_delete_non_existing_table", new BigQuery.DatasetDeleteOption[0]));
    }

    @Test
    public void testDeleteJob() {
        String query = "SELECT 17 as foo";
        QueryJobConfiguration config = QueryJobConfiguration.of((String)query);
        String jobName = "jobId_" + UUID.randomUUID().toString();
        JobId jobId = JobId.newBuilder().setLocation("us-east1").setJob(jobName).setProject(PROJECT_ID).build();
        Job createdJob = bigquery.create(JobInfo.of((JobId)jobId, (JobConfiguration)config), new BigQuery.JobOption[0]);
        Job remoteJob = bigquery.getJob(createdJob.getJobId(), new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)createdJob.getJobId(), (Object)remoteJob.getJobId());
        Assert.assertTrue((boolean)bigquery.delete(jobId));
        Assert.assertNull((Object)bigquery.getJob(jobId, new BigQuery.JobOption[0]));
    }

    @Test
    public void testInsertAll() throws IOException {
        String tableName = "test_insert_all_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Assert.assertNotNull((Object)bigquery.create(tableInfo, new BigQuery.TableOption[0]));
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        builder1.put((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00");
        builder1.put((Object)"StringField", (Object)"stringValue");
        builder1.put((Object)"IntegerArrayField", (Object)ImmutableList.of((Object)0, (Object)1));
        builder1.put((Object)"BooleanField", (Object)false);
        builder1.put((Object)"BytesField", (Object)BYTES_BASE64);
        builder1.put((Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerArrayField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true, (Object)"BytesField", (Object)BYTES_BASE64));
        builder1.put((Object)"IntegerField", (Object)5);
        builder1.put((Object)"FloatField", (Object)1.2);
        builder1.put((Object)"GeographyField", (Object)"POINT(-122.350220 47.649154)");
        builder1.put((Object)"NumericField", (Object)new BigDecimal("123456789.123456789"));
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        builder2.put((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00");
        builder2.put((Object)"StringField", (Object)"stringValue");
        builder2.put((Object)"IntegerArrayField", (Object)ImmutableList.of((Object)0, (Object)1));
        builder2.put((Object)"BooleanField", (Object)false);
        builder2.put((Object)"BytesField", (Object)BYTES_BASE64);
        builder2.put((Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerArrayField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true, (Object)"BytesField", (Object)BYTES_BASE64));
        builder2.put((Object)"IntegerField", (Object)5);
        builder2.put((Object)"FloatField", (Object)1.2);
        builder2.put((Object)"GeographyField", (Object)"POINT(-122.350220 47.649154)");
        builder2.put((Object)"NumericField", (Object)new BigDecimal("123456789.123456789"));
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableInfo.getTableId()).addRow((Map)builder1.build()).addRow((Map)builder2.build()).build();
        InsertAllResponse response = bigquery.insertAll(request);
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals((long)0L, (long)response.getInsertErrors().size());
        Assert.assertTrue((boolean)bigquery.delete(TableId.of((String)DATASET, (String)tableName)));
    }

    @Test
    public void testInsertAllWithSuffix() throws InterruptedException {
        String tableName = "test_insert_all_with_suffix_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Assert.assertNotNull((Object)bigquery.create(tableInfo, new BigQuery.TableOption[0]));
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        builder1.put((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00");
        builder1.put((Object)"StringField", (Object)"stringValue");
        builder1.put((Object)"IntegerArrayField", (Object)ImmutableList.of((Object)0, (Object)1));
        builder1.put((Object)"BooleanField", (Object)false);
        builder1.put((Object)"BytesField", (Object)BYTES_BASE64);
        builder1.put((Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerArrayField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true, (Object)"BytesField", (Object)BYTES_BASE64));
        builder1.put((Object)"IntegerField", (Object)5);
        builder1.put((Object)"FloatField", (Object)1.2);
        builder1.put((Object)"GeographyField", (Object)"POINT(-122.350220 47.649154)");
        builder1.put((Object)"NumericField", (Object)new BigDecimal("123456789.123456789"));
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        builder2.put((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00");
        builder2.put((Object)"StringField", (Object)"stringValue");
        builder2.put((Object)"IntegerArrayField", (Object)ImmutableList.of((Object)0, (Object)1));
        builder2.put((Object)"BooleanField", (Object)false);
        builder2.put((Object)"BytesField", (Object)BYTES_BASE64);
        builder2.put((Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerArrayField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true, (Object)"BytesField", (Object)BYTES_BASE64));
        builder2.put((Object)"IntegerField", (Object)5);
        builder2.put((Object)"FloatField", (Object)1.2);
        builder2.put((Object)"GeographyField", (Object)"POINT(-122.350220 47.649154)");
        builder2.put((Object)"NumericField", (Object)new BigDecimal("123456789.123456789"));
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableInfo.getTableId()).addRow((Map)builder1.build()).addRow((Map)builder2.build()).setTemplateSuffix("_suffix").build();
        InsertAllResponse response = bigquery.insertAll(request);
        Assert.assertFalse((boolean)response.hasErrors());
        Assert.assertEquals((long)0L, (long)response.getInsertErrors().size());
        String newTableName = tableName + "_suffix";
        Table suffixTable = bigquery.getTable(DATASET, newTableName, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        while (suffixTable == null) {
            Thread.sleep(1000L);
            suffixTable = bigquery.getTable(DATASET, newTableName, new BigQuery.TableOption[]{BigQuery.TableOption.fields((BigQuery.TableField[])new BigQuery.TableField[0])});
        }
        Assert.assertTrue((boolean)bigquery.delete(TableId.of((String)DATASET, (String)tableName)));
        Assert.assertTrue((boolean)suffixTable.delete());
    }

    @Test
    public void testInsertAllWithErrors() {
        String tableName = "test_insert_all_with_errors_table";
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)tableDefinition);
        Assert.assertNotNull((Object)bigquery.create(tableInfo, new BigQuery.TableOption[0]));
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        builder1.put((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00");
        builder1.put((Object)"StringField", (Object)"stringValue");
        builder1.put((Object)"IntegerArrayField", (Object)ImmutableList.of((Object)0, (Object)1));
        builder1.put((Object)"BooleanField", (Object)false);
        builder1.put((Object)"BytesField", (Object)BYTES_BASE64);
        builder1.put((Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerArrayField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true, (Object)"BytesField", (Object)BYTES_BASE64));
        builder1.put((Object)"IntegerField", (Object)5);
        builder1.put((Object)"FloatField", (Object)1.2);
        builder1.put((Object)"GeographyField", (Object)"POINT(-122.350220 47.649154)");
        builder1.put((Object)"NumericField", (Object)new BigDecimal("123456789.123456789"));
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        builder2.put((Object)"TimestampField", (Object)"invalidDate");
        builder2.put((Object)"StringField", (Object)"stringValue");
        builder2.put((Object)"IntegerArrayField", (Object)ImmutableList.of((Object)0, (Object)1));
        builder2.put((Object)"BooleanField", (Object)false);
        builder2.put((Object)"BytesField", (Object)BYTES_BASE64);
        builder2.put((Object)"RecordField", (Object)ImmutableMap.of((Object)"TimestampField", (Object)"1969-07-20 20:18:04 UTC", (Object)"IntegerArrayField", (Object)ImmutableList.of((Object)1, (Object)0), (Object)"BooleanField", (Object)true, (Object)"BytesField", (Object)BYTES_BASE64));
        builder2.put((Object)"IntegerField", (Object)5);
        builder2.put((Object)"FloatField", (Object)1.2);
        builder2.put((Object)"GeographyField", (Object)"POINT(-122.350220 47.649154)");
        builder2.put((Object)"NumericField", (Object)new BigDecimal("123456789.123456789"));
        ImmutableMap.Builder builder3 = ImmutableMap.builder();
        builder3.put((Object)"TimestampField", (Object)"2014-08-19 07:41:35.220 -05:00");
        builder3.put((Object)"StringField", (Object)"stringValue");
        builder3.put((Object)"IntegerArrayField", (Object)ImmutableList.of((Object)0, (Object)1));
        builder3.put((Object)"BooleanField", (Object)false);
        builder3.put((Object)"BytesField", (Object)BYTES_BASE64);
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableInfo.getTableId()).addRow((Map)builder1.build()).addRow((Map)builder2.build()).addRow((Map)builder3.build()).setSkipInvalidRows(true).build();
        InsertAllResponse response = bigquery.insertAll(request);
        Assert.assertTrue((boolean)response.hasErrors());
        Assert.assertEquals((long)2L, (long)response.getInsertErrors().size());
        Assert.assertNotNull((Object)response.getErrorsFor(1L));
        Assert.assertNotNull((Object)response.getErrorsFor(2L));
        Assert.assertTrue((boolean)bigquery.delete(TableId.of((String)DATASET, (String)tableName)));
    }

    @Test
    public void testListAllTableData() {
        TableResult rows = bigquery.listTableData(TABLE_ID, new BigQuery.TableDataListOption[0]);
        int rowCount = 0;
        for (FieldValueList row : rows.getValues()) {
            FieldValue timestampCell = row.get(0);
            FieldValue stringCell = row.get(1);
            FieldValue integerArrayCell = row.get(2);
            FieldValue booleanCell = row.get(3);
            FieldValue bytesCell = row.get(4);
            FieldValue recordCell = row.get(5);
            FieldValue integerCell = row.get(6);
            FieldValue floatCell = row.get(7);
            FieldValue geographyCell = row.get(8);
            FieldValue numericCell = row.get(9);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.REPEATED, (Object)integerArrayCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)bytesCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)recordCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)integerCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)floatCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)geographyCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)numericCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)integerArrayCell.getRepeatedValue().get(0)).getLongValue());
            Assert.assertEquals((long)1L, (long)((FieldValue)integerArrayCell.getRepeatedValue().get(1)).getLongValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
            Assert.assertArrayEquals((byte[])BYTES, (byte[])bytesCell.getBytesValue());
            Assert.assertEquals((long)-14182916000000L, (long)recordCell.getRecordValue().get(0).getTimestampValue());
            Assert.assertTrue((boolean)recordCell.getRecordValue().get(1).isNull());
            Assert.assertEquals((long)1L, (long)((FieldValue)recordCell.getRecordValue().get(2).getRepeatedValue().get(0)).getLongValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)recordCell.getRecordValue().get(2).getRepeatedValue().get(1)).getLongValue());
            Assert.assertEquals((Object)true, (Object)recordCell.getRecordValue().get(3).getBooleanValue());
            Assert.assertEquals((long)3L, (long)integerCell.getLongValue());
            Assert.assertEquals((double)1.2, (double)floatCell.getDoubleValue(), (double)1.0E-4);
            Assert.assertEquals((Object)"POINT(-122.35022 47.649154)", (Object)geographyCell.getStringValue());
            Assert.assertEquals((Object)new BigDecimal("123456.789012345"), (Object)numericCell.getNumericValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
    }

    @Test
    public void testListPageWithStartIndex() {
        String tableName = "midyear_population_agespecific";
        TableId tableId = TableId.of((String)PUBLIC_PROJECT, (String)PUBLIC_DATASET, (String)tableName);
        Table table = bigquery.getTable(tableId, new BigQuery.TableOption[0]);
        long numRows = table.getNumRows().longValue();
        TableResult tableResult = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)(numRows - 300000L)), BigQuery.TableDataListOption.pageSize((long)600000L)});
        Assert.assertNotNull((Object)tableResult.getNextPageToken());
        long totalRows = ((Collection)tableResult.getValues()).size();
        tableResult = tableResult.getNextPage();
        Assert.assertNull((Object)tableResult.getNextPageToken());
        Assert.assertEquals((long)300000L, (long)(totalRows += (long)((Collection)tableResult.getValues()).size()));
    }

    @Test
    public void testModelLifecycle() throws InterruptedException {
        String modelName = RemoteBigQueryHelper.generateModelName();
        String sql = "CREATE MODEL `" + MODEL_DATASET + "." + modelName + "`OPTIONS ( model_type='linear_reg', max_iterations=1, learn_rate=0.4, learn_rate_strategy='constant' ) AS ( \tSELECT 'a' AS f1, 2.0 AS label UNION ALL SELECT 'b' AS f1, 3.8 AS label )";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)sql).build();
        Job job = bigquery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)config), new BigQuery.JobOption[0]);
        job.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)job.getStatus().getError());
        ModelId modelId = ModelId.of((String)MODEL_DATASET, (String)modelName);
        Model model = bigquery.getModel(modelId, new BigQuery.ModelOption[0]);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)model.getModelType(), (Object)"LINEAR_REGRESSION");
        Assert.assertEquals((Object)((StandardSQLField)model.getFeatureColumns().get(0)).getName(), (Object)"f1");
        Assert.assertEquals((Object)((StandardSQLField)model.getLabelColumns().get(0)).getName(), (Object)"predicted_label");
        Assert.assertEquals((Object)((TrainingRun)model.getTrainingRuns().get(0)).getTrainingOptions().getLearnRateStrategy(), (Object)"CONSTANT");
        Model info = model.toBuilder().setDescription("TEST").build();
        Model afterUpdate = bigquery.update((ModelInfo)info, new BigQuery.ModelOption[0]);
        Assert.assertEquals((Object)afterUpdate.getDescription(), (Object)"TEST");
        Page models = bigquery.listModels(MODEL_DATASET, new BigQuery.ModelListOption[0]);
        Boolean found = false;
        for (Model m : models.getValues()) {
            if (!m.getModelId().getModel().equals(modelName)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        Assert.assertTrue((boolean)bigquery.delete(modelId));
    }

    @Test
    public void testEmptyListModels() {
        String datasetId = "test_empty_dataset_list_models_" + RANDOM_ID;
        Assert.assertNotNull((Object)bigquery.create(DatasetInfo.of((String)datasetId), new BigQuery.DatasetOption[0]));
        Page models = bigquery.listModels(datasetId, new BigQuery.ModelListOption[]{BigQuery.ModelListOption.pageSize((long)100L)});
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)models.getValues()));
        Assert.assertFalse((boolean)models.hasNextPage());
        Assert.assertNull((Object)models.getNextPageToken());
        Assert.assertTrue((boolean)bigquery.delete(datasetId, new BigQuery.DatasetDeleteOption[0]));
    }

    @Test
    public void testEmptyListRoutines() {
        String datasetId = "test_empty_dataset_list_routines_" + RANDOM_ID;
        Assert.assertNotNull((Object)bigquery.create(DatasetInfo.of((String)datasetId), new BigQuery.DatasetOption[0]));
        Page routines = bigquery.listRoutines(datasetId, new BigQuery.RoutineListOption[]{BigQuery.RoutineListOption.pageSize((long)100L)});
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)routines.getValues()));
        Assert.assertFalse((boolean)routines.hasNextPage());
        Assert.assertNull((Object)routines.getNextPageToken());
        Assert.assertTrue((boolean)bigquery.delete(datasetId, new BigQuery.DatasetDeleteOption[0]));
    }

    @Test
    public void testRoutineLifecycle() throws InterruptedException {
        String routineName = RemoteBigQueryHelper.generateRoutineName();
        String sql = "CREATE FUNCTION `" + ROUTINE_DATASET + "." + routineName + "`(x INT64) AS (x * 3)";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)sql).build();
        Job job = bigquery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)config), new BigQuery.JobOption[0]);
        job.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)job.getStatus().getError());
        RoutineId routineId = RoutineId.of((String)ROUTINE_DATASET, (String)routineName);
        Routine routine = bigquery.getRoutine(routineId, new BigQuery.RoutineOption[0]);
        Assert.assertNotNull((Object)routine);
        Assert.assertEquals((Object)routine.getRoutineType(), (Object)"SCALAR_FUNCTION");
        Routine newInfo = routine.toBuilder().setBody("x * 4").setReturnType(routine.getReturnType()).setArguments(routine.getArguments()).setRoutineType(routine.getRoutineType()).build();
        Routine afterUpdate = bigquery.update((RoutineInfo)newInfo, new BigQuery.RoutineOption[0]);
        Assert.assertEquals((Object)afterUpdate.getBody(), (Object)"x * 4");
        Page routines = bigquery.listRoutines(ROUTINE_DATASET, new BigQuery.RoutineListOption[0]);
        Boolean found = false;
        for (Routine r : routines.getValues()) {
            if (!r.getRoutineId().getRoutine().equals(routineName)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
        Assert.assertTrue((boolean)bigquery.delete(routineId));
    }

    @Test
    public void testRoutineAPICreation() {
        String routineName = RemoteBigQueryHelper.generateRoutineName();
        RoutineId routineId = RoutineId.of((String)ROUTINE_DATASET, (String)routineName);
        RoutineInfo routineInfo = RoutineInfo.newBuilder((RoutineId)routineId).setRoutineType("SCALAR_FUNCTION").setBody("x * 3").setLanguage("SQL").setArguments((List)ImmutableList.of((Object)RoutineArgument.newBuilder().setName("x").setDataType(StandardSQLDataType.newBuilder((String)"INT64").build()).build())).build();
        Routine routine = bigquery.create(routineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertNotNull((Object)routine);
        Assert.assertEquals((Object)routine.getRoutineType(), (Object)"SCALAR_FUNCTION");
    }

    @Test
    public void testRoutineAPICreationJavascriptUDF() {
        String routineName = RemoteBigQueryHelper.generateRoutineName();
        RoutineId routineId = RoutineId.of((String)ROUTINE_DATASET, (String)routineName);
        RoutineInfo routineInfo = RoutineInfo.newBuilder((RoutineId)routineId).setLanguage("JAVASCRIPT").setRoutineType("SCALAR_FUNCTION").setDeterminismLevel("DETERMINISTIC").setArguments((List)ImmutableList.of((Object)RoutineArgument.newBuilder().setName("instr").setKind("FIXED_TYPE").setDataType(StandardSQLDataType.newBuilder((String)"STRING").build()).build())).setReturnType(StandardSQLDataType.newBuilder((String)"STRING").build()).setBody("return instr.toUpperCase();").build();
        Routine routine = bigquery.create(routineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertNotNull((Object)routine);
        Assert.assertEquals((Object)routine.getLanguage(), (Object)"JAVASCRIPT");
        Assert.assertEquals((Object)routine.getDeterminismLevel(), (Object)"DETERMINISTIC");
        Assert.assertEquals((Object)routine.getRoutineType(), (Object)"SCALAR_FUNCTION");
        Assert.assertEquals((Object)routine.getReturnType(), (Object)StandardSQLDataType.newBuilder((String)"STRING").build());
    }

    @Test
    public void testRoutineAPICreationTVF() {
        String routineName = RemoteBigQueryHelper.generateRoutineName();
        RoutineId routineId = RoutineId.of((String)ROUTINE_DATASET, (String)routineName);
        ImmutableList columns = ImmutableList.of((Object)StandardSQLField.newBuilder((String)"x", (StandardSQLDataType)StandardSQLDataType.newBuilder((String)"INT64").build()).build());
        StandardSQLTableType returnTableType = StandardSQLTableType.newBuilder((List)columns).build();
        RoutineInfo routineInfo = RoutineInfo.newBuilder((RoutineId)routineId).setRoutineType("TABLE_VALUED_FUNCTION").setLanguage("SQL").setArguments((List)ImmutableList.of((Object)RoutineArgument.newBuilder().setName("filter").setDataType(StandardSQLDataType.newBuilder((String)"INT64").build()).build())).setReturnTableType(returnTableType).setBody("SELECT x FROM UNNEST([1,2,3]) x WHERE x = filter").build();
        Routine routine = bigquery.create(routineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertNotNull((Object)routine);
        Assert.assertEquals((Object)routine.getRoutineType(), (Object)"TABLE_VALUED_FUNCTION");
        Assert.assertEquals((Object)routine.getReturnTableType(), (Object)returnTableType);
    }

    @Test
    public void testRoutineDataGovernanceType() {
        String routineName = RemoteBigQueryHelper.generateRoutineName();
        RoutineId routineId = RoutineId.of((String)ROUTINE_DATASET, (String)routineName);
        RoutineInfo routineInfo = RoutineInfo.newBuilder((RoutineId)routineId).setLanguage("SQL").setRoutineType("SCALAR_FUNCTION").setBody("x").setArguments((List)ImmutableList.of((Object)RoutineArgument.newBuilder().setName("x").setDataType(StandardSQLDataType.newBuilder((String)"INT64").build()).build())).setReturnType(StandardSQLDataType.newBuilder((String)"INT64").build()).setDataGovernanceType("DATA_MASKING").build();
        Routine routine = bigquery.create(routineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertNotNull((Object)routine);
        Assert.assertEquals((Object)routine.getLanguage(), (Object)"SQL");
        Assert.assertEquals((Object)routine.getRoutineType(), (Object)"SCALAR_FUNCTION");
        Assert.assertEquals((Object)routine.getReturnType(), (Object)StandardSQLDataType.newBuilder((String)"INT64").build());
        Assert.assertEquals((Object)routine.getDataGovernanceType(), (Object)"DATA_MASKING");
    }

    @Test
    public void testAuthorizeRoutine() {
        String routineName = RemoteBigQueryHelper.generateRoutineName();
        RoutineId routineId = RoutineId.of((String)PROJECT_ID, (String)ROUTINE_DATASET, (String)routineName);
        RoutineInfo routineInfo = RoutineInfo.newBuilder((RoutineId)routineId).setRoutineType("SCALAR_FUNCTION").setBody("x * 3").setLanguage("SQL").setArguments((List)ImmutableList.of((Object)RoutineArgument.newBuilder().setName("x").setDataType(StandardSQLDataType.newBuilder((String)"INT64").build()).build())).build();
        Routine routine = bigquery.create(routineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertNotNull((Object)routine);
        Assert.assertEquals((Object)routine.getRoutineType(), (Object)"SCALAR_FUNCTION");
        Dataset routineDataset = bigquery.getDataset(ROUTINE_DATASET, new BigQuery.DatasetOption[0]);
        ArrayList<Acl> routineAcl = new ArrayList<Acl>(routineDataset.getAcl());
        routineAcl.add(Acl.of((Acl.Routine)new Acl.Routine(routineId)));
        routineDataset = routineDataset.toBuilder().setAcl(routineAcl).build().update(new BigQuery.DatasetOption[0]);
        Assert.assertEquals(routineAcl, (Object)routineDataset.getAcl());
    }

    @Test
    public void testAuthorizeDataset() {
        String datasetName = RemoteBigQueryHelper.generateDatasetName();
        DatasetId datasetId = DatasetId.of((String)PROJECT_ID, (String)datasetName);
        ImmutableList targetTypes = ImmutableList.of((Object)"VIEWS");
        ImmutableList acl = ImmutableList.of((Object)Acl.of((Acl.Entity)new Acl.Group("projectOwners"), (Acl.Role)Acl.Role.OWNER), (Object)Acl.of((Acl.Entity)new Acl.IamMember("allUsers"), (Acl.Role)Acl.Role.READER));
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((DatasetId)datasetId).setAcl((List)acl).setDescription("shared Dataset").build();
        Dataset sharedDataset = bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        Assert.assertNotNull((Object)sharedDataset);
        Assert.assertEquals((Object)sharedDataset.getDescription(), (Object)"shared Dataset");
        ArrayList<Acl> sharedDatasetAcl = new ArrayList<Acl>(sharedDataset.getAcl());
        String authorizedDatasetName = RemoteBigQueryHelper.generateDatasetName();
        DatasetId authorizedDatasetId = DatasetId.of((String)PROJECT_ID, (String)authorizedDatasetName);
        DatasetInfo authorizedDatasetInfo = DatasetInfo.newBuilder((DatasetId)authorizedDatasetId).setDescription("new Dataset to be authorized by the sharedDataset").build();
        Dataset authorizedDataset = bigquery.create(authorizedDatasetInfo, new BigQuery.DatasetOption[0]);
        Assert.assertNotNull((Object)authorizedDataset);
        Assert.assertEquals((Object)authorizedDataset.getDescription(), (Object)"new Dataset to be authorized by the sharedDataset");
        Acl.DatasetAclEntity datasetEntity = new Acl.DatasetAclEntity(authorizedDatasetId, (List)targetTypes);
        sharedDatasetAcl.add(Acl.of((Acl.DatasetAclEntity)datasetEntity));
        Dataset updatedDataset = sharedDataset.toBuilder().setAcl(sharedDatasetAcl).build().update(new BigQuery.DatasetOption[0]);
        Assert.assertEquals(sharedDatasetAcl, (Object)updatedDataset.getAcl());
    }

    @Test
    public void testSingleStatementsQueryException() throws InterruptedException {
        String invalidQuery = String.format("INSERT %s.%s VALUES('3', 10);", DATASET, TABLE_ID.getTable());
        try {
            bigquery.create(JobInfo.of((JobConfiguration)QueryJobConfiguration.of((String)invalidQuery)), new BigQuery.JobOption[0]).waitFor(new RetryOption[0]);
            Assert.fail((String)"BigQueryException was expected");
        }
        catch (BigQueryException ex) {
            Assert.assertEquals((Object)"invalidQuery", (Object)ex.getReason());
            Assert.assertNotNull((Object)ex.getMessage());
            BigQueryError error = ex.getError();
            Assert.assertEquals((Object)"invalidQuery", (Object)error.getReason());
            Assert.assertNotNull((Object)error.getMessage());
        }
    }

    @Test
    public void testMultipleStatementsQueryException() throws InterruptedException {
        String invalidQuery = String.format("INSERT %s.%s VALUES('3', 10); DELETE %s.%s where c2=3;", DATASET, TABLE_ID.getTable(), DATASET, TABLE_ID.getTable());
        try {
            bigquery.create(JobInfo.of((JobConfiguration)QueryJobConfiguration.of((String)invalidQuery)), new BigQuery.JobOption[0]).waitFor(new RetryOption[0]);
            Assert.fail((String)"BigQueryException was expected");
        }
        catch (BigQueryException ex) {
            Assert.assertEquals((Object)"invalidQuery", (Object)ex.getReason());
            Assert.assertNotNull((Object)ex.getMessage());
            BigQueryError error = ex.getError();
            Assert.assertEquals((Object)"invalidQuery", (Object)error.getReason());
            Assert.assertNotNull((Object)error.getMessage());
        }
    }

    @Test
    public void testTimestamp() throws InterruptedException {
        String query = "SELECT TIMESTAMP '2022-01-24T23:54:25.095574Z'";
        String timestampStringValueExpected = "2022-01-24T23:54:25.095574Z";
        TableResult resultInteractive = bigquery.query(QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build(), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)resultInteractive.getJobId());
        for (FieldValueList row : resultInteractive.getValues()) {
            FieldValue timeStampCell = row.get(0);
            Instant timestampStringValueActual = timeStampCell.getTimestampInstant();
            Assert.assertEquals((Object)timestampStringValueExpected, (Object)timestampStringValueActual.toString());
        }
    }

    @Test
    public void testLosslessTimestamp() throws InterruptedException {
        String query = "SELECT TIMESTAMP '2022-01-24T23:54:25.095574Z'";
        long expectedTimestamp = 1643068465095574L;
        TableResult result = bigquery.query(QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build(), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        for (FieldValueList row : result.getValues()) {
            FieldValue timeStampCell = row.get(0);
            Assert.assertFalse((boolean)timeStampCell.getUseInt64Timestamps());
            Assert.assertEquals((long)expectedTimestamp, (long)timeStampCell.getTimestampValue());
        }
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQuery bigqueryLossless = (BigQuery)bigqueryHelper.getOptions().getService();
        ((BigQueryOptions)bigqueryLossless.getOptions()).setUseInt64Timestamps(true);
        TableResult resultLossless = bigqueryLossless.query(QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build(), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)resultLossless.getJobId());
        for (FieldValueList row : resultLossless.getValues()) {
            FieldValue timeStampCellLossless = row.get(0);
            Assert.assertTrue((boolean)timeStampCellLossless.getUseInt64Timestamps());
            Assert.assertEquals((long)expectedTimestamp, (long)timeStampCellLossless.getTimestampValue());
        }
    }

    @Test
    public void testQuery() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Job job = bigquery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)config), new BigQuery.JobOption[0]);
        TableResult result = job.getQueryResults(new BigQuery.QueryResultsOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result.getSchema());
        int rowCount = 0;
        for (FieldValueList row : result.getValues()) {
            FieldValue timestampCell = row.get(0);
            Assert.assertEquals((Object)timestampCell, (Object)row.get("TimestampField"));
            FieldValue stringCell = row.get(1);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            FieldValue booleanCell = row.get(2);
            Assert.assertEquals((Object)booleanCell, (Object)row.get("BooleanField"));
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Job job2 = bigquery.getJob(job.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)job2.getStatistics();
        Assert.assertNotNull((Object)statistics.getQueryPlan());
    }

    @Test
    public void testQueryStatistics() throws InterruptedException {
        String query = "SELECT CURRENT_TIMESTAMP() AS ts";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setUseQueryCache(Boolean.valueOf(false)).build();
        Job job = bigquery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)config), new BigQuery.JobOption[0]);
        job = job.waitFor(new RetryOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)job.getStatistics();
        Assert.assertNotNull((Object)statistics.getQueryPlan());
        Truth.assertThat((Long)statistics.getTotalSlotMs()).isGreaterThan((Comparable)Long.valueOf(0L));
    }

    @Test
    public void testExecuteSelectDefaultConnectionSettings() throws SQLException {
        Connection connection = bigquery.createConnection();
        String query = "SELECT corpus FROM `bigquery-public-data.samples.shakespeare` GROUP BY corpus;";
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        Assert.assertEquals((long)42L, (long)bigQueryResult.getTotalRows());
    }

    @Test
    public void testExecuteSelectReadApiEmptyResultSet() throws SQLException {
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setJobTimeoutMs(Long.valueOf(Long.MAX_VALUE)).setUseReadAPI(Boolean.valueOf(true)).setUseQueryCache(Boolean.valueOf(false)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        String query = "SELECT TIMESTAMP '2022-01-24T23:54:25.095574Z' LIMIT 0";
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        Truth.assertThat((Boolean)rs.next()).isFalse();
        Truth.assertThat((Long)bigQueryResult.getTotalRows()).isEqualTo((Object)0);
    }

    @Test
    public void testExecuteSelectWithCredentials() throws SQLException {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQueryOptions bigQueryOptions = ((BigQueryOptions.Builder)bigqueryHelper.getOptions().toBuilder().setCredentials(((BigQueryOptions)bigquery.getOptions()).getCredentials())).build();
        BigQuery bigQueryGoodCredentials = (BigQuery)bigQueryOptions.getService();
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setPriority(QueryJobConfiguration.Priority.INTERACTIVE).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connectionGoodCredentials = bigQueryGoodCredentials.createConnection(connectionSettings);
        String query = "SELECT * FROM " + TABLE_ID_LARGE.getTable();
        BigQueryResult bigQueryResult = connectionGoodCredentials.executeSelect(query);
        Assert.assertEquals((long)313348L, (long)bigQueryResult.getTotalRows());
        BigQueryOptions bigQueryOptionsBadCredentials = ((BigQueryOptions.Builder)bigqueryHelper.getOptions().toBuilder().setCredentials((Credentials)ITBigQueryTest.loadCredentials(FAKE_JSON_CRED_WITH_GOOGLE_DOMAIN))).build();
        BigQuery bigQueryBadCredentials = (BigQuery)bigQueryOptionsBadCredentials.getService();
        Connection connectionBadCredentials = bigQueryBadCredentials.createConnection(connectionSettings);
        try {
            connectionBadCredentials.executeSelect(query);
            Assert.fail();
        }
        catch (BigQuerySQLException e) {
            Assert.assertNotNull((Object)((Object)e));
        }
    }

    @Test
    public void testQueryTimeStamp() throws InterruptedException {
        String query = "SELECT TIMESTAMP '2022-01-24T23:54:25.095574Z'";
        Instant beforeQueryInstant = Instant.parse("2022-01-24T23:54:25.095574Z");
        long microsBeforeQuery = TimeUnit.SECONDS.toMicros(beforeQueryInstant.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(beforeQueryInstant.getNano());
        TableResult result = bigquery.query(QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build(), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        for (FieldValueList row : result.getValues()) {
            FieldValue timeStampCell = row.get(0);
            long microsAfterQuery = timeStampCell.getTimestampValue();
            Assert.assertEquals((long)microsBeforeQuery, (long)microsAfterQuery);
        }
        TableResult resultInteractive = bigquery.query(QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build(), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)resultInteractive.getJobId());
        for (FieldValueList row : resultInteractive.getValues()) {
            FieldValue timeStampCell = row.get(0);
            long microsAfterQuery = timeStampCell.getTimestampValue();
            Assert.assertEquals((long)microsBeforeQuery, (long)microsAfterQuery);
        }
    }

    @Test
    public void testQueryCaseInsensitiveSchemaFieldByGetName() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Job job = bigquery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)config), new BigQuery.JobOption[0]);
        TableResult result = job.getQueryResults(new BigQuery.QueryResultsOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result.getSchema());
        int rowCount = 0;
        for (FieldValueList row : result.getValues()) {
            FieldValue timestampCell = row.get(0);
            Assert.assertEquals((Object)timestampCell, (Object)row.get("TimestampField"));
            Assert.assertEquals((Object)timestampCell, (Object)row.get("timestampfield"));
            Assert.assertEquals((Object)timestampCell, (Object)row.get("timeStampfIeld"));
            FieldValue stringCell = row.get(1);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            Assert.assertEquals((Object)stringCell, (Object)row.get("stringfield"));
            Assert.assertEquals((Object)stringCell, (Object)row.get("sTrinGfield"));
            FieldValue booleanCell = row.get(2);
            Assert.assertEquals((Object)booleanCell, (Object)row.get("BooleanField"));
            Assert.assertEquals((Object)booleanCell, (Object)row.get("booleanfield"));
            Assert.assertEquals((Object)booleanCell, (Object)row.get("booLeanfielD"));
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
    }

    @Test
    public void testQueryExternalHivePartitioningOptionAutoLayout() throws InterruptedException {
        String tableName = "test_queryexternalhivepartition_autolayout_table";
        String sourceUri = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/hive-partitioning-samples/autolayout/*";
        String sourceUriPrefix = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/hive-partitioning-samples/autolayout/";
        HivePartitioningOptions hivePartitioningOptions = HivePartitioningOptions.newBuilder().setMode("AUTO").setRequirePartitionFilter(Boolean.valueOf(true)).setSourceUriPrefix(sourceUriPrefix).build();
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ParquetOptions parquetOptions = ParquetOptions.newBuilder().setEnableListInference(Boolean.valueOf(true)).setEnumAsString(Boolean.valueOf(true)).build();
        ExternalTableDefinition externalTable = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.parquet()).setAutodetect(Boolean.valueOf(true)).setHivePartitioningOptions(hivePartitioningOptions).setFormatOptions((FormatOptions)parquetOptions).build();
        Assert.assertNotNull((Object)bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)externalTable), new BigQuery.TableOption[0]));
        String query = String.format("SELECT COUNT(*) as ct FROM %s.%s WHERE dt=\"2020-11-15\"", DATASET, tableName);
        TableResult result = bigquery.query(QueryJobConfiguration.of((String)query), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        for (FieldValueList fieldValues : result.iterateAll()) {
            Assert.assertEquals((long)50L, (long)fieldValues.get("ct").getLongValue());
        }
        Assert.assertEquals((long)1L, (long)result.getTotalRows());
        Assert.assertTrue((boolean)bigquery.delete(tableId));
    }

    @Test
    public void testQueryExternalHivePartitioningOptionCustomLayout() throws InterruptedException {
        String tableName = "test_queryexternalhivepartition_customlayout_table";
        String sourceUri = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/hive-partitioning-samples/customlayout/*";
        String sourceUriPrefix = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/hive-partitioning-samples/customlayout/{pkey:STRING}/";
        ParquetOptions parquetOptions = ParquetOptions.newBuilder().setEnableListInference(Boolean.valueOf(true)).setEnumAsString(Boolean.valueOf(true)).build();
        HivePartitioningOptions hivePartitioningOptions = HivePartitioningOptions.newBuilder().setMode("CUSTOM").setRequirePartitionFilter(Boolean.valueOf(true)).setSourceUriPrefix(sourceUriPrefix).build();
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ExternalTableDefinition externalTable = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.parquet()).setAutodetect(Boolean.valueOf(true)).setHivePartitioningOptions(hivePartitioningOptions).setFormatOptions((FormatOptions)parquetOptions).build();
        Assert.assertNotNull((Object)bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)externalTable), new BigQuery.TableOption[0]));
        String query = String.format("SELECT COUNT(*) as ct FROM %s.%s WHERE pkey=\"foo\"", DATASET, tableName);
        TableResult result = bigquery.query(QueryJobConfiguration.of((String)query), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        for (FieldValueList fieldValues : result.iterateAll()) {
            Assert.assertEquals((long)50L, (long)fieldValues.get("ct").getLongValue());
        }
        Assert.assertEquals((long)1L, (long)result.getTotalRows());
        Assert.assertTrue((boolean)bigquery.delete(tableId));
    }

    @Test
    public void testConnectionImplDryRun() throws SQLException {
        String query = String.format("select StringField,  BigNumericField, BooleanField, BytesField, IntegerField, TimestampField, FloatField, NumericField, TimeField, DateField,  DateTimeField , GeographyField, RecordField.BytesField, RecordField.BooleanField, IntegerArrayField from %s where StringField = ? order by TimestampField", TABLE_ID_FASTQUERY_BQ_RESULTSET.getTable());
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setCreateSession(Boolean.valueOf(true)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryDryRunResult bigQueryDryRunResultSet = connection.dryRun(query);
        Assert.assertNotNull((Object)bigQueryDryRunResultSet.getSchema());
        Assert.assertEquals((Object)BQ_RESULTSET_EXPECTED_SCHEMA, (Object)bigQueryDryRunResultSet.getSchema());
        List queryParameters = bigQueryDryRunResultSet.getQueryParameters();
        Assert.assertEquals((Object)StandardSQLTypeName.STRING, (Object)((Parameter)queryParameters.get(0)).getValue().getType());
        JobStatistics.QueryStatistics queryStatistics = bigQueryDryRunResultSet.getStatistics().getQueryStatistics();
        Assert.assertNotNull((Object)queryStatistics);
        JobStatistics.SessionInfo sessionInfo = bigQueryDryRunResultSet.getStatistics().getSessionInfo();
        Assert.assertNotNull((Object)sessionInfo.getSessionId());
        Assert.assertEquals((Object)JobStatistics.QueryStatistics.StatementType.SELECT, (Object)queryStatistics.getStatementType());
    }

    @Test
    public void testConnectionImplDryRunNoQueryParameters() throws SQLException {
        String query = String.format("select StringField,  BigNumericField, BooleanField, BytesField, IntegerField, TimestampField, FloatField, NumericField, TimeField, DateField,  DateTimeField, GeographyField, RecordField.BytesField, RecordField.BooleanField, IntegerArrayField from %s order by TimestampField", TABLE_ID_FASTQUERY_BQ_RESULTSET.getTable());
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setCreateSession(Boolean.valueOf(true)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryDryRunResult bigQueryDryRunResultSet = connection.dryRun(query);
        Assert.assertNotNull((Object)bigQueryDryRunResultSet.getSchema());
        Assert.assertEquals((Object)BQ_RESULTSET_EXPECTED_SCHEMA, (Object)bigQueryDryRunResultSet.getSchema());
        List queryParameters = bigQueryDryRunResultSet.getQueryParameters();
        Assert.assertEquals((long)0L, (long)queryParameters.size());
        JobStatistics.QueryStatistics queryStatistics = bigQueryDryRunResultSet.getStatistics().getQueryStatistics();
        Assert.assertNotNull((Object)queryStatistics);
        JobStatistics.SessionInfo sessionInfo = bigQueryDryRunResultSet.getStatistics().getSessionInfo();
        Assert.assertNotNull((Object)sessionInfo.getSessionId());
        Assert.assertEquals((Object)JobStatistics.QueryStatistics.StatementType.SELECT, (Object)queryStatistics.getStatementType());
    }

    @Test
    public void testBQResultSetMultiThreadedOrder() throws SQLException {
        String query = "SELECT date FROM " + TABLE_ID_LARGE.getTable() + " where date is not null order by date asc limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setNumBufferedRows(Integer.valueOf(10000)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        Assert.assertTrue((boolean)rs.next());
        ++cnt;
        java.sql.Date lastDate = rs.getDate(0);
        while (rs.next()) {
            Assert.assertNotNull((Object)rs.getDate(0));
            Assert.assertTrue((rs.getDate(0).getTime() >= lastDate.getTime() ? 1 : 0) != 0);
            lastDate = rs.getDate(0);
            ++cnt;
        }
        Assert.assertEquals((long)300000L, (long)cnt);
    }

    @Test
    public void testBQResultSetPaginationSlowQuery() throws SQLException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by date limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setNumBufferedRows(Integer.valueOf(10000)).setJobTimeoutMs(Long.valueOf(15000L)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            Assert.assertNotNull((Object)rs.getDate(0));
            Assert.assertNotNull((Object)rs.getString(1));
            Assert.assertNotNull((Object)rs.getString(2));
            Assert.assertTrue((rs.getInt(3) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((rs.getInt(4) >= 0 ? 1 : 0) != 0);
            ++cnt;
        }
        Assert.assertEquals((long)300000L, (long)cnt);
    }

    @Test
    public void testExecuteSelectSinglePageTableRow() throws SQLException {
        String query = "select StringField,  BigNumericField, BooleanField, BytesField, IntegerField, TimestampField, FloatField, NumericField, TimeField, DateField,  DateTimeField , GeographyField, RecordField.BytesField, RecordField.BooleanField, IntegerArrayField from " + TABLE_ID_FASTQUERY_BQ_RESULTSET.getTable() + " order by TimestampField";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        Schema sc = bigQueryResult.getSchema();
        Assert.assertEquals((Object)BQ_RESULTSET_EXPECTED_SCHEMA, (Object)sc);
        Assert.assertEquals((long)2L, (long)bigQueryResult.getTotalRows());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getString("StringField"));
        Assert.assertTrue((rs.getDouble("BigNumericField") == 0.0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rs.getBoolean("BooleanField"));
        Assert.assertNull((Object)rs.getBytes("BytesField"));
        Assert.assertEquals((long)rs.getInt("IntegerField"), (long)0L);
        Assert.assertNull((Object)rs.getTimestamp("TimestampField"));
        Assert.assertNull((Object)rs.getDate("DateField"));
        Assert.assertTrue((rs.getDouble("FloatField") == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((rs.getDouble("NumericField") == 0.0 ? 1 : 0) != 0);
        Assert.assertNull((Object)rs.getTime("TimeField"));
        Assert.assertNull((Object)rs.getString("DateTimeField"));
        Assert.assertNull((Object)rs.getString("GeographyField"));
        Assert.assertNull((Object)rs.getBytes("BytesField_1"));
        Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"StringValue1", (Object)rs.getString("StringField"));
        Assert.assertTrue((rs.getDouble("BigNumericField") == 0.3333333333333333 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rs.getBoolean("BooleanField"));
        Assert.assertNotNull((Object)rs.getBytes("BytesField"));
        Assert.assertEquals((long)1L, (long)rs.getInt("IntegerField"));
        Assert.assertEquals((long)1534680695123L, (long)rs.getTimestamp("TimestampField").getTime());
        Assert.assertEquals((Object)java.sql.Date.valueOf("2018-08-19"), (Object)rs.getDate("DateField"));
        Assert.assertTrue((rs.getDouble("FloatField") == 10.1 ? 1 : 0) != 0);
        Assert.assertTrue((rs.getDouble("NumericField") == 100.0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)Time.valueOf(LocalTime.of(12, 11, 35, 123456)), (Object)rs.getTime("TimeField"));
        Assert.assertEquals((Object)"2018-08-19T12:11:35.123456", (Object)rs.getString("DateTimeField"));
        Assert.assertEquals((Object)"POINT(-122.35022 47.649154)", (Object)rs.getString("GeographyField"));
        Assert.assertNotNull((Object)rs.getBytes("BytesField_1"));
        Assert.assertTrue((boolean)rs.getBoolean("BooleanField_1"));
        Assert.assertTrue((boolean)(rs.getObject("IntegerArrayField") instanceof FieldValueList));
        FieldValueList integerArrayFieldValue = (FieldValueList)rs.getObject("IntegerArrayField");
        Assert.assertEquals((long)4L, (long)integerArrayFieldValue.size());
        Assert.assertEquals((long)3L, (long)integerArrayFieldValue.get(2).getNumericValue().intValue());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testConnectionClose() throws SQLException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by date limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setNumBufferedRows(Integer.valueOf(10000)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            if (++cnt != 57000) continue;
            Assert.assertTrue((boolean)connection.close());
        }
        Assert.assertTrue((cnt < 100000 ? 1 : 0) != 0);
    }

    @Test
    public void testBQResultSetPagination() throws SQLException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by date limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setNumBufferedRows(Integer.valueOf(10000)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            Assert.assertNotNull((Object)rs.getDate(0));
            Assert.assertNotNull((Object)rs.getString(1));
            Assert.assertNotNull((Object)rs.getString(2));
            Assert.assertTrue((rs.getInt(3) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((rs.getInt(4) >= 0 ? 1 : 0) != 0);
            ++cnt;
        }
        Assert.assertEquals((long)300000L, (long)cnt);
    }

    public void testReadAPIIterationAndOrder() throws SQLException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by confirmed_cases asc limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        int lasConfirmedCases = Integer.MIN_VALUE;
        while (rs.next()) {
            Assert.assertNotNull((Object)rs.getDate(0));
            Assert.assertNotNull((Object)rs.getString(1));
            Assert.assertNotNull((Object)rs.getString(2));
            Assert.assertTrue((rs.getInt(3) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((rs.getInt(4) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((rs.getInt(3) >= lasConfirmedCases ? 1 : 0) != 0);
            lasConfirmedCases = rs.getInt(3);
            ++cnt;
        }
        Assert.assertEquals((long)300000L, (long)cnt);
        connection.close();
    }

    @Test
    public void testReadAPIIterationAndOrderAsync() throws SQLException, ExecutionException, InterruptedException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths / 10 FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by confirmed_cases asc limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        ListenableFuture executeSelectFut = connection.executeSelectAsync(query);
        ExecuteSelectResponse exSelRes = (ExecuteSelectResponse)executeSelectFut.get();
        BigQueryResult bigQueryResult = exSelRes.getResultSet();
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        int lasConfirmedCases = Integer.MIN_VALUE;
        while (rs.next()) {
            Assert.assertNotNull((Object)rs.getDate(0));
            Assert.assertNotNull((Object)rs.getString(1));
            Assert.assertNotNull((Object)rs.getString(2));
            Assert.assertTrue((rs.getInt(3) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(3) >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble(4) >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((rs.getInt(3) >= lasConfirmedCases ? 1 : 0) != 0);
            lasConfirmedCases = rs.getInt(3);
            ++cnt;
        }
        Assert.assertEquals((long)300000L, (long)cnt);
        connection.close();
    }

    @Test
    public void testExecuteSelectAsyncCancel() throws SQLException, ExecutionException, InterruptedException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by confirmed_cases asc limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        ListenableFuture executeSelectFut = connection.executeSelectAsync(query);
        Thread testCloseAsync = new Thread(() -> {
            try {
                Thread.sleep(1000L);
                executeSelectFut.cancel(true);
            }
            catch (InterruptedException e) {
                Assert.assertNotNull((Object)e);
            }
        });
        testCloseAsync.start();
        try {
            executeSelectFut.get();
            Assert.fail();
        }
        catch (CancellationException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testExecuteSelectAsyncTimeout() throws SQLException, ExecutionException, InterruptedException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by confirmed_cases asc limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        ListenableFuture executeSelectFut = connection.executeSelectAsync(query);
        try {
            executeSelectFut.get(1000L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (CancellationException | TimeoutException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testExecuteSelectWithNamedQueryParametersAsync() throws BigQuerySQLException, ExecutionException, InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable() + " WHERE StringField = @stringParam AND IntegerField IN UNNEST(@integerList)";
        QueryParameterValue stringParameter = QueryParameterValue.string((String)"stringValue");
        QueryParameterValue intArrayParameter = QueryParameterValue.array((Object[])new Integer[]{3, 4}, Integer.class);
        Parameter stringParam = Parameter.newBuilder().setName("stringParam").setValue(stringParameter).build();
        Parameter intArrayParam = Parameter.newBuilder().setName("integerList").setValue(intArrayParameter).build();
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        ImmutableList parameters = ImmutableList.of((Object)stringParam, (Object)intArrayParam);
        ListenableFuture executeSelectFut = connection.executeSelectAsync(query, (List)parameters, new Map[0]);
        ExecuteSelectResponse exSelRes = (ExecuteSelectResponse)executeSelectFut.get();
        BigQueryResult rs = exSelRes.getResultSet();
        Assert.assertEquals((long)2L, (long)rs.getTotalRows());
    }

    @Test
    public void testCreateDefaultConnection() throws BigQuerySQLException {
        Connection connection = bigquery.createConnection();
        Assert.assertNotNull((String)"bigquery.createConnection() returned null", (Object)connection);
        Assert.assertTrue((boolean)connection.close());
    }

    public void testReadAPIConnectionMultiClose() throws SQLException {
        String query = "SELECT date, county, state_name, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable() + " where date is not null and county is not null and state_name is not null order by confirmed_cases asc limit 300000";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setPriority(QueryJobConfiguration.Priority.INTERACTIVE).build();
        int closeCnt = 0;
        int runCnt = 3;
        for (int run = 0; run < runCnt; ++run) {
            Connection connection = bigquery.createConnection(connectionSettings);
            BigQueryResult bigQueryResult = connection.executeSelect(query);
            ResultSet rs = bigQueryResult.getResultSet();
            int cnt = 0;
            while (rs.next()) {
                Assert.assertNotNull((Object)rs.getDate(0));
                ++cnt;
            }
            Assert.assertEquals((long)300000L, (long)cnt);
            Assert.assertTrue((boolean)connection.close());
            ++closeCnt;
        }
        Assert.assertEquals((long)closeCnt, (long)runCnt);
    }

    @Test
    public void testExecuteSelectSinglePageTableRowColInd() throws SQLException {
        String query = "select StringField,  BigNumericField, BooleanField, BytesField, IntegerField, TimestampField, FloatField, NumericField, TimeField, DateField,  DateTimeField , GeographyField, RecordField.BytesField, RecordField.BooleanField, IntegerArrayField from " + TABLE_ID_FASTQUERY_BQ_RESULTSET.getTable() + " order by TimestampField";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        ResultSet rs = bigQueryResult.getResultSet();
        Schema sc = bigQueryResult.getSchema();
        Assert.assertEquals((Object)BQ_RESULTSET_EXPECTED_SCHEMA, (Object)sc);
        Assert.assertEquals((long)2L, (long)bigQueryResult.getTotalRows());
        while (rs.next()) {
            Assert.assertEquals((Object)rs.getString(0), (Object)rs.getString("StringField"));
            Assert.assertTrue((rs.getDouble(1) == rs.getDouble("BigNumericField") ? 1 : 0) != 0);
            Assert.assertEquals((Object)rs.getBoolean(2), (Object)rs.getBoolean("BooleanField"));
            if (rs.getBytes(3) == null) {
                Assert.assertEquals((Object)rs.getBytes(3), (Object)rs.getBytes("BytesField"));
            } else {
                Assert.assertEquals((Object)new String(rs.getBytes(3), StandardCharsets.UTF_8), (Object)new String(rs.getBytes("BytesField"), StandardCharsets.UTF_8));
            }
            Assert.assertEquals((long)rs.getInt(4), (long)rs.getInt("IntegerField"));
            Assert.assertEquals((Object)rs.getTimestamp(5), (Object)rs.getTimestamp("TimestampField"));
            Assert.assertEquals((Object)rs.getDate(9), (Object)rs.getDate("DateField"));
            Assert.assertTrue((rs.getDouble("FloatField") == rs.getDouble(6) ? 1 : 0) != 0);
            Assert.assertTrue((rs.getDouble("NumericField") == rs.getDouble(7) ? 1 : 0) != 0);
            Assert.assertEquals((Object)rs.getTime(8), (Object)rs.getTime("TimeField"));
            Assert.assertEquals((Object)rs.getString(10), (Object)rs.getString("DateTimeField"));
            Assert.assertEquals((Object)rs.getString(11), (Object)rs.getString("GeographyField"));
            if (rs.getBytes(12) == null) {
                Assert.assertEquals((Object)rs.getBytes(12), (Object)rs.getBytes("BytesField_1"));
            } else {
                Assert.assertEquals((Object)new String(rs.getBytes(12), StandardCharsets.UTF_8), (Object)new String(rs.getBytes("BytesField_1"), StandardCharsets.UTF_8));
            }
            Assert.assertEquals((Object)rs.getBoolean(13), (Object)rs.getBoolean("BooleanField_1"));
            Assert.assertTrue((boolean)(rs.getObject("IntegerArrayField") instanceof FieldValueList));
            FieldValueList integerArrayFieldValue = (FieldValueList)rs.getObject("IntegerArrayField");
            Assert.assertTrue((boolean)(rs.getObject(14) instanceof FieldValueList));
            FieldValueList integerArrayFieldValueColInd = (FieldValueList)rs.getObject(14);
            Assert.assertEquals((long)integerArrayFieldValue.size(), (long)integerArrayFieldValueColInd.size());
            if (integerArrayFieldValue.size() != 4) continue;
            Assert.assertEquals((long)integerArrayFieldValue.get(2).getNumericValue().intValue(), (long)integerArrayFieldValueColInd.get(2).getNumericValue().intValue());
        }
    }

    @Test
    public void testExecuteSelectStruct() throws SQLException {
        String query = "select (STRUCT(\"Vancouver\" as city, 5 as years)) as address";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        Assert.assertEquals((long)1L, (long)bigQueryResult.getTotalRows());
        Schema schema = bigQueryResult.getSchema();
        Assert.assertEquals((Object)"address", (Object)schema.getFields().get(0).getName());
        Assert.assertEquals((Object)Field.Mode.NULLABLE, (Object)schema.getFields().get(0).getMode());
        Assert.assertEquals((Object)LegacySQLTypeName.RECORD, (Object)schema.getFields().get(0).getType());
        Assert.assertEquals((Object)"city", (Object)schema.getFields().get(0).getSubFields().get(0).getName());
        Assert.assertEquals((Object)LegacySQLTypeName.STRING, (Object)schema.getFields().get(0).getSubFields().get(0).getType());
        Assert.assertEquals((Object)Field.Mode.NULLABLE, (Object)schema.getFields().get(0).getSubFields().get(0).getMode());
        Assert.assertEquals((Object)"years", (Object)schema.getFields().get(0).getSubFields().get(1).getName());
        Assert.assertEquals((Object)LegacySQLTypeName.INTEGER, (Object)schema.getFields().get(0).getSubFields().get(1).getType());
        Assert.assertEquals((Object)Field.Mode.NULLABLE, (Object)schema.getFields().get(0).getSubFields().get(1).getMode());
        ResultSet rs = bigQueryResult.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        FieldValueList addressFieldValue = (FieldValueList)rs.getObject("address");
        Assert.assertEquals((Object)rs.getObject("address"), (Object)rs.getObject(0));
        Assert.assertEquals((Object)"Vancouver", (Object)addressFieldValue.get(0).getStringValue());
        Assert.assertEquals((long)5L, (long)addressFieldValue.get(1).getLongValue());
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testExecuteSelectStructSubField() throws SQLException {
        String query = "select address.city from (select (STRUCT(\"Vancouver\" as city, 5 as years)) as address)";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        Assert.assertEquals((long)1L, (long)bigQueryResult.getTotalRows());
        Schema schema = bigQueryResult.getSchema();
        Assert.assertEquals((Object)"city", (Object)schema.getFields().get(0).getName());
        Assert.assertEquals((Object)Field.Mode.NULLABLE, (Object)schema.getFields().get(0).getMode());
        Assert.assertEquals((Object)LegacySQLTypeName.STRING, (Object)schema.getFields().get(0).getType());
        Assert.assertNull((Object)schema.getFields().get(0).getSubFields());
        ResultSet rs = bigQueryResult.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        String cityFieldValue = rs.getString("city");
        Assert.assertEquals((Object)rs.getString("city"), (Object)rs.getObject(0));
        Assert.assertEquals((Object)"Vancouver", (Object)cityFieldValue);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testExecuteSelectArray() throws SQLException {
        String query = "SELECT [1,2,3]";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        Assert.assertEquals((long)1L, (long)bigQueryResult.getTotalRows());
        Schema schema = bigQueryResult.getSchema();
        Assert.assertEquals((Object)"f0_", (Object)schema.getFields().get(0).getName());
        Assert.assertEquals((Object)Field.Mode.REPEATED, (Object)schema.getFields().get(0).getMode());
        Assert.assertEquals((Object)LegacySQLTypeName.INTEGER, (Object)schema.getFields().get(0).getType());
        Assert.assertNull((Object)schema.getFields().get(0).getSubFields());
        ResultSet rs = bigQueryResult.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        FieldValueList arrayFieldValue = (FieldValueList)rs.getObject(0);
        Assert.assertEquals((long)1L, (long)arrayFieldValue.get(0).getLongValue());
        Assert.assertEquals((long)2L, (long)arrayFieldValue.get(1).getLongValue());
        Assert.assertEquals((long)3L, (long)arrayFieldValue.get(2).getLongValue());
    }

    @Test
    public void testExecuteSelectArrayOfStruct() throws SQLException {
        String query = "SELECT [STRUCT(\"Vancouver\" as city, 5 as years), STRUCT(\"Boston\" as city, 10 as years)]";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        Assert.assertEquals((long)1L, (long)bigQueryResult.getTotalRows());
        Schema schema = bigQueryResult.getSchema();
        Assert.assertEquals((Object)"f0_", (Object)schema.getFields().get(0).getName());
        Assert.assertEquals((Object)Field.Mode.REPEATED, (Object)schema.getFields().get(0).getMode());
        Assert.assertEquals((Object)LegacySQLTypeName.RECORD, (Object)schema.getFields().get(0).getType());
        Assert.assertEquals((Object)"city", (Object)schema.getFields().get(0).getSubFields().get(0).getName());
        Assert.assertEquals((Object)LegacySQLTypeName.STRING, (Object)schema.getFields().get(0).getSubFields().get(0).getType());
        Assert.assertEquals((Object)Field.Mode.NULLABLE, (Object)schema.getFields().get(0).getSubFields().get(0).getMode());
        Assert.assertEquals((Object)"years", (Object)schema.getFields().get(0).getSubFields().get(1).getName());
        Assert.assertEquals((Object)LegacySQLTypeName.INTEGER, (Object)schema.getFields().get(0).getSubFields().get(1).getType());
        Assert.assertEquals((Object)Field.Mode.NULLABLE, (Object)schema.getFields().get(0).getSubFields().get(1).getMode());
        ResultSet rs = bigQueryResult.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        FieldValueList arrayOfStructFieldValue = (FieldValueList)rs.getObject(0);
        Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)arrayOfStructFieldValue.get(0).getAttribute());
        Assert.assertEquals((Object)"Vancouver", (Object)arrayOfStructFieldValue.get(0).getRecordValue().get(0).getStringValue());
        Assert.assertEquals((long)5L, (long)arrayOfStructFieldValue.get(0).getRecordValue().get(1).getLongValue());
        Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)arrayOfStructFieldValue.get(1).getAttribute());
        Assert.assertEquals((Object)"Boston", (Object)arrayOfStructFieldValue.get(1).getRecordValue().get(0).getStringValue());
        Assert.assertEquals((long)10L, (long)arrayOfStructFieldValue.get(1).getRecordValue().get(1).getLongValue());
    }

    @Test
    public void testFastQueryMultipleRuns() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID_FASTQUERY.getTable();
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)2L, (long)result.getTotalRows());
        Assert.assertNull((Object)result.getNextPage());
        Assert.assertNull((Object)result.getNextPageToken());
        Assert.assertFalse((boolean)result.hasNextPage());
        TableResult result1Duplicate = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result1Duplicate.getJobId());
        Assert.assertNotEquals((Object)result.getJobId(), (Object)result1Duplicate.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result1Duplicate.getSchema());
        Assert.assertEquals((long)2L, (long)result.getTotalRows());
        Assert.assertNull((Object)result1Duplicate.getNextPage());
        Assert.assertNull((Object)result1Duplicate.getNextPageToken());
        Assert.assertFalse((boolean)result1Duplicate.hasNextPage());
        QueryJobConfiguration config2 = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableResult result2 = bigquery.query(config2, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result2.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result2.getSchema());
        Assert.assertEquals((long)2L, (long)result2.getTotalRows());
        Assert.assertNull((Object)result2.getNextPage());
        Assert.assertNull((Object)result2.getNextPageToken());
        Assert.assertFalse((boolean)result2.hasNextPage());
    }

    @Test
    public void testFastQuerySinglePageDuplicateRequestIds() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID_FASTQUERY.getTable();
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)2L, (long)result.getTotalRows());
        Assert.assertNull((Object)result.getNextPage());
        Assert.assertNull((Object)result.getNextPageToken());
        Assert.assertFalse((boolean)result.hasNextPage());
        TableResult result1 = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result1.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result1.getSchema());
        Assert.assertEquals((long)2L, (long)result1.getTotalRows());
        Assert.assertNull((Object)result1.getNextPage());
        Assert.assertNull((Object)result1.getNextPageToken());
        Assert.assertFalse((boolean)result1.hasNextPage());
        config.toBuilder().setQuery(query).build();
        TableResult result2 = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result2.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result2.getSchema());
        Assert.assertEquals((long)2L, (long)result2.getTotalRows());
        Assert.assertNull((Object)result2.getNextPage());
        Assert.assertNull((Object)result2.getNextPageToken());
        Assert.assertFalse((boolean)result2.hasNextPage());
    }

    @Test
    public void testFastSQLQuery() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID_FASTQUERY.getTable();
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)2L, (long)result.getTotalRows());
        Assert.assertNull((Object)result.getNextPage());
        Assert.assertNull((Object)result.getNextPageToken());
        Assert.assertFalse((boolean)result.hasNextPage());
        for (FieldValueList row : result.getValues()) {
            FieldValue timestampCell = row.get(0);
            Assert.assertEquals((Object)timestampCell, (Object)row.get("TimestampField"));
            FieldValue stringCell = row.get(1);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            FieldValue booleanCell = row.get(2);
            Assert.assertEquals((Object)booleanCell, (Object)row.get("BooleanField"));
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
        }
    }

    @Test
    public void testProjectIDFastSQLQueryWithJobId() throws InterruptedException {
        String random_project_id = "RANDOM_PROJECT_" + UUID.randomUUID().toString().replace('-', '_');
        System.out.println(random_project_id);
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID_FASTQUERY.getTable();
        JobId jobIdWithProjectId = JobId.newBuilder().setProject(random_project_id).build();
        QueryJobConfiguration configSelect = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        try {
            bigquery.query(configSelect, jobIdWithProjectId, new BigQuery.JobOption[0]);
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)exception.getMessage().contains("Cannot parse  as CloudRegion"));
            Assert.assertEquals(BigQueryException.class, exception.getClass());
        }
    }

    @Test
    public void testLocationFastSQLQueryWithJobId() throws InterruptedException {
        DatasetInfo infoUK = DatasetInfo.newBuilder((String)UK_DATASET).setDescription(DESCRIPTION).setLocation("europe-west1").setLabels(LABELS).build();
        bigquery.create(infoUK, new BigQuery.DatasetOption[0]);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)SIMPLE_SCHEMA);
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TABLE_ID_FASTQUERY_UK, (TableDefinition)tableDefinition).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        String insert = "INSERT " + UK_DATASET + "." + TABLE_ID_FASTQUERY_UK.getTable() + " VALUES('Anna');";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)insert).setDefaultDataset(DatasetId.of((String)UK_DATASET)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)SIMPLE_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)1L, (long)result.getTotalRows());
        Assert.assertNull((Object)result.getNextPage());
        Assert.assertNull((Object)result.getNextPageToken());
        Assert.assertFalse((boolean)result.hasNextPage());
        for (FieldValueList row : result.getValues()) {
            FieldValue stringCell = row.get(0);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            Assert.assertEquals((Object)"Anna", (Object)stringCell.getStringValue());
        }
        String query = "SELECT StringField FROM " + TABLE_ID_FASTQUERY_UK.getTable();
        JobId jobIdWithLocation = JobId.newBuilder().setLocation("us-west1").build();
        QueryJobConfiguration configSelect = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)UK_DATASET)).build();
        try {
            bigquery.query(configSelect, jobIdWithLocation, new BigQuery.JobOption[0]);
        }
        catch (BigQueryException exception) {
            Assert.assertTrue((boolean)exception.getMessage().contains("Not found"));
            Assert.assertEquals(BigQueryException.class, ((Object)((Object)exception)).getClass());
        }
        JobId jobIdNoLocation = JobId.newBuilder().build();
        QueryJobConfiguration configNoLocation = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)UK_DATASET)).build();
        TableResult resultNoLocation = bigquery.query(configNoLocation, jobIdNoLocation, new BigQuery.JobOption[0]);
        for (FieldValueList row : resultNoLocation.getValues()) {
            FieldValue stringCell = row.get(0);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            Assert.assertEquals((Object)"Anna", (Object)stringCell.getStringValue());
        }
    }

    @Test
    public void testFastSQLQueryMultiPage() throws InterruptedException {
        String query = "SELECT date, county, state_name, county_fips_code, confirmed_cases, deaths FROM " + TABLE_ID_LARGE.getTable();
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)LARGE_TABLE_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)313348L, (long)result.getTotalRows());
        Assert.assertNotNull((Object)result.getNextPage());
        Assert.assertNotNull((Object)result.getNextPageToken());
        Assert.assertTrue((boolean)result.hasNextPage());
        TableResult result1 = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result1.getJobId());
        Assert.assertEquals((Object)LARGE_TABLE_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)313348L, (long)result.getTotalRows());
        Assert.assertNotNull((Object)result1.getNextPage());
        Assert.assertNotNull((Object)result1.getNextPageToken());
        Assert.assertTrue((boolean)result1.hasNextPage());
        config.toBuilder().setQuery(query).build();
        TableResult result2 = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result2.getJobId());
        Assert.assertEquals((Object)LARGE_TABLE_SCHEMA, (Object)result2.getSchema());
        Assert.assertEquals((long)313348L, (long)result2.getTotalRows());
        Assert.assertNotNull((Object)result2.getNextPage());
        Assert.assertNotNull((Object)result2.getNextPageToken());
        Assert.assertTrue((boolean)result2.hasNextPage());
    }

    @Test
    public void testFastDMLQuery() throws InterruptedException {
        String tableName = TABLE_ID_FASTQUERY.getTable();
        String dmlQuery = String.format("UPDATE %s.%s SET StringField = 'hello' WHERE TRUE", DATASET, tableName);
        QueryJobConfiguration dmlConfig = QueryJobConfiguration.newBuilder((String)dmlQuery).build();
        TableResult result = bigquery.query(dmlConfig, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)result.getSchema());
        Job queryJob = bigquery.getJob(result.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
        Assert.assertEquals((long)2L, (long)statistics.getNumDmlAffectedRows());
        Assert.assertEquals((long)2L, (long)statistics.getDmlStats().getUpdatedRowCount());
    }

    @Test
    public void testFastDDLQuery() throws InterruptedException {
        String tableName = "test_table_fast_query_ddl";
        String tableNameFastQuery = TABLE_ID_DDL.getTable();
        String ddlQuery = String.format("CREATE OR REPLACE TABLE %s (TimestampField TIMESTAMP OPTIONS(description='TimestampDescription'), StringField STRING OPTIONS(description='StringDescription'), BooleanField BOOLEAN OPTIONS(description='BooleanDescription') ) AS SELECT * FROM %s", tableName, tableNameFastQuery);
        QueryJobConfiguration ddlConfig = QueryJobConfiguration.newBuilder((String)ddlQuery).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableResult result = bigquery.query(ddlConfig, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)DDL_TABLE_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)0L, (long)result.getTotalRows());
        String sqlQuery = String.format("SELECT * FROM %s.%s", DATASET, tableName);
        QueryJobConfiguration sqlConfig = QueryJobConfiguration.newBuilder((String)sqlQuery).build();
        TableResult resultAfterDDL = bigquery.query(sqlConfig, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)resultAfterDDL.getJobId());
        for (FieldValueList row : resultAfterDDL.getValues()) {
            FieldValue timestampCell = row.get(0);
            Assert.assertEquals((Object)timestampCell, (Object)row.get("TimestampField"));
            FieldValue stringCell = row.get(1);
            Assert.assertEquals((Object)stringCell, (Object)row.get("StringField"));
            FieldValue booleanCell = row.get(2);
            Assert.assertEquals((Object)booleanCell, (Object)row.get("BooleanField"));
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
        }
    }

    @Test
    public void testFastQuerySlowDDL() throws InterruptedException {
        String tableName = "test_table_fast_query_ddl_slow_" + UUID.randomUUID().toString().substring(0, 8);
        String slowDdlQuery = String.format("CREATE OR REPLACE TABLE %s AS SELECT unique_key, agency, complaint_type, descriptor, street_name, city, landmark FROM `bigquery-public-data.new_york.311_service_requests`", tableName);
        QueryJobConfiguration ddlConfig = QueryJobConfiguration.newBuilder((String)slowDdlQuery).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableResult result = bigquery.query(ddlConfig, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((long)0L, (long)result.getTotalRows());
        Assert.assertNotNull((Object)result.getSchema());
        String sqlQuery = String.format("SELECT * FROM %s.%s", DATASET, tableName);
        QueryJobConfiguration sqlConfig = QueryJobConfiguration.newBuilder((String)sqlQuery).build();
        TableResult resultAfterDDL = bigquery.query(sqlConfig, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)resultAfterDDL.getJobId());
        for (FieldValueList row : resultAfterDDL.getValues()) {
            FieldValue unique_key = row.get(0);
            Assert.assertEquals((Object)unique_key, (Object)row.get("unique_key"));
            FieldValue agency = row.get(1);
            Assert.assertEquals((Object)agency, (Object)row.get("agency"));
            FieldValue complaint_type = row.get(2);
            Assert.assertEquals((Object)complaint_type, (Object)row.get("complaint_type"));
        }
    }

    @Test
    public void testFastQueryHTTPException() throws InterruptedException {
        String queryInvalid = "CREATE OR REPLACE SELECT * FROM UPDATE TABLE SET " + TABLE_ID_FASTQUERY.getTable();
        QueryJobConfiguration configInvalidQuery = QueryJobConfiguration.newBuilder((String)queryInvalid).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        try {
            bigquery.query(configInvalidQuery, new BigQuery.JobOption[0]);
            Assert.fail((String)"\"BigQueryException was expected\"");
        }
        catch (BigQueryException e) {
            BigQueryError error = e.getError();
            Assert.assertNotNull((Object)error.getMessage());
            Assert.assertEquals((Object)"invalidQuery", (Object)error.getReason());
        }
        String queryMissingTable = "SELECT * FROM " + TableId.of((String)DATASET, (String)"non_existing_table").getTable();
        QueryJobConfiguration configMissingTable = QueryJobConfiguration.newBuilder((String)queryMissingTable).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        try {
            bigquery.query(configMissingTable, new BigQuery.JobOption[0]);
            Assert.fail((String)"\"BigQueryException was expected\"");
        }
        catch (BigQueryException e) {
            BigQueryError error = e.getError();
            Assert.assertNotNull((Object)error.getMessage());
            Assert.assertEquals((Object)"notFound", (Object)error.getReason());
        }
    }

    @Test
    public void testQuerySessionSupport() throws InterruptedException {
        String query = "CREATE TEMPORARY TABLE temptable AS SELECT 17 as foo";
        QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setCreateSession(Boolean.valueOf(true)).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)queryJobConfiguration), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        Job queryJob = bigquery.getJob(remoteJob.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
        String sessionId = statistics.getSessionInfo().getSessionId();
        Assert.assertNotNull((Object)sessionId);
        String queryTempTable = "SELECT * FROM temptable";
        ConnectionProperty connectionProperty = ConnectionProperty.newBuilder().setKey("session_id").setValue(sessionId).build();
        QueryJobConfiguration queryJobConfigurationWithSession = QueryJobConfiguration.newBuilder((String)queryTempTable).setDefaultDataset(DatasetId.of((String)DATASET)).setConnectionProperties((List)ImmutableList.of((Object)connectionProperty)).build();
        Job remoteJobWithSession = bigquery.create(JobInfo.of((JobConfiguration)queryJobConfigurationWithSession), new BigQuery.JobOption[0]);
        remoteJobWithSession = remoteJobWithSession.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJobWithSession.getStatus().getError());
        Job queryJobWithSession = bigquery.getJob(remoteJobWithSession.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statisticsWithSession = (JobStatistics.QueryStatistics)queryJobWithSession.getStatistics();
        Assert.assertEquals((Object)sessionId, (Object)statisticsWithSession.getSessionInfo().getSessionId());
    }

    @Test
    public void testLoadSessionSupportWriteChannelConfiguration() throws InterruptedException {
        TableId sessionTableId = TableId.of((String)"_SESSION", (String)"test_temp_destination_table_from_file");
        WriteChannelConfiguration configuration = WriteChannelConfiguration.newBuilder((TableId)sessionTableId).setFormatOptions((FormatOptions)CsvOptions.newBuilder().setFieldDelimiter(",").build()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(SESSION_TABLE_SCHEMA).setCreateSession(Boolean.valueOf(true)).build();
        String jobName = "jobId_" + UUID.randomUUID().toString();
        JobId jobId = JobId.newBuilder().setLocation("us").setJob(jobName).build();
        try (TableDataWriteChannel writer = bigquery.writer(jobId, configuration);
             OutputStream stream = Channels.newOutputStream((WritableByteChannel)writer);){
            InputStream inputStream = ITBigQueryTest.class.getClassLoader().getResourceAsStream("sessionTest.csv");
            IOUtils.copy((InputStream)inputStream, (OutputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Job loadJob = bigquery.getJob(jobId, new BigQuery.JobOption[0]);
        Job completedJob = loadJob.waitFor(new RetryOption[0]);
        Assert.assertNotNull((Object)completedJob);
        Assert.assertEquals((Object)jobId.getJob(), (Object)completedJob.getJobId().getJob());
        JobStatistics.LoadStatistics statistics = (JobStatistics.LoadStatistics)completedJob.getStatistics();
        String sessionId = statistics.getSessionInfo().getSessionId();
        Assert.assertNotNull((Object)sessionId);
        ConnectionProperty sessionConnectionProperty = ConnectionProperty.newBuilder().setKey("session_id").setValue(sessionId).build();
        WriteChannelConfiguration sessionConfiguration = WriteChannelConfiguration.newBuilder((TableId)sessionTableId).setConnectionProperties((List)ImmutableList.of((Object)sessionConnectionProperty)).setFormatOptions((FormatOptions)CsvOptions.newBuilder().setFieldDelimiter(",").build()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(SESSION_TABLE_SCHEMA).build();
        String sessionJobName = "jobId_" + UUID.randomUUID().toString();
        JobId sessionJobId = JobId.newBuilder().setLocation("us").setJob(sessionJobName).build();
        try (TableDataWriteChannel writer = bigquery.writer(sessionJobId, sessionConfiguration);
             OutputStream stream = Channels.newOutputStream((WritableByteChannel)writer);){
            InputStream inputStream = ITBigQueryTest.class.getClassLoader().getResourceAsStream("sessionTest.csv");
            IOUtils.copy((InputStream)inputStream, (OutputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Job queryJobWithSession = bigquery.getJob(sessionJobId, new BigQuery.JobOption[0]);
        queryJobWithSession = queryJobWithSession.waitFor(new RetryOption[0]);
        JobStatistics.LoadStatistics statisticsWithSession = (JobStatistics.LoadStatistics)queryJobWithSession.getStatistics();
        Assert.assertNotNull((Object)statisticsWithSession.getSessionInfo().getSessionId());
        String queryTempTable = "SELECT * FROM _SESSION.test_temp_destination_table_from_file;";
        QueryJobConfiguration queryJobConfigurationWithSession = QueryJobConfiguration.newBuilder((String)queryTempTable).setConnectionProperties((List)ImmutableList.of((Object)sessionConnectionProperty)).build();
        Job queryTempTableJob = bigquery.create(JobInfo.of((JobConfiguration)queryJobConfigurationWithSession), new BigQuery.JobOption[0]);
        queryTempTableJob = queryTempTableJob.waitFor(new RetryOption[0]);
        Assert.assertNotNull((Object)queryTempTableJob.getQueryResults(new BigQuery.QueryResultsOption[0]));
    }

    @Test
    public void testLoadSessionSupport() throws InterruptedException {
        TableId sessionTableId = TableId.of((String)"_SESSION", (String)"test_temp_destination_table");
        LoadJobConfiguration configuration = LoadJobConfiguration.newBuilder((TableId)sessionTableId, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(TABLE_SCHEMA).setCreateSession(Boolean.valueOf(true)).build();
        Job job = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        job = job.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)job.getStatus().getError());
        Job loadJob = bigquery.getJob(job.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.LoadStatistics statistics = (JobStatistics.LoadStatistics)loadJob.getStatistics();
        Truth.assertThat((Long)statistics.getTotalSlotMs()).isGreaterThan((Comparable)Long.valueOf(0L));
        String sessionId = statistics.getSessionInfo().getSessionId();
        Assert.assertNotNull((Object)sessionId);
        ConnectionProperty sessionConnectionProperty = ConnectionProperty.newBuilder().setKey("session_id").setValue(sessionId).build();
        LoadJobConfiguration loadJobConfigurationWithSession = LoadJobConfiguration.newBuilder((TableId)sessionTableId, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(TABLE_SCHEMA).setConnectionProperties((List)ImmutableList.of((Object)sessionConnectionProperty)).build();
        Job remoteJobWithSession = bigquery.create(JobInfo.of((JobConfiguration)loadJobConfigurationWithSession), new BigQuery.JobOption[0]);
        remoteJobWithSession = remoteJobWithSession.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJobWithSession.getStatus().getError());
        Job queryJobWithSession = bigquery.getJob(remoteJobWithSession.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.LoadStatistics statisticsWithSession = (JobStatistics.LoadStatistics)queryJobWithSession.getStatistics();
        Assert.assertNotNull((Object)statisticsWithSession.getSessionInfo().getSessionId());
        String queryTempTable = "SELECT * FROM _SESSION.test_temp_destination_table;";
        QueryJobConfiguration queryJobConfigurationWithSession = QueryJobConfiguration.newBuilder((String)queryTempTable).setConnectionProperties((List)ImmutableList.of((Object)sessionConnectionProperty)).build();
        Job queryTempTableJob = bigquery.create(JobInfo.of((JobConfiguration)queryJobConfigurationWithSession), new BigQuery.JobOption[0]);
        queryTempTableJob = queryTempTableJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)queryTempTableJob.getStatus().getError());
        Assert.assertNotNull((Object)queryTempTableJob.getQueryResults(new BigQuery.QueryResultsOption[0]));
    }

    @Test
    public void testExecuteSelectSessionSupport() throws BigQuerySQLException {
        String query = "SELECT 17 as foo";
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).setCreateSession(Boolean.valueOf(true)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        BigQueryResult bigQueryResult = connection.executeSelect(query);
        String sessionId = bigQueryResult.getBigQueryResultStats().getSessionInfo().getSessionId();
        Assert.assertNotNull((Object)sessionId);
    }

    @Test
    public void testDmlStatistics() throws InterruptedException {
        String tableName = TABLE_ID_FASTQUERY.getTable();
        String dmlQuery = String.format("UPDATE %s.%s SET StringField = 'hello' WHERE TRUE", DATASET, tableName);
        QueryJobConfiguration dmlConfig = QueryJobConfiguration.newBuilder((String)dmlQuery).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)dmlConfig), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        TableResult result = remoteJob.getQueryResults(new BigQuery.QueryResultsOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)result.getSchema());
        Job queryJob = bigquery.getJob(remoteJob.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
        Assert.assertEquals((long)2L, (long)statistics.getNumDmlAffectedRows());
        Assert.assertEquals((long)2L, (long)statistics.getDmlStats().getUpdatedRowCount());
    }

    @Test
    public void testTransactionInfo() throws InterruptedException {
        String tableName = TABLE_ID_FASTQUERY.getTable();
        String transaction = String.format("BEGIN TRANSACTION;\n  UPDATE %s.%s SET StringField = 'hello' WHERE TRUE;\n  COMMIT TRANSACTION;\n", DATASET, tableName);
        QueryJobConfiguration config = QueryJobConfiguration.of((String)transaction);
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)config), new BigQuery.JobOption[0]);
        Job parentJobInfo = remoteJob.waitFor(new RetryOption[0]);
        String parentJobId = parentJobInfo.getJobId().getJob();
        Page childJobs = bigquery.listJobs(new BigQuery.JobListOption[]{BigQuery.JobListOption.parentJobId((String)parentJobId)});
        for (Job job : childJobs.iterateAll()) {
            JobStatistics.TransactionInfo transactionInfo = job.getStatistics().getTransactionInfo();
            Assert.assertNotNull((Object)transactionInfo.getTransactionId());
        }
    }

    @Test
    public void testScriptStatistics() throws InterruptedException {
        String script = "-- Declare a variable to hold names as an array.\nDECLARE top_names ARRAY<STRING>;\n-- Build an array of the top 100 names from the year 2017.\nSET top_names = (\n  SELECT ARRAY_AGG(name ORDER BY number DESC LIMIT 100)\n  FROM `bigquery-public-data`.usa_names.usa_1910_current\n  WHERE year = 2017\n);\n-- Which names appear as words in Shakespeare's plays?\nSELECT\n  name AS shakespeare_name\nFROM UNNEST(top_names) AS name\nWHERE name IN (\n  SELECT word\n  FROM `bigquery-public-data`.samples.shakespeare\n);";
        QueryJobConfiguration config = QueryJobConfiguration.of((String)script);
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)config), new BigQuery.JobOption[0]);
        Job info = remoteJob.waitFor(new RetryOption[0]);
        JobStatistics jobStatistics = info.getStatistics();
        String parentJobId = info.getJobId().getJob();
        Assert.assertEquals((long)2L, (long)jobStatistics.getNumChildJobs());
        Page page = bigquery.listJobs(new BigQuery.JobListOption[]{BigQuery.JobListOption.parentJobId((String)parentJobId)});
        for (Job job : page.iterateAll()) {
            JobStatistics.ScriptStatistics scriptStatistics = job.getStatistics().getScriptStatistics();
            if (scriptStatistics == null) continue;
            if (scriptStatistics.getEvaluationKind().equals("STATEMENT")) {
                Assert.assertEquals((Object)"STATEMENT", (Object)scriptStatistics.getEvaluationKind());
                for (JobStatistics.ScriptStatistics.ScriptStackFrame stackFrame : scriptStatistics.getStackFrames()) {
                    Assert.assertEquals((long)2L, (long)stackFrame.getEndColumn().intValue());
                    Assert.assertEquals((long)16L, (long)stackFrame.getEndLine().intValue());
                    Assert.assertEquals((long)1L, (long)stackFrame.getStartColumn().intValue());
                    Assert.assertEquals((long)10L, (long)stackFrame.getStartLine().intValue());
                }
                continue;
            }
            Assert.assertEquals((Object)"EXPRESSION", (Object)scriptStatistics.getEvaluationKind());
            for (JobStatistics.ScriptStatistics.ScriptStackFrame stackFrame : scriptStatistics.getStackFrames()) {
                Assert.assertEquals((long)2L, (long)stackFrame.getEndColumn().intValue());
                Assert.assertEquals((long)8L, (long)stackFrame.getEndLine().intValue());
                Assert.assertEquals((long)17L, (long)stackFrame.getStartColumn().intValue());
                Assert.assertEquals((long)4L, (long)stackFrame.getStartLine().intValue());
            }
        }
    }

    @Test
    public void testQueryParameterModeWithDryRun() {
        String query = "SELECT TimestampField, StringField, BooleanField, BigNumericField, BigNumericField1, BigNumericField2, BigNumericField3, BigNumericField4 FROM " + TABLE_ID.getTable() + " WHERE StringField = ? AND TimestampField > ? AND IntegerField IN UNNEST(?) AND IntegerField < ? AND FloatField > ? AND NumericField < ? AND BigNumericField = ?";
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setParameterMode("POSITIONAL").setUseLegacySql(Boolean.valueOf(false)).setDryRun(Boolean.valueOf(true)).build();
        Job job = bigquery.create(JobInfo.of((JobConfiguration)queryConfig), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)job.getStatistics();
        Assert.assertNotNull((Object)statistics.getTotalBytesProcessed());
    }

    @Test
    public void testPositionalQueryParameters() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField, BigNumericField, BigNumericField1, BigNumericField2, BigNumericField3, BigNumericField4 FROM " + TABLE_ID.getTable() + " WHERE StringField = ? AND TimestampField > ? AND IntegerField IN UNNEST(?) AND IntegerField < ? AND FloatField > ? AND NumericField < ? AND BigNumericField = ?";
        QueryParameterValue stringParameter = QueryParameterValue.string((String)"stringValue");
        QueryParameterValue timestampParameter = QueryParameterValue.timestamp((String)"2014-01-01 07:00:00.000000+00:00");
        QueryParameterValue intArrayParameter = QueryParameterValue.array((Object[])new Integer[]{3, 4}, Integer.class);
        QueryParameterValue int64Parameter = QueryParameterValue.int64((Integer)5);
        QueryParameterValue float64Parameter = QueryParameterValue.float64((Double)0.5);
        QueryParameterValue numericParameter = QueryParameterValue.numeric((BigDecimal)new BigDecimal("234567890.123456"));
        QueryParameterValue bigNumericParameter = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("0.33333333333333333333333333333333333333"));
        QueryParameterValue bigNumericParameter1 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("1e-38"));
        QueryParameterValue bigNumericParameter2 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("-1e38"));
        QueryParameterValue bigNumericParameter3 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("578960446186580977117854925043439539266.34992332820282019728792003956564819967"));
        QueryParameterValue bigNumericParameter4 = QueryParameterValue.bigNumeric((BigDecimal)new BigDecimal("-578960446186580977117854925043439539266.34992332820282019728792003956564819968"));
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addPositionalParameter(stringParameter).addPositionalParameter(timestampParameter).addPositionalParameter(intArrayParameter).addPositionalParameter(int64Parameter).addPositionalParameter(float64Parameter).addPositionalParameter(numericParameter).addPositionalParameter(bigNumericParameter).addPositionalParameter(bigNumericParameter1).addPositionalParameter(bigNumericParameter2).addPositionalParameter(bigNumericParameter3).addPositionalParameter(bigNumericParameter4).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA_BIGNUMERIC, (Object)result.getSchema());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)result.getValues()));
        for (FieldValueList values : result.iterateAll()) {
            Assert.assertEquals((long)((long)Double.parseDouble("1.40845209522E9")), (long)((long)Double.parseDouble(values.get(0).getValue().toString())));
            Assert.assertEquals((Object)"stringValue", (Object)values.get(1).getValue());
            Assert.assertEquals((Object)false, (Object)values.get(2).getBooleanValue());
            Assert.assertEquals((Object)"0.33333333333333333333333333333333333333", (Object)values.get(3).getValue());
            Assert.assertEquals((Object)"0.00000000000000000000000000000000000001", (Object)values.get(4).getValue());
            Assert.assertEquals((Object)"-100000000000000000000000000000000000000", (Object)values.get(5).getValue());
            Assert.assertEquals((Object)"578960446186580977117854925043439539266.34992332820282019728792003956564819967", (Object)values.get(6).getValue());
            Assert.assertEquals((Object)"-578960446186580977117854925043439539266.34992332820282019728792003956564819968", (Object)values.get(7).getValue());
        }
    }

    @Test
    public void testExecuteSelectWithPositionalQueryParameters() throws BigQuerySQLException {
        String query = "SELECT TimestampField, StringField FROM " + TABLE_ID.getTable() + " WHERE StringField = ? AND TimestampField > ?";
        QueryParameterValue stringParameter = QueryParameterValue.string((String)"stringValue");
        QueryParameterValue timestampParameter = QueryParameterValue.timestamp((String)"2014-01-01 07:00:00.000000+00:00");
        Parameter stringParam = Parameter.newBuilder().setValue(stringParameter).build();
        Parameter timeStampParam = Parameter.newBuilder().setValue(timestampParameter).build();
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        ImmutableList parameters = ImmutableList.of((Object)stringParam, (Object)timeStampParam);
        BigQueryResult rs = connection.executeSelect(query, (List)parameters, new Map[0]);
        Assert.assertEquals((long)2L, (long)rs.getTotalRows());
    }

    @Test
    public void testNamedQueryParameters() throws InterruptedException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable() + " WHERE StringField = @stringParam AND IntegerField IN UNNEST(@integerList)";
        QueryParameterValue stringParameter = QueryParameterValue.string((String)"stringValue");
        QueryParameterValue intArrayParameter = QueryParameterValue.array((Object[])new Integer[]{3, 4}, Integer.class);
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("stringParam", stringParameter).addNamedParameter("integerList", intArrayParameter).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result.getSchema());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)result.getValues()));
    }

    @Test
    public void testExecuteSelectWithNamedQueryParameters() throws BigQuerySQLException {
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable() + " WHERE StringField = @stringParam AND IntegerField IN UNNEST(@integerList)";
        QueryParameterValue stringParameter = QueryParameterValue.string((String)"stringValue");
        QueryParameterValue intArrayParameter = QueryParameterValue.array((Object[])new Integer[]{3, 4}, Integer.class);
        Parameter stringParam = Parameter.newBuilder().setName("stringParam").setValue(stringParameter).build();
        Parameter intArrayParam = Parameter.newBuilder().setName("integerList").setValue(intArrayParameter).build();
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Connection connection = bigquery.createConnection(connectionSettings);
        ImmutableList parameters = ImmutableList.of((Object)stringParam, (Object)intArrayParam);
        BigQueryResult rs = connection.executeSelect(query, (List)parameters, new Map[0]);
        Assert.assertEquals((long)2L, (long)rs.getTotalRows());
    }

    @Test
    public void testStructNamedQueryParameters() throws InterruptedException {
        QueryParameterValue booleanValue = QueryParameterValue.bool((Boolean)true);
        QueryParameterValue stringValue = QueryParameterValue.string((String)"test-stringField");
        QueryParameterValue integerValue = QueryParameterValue.int64((Integer)10);
        HashMap<String, QueryParameterValue> struct = new HashMap<String, QueryParameterValue>();
        struct.put("booleanField", booleanValue);
        struct.put("integerField", integerValue);
        struct.put("stringField", stringValue);
        QueryParameterValue recordValue = QueryParameterValue.struct(struct);
        String query = "SELECT @recordField AS record";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("recordField", recordValue).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result.getValues()));
        for (FieldValueList values : result.iterateAll()) {
            for (FieldValue value : values) {
                ITBigQueryTest.assertsFieldValue(value);
            }
        }
    }

    @Test
    public void testRepeatedRecordNamedQueryParameters() throws InterruptedException {
        String[] stringValues = new String[]{"test-stringField", "test-stringField2"};
        ArrayList<QueryParameterValue> tuples = new ArrayList<QueryParameterValue>();
        for (int i = 0; i < 2; ++i) {
            QueryParameterValue stringValue = QueryParameterValue.string((String)stringValues[i]);
            HashMap<String, QueryParameterValue> struct = new HashMap<String, QueryParameterValue>();
            struct.put("stringField", stringValue);
            QueryParameterValue recordValue = QueryParameterValue.struct(struct);
            tuples.add(recordValue);
        }
        QueryParameterValue repeatedRecord = QueryParameterValue.array((Object[])tuples.toArray(), (StandardSQLTypeName)StandardSQLTypeName.STRUCT);
        String query = "SELECT @repeatedRecordField AS repeatedRecord";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("repeatedRecordField", repeatedRecord).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result.getValues()));
        FieldList subSchema = result.getSchema().getFields().get("repeatedRecord").getSubFields();
        for (FieldValueList values : result.iterateAll()) {
            for (FieldValue value : values) {
                Assert.assertEquals((Object)FieldValue.Attribute.REPEATED, (Object)value.getAttribute());
                Assert.assertEquals((long)2L, (long)value.getRepeatedValue().size());
                for (int i = 0; i < 2; ++i) {
                    FieldValue record = (FieldValue)value.getRepeatedValue().get(i);
                    Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)record.getAttribute());
                    FieldValueList recordValue = record.getRecordValue();
                    Assert.assertEquals((Object)stringValues[i], (Object)FieldValueList.of((List)recordValue, (FieldList)subSchema).get("stringField").getValue());
                }
            }
        }
    }

    @Test
    public void testUnnestRepeatedRecordNamedQueryParameter() throws InterruptedException {
        Boolean[] boolValues = new Boolean[]{true, false};
        ArrayList<QueryParameterValue> tuples = new ArrayList<QueryParameterValue>();
        for (int i = 0; i < 2; ++i) {
            QueryParameterValue boolValue = QueryParameterValue.bool((Boolean)boolValues[i]);
            HashMap<String, QueryParameterValue> struct = new HashMap<String, QueryParameterValue>();
            struct.put("boolField", boolValue);
            QueryParameterValue recordValue = QueryParameterValue.struct(struct);
            tuples.add(recordValue);
        }
        QueryParameterValue repeatedRecord = QueryParameterValue.array((Object[])tuples.toArray(), (StandardSQLTypeName)StandardSQLTypeName.STRUCT);
        String query = "SELECT * FROM (SELECT STRUCT(" + boolValues[0] + " AS boolField) AS repeatedRecord) WHERE repeatedRecord IN UNNEST(@repeatedRecordField)";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("repeatedRecordField", repeatedRecord).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result.getValues()));
        FieldList subSchema = result.getSchema().getFields().get("repeatedRecord").getSubFields();
        for (FieldValueList values : result.iterateAll()) {
            for (FieldValue value : values) {
                Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)value.getAttribute());
                FieldValueList recordValue = value.getRecordValue();
                Assert.assertEquals((Object)boolValues[0], (Object)FieldValueList.of((List)recordValue, (FieldList)subSchema).get("boolField").getBooleanValue());
            }
        }
    }

    @Test
    public void testUnnestRepeatedRecordNamedQueryParameterFromDataset() throws InterruptedException {
        TableId tableId = TableId.of((String)DATASET, (String)"test_repeated_record_table");
        this.setUpRepeatedRecordTable(tableId);
        ArrayList<QueryParameterValue> tuples = new ArrayList<QueryParameterValue>();
        QueryParameterValue statusValue = QueryParameterValue.string((String)"single");
        QueryParameterValue addressValue = QueryParameterValue.string((String)"123 this lane");
        QueryParameterValue cityValue = QueryParameterValue.string((String)"Toronto");
        QueryParameterValue stateValue = QueryParameterValue.string((String)"ON");
        QueryParameterValue zipValue = QueryParameterValue.string((String)"1h2j34");
        QueryParameterValue numberOfYearsValue = QueryParameterValue.string((String)"3");
        LinkedHashMap<String, QueryParameterValue> struct = new LinkedHashMap<String, QueryParameterValue>();
        struct.put("statusValue", statusValue);
        struct.put("addressValue", addressValue);
        struct.put("cityValue", cityValue);
        struct.put("stateValue", stateValue);
        struct.put("zipValue", zipValue);
        struct.put("numberOfYearsValue", numberOfYearsValue);
        QueryParameterValue recordValue = QueryParameterValue.struct(struct);
        tuples.add(recordValue);
        QueryParameterValue repeatedRecord = QueryParameterValue.array((Object[])tuples.toArray(), (StandardSQLTypeName)StandardSQLTypeName.STRUCT);
        String query = "SELECT * FROM " + tableId.getTable() + ", UNNEST(@repeatedRecord) AS TEMP where TEMP IN UNNEST(addresses);";
        QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("repeatedRecord", repeatedRecord).build();
        TableResult results = bigquery.query(queryConfig, new BigQuery.JobOption[0]);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)results.getValues()));
        for (FieldValueList values : results.iterateAll()) {
            Assert.assertEquals((Object)"1", (Object)values.get("ID").getStringValue());
            Assert.assertEquals((Object)"first_name1", (Object)values.get("FirstName").getStringValue());
            Assert.assertEquals((long)2L, (long)values.get("Addresses").getRecordValue().size());
        }
    }

    private void setUpRepeatedRecordTable(TableId tableId) {
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)REPEATED_RECORD_TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition);
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        builder1.put((Object)"ID", (Object)"1");
        builder1.put((Object)"FirstName", (Object)"first_name1");
        builder1.put((Object)"LastName", (Object)"last_name1");
        builder1.put((Object)"DOB", (Object)"1995-08-09");
        builder1.put((Object)"Addresses", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"Status", (Object)"single", (Object)"Address", (Object)"123 this lane", (Object)"City", (Object)"Toronto", (Object)"State", (Object)"ON", (Object)"Zip", (Object)"1h2j34", (Object)"NumberOfYears", (Object)"3"), (Object)ImmutableMap.of((Object)"Status", (Object)"couple", (Object)"Address", (Object)"345 that lane", (Object)"City", (Object)"Maple", (Object)"State", (Object)"ON", (Object)"Zip", (Object)"1h2j34", (Object)"NumberOfYears", (Object)"5")));
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        builder2.put((Object)"ID", (Object)"2");
        builder2.put((Object)"FirstName", (Object)"first_name2");
        builder2.put((Object)"LastName", (Object)"last_name2");
        builder2.put((Object)"DOB", (Object)"1992-03-19");
        builder2.put((Object)"Addresses", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"Status", (Object)"single", (Object)"Address", (Object)"97 Kota lane", (Object)"City", (Object)"Ottawa", (Object)"State", (Object)"ON", (Object)"Zip", (Object)"1h2j34", (Object)"NumberOfYears", (Object)"3"), (Object)ImmutableMap.of((Object)"Status", (Object)"couple", (Object)"Address", (Object)"75 Malta lane", (Object)"City", (Object)"Victoria", (Object)"State", (Object)"AL", (Object)"Zip", (Object)"1h2j34", (Object)"NumberOfYears", (Object)"5")));
        InsertAllRequest request = InsertAllRequest.newBuilder((TableId)tableInfo.getTableId()).addRow((Map)builder1.build()).addRow((Map)builder2.build()).build();
        bigquery.insertAll(request);
    }

    @Test
    public void testEmptyRepeatedRecordNamedQueryParameters() throws InterruptedException {
        Object[] tuples = new QueryParameterValue[]{};
        QueryParameterValue repeatedRecord = QueryParameterValue.array((Object[])tuples, (StandardSQLTypeName)StandardSQLTypeName.STRUCT);
        String query = "SELECT * FROM (SELECT STRUCT(false AS boolField) AS repeatedRecord) WHERE repeatedRecord IN UNNEST(@repeatedRecordField)";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("repeatedRecordField", repeatedRecord).build();
        try {
            bigquery.query(config, new BigQuery.JobOption[0]);
            Assert.fail((String)"an empty array of struct query parameter shouldn't work with 'IN UNNEST'");
        }
        catch (BigQueryException bigQueryException) {
            // empty catch block
        }
    }

    @Test
    public void testStructQuery() throws InterruptedException {
        String query = String.format("SELECT RecordField FROM %s.%s", DATASET, TABLE_ID.getTable());
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)result.getValues()));
        for (FieldValueList values : result.iterateAll()) {
            for (FieldValue value : values) {
                Assert.assertEquals(null, (Object)value.getRecordValue().get("StringField").getValue());
                Assert.assertEquals((Object)true, (Object)value.getRecordValue().get("BooleanField").getBooleanValue());
            }
        }
    }

    private static void assertsFieldValue(FieldValue record) {
        Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)record.getAttribute());
        Assert.assertEquals((Object)true, (Object)record.getRecordValue().get("booleanField").getBooleanValue());
        Assert.assertEquals((long)10L, (long)record.getRecordValue().get("integerField").getLongValue());
        Assert.assertEquals((Object)"test-stringField", (Object)record.getRecordValue().get("stringField").getStringValue());
    }

    @Test
    public void testNestedStructNamedQueryParameters() throws InterruptedException {
        QueryParameterValue booleanValue = QueryParameterValue.bool((Boolean)true);
        QueryParameterValue stringValue = QueryParameterValue.string((String)"test-stringField");
        QueryParameterValue integerValue = QueryParameterValue.int64((Integer)10);
        HashMap<String, QueryParameterValue> struct = new HashMap<String, QueryParameterValue>();
        struct.put("booleanField", booleanValue);
        struct.put("integerField", integerValue);
        struct.put("stringField", stringValue);
        QueryParameterValue recordValue = QueryParameterValue.struct(struct);
        HashMap<String, QueryParameterValue> structValue = new HashMap<String, QueryParameterValue>();
        structValue.put("bool", booleanValue);
        structValue.put("int", integerValue);
        structValue.put("string", stringValue);
        structValue.put("struct", recordValue);
        QueryParameterValue nestedRecordField = QueryParameterValue.struct(structValue);
        String query = "SELECT @nestedRecordField AS record";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("nestedRecordField", nestedRecordField).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result.getValues()));
        for (FieldValueList values : result.iterateAll()) {
            for (FieldValue value : values) {
                Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)value.getAttribute());
                Assert.assertEquals((Object)true, (Object)value.getRecordValue().get(0).getRecordValue().get(0).getBooleanValue());
                Assert.assertEquals((long)10L, (long)value.getRecordValue().get(0).getRecordValue().get(1).getLongValue());
                Assert.assertEquals((Object)"test-stringField", (Object)value.getRecordValue().get(0).getRecordValue().get(2).getStringValue());
                Assert.assertEquals((Object)true, (Object)value.getRecordValue().get(1).getBooleanValue());
                Assert.assertEquals((Object)"test-stringField", (Object)value.getRecordValue().get(2).getStringValue());
                Assert.assertEquals((long)10L, (long)value.getRecordValue().get(3).getLongValue());
            }
        }
    }

    @Test
    public void testBytesParameter() throws Exception {
        String query = "SELECT BYTE_LENGTH(@p) AS length";
        QueryParameterValue bytesParameter = QueryParameterValue.bytes((byte[])new byte[]{1, 3});
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("p", bytesParameter).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        int rowCount = 0;
        for (FieldValueList row : result.getValues()) {
            ++rowCount;
            Assert.assertEquals((long)2L, (long)row.get(0).getLongValue());
            Assert.assertEquals((long)2L, (long)row.get("length").getLongValue());
        }
        Assert.assertEquals((long)1L, (long)rowCount);
    }

    @Test
    public void testGeographyParameter() throws Exception {
        String query = "SELECT ST_DISTANCE(ST_GEOGFROMTEXT(\"POINT(-122.335503 47.625536)\"), @geo) < 3000 as within3k";
        QueryParameterValue geoParameterValue = QueryParameterValue.geography((String)"POINT(-122.3509153 47.6495389)");
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).addNamedParameter("geo", geoParameterValue).build();
        TableResult result = bigquery.query(config, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        int rowCount = 0;
        for (FieldValueList row : result.getValues()) {
            ++rowCount;
            Assert.assertEquals((Object)true, (Object)row.get(0).getBooleanValue());
        }
        Assert.assertEquals((long)1L, (long)rowCount);
    }

    @Test
    public void testListJobs() {
        Page jobs = bigquery.listJobs(new BigQuery.JobListOption[0]);
        for (Job job : jobs.getValues()) {
            Assert.assertNotNull((Object)job.getJobId());
            Assert.assertNotNull((Object)job.getStatistics());
            Assert.assertNotNull((Object)job.getStatus());
            Assert.assertNotNull((Object)job.getUserEmail());
            Assert.assertNotNull((Object)job.getGeneratedId());
        }
    }

    @Test
    public void testListJobsWithSelectedFields() {
        Page jobs = bigquery.listJobs(new BigQuery.JobListOption[]{BigQuery.JobListOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.USER_EMAIL})});
        for (Job job : jobs.getValues()) {
            Assert.assertNotNull((Object)job.getJobId());
            Assert.assertNotNull((Object)job.getStatus());
            Assert.assertNotNull((Object)job.getUserEmail());
            Assert.assertNull((Object)job.getStatistics());
            Assert.assertNull((Object)job.getGeneratedId());
        }
    }

    @Test
    public void testListJobsWithCreationBounding() {
        long currentMillis = System.currentTimeMillis();
        long lowerBound = currentMillis - 3600000L;
        long upperBound = currentMillis;
        Page jobs = bigquery.listJobs(new BigQuery.JobListOption[]{BigQuery.JobListOption.minCreationTime((long)lowerBound), BigQuery.JobListOption.maxCreationTime((long)upperBound)});
        long foundMin = upperBound;
        long foundMax = lowerBound;
        long jobCount = 0L;
        for (Job job : jobs.getValues()) {
            ++jobCount;
            foundMin = Math.min(job.getStatistics().getCreationTime(), foundMin);
            foundMax = Math.max(job.getStatistics().getCreationTime(), foundMax);
        }
        Assert.assertTrue((String)("Found min job time " + foundMin + " earlier than " + lowerBound), (foundMin >= lowerBound ? 1 : 0) != 0);
        Assert.assertTrue((String)("Found max job time " + foundMax + " later than " + upperBound), (foundMax <= upperBound ? 1 : 0) != 0);
        Assert.assertTrue((String)"no jobs listed", (jobCount > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCreateAndGetJob() throws InterruptedException, TimeoutException {
        String sourceTableName = "test_create_and_get_job_source_table";
        String destinationTableName = "test_create_and_get_job_destination_table";
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)sourceTable, (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)sourceTableName, (Object)createdTable.getTableId().getTable());
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration copyJobConfiguration = CopyJobConfiguration.of((TableId)destinationTable, (TableId)sourceTable);
        Job createdJob = bigquery.create(JobInfo.of((JobConfiguration)copyJobConfiguration), new BigQuery.JobOption[0]);
        Job remoteJob = bigquery.getJob(createdJob.getJobId(), new BigQuery.JobOption[0]);
        Assert.assertEquals((Object)createdJob.getJobId(), (Object)remoteJob.getJobId());
        CopyJobConfiguration createdConfiguration = (CopyJobConfiguration)createdJob.getConfiguration();
        CopyJobConfiguration remoteConfiguration = (CopyJobConfiguration)remoteJob.getConfiguration();
        Assert.assertEquals((Object)createdConfiguration.getSourceTables(), (Object)remoteConfiguration.getSourceTables());
        Assert.assertEquals((Object)createdConfiguration.getDestinationTable(), (Object)remoteConfiguration.getDestinationTable());
        Assert.assertEquals((Object)createdConfiguration.getCreateDisposition(), (Object)remoteConfiguration.getCreateDisposition());
        Assert.assertEquals((Object)createdConfiguration.getWriteDisposition(), (Object)remoteConfiguration.getWriteDisposition());
        Assert.assertNotNull((Object)remoteJob.getEtag());
        Assert.assertNotNull((Object)remoteJob.getStatistics());
        Assert.assertNotNull((Object)remoteJob.getStatus());
        Assert.assertEquals((Object)createdJob.getSelfLink(), (Object)remoteJob.getSelfLink());
        Assert.assertEquals((Object)createdJob.getUserEmail(), (Object)remoteJob.getUserEmail());
        Job completedJob = remoteJob.waitFor(new RetryOption[]{RetryOption.totalTimeoutDuration((Duration)Duration.ofMinutes(1L))});
        Assert.assertNotNull((Object)completedJob);
        Assert.assertNull((Object)completedJob.getStatus().getError());
        Assert.assertTrue((boolean)createdTable.delete());
        Assert.assertTrue((boolean)bigquery.delete(destinationTable));
    }

    @Test
    public void testCreateJobAndWaitForWithRetryOptions() throws InterruptedException, TimeoutException {
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)"SELECT CURRENT_TIMESTAMP() as ts").setDefaultDataset(DATASET).setUseLegacySql(Boolean.valueOf(false)).build();
        BigQueryRetryConfig bigQueryRetryConfig = BigQueryRetryConfig.newBuilder().build();
        BigQuery.JobOption bigQueryRetryConfigOption = BigQuery.JobOption.bigQueryRetryConfig((BigQueryRetryConfig)bigQueryRetryConfig);
        BigQuery.JobOption retryOptions = BigQuery.JobOption.retryOptions((RetryOption[])new RetryOption[]{RetryOption.maxAttempts((int)1)});
        Job job = bigquery.create(JobInfo.of((JobConfiguration)config), new BigQuery.JobOption[]{bigQueryRetryConfigOption, retryOptions});
        job = job.waitFor(bigQueryRetryConfig, new RetryOption[0]);
        Assert.assertEquals((Object)JobStatus.State.DONE, (Object)job.getStatus().getState());
    }

    @Test
    public void testCreateAndGetJobWithSelectedFields() throws InterruptedException, TimeoutException {
        String sourceTableName = "test_create_and_get_job_with_selected_fields_source_table";
        String destinationTableName = "test_create_and_get_job_with_selected_fields_destination_table";
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)sourceTable, (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)sourceTableName, (Object)createdTable.getTableId().getTable());
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration configuration = CopyJobConfiguration.of((TableId)destinationTable, (TableId)sourceTable);
        Job createdJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.ETAG})});
        CopyJobConfiguration createdConfiguration = (CopyJobConfiguration)createdJob.getConfiguration();
        Assert.assertNotNull((Object)createdJob.getJobId());
        Assert.assertNotNull((Object)createdConfiguration.getSourceTables());
        Assert.assertNotNull((Object)createdConfiguration.getDestinationTable());
        Assert.assertNotNull((Object)createdJob.getEtag());
        Assert.assertNull((Object)createdJob.getStatistics());
        Assert.assertNull((Object)createdJob.getStatus());
        Assert.assertNull((Object)createdJob.getSelfLink());
        Assert.assertNull((Object)createdJob.getUserEmail());
        Job remoteJob = bigquery.getJob(createdJob.getJobId(), new BigQuery.JobOption[]{BigQuery.JobOption.fields((BigQuery.JobField[])new BigQuery.JobField[]{BigQuery.JobField.ETAG})});
        CopyJobConfiguration remoteConfiguration = (CopyJobConfiguration)remoteJob.getConfiguration();
        Assert.assertEquals((Object)createdJob.getJobId(), (Object)remoteJob.getJobId());
        Assert.assertEquals((Object)createdConfiguration.getSourceTables(), (Object)remoteConfiguration.getSourceTables());
        Assert.assertEquals((Object)createdConfiguration.getDestinationTable(), (Object)remoteConfiguration.getDestinationTable());
        Assert.assertEquals((Object)createdConfiguration.getCreateDisposition(), (Object)remoteConfiguration.getCreateDisposition());
        Assert.assertEquals((Object)createdConfiguration.getWriteDisposition(), (Object)remoteConfiguration.getWriteDisposition());
        Assert.assertNotNull((Object)remoteJob.getEtag());
        Assert.assertNull((Object)remoteJob.getStatistics());
        Assert.assertNull((Object)remoteJob.getStatus());
        Assert.assertNull((Object)remoteJob.getSelfLink());
        Assert.assertNull((Object)remoteJob.getUserEmail());
        Job completedJob = remoteJob.waitFor(new RetryOption[]{RetryOption.initialRetryDelayDuration((Duration)Duration.ofSeconds(1L)), RetryOption.totalTimeoutDuration((Duration)Duration.ofMinutes(1L))});
        Assert.assertNotNull((Object)completedJob);
        Assert.assertTrue((boolean)createdTable.delete());
        Assert.assertNull((Object)completedJob.getStatus().getError());
        Assert.assertTrue((boolean)bigquery.delete(destinationTable));
    }

    @Test
    public void testCopyJob() throws InterruptedException, TimeoutException {
        String sourceTableName = "test_copy_job_source_table";
        String destinationTableName = "test_copy_job_destination_table";
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)sourceTable, (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)sourceTableName, (Object)createdTable.getTableId().getTable());
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration configuration = CopyJobConfiguration.of((TableId)destinationTable, (TableId)sourceTable);
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        JobStatistics.CopyStatistics copyStatistics = (JobStatistics.CopyStatistics)remoteJob.getStatistics();
        Assert.assertNotNull((Object)copyStatistics);
        Assert.assertEquals((long)0L, (long)copyStatistics.getCopiedRows());
        Assert.assertEquals((long)0L, (long)copyStatistics.getCopiedLogicalBytes());
        Table remoteTable = bigquery.getTable(DATASET, destinationTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertEquals((Object)destinationTable.getDataset(), (Object)remoteTable.getTableId().getDataset());
        Assert.assertEquals((Object)destinationTableName, (Object)remoteTable.getTableId().getTable());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        Assert.assertTrue((boolean)createdTable.delete());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testCopyJobStatistics() throws InterruptedException, TimeoutException {
        String sourceTableName = "test_copy_job_statistics_source_table";
        String destinationTableName = "test_copy_job_statistics_destination_table";
        QueryJobConfiguration createTable = QueryJobConfiguration.newBuilder((String)String.format("CREATE TABLE %s AS SELECT num FROM UNNEST(GENERATE_ARRAY(0,5)) as num", sourceTableName)).setDefaultDataset(DatasetId.of((String)DATASET)).setUseLegacySql(Boolean.valueOf(false)).build();
        bigquery.query(createTable, new BigQuery.JobOption[0]);
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration configuration = CopyJobConfiguration.of((TableId)destinationTable, (TableId)sourceTable);
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        JobStatistics.CopyStatistics copyStatistics = (JobStatistics.CopyStatistics)remoteJob.getStatistics();
        Assert.assertNotNull((Object)copyStatistics);
        Assert.assertEquals((long)6L, (long)copyStatistics.getCopiedRows());
        Assert.assertNotEquals((long)0L, (long)copyStatistics.getCopiedLogicalBytes());
    }

    @Test
    public void testSnapshotTableCopyJob() throws InterruptedException {
        String sourceTableName = "test_copy_job_base_table";
        String ddlTableName = TABLE_ID_DDL.getTable();
        String snapshotTableName = String.format("test_snapshot_table", new Object[0]);
        String ddlQuery = String.format("CREATE OR REPLACE TABLE %s (TimestampField TIMESTAMP OPTIONS(description='TimestampDescription'), StringField STRING OPTIONS(description='StringDescription'), BooleanField BOOLEAN OPTIONS(description='BooleanDescription') ) AS SELECT * FROM %s", sourceTableName, ddlTableName);
        QueryJobConfiguration ddlConfig = QueryJobConfiguration.newBuilder((String)ddlQuery).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableId sourceTableId = TableId.of((String)DATASET, (String)sourceTableName);
        TableResult result = bigquery.query(ddlConfig, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)DDL_TABLE_SCHEMA, (Object)result.getSchema());
        Table remoteTable = bigquery.getTable(DATASET, sourceTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        TableId snapshotTableId = TableId.of((String)DATASET, (String)snapshotTableName);
        CopyJobConfiguration snapshotConfiguration = CopyJobConfiguration.newBuilder((TableId)snapshotTableId, (TableId)sourceTableId).setOperationType("SNAPSHOT").build();
        Job createdJob = bigquery.create(JobInfo.of((JobConfiguration)snapshotConfiguration), new BigQuery.JobOption[0]);
        CopyJobConfiguration createdConfiguration = (CopyJobConfiguration)createdJob.getConfiguration();
        Assert.assertNotNull((Object)createdConfiguration.getSourceTables());
        Assert.assertNotNull((Object)createdConfiguration.getOperationType());
        Assert.assertNotNull((Object)createdConfiguration.getDestinationTable());
        Job completedJob = createdJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)completedJob.getStatus().getError());
        Table snapshotTable = bigquery.getTable(DATASET, snapshotTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)snapshotTable);
        Assert.assertEquals((Object)snapshotTableId.getDataset(), (Object)snapshotTable.getTableId().getDataset());
        Assert.assertEquals((Object)snapshotTableName, (Object)snapshotTable.getTableId().getTable());
        System.out.println(snapshotTable.getDefinition());
        Assert.assertTrue((boolean)(snapshotTable.getDefinition() instanceof SnapshotTableDefinition));
        Assert.assertEquals((Object)DDL_TABLE_SCHEMA, (Object)snapshotTable.getDefinition().getSchema());
        Assert.assertNotNull((Object)((SnapshotTableDefinition)snapshotTable.getDefinition()).getSnapshotTime());
        Assert.assertEquals((Object)sourceTableName, (Object)((SnapshotTableDefinition)snapshotTable.getDefinition()).getBaseTableId().getTable());
        String restoredTableName = "test_restore_table";
        TableId restoredTableId = TableId.of((String)DATASET, (String)restoredTableName);
        CopyJobConfiguration restoreConfiguration = CopyJobConfiguration.newBuilder((TableId)restoredTableId, (TableId)snapshotTableId).setOperationType("RESTORE").build();
        Job createdRestoreJob = bigquery.create(JobInfo.of((JobConfiguration)restoreConfiguration), new BigQuery.JobOption[0]);
        CopyJobConfiguration createdRestoreConfiguration = (CopyJobConfiguration)createdRestoreJob.getConfiguration();
        Assert.assertEquals((Object)restoreConfiguration.getOperationType(), (Object)createdRestoreConfiguration.getOperationType());
        Assert.assertEquals((Object)restoreConfiguration.getDestinationTable().getTable(), (Object)createdRestoreConfiguration.getDestinationTable().getTable());
        Job completedRestoreJob = createdRestoreJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)completedRestoreJob.getStatus().getError());
        Table restoredTable = bigquery.getTable(DATASET, restoredTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)restoredTable);
        Assert.assertEquals((Object)restoredTableId.getDataset(), (Object)restoredTable.getTableId().getDataset());
        Assert.assertEquals((Object)restoredTableName, (Object)restoredTable.getTableId().getTable());
        Assert.assertEquals((Object)DDL_TABLE_SCHEMA, (Object)restoredTable.getDefinition().getSchema());
        Assert.assertEquals((Object)snapshotTable.getNumBytes(), (Object)restoredTable.getNumBytes());
        Assert.assertEquals((Object)snapshotTable.getNumRows(), (Object)restoredTable.getNumRows());
        Assert.assertTrue((boolean)remoteTable.delete());
        Assert.assertTrue((boolean)restoredTable.delete());
        Assert.assertTrue((boolean)snapshotTable.delete());
    }

    @Test
    public void testCopyJobWithLabelsAndExpTime() throws InterruptedException {
        String destExpiryTime = "2025-12-31T23:59:59.999999999Z";
        String sourceTableName = "test_copy_job_source_table_label";
        String destinationTableName = "test_copy_job_destination_table_label";
        ImmutableMap labels = ImmutableMap.of((Object)"test_job_name", (Object)"test_copy_job");
        TableId sourceTable = TableId.of((String)DATASET, (String)sourceTableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)TABLE_SCHEMA);
        TableInfo tableInfo = TableInfo.of((TableId)sourceTable, (TableDefinition)tableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        CopyJobConfiguration configuration = CopyJobConfiguration.newBuilder((TableId)destinationTable, (TableId)sourceTable).setLabels((Map)labels).setDestinationExpirationTime(destExpiryTime).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        CopyJobConfiguration copyJobConfiguration = (CopyJobConfiguration)remoteJob.getConfiguration();
        Assert.assertEquals((Object)labels, (Object)copyJobConfiguration.getLabels());
        Assert.assertNotNull((Object)copyJobConfiguration.getDestinationExpirationTime());
        Assert.assertEquals((Object)destExpiryTime, (Object)copyJobConfiguration.getDestinationExpirationTime());
        Table remoteTable = bigquery.getTable(DATASET, destinationTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)createdTable.delete());
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testQueryJob() throws InterruptedException, TimeoutException {
        String tableName = "test_query_job_table";
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        QueryJobConfiguration configuration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setDestinationTable(destinationTable).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        TableResult result = remoteJob.getQueryResults(new BigQuery.QueryResultsOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)QUERY_RESULT_SCHEMA, (Object)result.getSchema());
        int rowCount = 0;
        for (FieldValueList row : result.getValues()) {
            FieldValue timestampCell = row.get(0);
            FieldValue stringCell = row.get(1);
            FieldValue booleanCell = row.get(2);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Assert.assertTrue((boolean)bigquery.delete(destinationTable));
        Job queryJob = bigquery.getJob(remoteJob.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
        if (statistics.getBiEngineStats() != null) {
            Assert.assertEquals((Object)statistics.getBiEngineStats().getBiEngineMode(), (Object)"DISABLED");
            Assert.assertEquals((Object)((BiEngineReason)statistics.getBiEngineStats().getBiEngineReasons().get(0)).getCode(), (Object)"OTHER_REASON");
            Assert.assertEquals((Object)((BiEngineReason)statistics.getBiEngineStats().getBiEngineReasons().get(0)).getMessage(), (Object)"Only SELECT queries without a destination table can be accelerated.");
        }
        Assert.assertNotNull((Object)statistics.getQueryPlan());
    }

    @Test
    public void testQueryJobWithConnectionProperties() throws InterruptedException {
        String tableName = "test_query_job_table_connection_properties";
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        QueryJobConfiguration configuration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setDestinationTable(destinationTable).setConnectionProperties(CONNECTION_PROPERTIES).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        QueryJobConfiguration jobConfiguration = (QueryJobConfiguration)remoteJob.getConfiguration();
        Assert.assertEquals(CONNECTION_PROPERTIES, (Object)jobConfiguration.getConnectionProperties());
        Assert.assertTrue((boolean)bigquery.delete(destinationTable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryJobWithLabels() throws InterruptedException, TimeoutException {
        String tableName = "test_query_job_table";
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        ImmutableMap labels = ImmutableMap.of((Object)"test-job-name", (Object)"test-query-job");
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        try {
            QueryJobConfiguration configuration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setDestinationTable(destinationTable).setLabels((Map)labels).build();
            Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
            remoteJob = remoteJob.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)remoteJob.getStatus().getError());
            QueryJobConfiguration queryJobConfiguration = (QueryJobConfiguration)remoteJob.getConfiguration();
            Assert.assertEquals((Object)labels, (Object)queryJobConfiguration.getLabels());
        }
        finally {
            bigquery.delete(destinationTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryJobWithSearchReturnsSearchStatisticsUnused() throws InterruptedException {
        String tableName = "test_query_job_table";
        String query = "SELECT * FROM " + TABLE_ID.getTable() + "         WHERE search(StringField, \"stringValue\")";
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        try {
            QueryJobConfiguration configuration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setDestinationTable(destinationTable).build();
            Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
            remoteJob = remoteJob.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)remoteJob.getStatus().getError());
            JobStatistics.QueryStatistics stats = (JobStatistics.QueryStatistics)remoteJob.getStatistics();
            Assert.assertNotNull((Object)stats.getSearchStats());
            Assert.assertEquals((Object)stats.getSearchStats().getIndexUsageMode(), (Object)"UNUSED");
            Assert.assertNotNull((Object)stats.getSearchStats().getIndexUnusedReasons());
            Assert.assertNotNull((String)((IndexUnusedReason)stats.getSearchStats().getIndexUnusedReasons().get(0)).getCode(), (Object)"INDEX_CONFIG_NOT_AVAILABLE");
        }
        finally {
            bigquery.delete(destinationTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryJobWithRangePartitioning() throws InterruptedException {
        String tableName = "test_query_job_table_rangepartitioning";
        String query = "SELECT IntegerField, TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        try {
            QueryJobConfiguration configuration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setDestinationTable(destinationTable).setRangePartitioning(RANGE_PARTITIONING).build();
            Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
            remoteJob = remoteJob.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)remoteJob.getStatus().getError());
            QueryJobConfiguration queryJobConfiguration = (QueryJobConfiguration)remoteJob.getConfiguration();
            Assert.assertEquals((Object)RANGE, (Object)queryJobConfiguration.getRangePartitioning().getRange());
            Assert.assertEquals((Object)RANGE_PARTITIONING, (Object)queryJobConfiguration.getRangePartitioning());
        }
        finally {
            bigquery.delete(destinationTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadJobWithRangePartitioning() throws InterruptedException {
        String tableName = "test_load_job_table_rangepartitioning";
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        try {
            LoadJobConfiguration configuration = LoadJobConfiguration.newBuilder((TableId)TABLE_ID, (String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (FormatOptions)FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(TABLE_SCHEMA).setRangePartitioning(RANGE_PARTITIONING).setDestinationTable(destinationTable).build();
            Job job = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
            job = job.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)job.getStatus().getError());
            LoadJobConfiguration loadJobConfiguration = (LoadJobConfiguration)job.getConfiguration();
            Assert.assertEquals((Object)RANGE, (Object)loadJobConfiguration.getRangePartitioning().getRange());
            Assert.assertEquals((Object)RANGE_PARTITIONING, (Object)loadJobConfiguration.getRangePartitioning());
        }
        finally {
            bigquery.delete(destinationTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadJobWithDecimalTargetTypes() throws InterruptedException {
        String tableName = "test_load_job_table_parquet_decimalTargetTypes";
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        String sourceUri = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/numeric/numeric_38_12.parquet";
        try {
            LoadJobConfiguration configuration = LoadJobConfiguration.newBuilder((TableId)destinationTable, (String)sourceUri, (FormatOptions)FormatOptions.parquet()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setDecimalTargetTypes((List)ImmutableList.of((Object)"NUMERIC", (Object)"BIGNUMERIC", (Object)"STRING")).build();
            Job job = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
            job = job.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)job.getStatus().getError());
            LoadJobConfiguration loadJobConfiguration = (LoadJobConfiguration)job.getConfiguration();
            Assert.assertEquals((Object)ImmutableList.of((Object)"NUMERIC", (Object)"BIGNUMERIC", (Object)"STRING"), (Object)loadJobConfiguration.getDecimalTargetTypes());
            Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)remoteTable);
            Assert.assertEquals((Object)remoteTable.getDefinition().getSchema().getFields().get(0).getType().toString(), (Object)"BIGNUMERIC");
        }
        finally {
            bigquery.delete(destinationTable);
        }
    }

    @Test
    public void testExternalTableWithDecimalTargetTypes() throws InterruptedException {
        String tableName = "test_create_external_table_parquet_decimalTargetTypes";
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        String sourceUri = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/numeric/numeric_38_12.parquet";
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.parquet()).setDecimalTargetTypes((List)ImmutableList.of((Object)"NUMERIC", (Object)"BIGNUMERIC", (Object)"STRING")).build();
        TableInfo tableInfo = TableInfo.of((TableId)destinationTable, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertEquals((Object)remoteTable.getDefinition().getSchema().getFields().get(0).getType().toString(), (Object)"BIGNUMERIC");
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testQueryJobWithDryRun() throws InterruptedException, TimeoutException {
        String tableName = "test_query_job_table";
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        QueryJobConfiguration configuration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setDestinationTable(destinationTable).setDryRun(Boolean.valueOf(true)).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        Assert.assertNull((Object)remoteJob.getJobId().getJob());
        remoteJob.getStatistics();
        Assert.assertEquals((Object)JobStatus.State.DONE, (Object)remoteJob.getStatus().getState());
        Assert.assertNotNull((Object)remoteJob.getConfiguration());
    }

    @Test
    public void testExtractJob() throws InterruptedException, TimeoutException {
        String tableName = "test_export_job_table";
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        ImmutableMap labels = ImmutableMap.of((Object)"test-job-name", (Object)"test-load-extract-job");
        LoadJobConfiguration configuration = LoadJobConfiguration.newBuilder((TableId)destinationTable, (String)("gs://" + BUCKET + "/" + LOAD_FILE)).setSchema(SIMPLE_SCHEMA).setLabels((Map)labels).build();
        Job remoteLoadJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        remoteLoadJob = remoteLoadJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteLoadJob.getStatus().getError());
        LoadJobConfiguration loadJobConfiguration = (LoadJobConfiguration)remoteLoadJob.getConfiguration();
        Assert.assertEquals((Object)labels, (Object)loadJobConfiguration.getLabels());
        JobStatistics.LoadStatistics loadStatistics = (JobStatistics.LoadStatistics)remoteLoadJob.getStatistics();
        Assert.assertNotNull((Object)loadStatistics);
        ExtractJobConfiguration extractConfiguration = ExtractJobConfiguration.newBuilder((TableId)destinationTable, (String)("gs://" + BUCKET + "/" + EXTRACT_FILE)).setPrintHeader(Boolean.valueOf(false)).build();
        Job remoteExtractJob = bigquery.create(JobInfo.of((JobConfiguration)extractConfiguration), new BigQuery.JobOption[0]);
        remoteExtractJob = remoteExtractJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteExtractJob.getStatus().getError());
        JobStatistics.ExtractStatistics extractStatistics = (JobStatistics.ExtractStatistics)remoteExtractJob.getStatistics();
        Assert.assertNotNull((Object)extractStatistics);
        Assert.assertEquals((long)1L, (long)extractStatistics.getDestinationUriFileCounts().size());
        Assert.assertEquals((long)loadStatistics.getOutputBytes(), (long)extractStatistics.getInputBytes());
        Truth.assertThat((Long)extractStatistics.getTotalSlotMs()).isGreaterThan((Comparable)Long.valueOf(0L));
        String extractedCsv = new String(storage.readAllBytes(BUCKET, EXTRACT_FILE, new Storage.BlobSourceOption[0]), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])CSV_CONTENT.split("\n")), (Object)Sets.newHashSet((Object[])extractedCsv.split("\n")));
        Assert.assertTrue((boolean)bigquery.delete(destinationTable));
    }

    @Test
    public void testExtractJobWithModel() throws InterruptedException {
        String modelName = RemoteBigQueryHelper.generateModelName();
        String sql = "CREATE MODEL `" + MODEL_DATASET + "." + modelName + "`OPTIONS ( model_type='linear_reg', max_iterations=1, learn_rate=0.4, learn_rate_strategy='constant' ) AS ( \tSELECT 'a' AS f1, 2.0 AS label UNION ALL SELECT 'b' AS f1, 3.8 AS label )";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)sql).build();
        Job job = bigquery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)config), new BigQuery.JobOption[0]);
        job.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)job.getStatus().getError());
        ModelId destinationModel = ModelId.of((String)MODEL_DATASET, (String)modelName);
        Assert.assertNotNull((Object)destinationModel);
        ExtractJobConfiguration extractConfiguration = ExtractJobConfiguration.newBuilder((ModelId)destinationModel, (String)("gs://" + BUCKET + "/" + EXTRACT_MODEL_FILE)).setPrintHeader(Boolean.valueOf(false)).build();
        Job remoteExtractJob = bigquery.create(JobInfo.of((JobConfiguration)extractConfiguration), new BigQuery.JobOption[0]);
        remoteExtractJob = remoteExtractJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteExtractJob.getStatus().getError());
        Assert.assertTrue((boolean)bigquery.delete(destinationModel));
    }

    @Test
    public void testExtractJobWithLabels() throws InterruptedException, TimeoutException {
        String tableName = "test_export_job_table_label";
        ImmutableMap labels = ImmutableMap.of((Object)"test_job_name", (Object)"test_export_job");
        TableId destinationTable = TableId.of((String)DATASET, (String)tableName);
        LoadJobConfiguration configuration = LoadJobConfiguration.newBuilder((TableId)destinationTable, (String)("gs://" + BUCKET + "/" + LOAD_FILE)).setSchema(SIMPLE_SCHEMA).build();
        Job remoteLoadJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        remoteLoadJob = remoteLoadJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteLoadJob.getStatus().getError());
        ExtractJobConfiguration extractConfiguration = ExtractJobConfiguration.newBuilder((TableId)destinationTable, (String)("gs://" + BUCKET + "/" + EXTRACT_FILE)).setLabels((Map)labels).setPrintHeader(Boolean.valueOf(false)).build();
        Job remoteExtractJob = bigquery.create(JobInfo.of((JobConfiguration)extractConfiguration), new BigQuery.JobOption[0]);
        remoteExtractJob = remoteExtractJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteExtractJob.getStatus().getError());
        ExtractJobConfiguration extractJobConfiguration = (ExtractJobConfiguration)remoteExtractJob.getConfiguration();
        Assert.assertEquals((Object)labels, (Object)extractJobConfiguration.getLabels());
        Assert.assertTrue((boolean)bigquery.delete(destinationTable));
    }

    @Test
    public void testCancelJob() throws InterruptedException, TimeoutException {
        String destinationTableName = "test_cancel_query_job_table";
        String query = "SELECT TimestampField, StringField, BooleanField FROM " + TABLE_ID.getTable();
        TableId destinationTable = TableId.of((String)DATASET, (String)destinationTableName);
        QueryJobConfiguration configuration = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).setDestinationTable(destinationTable).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)configuration), new BigQuery.JobOption[0]);
        Assert.assertTrue((boolean)remoteJob.cancel());
    }

    @Test
    public void testCancelNonExistingJob() {
        Assert.assertFalse((boolean)bigquery.cancel("test_cancel_non_existing_job"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertFromFile() throws InterruptedException, IOException, TimeoutException {
        String destinationTableName = "test_insert_from_file_table";
        TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
        WriteChannelConfiguration configuration = WriteChannelConfiguration.newBuilder((TableId)tableId).setFormatOptions(FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(TABLE_SCHEMA).build();
        try (TableDataWriteChannel channel = bigquery.writer(configuration);){
            Assert.assertEquals((long)0L, (long)channel.write(ByteBuffer.wrap("".getBytes(StandardCharsets.UTF_8))));
        }
        channel = bigquery.writer(configuration);
        try {
            channel.write(ByteBuffer.wrap(JSON_CONTENT.getBytes(StandardCharsets.UTF_8)));
        }
        finally {
            channel.close();
        }
        Job job = channel.getJob().waitFor(new RetryOption[0]);
        JobStatistics.LoadStatistics statistics = (JobStatistics.LoadStatistics)job.getStatistics();
        Assert.assertEquals((long)1L, (long)statistics.getInputFiles());
        Assert.assertEquals((long)2L, (long)statistics.getOutputRows());
        LoadJobConfiguration jobConfiguration = (LoadJobConfiguration)job.getConfiguration();
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)jobConfiguration.getSchema());
        Assert.assertNull((Object)jobConfiguration.getSourceUris());
        Assert.assertNull((Object)job.getStatus().getError());
        TableResult rows = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
        int rowCount = 0;
        for (FieldValueList row : rows.getValues()) {
            FieldValue timestampCell = row.get(0);
            FieldValue stringCell = row.get(1);
            FieldValue integerArrayCell = row.get(2);
            FieldValue booleanCell = row.get(3);
            FieldValue bytesCell = row.get(4);
            FieldValue recordCell = row.get(5);
            FieldValue integerCell = row.get(6);
            FieldValue floatCell = row.get(7);
            FieldValue geographyCell = row.get(8);
            FieldValue numericCell = row.get(9);
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)timestampCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)stringCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.REPEATED, (Object)integerArrayCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)booleanCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)bytesCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.RECORD, (Object)recordCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)integerCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)floatCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)geographyCell.getAttribute());
            Assert.assertEquals((Object)FieldValue.Attribute.PRIMITIVE, (Object)numericCell.getAttribute());
            Assert.assertEquals((long)1408452095220000L, (long)timestampCell.getTimestampValue());
            Assert.assertEquals((Object)"stringValue", (Object)stringCell.getStringValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)integerArrayCell.getRepeatedValue().get(0)).getLongValue());
            Assert.assertEquals((long)1L, (long)((FieldValue)integerArrayCell.getRepeatedValue().get(1)).getLongValue());
            Assert.assertEquals((Object)false, (Object)booleanCell.getBooleanValue());
            Assert.assertArrayEquals((byte[])BYTES, (byte[])bytesCell.getBytesValue());
            Assert.assertEquals((long)-14182916000000L, (long)recordCell.getRecordValue().get(0).getTimestampValue());
            Assert.assertTrue((boolean)recordCell.getRecordValue().get(1).isNull());
            Assert.assertEquals((long)1L, (long)((FieldValue)recordCell.getRecordValue().get(2).getRepeatedValue().get(0)).getLongValue());
            Assert.assertEquals((long)0L, (long)((FieldValue)recordCell.getRecordValue().get(2).getRepeatedValue().get(1)).getLongValue());
            Assert.assertEquals((Object)true, (Object)recordCell.getRecordValue().get(3).getBooleanValue());
            Assert.assertEquals((long)3L, (long)integerCell.getLongValue());
            Assert.assertEquals((double)1.2, (double)floatCell.getDoubleValue(), (double)1.0E-4);
            Assert.assertEquals((Object)"POINT(-122.35022 47.649154)", (Object)geographyCell.getStringValue());
            Assert.assertEquals((Object)new BigDecimal("123456.789012345"), (Object)numericCell.getNumericValue());
            ++rowCount;
        }
        Assert.assertEquals((long)2L, (long)rowCount);
        Assert.assertTrue((boolean)bigquery.delete(tableId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertFromFileWithLabels() throws InterruptedException, IOException, TimeoutException {
        String destinationTableName = "test_insert_from_file_table_with_labels";
        TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
        WriteChannelConfiguration configuration = WriteChannelConfiguration.newBuilder((TableId)tableId).setFormatOptions(FormatOptions.json()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(TABLE_SCHEMA).setLabels(LABELS).build();
        try (TableDataWriteChannel channel = bigquery.writer(configuration);){
            Assert.assertEquals((long)0L, (long)channel.write(ByteBuffer.wrap("".getBytes(StandardCharsets.UTF_8))));
        }
        channel = bigquery.writer(configuration);
        try {
            channel.write(ByteBuffer.wrap(JSON_CONTENT.getBytes(StandardCharsets.UTF_8)));
        }
        finally {
            channel.close();
        }
        Job job = channel.getJob().waitFor(new RetryOption[0]);
        LoadJobConfiguration jobConfiguration = (LoadJobConfiguration)job.getConfiguration();
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)jobConfiguration.getSchema());
        Assert.assertEquals(LABELS, (Object)jobConfiguration.getLabels());
        Assert.assertNull((Object)job.getStatus().getError());
        Assert.assertTrue((boolean)bigquery.delete(tableId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertWithDecimalTargetTypes() throws InterruptedException, IOException, TimeoutException {
        String destinationTableName = "test_insert_from_file_table_with_decimal_target_type";
        TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
        WriteChannelConfiguration configuration = WriteChannelConfiguration.newBuilder((TableId)tableId).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setAutodetect(Boolean.valueOf(true)).setDecimalTargetTypes((List)ImmutableList.of((Object)"STRING", (Object)"NUMERIC", (Object)"BIGNUMERIC")).build();
        try (TableDataWriteChannel channel = bigquery.writer(configuration);){
            channel.write(ByteBuffer.wrap("foo".getBytes(StandardCharsets.UTF_8)));
        }
        Job job = channel.getJob().waitFor(new RetryOption[0]);
        LoadJobConfiguration jobConfiguration = (LoadJobConfiguration)job.getConfiguration();
        Assert.assertNull((Object)job.getStatus().getError());
        Assert.assertEquals((Object)ImmutableList.of((Object)"STRING", (Object)"NUMERIC", (Object)"BIGNUMERIC"), (Object)jobConfiguration.getDecimalTargetTypes());
        Assert.assertTrue((boolean)bigquery.delete(tableId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocation() throws Exception {
        String location = "EU";
        String wrongLocation = "US";
        Truth.assertThat((String)location).isNotEqualTo((Object)wrongLocation);
        Dataset dataset = bigquery.create(DatasetInfo.newBuilder((String)("locationset_" + UUID.randomUUID().toString().replace("-", "_"))).setLocation(location).build(), new BigQuery.DatasetOption[0]);
        try {
            TableId tableId = TableId.of((String)dataset.getDatasetId().getDataset(), (String)"sometable");
            Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"name", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0])});
            StandardTableDefinition tableDef = StandardTableDefinition.of((Schema)schema);
            Table table = bigquery.create(TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDef).build(), new BigQuery.TableOption[0]);
            String query = String.format("SELECT * FROM `%s.%s.%s`", table.getTableId().getProject(), table.getTableId().getDataset(), table.getTableId().getTable());
            Job job22 = bigquery.create(JobInfo.of((JobId)JobId.newBuilder().setLocation(location).build(), (JobConfiguration)QueryJobConfiguration.of((String)query)), new BigQuery.JobOption[0]);
            job22 = job22.waitFor(new RetryOption[0]);
            Truth.assertThat((Object)job22.getStatus().getError()).isNull();
            Truth.assertThat((String)job22.getJobId().getLocation()).isEqualTo((Object)location);
            JobId jobId = job22.getJobId();
            JobId wrongId = jobId.toBuilder().setLocation(wrongLocation).build();
            Truth.assertThat((Object)bigquery.getJob(jobId, new BigQuery.JobOption[0])).isNotNull();
            Truth.assertThat((Object)bigquery.getJob(wrongId, new BigQuery.JobOption[0])).isNull();
            Truth.assertThat((Boolean)bigquery.cancel(jobId)).isTrue();
            Truth.assertThat((Boolean)bigquery.cancel(wrongId)).isFalse();
            Truth.assertThat((Iterable)bigquery.query(QueryJobConfiguration.of((String)query), JobId.newBuilder().setLocation(location).build(), new BigQuery.JobOption[0]).iterateAll()).isEmpty();
            try {
                bigquery.query(QueryJobConfiguration.of((String)query), JobId.newBuilder().setLocation(wrongLocation).build(), new BigQuery.JobOption[0]).iterateAll();
                Assert.fail((String)"querying a table with wrong location shouldn't work");
            }
            catch (BigQueryException job22) {
                // empty catch block
            }
            WriteChannelConfiguration writeChannelConfiguration = WriteChannelConfiguration.newBuilder((TableId)tableId).setFormatOptions((FormatOptions)FormatOptions.csv()).build();
            try (TableDataWriteChannel writer = bigquery.writer(JobId.newBuilder().setLocation(location).build(), writeChannelConfiguration);){
                writer.write(ByteBuffer.wrap("foo".getBytes()));
            }
            try {
                bigquery.writer(JobId.newBuilder().setLocation(wrongLocation).build(), writeChannelConfiguration);
                Assert.fail((String)"writing to a table with wrong location shouldn't work");
            }
            catch (BigQueryException bigQueryException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            bigquery.delete(dataset.getDatasetId(), new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
            throw throwable;
        }
        bigquery.delete(dataset.getDatasetId(), new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveAsciiControlCharacters() throws InterruptedException, IOException, TimeoutException {
        String destinationTableName = "test_preserve_ascii_control_characters";
        TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
        WriteChannelConfiguration configuration = WriteChannelConfiguration.newBuilder((TableId)tableId).setFormatOptions((FormatOptions)FormatOptions.csv().toBuilder().setPreserveAsciiControlCharacters(true).build()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setSchema(SIMPLE_SCHEMA).build();
        try (TableDataWriteChannel channel = bigquery.writer(configuration);){
            channel.write(ByteBuffer.wrap("\u0000".getBytes(StandardCharsets.UTF_8)));
        }
        Job job = channel.getJob().waitFor(new RetryOption[0]);
        Assert.assertNull((Object)job.getStatus().getError());
        TableResult rows = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]);
        FieldValueList row = (FieldValueList)rows.getValues().iterator().next();
        Assert.assertEquals((Object)"\u0000", (Object)row.get(0).getStringValue());
        Assert.assertTrue((boolean)bigquery.delete(tableId));
    }

    @Test
    public void testReferenceFileSchemaUriForAvro() {
        try {
            String destinationTableName = "test_reference_file_schema_avro";
            TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
            Schema expectedSchema = Schema.of((Field[])new Field[]{Field.newBuilder((String)"username", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"tweet", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"timestamp", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"likes", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
            ImmutableList SOURCE_URIS = ImmutableList.of((Object)("gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/a-twitter.avro"), (Object)("gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/b-twitter.avro"), (Object)("gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/c-twitter.avro"));
            String referenceFileSchema = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/a-twitter.avro";
            LoadJobConfiguration loadJobConfiguration = LoadJobConfiguration.newBuilder((TableId)tableId, (List)SOURCE_URIS, (FormatOptions)FormatOptions.avro()).setReferenceFileSchemaUri(referenceFileSchema).build();
            Job job = bigquery.create(JobInfo.of((JobConfiguration)loadJobConfiguration), new BigQuery.JobOption[0]);
            job = job.waitFor(new RetryOption[0]);
            Assert.assertEquals((Object)true, (Object)job.isDone());
            LoadJobConfiguration actualLoadJobConfiguration = (LoadJobConfiguration)job.getConfiguration();
            Table generatedTable = bigquery.getTable(actualLoadJobConfiguration.getDestinationTable(), new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)expectedSchema, (Object)generatedTable.getDefinition().getSchema());
            boolean success = bigquery.delete(tableId);
            Assert.assertEquals((Object)true, (Object)success);
        }
        catch (BigQueryException | InterruptedException e) {
            System.out.println("Column not added during load append \n" + e.toString());
        }
    }

    @Test
    public void testReferenceFileSchemaUriForParquet() {
        try {
            String destinationTableName = "test_reference_file_schema_parquet";
            TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
            Schema expectedSchema = Schema.of((Field[])new Field[]{Field.newBuilder((String)"username", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"tweet", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"timestamp", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"likes", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
            ImmutableList SOURCE_URIS = ImmutableList.of((Object)("gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/a-twitter.parquet"), (Object)("gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/b-twitter.parquet"), (Object)("gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/c-twitter.parquet"));
            String referenceFileSchema = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/a-twitter.parquet";
            LoadJobConfiguration loadJobConfiguration = LoadJobConfiguration.newBuilder((TableId)tableId, (List)SOURCE_URIS, (FormatOptions)FormatOptions.parquet()).setReferenceFileSchemaUri(referenceFileSchema).build();
            Job job = bigquery.create(JobInfo.of((JobConfiguration)loadJobConfiguration), new BigQuery.JobOption[0]);
            job = job.waitFor(new RetryOption[0]);
            Assert.assertEquals((Object)true, (Object)job.isDone());
            LoadJobConfiguration actualLoadJobConfiguration = (LoadJobConfiguration)job.getConfiguration();
            Table generatedTable = bigquery.getTable(actualLoadJobConfiguration.getDestinationTable(), new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)expectedSchema, (Object)generatedTable.getDefinition().getSchema());
            boolean success = bigquery.delete(tableId);
            Assert.assertEquals((Object)true, (Object)success);
        }
        catch (BigQueryException | InterruptedException e) {
            System.out.println("Column not added during load append \n" + e.toString());
        }
    }

    @Test
    public void testCreateExternalTableWithReferenceFileSchemaAvro() {
        String destinationTableName = "test_create_external_table_reference_file_schema_avro";
        TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
        Schema expectedSchema = Schema.of((Field[])new Field[]{Field.newBuilder((String)"username", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"tweet", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"timestamp", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"likes", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
        String CLOUD_SAMPLES_DATA = "cloud-samples-data";
        String SOURCE_URI = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/*.avro";
        String referenceFileSchema = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/a-twitter.avro";
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder((String)SOURCE_URI, (FormatOptions)FormatOptions.avro()).setReferenceFileSchemaUri(referenceFileSchema).build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Table generatedTable = bigquery.getTable(createdTable.getTableId(), new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)expectedSchema, (Object)generatedTable.getDefinition().getSchema());
        boolean success = bigquery.delete(tableId);
        Assert.assertEquals((Object)true, (Object)success);
    }

    @Test
    public void testCreateExternalTableWithReferenceFileSchemaParquet() {
        String destinationTableName = "test_create_external_table_reference_file_schema_parquet";
        TableId tableId = TableId.of((String)DATASET, (String)destinationTableName);
        Schema expectedSchema = Schema.of((Field[])new Field[]{Field.newBuilder((String)"username", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"tweet", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"timestamp", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"likes", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()});
        String CLOUD_SAMPLES_DATA = "cloud-samples-data";
        String SOURCE_URI = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/*.parquet";
        String referenceFileSchema = "gs://" + CLOUD_SAMPLES_DATA + "/bigquery/federated-formats-reference-file-schema/a-twitter.parquet";
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder((String)SOURCE_URI, (FormatOptions)FormatOptions.parquet()).setReferenceFileSchemaUri(referenceFileSchema).build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Table generatedTable = bigquery.getTable(createdTable.getTableId(), new BigQuery.TableOption[0]);
        Assert.assertEquals((Object)expectedSchema, (Object)generatedTable.getDefinition().getSchema());
        boolean success = bigquery.delete(tableId);
        Assert.assertEquals((Object)true, (Object)success);
    }

    @Test
    public void testCloneTableCopyJob() throws InterruptedException {
        String sourceTableName = "test_copy_job_base_table";
        String ddlTableName = TABLE_ID_DDL.getTable();
        String cloneTableName = String.format("test_clone_table", new Object[0]);
        String ddlQuery = String.format("CREATE OR REPLACE TABLE %s (TimestampField TIMESTAMP OPTIONS(description='TimestampDescription'), StringField STRING OPTIONS(description='StringDescription'), BooleanField BOOLEAN OPTIONS(description='BooleanDescription') ) AS SELECT * FROM %s", sourceTableName, ddlTableName);
        QueryJobConfiguration ddlConfig = QueryJobConfiguration.newBuilder((String)ddlQuery).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        TableId sourceTableId = TableId.of((String)DATASET, (String)sourceTableName);
        TableResult result = bigquery.query(ddlConfig, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertEquals((Object)DDL_TABLE_SCHEMA, (Object)result.getSchema());
        Table remoteTable = bigquery.getTable(DATASET, sourceTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        TableId cloneTableId = TableId.of((String)DATASET, (String)cloneTableName);
        CopyJobConfiguration cloneConfiguration = CopyJobConfiguration.newBuilder((TableId)cloneTableId, (TableId)sourceTableId).setOperationType("CLONE").build();
        Job createdJob = bigquery.create(JobInfo.of((JobConfiguration)cloneConfiguration), new BigQuery.JobOption[0]);
        CopyJobConfiguration createdConfiguration = (CopyJobConfiguration)createdJob.getConfiguration();
        Assert.assertNotNull((Object)createdConfiguration.getSourceTables());
        Assert.assertNotNull((Object)createdConfiguration.getOperationType());
        Assert.assertNotNull((Object)createdConfiguration.getDestinationTable());
        Job completedJob = createdJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)completedJob.getStatus().getError());
        Table cloneTable = bigquery.getTable(DATASET, cloneTableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)cloneTable);
        Assert.assertEquals((Object)cloneTableId.getDataset(), (Object)cloneTable.getTableId().getDataset());
        Assert.assertEquals((Object)cloneTableName, (Object)cloneTable.getTableId().getTable());
        Assert.assertEquals((Object)TableDefinition.Type.TABLE, (Object)cloneTable.getDefinition().getType());
        Assert.assertTrue((boolean)(cloneTable.getDefinition() instanceof StandardTableDefinition));
        Assert.assertEquals((Object)DDL_TABLE_SCHEMA, (Object)cloneTable.getDefinition().getSchema());
        Assert.assertTrue((boolean)(cloneTable.getCloneDefinition() instanceof CloneDefinition));
        Assert.assertEquals((Object)sourceTableName, (Object)cloneTable.getCloneDefinition().getBaseTableId().getTable());
        Assert.assertNotNull((Object)cloneTable.getCloneDefinition().getCloneTime());
        Assert.assertTrue((boolean)remoteTable.delete());
        Assert.assertTrue((boolean)cloneTable.delete());
    }

    @Test
    public void testHivePartitioningOptionsFieldsFieldExistence() throws InterruptedException {
        String tableName = "hive_partitioned_external_table";
        String sourceDirectory = "bigquery/hive-partitioning-table/example";
        BlobInfo blobInfo = BlobInfo.newBuilder((String)BUCKET, (String)(sourceDirectory + "/key=foo/data.json")).build();
        Assert.assertNotNull((String)"Failed to upload JSON to GCS", (Object)storage.create(blobInfo, "{\"name\":\"bar\"}".getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]));
        String sourceUri = "gs://" + BUCKET + "/" + sourceDirectory + "/*";
        String sourceUriPrefix = "gs://" + BUCKET + "/" + sourceDirectory + "/";
        HivePartitioningOptions hivePartitioningOptions = HivePartitioningOptions.newBuilder().setMode("AUTO").setRequirePartitionFilter(Boolean.valueOf(true)).setSourceUriPrefix(sourceUriPrefix).build();
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ExternalTableDefinition customTable = ExternalTableDefinition.newBuilder((String)sourceUri, (FormatOptions)FormatOptions.json()).setAutodetect(Boolean.valueOf(true)).setHivePartitioningOptions(hivePartitioningOptions).build();
        bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)customTable), new BigQuery.TableOption[0]);
        Table table = bigquery.getTable(tableId, new BigQuery.TableOption[0]);
        Truth.assertThat((Object)table).isNotNull();
        HivePartitioningOptions options = ((ExternalTableDefinition)table.getDefinition()).getHivePartitioningOptions();
        List fields = options.getFields();
        Truth.assertThat((Iterable)fields).isNotNull();
        Truth.assertThat((Iterable)fields).hasSize(1);
        Truth.assertThat((Iterable)fields).contains((Object)"key");
        Assert.assertTrue((boolean)table.delete());
        Assert.assertTrue((boolean)storage.delete(blobInfo.getBlobId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrimaryKey() {
        String tableName = "test_primary_key";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        PrimaryKey primaryKey = PrimaryKey.newBuilder().setColumns(Arrays.asList("ID")).build();
        TableConstraints tableConstraintsPk = TableConstraints.newBuilder().setPrimaryKey(primaryKey).build();
        try {
            StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(CONSTRAINTS_TABLE_SCHEMA).setTableConstraints(tableConstraintsPk).build();
            Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTable);
            Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)tableConstraintsPk, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getTableConstraints());
        }
        finally {
            bigquery.delete(tableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrimaryKeyUpdate() {
        String tableName = "test_primary_key_update";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        PrimaryKey primaryKey = PrimaryKey.newBuilder().setColumns(Arrays.asList("FirstName", "LastName")).build();
        TableConstraints tableConstraintsPk = TableConstraints.newBuilder().setPrimaryKey(primaryKey).build();
        try {
            StandardTableDefinition tableDefinition = StandardTableDefinition.newBuilder().setSchema(CONSTRAINTS_TABLE_SCHEMA).build();
            Table createdTable = bigquery.create(TableInfo.of((TableId)tableId, (TableDefinition)tableDefinition), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTable);
            Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
            Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getTableConstraints());
            Table updatedTable = remoteTable.toBuilder().setTableConstraints(tableConstraintsPk).build().update(new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)updatedTable);
            Table remoteUpdatedTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)tableConstraintsPk, (Object)((StandardTableDefinition)remoteUpdatedTable.getDefinition()).getTableConstraints());
        }
        finally {
            bigquery.delete(tableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForeignKeys() {
        String tableNamePk = "test_foreign_key";
        String tableNameFk = "test_foreign_key2";
        TableId tableIdPk = TableId.of((String)PROJECT_ID, (String)DATASET, (String)tableNamePk);
        TableId tableIdFk = TableId.of((String)DATASET, (String)tableNameFk);
        ColumnReference columnReference = ColumnReference.newBuilder().setReferencingColumn("ID").setReferencedColumn("ID").build();
        PrimaryKey primaryKey = PrimaryKey.newBuilder().setColumns(Collections.singletonList("ID")).build();
        TableConstraints tableConstraintsPk = TableConstraints.newBuilder().setPrimaryKey(primaryKey).build();
        ForeignKey foreignKey = ForeignKey.newBuilder().setName("foreign_key").setReferencedTable(tableIdPk).setColumnReferences(Collections.singletonList(columnReference)).build();
        TableConstraints tableConstraintsFk = TableConstraints.newBuilder().setForeignKeys(Collections.singletonList(foreignKey)).build();
        try {
            StandardTableDefinition tableDefinitionPk = StandardTableDefinition.newBuilder().setSchema(CONSTRAINTS_TABLE_SCHEMA).setTableConstraints(tableConstraintsPk).build();
            Table createdTablePk = bigquery.create(TableInfo.of((TableId)tableIdPk, (TableDefinition)tableDefinitionPk), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTablePk);
            StandardTableDefinition tableDefinitionFk = StandardTableDefinition.newBuilder().setSchema(CONSTRAINTS_TABLE_SCHEMA).setTableConstraints(tableConstraintsFk).build();
            Table createdTableFk = bigquery.create(TableInfo.of((TableId)tableIdFk, (TableDefinition)tableDefinitionFk), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTableFk);
            Table remoteTable = bigquery.getTable(DATASET, tableNameFk, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)tableConstraintsFk, (Object)((StandardTableDefinition)remoteTable.getDefinition()).getTableConstraints());
        }
        finally {
            bigquery.delete(tableIdPk);
            bigquery.delete(tableIdFk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForeignKeysUpdate() {
        String tableNameFk = "test_foreign_key";
        String tableNamePk1 = "test_foreign_key2";
        String tableNamePk2 = "test_foreign_key3";
        TableId tableIdFk = TableId.of((String)DATASET, (String)tableNameFk);
        TableId tableIdPk1 = TableId.of((String)PROJECT_ID, (String)DATASET, (String)tableNamePk1);
        TableId tableIdPk2 = TableId.of((String)PROJECT_ID, (String)DATASET, (String)tableNamePk2);
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        ColumnReference columnReferencePk1 = ColumnReference.newBuilder().setReferencingColumn("ID").setReferencedColumn("ID").build();
        PrimaryKey primaryKey1 = PrimaryKey.newBuilder().setColumns(Collections.singletonList("ID")).build();
        TableConstraints tableConstraintsPk1 = TableConstraints.newBuilder().setPrimaryKey(primaryKey1).build();
        ForeignKey foreignKey1 = ForeignKey.newBuilder().setName("foreign_key1").setReferencedTable(tableIdPk1).setColumnReferences(Collections.singletonList(columnReferencePk1)).build();
        foreignKeys.add(foreignKey1);
        ArrayList<ColumnReference> columnReferencesPk2 = new ArrayList<ColumnReference>();
        columnReferencesPk2.add(ColumnReference.newBuilder().setReferencingColumn("FirstName").setReferencedColumn("FirstName").build());
        columnReferencesPk2.add(ColumnReference.newBuilder().setReferencingColumn("LastName").setReferencedColumn("LastName").build());
        ArrayList<String> primaryKey2Columns = new ArrayList<String>();
        primaryKey2Columns.add("FirstName");
        primaryKey2Columns.add("LastName");
        PrimaryKey primaryKey2 = PrimaryKey.newBuilder().setColumns(primaryKey2Columns).build();
        TableConstraints tableConstraintsPk2 = TableConstraints.newBuilder().setPrimaryKey(primaryKey2).build();
        ForeignKey foreignKey2 = ForeignKey.newBuilder().setName("foreign_key2").setReferencedTable(tableIdPk2).setColumnReferences(columnReferencesPk2).build();
        foreignKeys.add(foreignKey2);
        TableConstraints tableConstraintsFk = TableConstraints.newBuilder().setForeignKeys(foreignKeys).build();
        try {
            StandardTableDefinition tableDefinitionFk = StandardTableDefinition.newBuilder().setSchema(CONSTRAINTS_TABLE_SCHEMA).build();
            Table createdTableFk = bigquery.create(TableInfo.of((TableId)tableIdFk, (TableDefinition)tableDefinitionFk), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTableFk);
            StandardTableDefinition tableDefinitionPk1 = StandardTableDefinition.newBuilder().setSchema(CONSTRAINTS_TABLE_SCHEMA).setTableConstraints(tableConstraintsPk1).build();
            Table createdTablePk1 = bigquery.create(TableInfo.of((TableId)tableIdPk1, (TableDefinition)tableDefinitionPk1), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTablePk1);
            StandardTableDefinition tableDefinitionPk2 = StandardTableDefinition.newBuilder().setSchema(CONSTRAINTS_TABLE_SCHEMA).setTableConstraints(tableConstraintsPk2).build();
            Table createdTablePk2 = bigquery.create(TableInfo.of((TableId)tableIdPk2, (TableDefinition)tableDefinitionPk2), new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)createdTablePk2);
            Table remoteTable = bigquery.getTable(DATASET, tableNameFk, new BigQuery.TableOption[0]);
            Assert.assertNull((Object)((StandardTableDefinition)remoteTable.getDefinition()).getTableConstraints());
            Table updatedTable = remoteTable.toBuilder().setTableConstraints(tableConstraintsFk).build().update(new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)updatedTable);
            Table remoteUpdatedTable = bigquery.getTable(DATASET, tableNameFk, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)tableConstraintsFk, (Object)((StandardTableDefinition)remoteUpdatedTable.getDefinition()).getTableConstraints());
        }
        finally {
            bigquery.delete(tableIdFk);
            bigquery.delete(tableIdPk1);
            bigquery.delete(tableIdPk2);
        }
    }

    @Test
    public void testAlreadyExistJobExceptionHandling() throws InterruptedException {
        block2: {
            String query = "SELECT TimestampField, StringField, BooleanField FROM " + DATASET + "." + TABLE_ID.getTable();
            JobId jobId = JobId.newBuilder().setRandomJob().build();
            QueryJobConfiguration queryJobConfiguration = QueryJobConfiguration.newBuilder((String)query).build();
            bigquery.create(JobInfo.of((JobId)jobId, (JobConfiguration)queryJobConfiguration), new BigQuery.JobOption[0]);
            try {
                bigquery.query(QueryJobConfiguration.newBuilder((String)query).build(), jobId, new BigQuery.JobOption[0]);
                Assert.assertTrue((boolean)true);
            }
            catch (BigQueryException ex) {
                if (ex.getCause() == null || !ex.getCause().getMessage().contains("Already Exists: Job")) break block2;
                Assert.fail((String)"Already exists error should not be thrown");
            }
        }
    }

    @Test
    public void testStatelessQueries() throws InterruptedException {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQuery bigQuery = (BigQuery)bigqueryHelper.getOptions().getService();
        ((BigQueryOptions)bigQuery.getOptions()).setQueryPreviewEnabled("TRUE");
        TableResult tableResult = this.executeSimpleQuery(bigQuery);
        Assert.assertNotNull((Object)tableResult.getQueryId());
        Assert.assertNull((Object)tableResult.getJobId());
        ((BigQueryOptions)bigQuery.getOptions()).setQueryPreviewEnabled("tRuE");
        tableResult = this.executeSimpleQuery(bigQuery);
        Assert.assertNotNull((Object)tableResult.getQueryId());
        Assert.assertNull((Object)tableResult.getJobId());
        ((BigQueryOptions)bigQuery.getOptions()).setQueryPreviewEnabled("test_value");
        tableResult = this.executeSimpleQuery(bigQuery);
        Assert.assertNotNull((Object)tableResult.getQueryId());
        Assert.assertNotNull((Object)tableResult.getJobId());
        ((BigQueryOptions)bigQuery.getOptions()).setQueryPreviewEnabled(null);
        tableResult = this.executeSimpleQuery(bigQuery);
        Assert.assertNotNull((Object)tableResult.getQueryId());
        Assert.assertNotNull((Object)tableResult.getJobId());
    }

    private TableResult executeSimpleQuery(BigQuery bigQuery) throws InterruptedException {
        String query = "SELECT CURRENT_TIMESTAMP() as ts";
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).build();
        TableResult result = bigQuery.query(config, new BigQuery.JobOption[0]);
        return result;
    }

    @Test
    public void testTableResultJobIdAndQueryId() throws InterruptedException {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQuery bigQuery = (BigQuery)bigqueryHelper.getOptions().getService();
        ((BigQueryOptions)bigQuery.getOptions()).setQueryPreviewEnabled("TRUE");
        String query = "SELECT 1 as one";
        QueryJobConfiguration configStateless = QueryJobConfiguration.newBuilder((String)query).build();
        TableResult result = bigQuery.query(configStateless, new BigQuery.JobOption[0]);
        Assert.assertNull((Object)result.getJobId());
        Assert.assertNotNull((Object)result.getQueryId());
        QueryJobConfiguration configQueryWithJob = QueryJobConfiguration.newBuilder((String)query).setJobTimeoutMs(Long.valueOf(1L)).build();
        result = bigQuery.query(configQueryWithJob, new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertNull((Object)result.getQueryId());
        QueryJobConfiguration configWithJob = QueryJobConfiguration.newBuilder((String)query).build();
        Job job = bigQuery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)configWithJob), new BigQuery.JobOption[0]);
        result = job.getQueryResults(new BigQuery.QueryResultsOption[0]);
        Assert.assertNotNull((Object)result.getJobId());
        Assert.assertNull((Object)result.getQueryId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatelessQueriesWithLocation() throws Exception {
        String location = "EU";
        String wrongLocation = "US";
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQuery bigQuery = (BigQuery)bigqueryHelper.getOptions().toBuilder().setLocation(location).build().getService();
        Dataset dataset = bigQuery.create(DatasetInfo.newBuilder((String)("locationset_" + UUID.randomUUID().toString().replace("-", "_"))).setLocation(location).build(), new BigQuery.DatasetOption[0]);
        try {
            TableId tableId = TableId.of((String)dataset.getDatasetId().getDataset(), (String)"sometable");
            Schema schema = Schema.of((Field[])new Field[]{Field.of((String)"name", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0])});
            StandardTableDefinition tableDef = StandardTableDefinition.of((Schema)schema);
            Table table = bigQuery.create(TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDef).build(), new BigQuery.TableOption[0]);
            String query = String.format("SELECT * FROM `%s.%s.%s`", table.getTableId().getProject(), table.getTableId().getDataset(), table.getTableId().getTable());
            ((BigQueryOptions)bigQuery.getOptions()).setQueryPreviewEnabled("TRUE");
            TableResult tb = bigQuery.query(QueryJobConfiguration.of((String)query), new BigQuery.JobOption[0]);
            Assert.assertNull((Object)tb.getJobId());
            try {
                BigQuery bigQueryWrongLocation = (BigQuery)bigqueryHelper.getOptions().toBuilder().setLocation(wrongLocation).build().getService();
                ((BigQueryOptions)bigQueryWrongLocation.getOptions()).setQueryPreviewEnabled("TRUE");
                bigQueryWrongLocation.query(QueryJobConfiguration.of((String)query), new BigQuery.JobOption[0]);
                Assert.fail((String)"querying a table with wrong location shouldn't work");
            }
            catch (BigQueryException bigQueryException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            bigQuery.delete(dataset.getDatasetId(), new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
            throw throwable;
        }
        bigQuery.delete(dataset.getDatasetId(), new BigQuery.DatasetDeleteOption[]{BigQuery.DatasetDeleteOption.deleteContents()});
    }

    @Test
    public void testUniverseDomainWithInvalidUniverseDomain() {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQueryOptions bigQueryOptions = ((BigQueryOptions.Builder)((BigQueryOptions.Builder)bigqueryHelper.getOptions().toBuilder().setCredentials((Credentials)ITBigQueryTest.loadCredentials(FAKE_JSON_CRED_WITH_GOOGLE_DOMAIN))).setUniverseDomain("invalid.domain")).build();
        BigQuery bigQuery = (BigQuery)bigQueryOptions.getService();
        try {
            bigQuery.listDatasets(PUBLIC_PROJECT, new BigQuery.DatasetListOption[0]);
            Assert.fail((String)"RPCs to invalid universe domain should fail");
        }
        catch (BigQueryException e) {
            Assert.assertEquals((long)e.getCode(), (long)401L);
            Assert.assertNotNull((Object)e.getMessage());
            Truth.assertThat((Boolean)e.getMessage().contains("does not match the universe domain found in the credentials")).isTrue();
        }
    }

    @Test
    public void testInvalidUniverseDomainWithMismatchCredentials() {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQueryOptions bigQueryOptions = ((BigQueryOptions.Builder)bigqueryHelper.getOptions().toBuilder().setCredentials((Credentials)ITBigQueryTest.loadCredentials(FAKE_JSON_CRED_WITH_INVALID_DOMAIN))).build();
        BigQuery bigQuery = (BigQuery)bigQueryOptions.getService();
        try {
            bigQuery.listDatasets(PUBLIC_PROJECT, new BigQuery.DatasetListOption[0]);
            Assert.fail((String)"RPCs to invalid universe domain should fail");
        }
        catch (BigQueryException e) {
            Assert.assertEquals((long)e.getCode(), (long)401L);
            Assert.assertNotNull((Object)e.getMessage());
            Truth.assertThat((Boolean)e.getMessage().contains("does not match the universe domain found in the credentials")).isTrue();
        }
    }

    @Test
    public void testUniverseDomainWithMatchingDomain() {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        BigQueryOptions bigQueryOptions = ((BigQueryOptions.Builder)bigqueryHelper.getOptions().toBuilder().setUniverseDomain("googleapis.com")).build();
        BigQuery bigQuery = (BigQuery)bigQueryOptions.getService();
        Page datasets = bigQuery.listDatasets(PUBLIC_PROJECT, new BigQuery.DatasetListOption[0]);
        Iterator iterator = datasets.iterateAll().iterator();
        HashSet<String> datasetNames = new HashSet<String>();
        HashMap<String, String> datasetLocation = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Dataset dataset = (Dataset)iterator.next();
            String name = dataset.getDatasetId().getDataset();
            datasetNames.add(name);
            datasetLocation.put(name, dataset.getLocation());
        }
        for (String type : PUBLIC_DATASETS) {
            Assert.assertTrue((boolean)datasetNames.contains(type));
            Assert.assertEquals((Object)PUBLIC_DATASETS_LOCATION.get(type), datasetLocation.get(type));
        }
    }

    @Test
    public void testExternalTableMetadataCachingNotEnable() throws InterruptedException {
        String tableName = "test_metadata_cache_not_enable";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.of((String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (Schema)TABLE_SCHEMA, (FormatOptions)FormatOptions.json());
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof ExternalTableDefinition));
        Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
        Assert.assertEquals((Object)TABLE_SCHEMA, (Object)remoteTable.getDefinition().getSchema());
        String query = String.format("SELECT * FROM  %s.%s", DATASET, tableName);
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).build();
        Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)config), new BigQuery.JobOption[0]);
        remoteJob = remoteJob.waitFor(new RetryOption[0]);
        Assert.assertNull((Object)remoteJob.getStatus().getError());
        Job queryJob = bigquery.getJob(remoteJob.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
        Assert.assertNotNull((Object)statistics);
        Assert.assertNotNull((Object)statistics.getMetadataCacheStats());
        Truth.assertThat((Integer)statistics.getMetadataCacheStats().getTableMetadataCacheUsage().size()).isEqualTo((Object)1);
        Truth.assertThat((Comparable)((TableMetadataCacheUsage)statistics.getMetadataCacheStats().getTableMetadataCacheUsage().get(0)).getUnusedReason()).isEqualTo((Object)TableMetadataCacheUsage.UnusedReason.METADATA_CACHING_NOT_ENABLED);
        Assert.assertTrue((boolean)remoteTable.delete());
    }

    @Test
    public void testExternalMetadataCacheModeFailForNonBiglake() {
        String tableName = "test_metadata_cache_mode_fail_for_non_biglake";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder((String)("gs://" + BUCKET + "/" + JSON_LOAD_FILE), (Schema)TABLE_SCHEMA, (FormatOptions)FormatOptions.json()).setMetadataCacheMode("AUTOMATIC").build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        try {
            bigquery.create(tableInfo, new BigQuery.TableOption[0]);
            Assert.fail((String)"BigQueryException was expected");
        }
        catch (BigQueryException e) {
            BigQueryError error = e.getError();
            Assert.assertNotNull((Object)error);
            Assert.assertEquals((Object)"invalid", (Object)error.getReason());
            Truth.assertThat((Boolean)e.getMessage().contains("metadataCacheMode provided for non BigLake external table")).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObjectTable() throws InterruptedException {
        String tableName = "test_object_table";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        String sourceUri = "gs://" + BUCKET + "/" + JSON_LOAD_FILE;
        ExternalTableDefinition externalTableDefinition = ExternalTableDefinition.newBuilder((String)sourceUri).setConnectionId("projects/java-docs-samples-testing/locations/us/connections/DEVREL_TEST_CONNECTION").setObjectMetadata("SIMPLE").build();
        TableInfo tableInfo = TableInfo.of((TableId)tableId, (TableDefinition)externalTableDefinition);
        Table createdTable = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)createdTable);
        Assert.assertEquals((Object)DATASET, (Object)createdTable.getTableId().getDataset());
        Assert.assertEquals((Object)tableName, (Object)createdTable.getTableId().getTable());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        try {
            Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof ExternalTableDefinition));
            Assert.assertEquals((Object)createdTable.getTableId(), (Object)remoteTable.getTableId());
            Assert.assertEquals((Object)"SIMPLE", (Object)((ExternalTableDefinition)remoteTable.getDefinition()).getObjectMetadata());
            Assert.assertNotNull((Object)remoteTable.getDefinition().getSchema().getFields().get("uri"));
            String query = String.format("SELECT * FROM  %s.%s", DATASET, tableName);
            QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).build();
            Job remoteJob = bigquery.create(JobInfo.of((JobConfiguration)config), new BigQuery.JobOption[0]);
            remoteJob = remoteJob.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)remoteJob.getStatus().getError());
            Job queryJob = bigquery.getJob(remoteJob.getJobId(), new BigQuery.JobOption[0]);
            JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)queryJob.getStatistics();
            Assert.assertNotNull((Object)statistics);
            Truth.assertThat((Long)statistics.getTotalBytesProcessed()).isGreaterThan(0);
        }
        finally {
            Assert.assertTrue((boolean)remoteTable.delete());
        }
    }

    static GoogleCredentials loadCredentials(String credentialFile) {
        try {
            ByteArrayInputStream keyStream = new ByteArrayInputStream(credentialFile.getBytes());
            return GoogleCredentials.fromStream((InputStream)keyStream);
        }
        catch (IOException e) {
            Assert.fail((String)"Couldn't create fake JSON credentials.");
            return null;
        }
    }

    @Test
    public void testQueryExportStatistics() throws InterruptedException {
        String query = String.format("EXPORT DATA OPTIONS(\n  uri='gs://%s/*.csv',\n  format='CSV',\n  overwrite=true,\n  header=true,\n  field_delimiter=';') AS\nSELECT num FROM UNNEST([1,2,3]) AS num", BUCKET);
        QueryJobConfiguration config = QueryJobConfiguration.newBuilder((String)query).setDefaultDataset(DatasetId.of((String)DATASET)).build();
        Job job = bigquery.create(JobInfo.of((JobId)JobId.of(), (JobConfiguration)config), new BigQuery.JobOption[0]);
        job = job.waitFor(new RetryOption[0]);
        JobStatistics.QueryStatistics queryStatistics = (JobStatistics.QueryStatistics)job.getStatistics();
        Assert.assertNotNull((Object)queryStatistics);
        Assert.assertNotNull((Object)queryStatistics.getExportDataStats());
        Assert.assertEquals((long)1L, (long)queryStatistics.getExportDataStats().getFileCount());
        Assert.assertEquals((long)3L, (long)queryStatistics.getExportDataStats().getRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadConfigurationFlexibleColumnName() throws InterruptedException {
        String v1TableName = "flexible_column_name_data_testing_table_v1";
        TableId v1TableId = TableId.of((String)DATASET, (String)v1TableName);
        try {
            LoadJobConfiguration loadJobConfigurationV1 = LoadJobConfiguration.newBuilder((TableId)v1TableId, (String)("gs://" + BUCKET + "/" + LOAD_FILE_FLEXIBLE_COLUMN_NAME), (FormatOptions)FormatOptions.csv()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setAutodetect(Boolean.valueOf(true)).setColumnNameCharacterMap("V1").build();
            Job jobV1 = bigquery.create(JobInfo.of((JobConfiguration)loadJobConfigurationV1), new BigQuery.JobOption[0]);
            jobV1 = jobV1.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)jobV1.getStatus().getError());
            Table remoteTableV1 = bigquery.getTable(DATASET, v1TableName, new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)remoteTableV1);
            Assert.assertEquals((Object)"_ampersand", (Object)remoteTableV1.getDefinition().getSchema().getFields().get(1).getName());
        }
        finally {
            bigquery.delete(v1TableId);
        }
        String v2TableName = "flexible_column_name_data_testing_table_v2";
        TableId v2TableId = TableId.of((String)DATASET, (String)v2TableName);
        try {
            LoadJobConfiguration loadJobConfigurationV2 = LoadJobConfiguration.newBuilder((TableId)v2TableId, (String)("gs://" + BUCKET + "/" + LOAD_FILE_FLEXIBLE_COLUMN_NAME), (FormatOptions)FormatOptions.csv()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setAutodetect(Boolean.valueOf(true)).setColumnNameCharacterMap("V2").build();
            Job jobV2 = bigquery.create(JobInfo.of((JobConfiguration)loadJobConfigurationV2), new BigQuery.JobOption[0]);
            jobV2 = jobV2.waitFor(new RetryOption[0]);
            Assert.assertNull((Object)jobV2.getStatus().getError());
            Table remoteTableV2 = bigquery.getTable(DATASET, v2TableName, new BigQuery.TableOption[0]);
            Assert.assertNotNull((Object)remoteTableV2);
            Assert.assertEquals((Object)"&ampersand", (Object)remoteTableV2.getDefinition().getSchema().getFields().get(1).getName());
        }
        finally {
            bigquery.delete(v2TableId);
        }
    }

    @Test
    public void testStatementType() throws InterruptedException {
        String tableName = "test_materialized_view_table_statemnt_type";
        String createQuery = String.format("CREATE MATERIALIZED VIEW %s.%s.%s AS (SELECT MAX(TimestampField) AS TimestampField,StringField, MAX(BooleanField) AS BooleanField FROM %s.%s.%s GROUP BY StringField)", PROJECT_ID, DATASET, tableName, PROJECT_ID, DATASET, TABLE_ID.getTable());
        TableResult result = bigquery.query(QueryJobConfiguration.of((String)createQuery), new BigQuery.JobOption[0]);
        Assert.assertNotNull((Object)result);
        Job job = bigquery.getJob(result.getJobId(), new BigQuery.JobOption[0]);
        JobStatistics.QueryStatistics stats = (JobStatistics.QueryStatistics)job.getStatistics();
        Assert.assertEquals((Object)JobStatistics.QueryStatistics.StatementType.CREATE_MATERIALIZED_VIEW, (Object)stats.getStatementType());
        Table remoteTable = bigquery.getTable(DATASET, tableName, new BigQuery.TableOption[0]);
        Assert.assertNotNull((Object)remoteTable);
        Assert.assertTrue((boolean)(remoteTable.getDefinition() instanceof MaterializedViewDefinition));
        Assert.assertTrue((boolean)remoteTable.delete());
    }
}

