/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.it;

import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryResult;
import com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.bigquery.Connection;
import com.google.cloud.bigquery.ConnectionSettings;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Parameter;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ITNightlyBigQueryTest {
    private static final Logger logger = Logger.getLogger(ITNightlyBigQueryTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String TABLE = "TEMP_RS_TEST_TABLE";
    private static final byte[] BYTES = "TestByteValue".getBytes(StandardCharsets.UTF_8);
    private static final String BYTES_BASE64 = BaseEncoding.base64().encode(BYTES);
    private static final int NUM_BATCHES = 55;
    private static final int REC_PER_BATCHES = 10000;
    private static final int LIMIT_RECS = 500000;
    private static final int MULTI_LIMIT_RECS = 300000;
    private static int rowCnt = 0;
    private static BigQuery bigquery;
    private static final String BASE_QUERY = "select StringField, GeographyField, BooleanField, BigNumericField, IntegerField, NumericField, BytesField,  TimestampField, TimeField, DateField, IntegerArrayField,  RecordField.BooleanField, RecordField.StringField , JSONField, JSONField.hello, JSONField.id from %s.%s order by IntegerField asc LIMIT %s";
    private static final String POSITIONAL_QUERY;
    private static final String QUERY;
    private static final String MULTI_QUERY;
    private static final String INVALID_QUERY;
    private static final Schema BQ_SCHEMA;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)1800L);

    @BeforeClass
    public static void beforeClass() throws InterruptedException, IOException {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        ITNightlyBigQueryTest.createDataset(DATASET);
        ITNightlyBigQueryTest.createTable(DATASET, TABLE, BQ_SCHEMA);
        ITNightlyBigQueryTest.populateTestRecords(DATASET, TABLE);
    }

    @AfterClass
    public static void afterClass() throws ExecutionException, InterruptedException {
        try {
            if (bigquery != null) {
                ITNightlyBigQueryTest.deleteTable(DATASET, TABLE);
                RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
            } else {
                Assert.fail((String)"Error clearing the test dataset");
            }
        }
        catch (BigQueryException e) {
            Assert.fail((String)("Error clearing the test dataset " + (Object)((Object)e)));
        }
    }

    @Test
    public void testInvalidQuery() throws BigQuerySQLException {
        try (Connection connection = this.getConnection();){
            BigQueryResult bigQueryResult = connection.executeSelect(INVALID_QUERY);
            Assert.fail((String)"BigQuerySQLException was expected");
        }
    }

    @Test
    public void testIterateAndOrder() throws SQLException {
        Connection connection = this.getConnection();
        BigQueryResult bigQueryResult = connection.executeSelect(QUERY);
        logger.log(Level.INFO, "Query used: {0}", QUERY);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        int prevIntegerFieldVal = 0;
        while (rs.next()) {
            if (cnt == 0) {
                Assert.assertNull((Object)rs.getString("StringField"));
                Assert.assertNull((Object)rs.getString("GeographyField"));
                Object intAryField = rs.getObject("IntegerArrayField");
                if (intAryField instanceof JsonStringArrayList) {
                    Assert.assertEquals((Object)new JsonStringArrayList(), (Object)((JsonStringArrayList)intAryField));
                }
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField"));
                Assert.assertTrue((0.0 == rs.getDouble("BigNumericField") ? 1 : 0) != 0);
                Assert.assertTrue((0 == rs.getInt("IntegerField") ? 1 : 0) != 0);
                Assert.assertTrue((0L == rs.getLong("NumericField") ? 1 : 0) != 0);
                Assert.assertNull((Object)rs.getBytes("BytesField"));
                Assert.assertNull((Object)rs.getTimestamp("TimestampField"));
                Assert.assertNull((Object)rs.getTime("TimeField"));
                Assert.assertNull((Object)rs.getDate("DateField"));
                Assert.assertNull((Object)rs.getString("JSONField"));
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
                Assert.assertNull((Object)rs.getString("StringField_1"));
                Assert.assertNull((Object)rs.getString("hello"));
                Assert.assertEquals((long)0L, (long)rs.getInt("id"));
            } else {
                Assert.assertNotNull((Object)rs.getString("StringField"));
                Assert.assertNotNull((Object)rs.getString("GeographyField"));
                Assert.assertNotNull((Object)rs.getObject("IntegerArrayField"));
                Assert.assertTrue((boolean)rs.getBoolean("BooleanField"));
                Assert.assertTrue((0.0 < rs.getDouble("BigNumericField") ? 1 : 0) != 0);
                Assert.assertTrue((0 < rs.getInt("IntegerField") ? 1 : 0) != 0);
                Assert.assertTrue((0L < rs.getLong("NumericField") ? 1 : 0) != 0);
                Assert.assertNotNull((Object)rs.getBytes("BytesField"));
                Assert.assertNotNull((Object)rs.getTimestamp("TimestampField"));
                Assert.assertNotNull((Object)rs.getTime("TimeField"));
                Assert.assertNotNull((Object)rs.getDate("DateField"));
                Assert.assertNotNull((Object)rs.getString("JSONField"));
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
                Assert.assertNotNull((Object)rs.getString("StringField_1"));
                Assert.assertTrue((prevIntegerFieldVal < rs.getInt("IntegerField") ? 1 : 0) != 0);
                prevIntegerFieldVal = rs.getInt("IntegerField");
                ITNightlyBigQueryTest.testForAllDataTypeValues(rs, cnt);
            }
            ++cnt;
        }
        Assert.assertEquals((long)500000L, (long)cnt);
        connection.close();
    }

    @Test
    public void testIterateAndOrderDefaultConnSettings() throws SQLException {
        Connection connection = bigquery.createConnection();
        BigQueryResult bigQueryResult = connection.executeSelect(QUERY);
        logger.log(Level.INFO, "Query used: {0}", QUERY);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        int prevIntegerFieldVal = 0;
        while (rs.next()) {
            if (cnt == 0) {
                Assert.assertNull((Object)rs.getString("StringField"));
                Assert.assertNull((Object)rs.getString("GeographyField"));
                Object intAryField = rs.getObject("IntegerArrayField");
                if (intAryField instanceof JsonStringArrayList) {
                    Assert.assertEquals((Object)new JsonStringArrayList(), (Object)((JsonStringArrayList)intAryField));
                }
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField"));
                Assert.assertTrue((0.0 == rs.getDouble("BigNumericField") ? 1 : 0) != 0);
                Assert.assertTrue((0 == rs.getInt("IntegerField") ? 1 : 0) != 0);
                Assert.assertTrue((0L == rs.getLong("NumericField") ? 1 : 0) != 0);
                Assert.assertNull((Object)rs.getBytes("BytesField"));
                Assert.assertNull((Object)rs.getTimestamp("TimestampField"));
                Assert.assertNull((Object)rs.getTime("TimeField"));
                Assert.assertNull((Object)rs.getDate("DateField"));
                Assert.assertNull((Object)rs.getString("JSONField"));
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
                Assert.assertNull((Object)rs.getString("StringField_1"));
                Assert.assertNull((Object)rs.getString("hello"));
                Assert.assertEquals((long)0L, (long)rs.getInt("id"));
            } else {
                Assert.assertNotNull((Object)rs.getString("StringField"));
                Assert.assertNotNull((Object)rs.getString("GeographyField"));
                Assert.assertNotNull((Object)rs.getObject("IntegerArrayField"));
                Assert.assertTrue((boolean)rs.getBoolean("BooleanField"));
                Assert.assertTrue((0.0 < rs.getDouble("BigNumericField") ? 1 : 0) != 0);
                Assert.assertTrue((0 < rs.getInt("IntegerField") ? 1 : 0) != 0);
                Assert.assertTrue((0L < rs.getLong("NumericField") ? 1 : 0) != 0);
                Assert.assertNotNull((Object)rs.getBytes("BytesField"));
                Assert.assertNotNull((Object)rs.getTimestamp("TimestampField"));
                Assert.assertNotNull((Object)rs.getTime("TimeField"));
                Assert.assertNotNull((Object)rs.getDate("DateField"));
                Assert.assertNotNull((Object)rs.getString("JSONField"));
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
                Assert.assertNotNull((Object)rs.getString("StringField_1"));
                Assert.assertTrue((prevIntegerFieldVal < rs.getInt("IntegerField") ? 1 : 0) != 0);
                prevIntegerFieldVal = rs.getInt("IntegerField");
                ITNightlyBigQueryTest.testForAllDataTypeValues(rs, cnt);
            }
            ++cnt;
        }
        Assert.assertEquals((long)500000L, (long)cnt);
        Assert.assertTrue((boolean)connection.close());
    }

    @Test
    public void testConnectionClose() throws SQLException {
        Connection connection = bigquery.createConnection();
        Assert.assertNotNull((String)"bigquery.createConnection() returned null", (Object)connection);
        BigQueryResult bigQueryResult = connection.executeSelect(QUERY);
        logger.log(Level.INFO, "Query used: {0}", QUERY);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            if (++cnt != 50000) continue;
            Assert.assertTrue((boolean)connection.close());
        }
        Assert.assertTrue((500000 > cnt ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleRuns() throws SQLException {
        Object intAryField;
        Connection connection = this.getConnection();
        BigQueryResult bigQueryResult = connection.executeSelect(MULTI_QUERY);
        logger.log(Level.INFO, "Query used: {0}", MULTI_QUERY);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        int totalCnt = 0;
        int prevIntegerFieldVal = 0;
        while (rs.next()) {
            if (cnt == 0) {
                Assert.assertNull((Object)rs.getString("StringField"));
                Assert.assertNull((Object)rs.getString("GeographyField"));
                intAryField = rs.getObject("IntegerArrayField");
                if (intAryField instanceof JsonStringArrayList) {
                    Assert.assertEquals((Object)new JsonStringArrayList(), (Object)((JsonStringArrayList)intAryField));
                }
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField"));
                Assert.assertTrue((0.0 == rs.getDouble("BigNumericField") ? 1 : 0) != 0);
                Assert.assertTrue((0 == rs.getInt("IntegerField") ? 1 : 0) != 0);
                Assert.assertTrue((0L == rs.getLong("NumericField") ? 1 : 0) != 0);
                Assert.assertNull((Object)rs.getBytes("BytesField"));
                Assert.assertNull((Object)rs.getTimestamp("TimestampField"));
                Assert.assertNull((Object)rs.getTime("TimeField"));
                Assert.assertNull((Object)rs.getDate("DateField"));
                Assert.assertNull((Object)rs.getString("JSONField"));
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
                Assert.assertNull((Object)rs.getString("StringField_1"));
                Assert.assertNull((Object)rs.getString("hello"));
                Assert.assertEquals((long)0L, (long)rs.getInt("id"));
            } else {
                Assert.assertTrue((prevIntegerFieldVal < rs.getInt("IntegerField") ? 1 : 0) != 0);
                prevIntegerFieldVal = rs.getInt("IntegerField");
                ITNightlyBigQueryTest.testForAllDataTypeValues(rs, cnt);
            }
            ++cnt;
        }
        connection.close();
        totalCnt += cnt;
        connection = this.getConnection();
        bigQueryResult = connection.executeSelect(MULTI_QUERY);
        rs = bigQueryResult.getResultSet();
        cnt = 0;
        prevIntegerFieldVal = 0;
        while (rs.next()) {
            if (cnt == 0) {
                Assert.assertNull((Object)rs.getString("StringField"));
                Assert.assertNull((Object)rs.getString("GeographyField"));
                intAryField = rs.getObject("IntegerArrayField");
                if (intAryField instanceof JsonStringArrayList) {
                    Assert.assertEquals((Object)new JsonStringArrayList(), (Object)((JsonStringArrayList)intAryField));
                }
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField"));
                Assert.assertTrue((0.0 == rs.getDouble("BigNumericField") ? 1 : 0) != 0);
                Assert.assertTrue((0 == rs.getInt("IntegerField") ? 1 : 0) != 0);
                Assert.assertTrue((0L == rs.getLong("NumericField") ? 1 : 0) != 0);
                Assert.assertNull((Object)rs.getBytes("BytesField"));
                Assert.assertNull((Object)rs.getTimestamp("TimestampField"));
                Assert.assertNull((Object)rs.getTime("TimeField"));
                Assert.assertNull((Object)rs.getDate("DateField"));
                Assert.assertNull((Object)rs.getString("JSONField"));
                Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
                Assert.assertNull((Object)rs.getString("StringField_1"));
                Assert.assertNull((Object)rs.getString("hello"));
                Assert.assertEquals((long)0L, (long)rs.getInt("id"));
            } else {
                Assert.assertTrue((prevIntegerFieldVal < rs.getInt("IntegerField") ? 1 : 0) != 0);
                prevIntegerFieldVal = rs.getInt("IntegerField");
                ITNightlyBigQueryTest.testForAllDataTypeValues(rs, cnt);
            }
            ++cnt;
        }
        connection.close();
        Assert.assertEquals((long)600000L, (long)(totalCnt += cnt));
    }

    @Test
    public void testPositionalParams() throws SQLException {
        Connection connection = this.getConnection();
        Parameter dateParam = Parameter.newBuilder().setValue(QueryParameterValue.date((String)"2022-01-01")).build();
        Parameter boolParam = Parameter.newBuilder().setValue(QueryParameterValue.bool((Boolean)true)).build();
        Parameter intParam = Parameter.newBuilder().setValue(QueryParameterValue.int64((Integer)1)).build();
        Parameter numericParam = Parameter.newBuilder().setValue(QueryParameterValue.numeric((BigDecimal)new BigDecimal(100))).build();
        ImmutableList parameters = ImmutableList.of((Object)dateParam, (Object)boolParam, (Object)intParam, (Object)numericParam);
        BigQueryResult bigQueryResult = connection.executeSelect(POSITIONAL_QUERY, (List)parameters, new Map[0]);
        logger.log(Level.INFO, "Query used: {0}", POSITIONAL_QUERY);
        ResultSet rs = bigQueryResult.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            Assert.assertFalse((boolean)rs.getBoolean("BooleanField"));
            Assert.assertTrue((0.0 <= rs.getDouble("BigNumericField") ? 1 : 0) != 0);
            Assert.assertTrue((0 <= rs.getInt("IntegerField") ? 1 : 0) != 0);
            Assert.assertTrue((0L <= rs.getLong("NumericField") ? 1 : 0) != 0);
            Assert.assertNotNull((Object)rs.getBytes("BytesField"));
            Assert.assertNotNull((Object)rs.getTimestamp("TimestampField"));
            Assert.assertNotNull((Object)rs.getTime("TimeField"));
            Assert.assertNotNull((Object)rs.getDate("DateField"));
            Assert.assertNotNull((Object)rs.getString("JSONField"));
            Assert.assertTrue((boolean)rs.getBoolean("BooleanField_1"));
            Assert.assertNotNull((Object)rs.getString("StringField_1"));
            ++cnt;
        }
        connection.close();
        Assert.assertEquals((long)300000L, (long)cnt);
    }

    @Test
    public void testForTableNotFound() throws SQLException {
        int recordCnt = 50000000;
        String query = String.format("SELECT * FROM `bigquery-samples.wikipedia_benchmark.Wiki10B` LIMIT %s", recordCnt);
        logger.log(Level.INFO, "Query used: {0}", query);
        String dataSet = RemoteBigQueryHelper.generateDatasetName();
        String table = "TAB_" + UUID.randomUUID();
        ITNightlyBigQueryTest.createDataset(dataSet);
        TableId targetTable = TableId.of((String)ServiceOptions.getDefaultProjectId(), (String)dataSet, (String)table);
        ConnectionSettings conSet = ConnectionSettings.newBuilder().setUseReadAPI(Boolean.valueOf(true)).setDestinationTable(targetTable).setAllowLargeResults(Boolean.valueOf(true)).build();
        Connection connection = ((BigQuery)BigQueryOptions.getDefaultInstance().getService()).createConnection(conSet);
        BigQueryResult bigQueryResultSet = connection.executeSelect(query);
        Assert.assertNotNull((Object)this.getResultHashWiki(bigQueryResultSet));
        Assert.assertTrue(((long)recordCnt == bigQueryResultSet.getTotalRows() || -1L == bigQueryResultSet.getTotalRows() ? 1 : 0) != 0);
        try {
            ITNightlyBigQueryTest.deleteTable(dataSet, table);
            ITNightlyBigQueryTest.deleteDataset(dataSet);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, String.format("Error [ %s ] while deleting dataset: %s , table: %s", e.getMessage(), dataSet, table));
        }
    }

    private Long getResultHashWiki(BigQueryResult bigQueryResultSet) throws SQLException {
        ResultSet rs = bigQueryResultSet.getResultSet();
        long hash = 0L;
        System.out.print("\n Running");
        while (rs.next()) {
            hash += rs.getString("title") == null ? 0L : (long)rs.getString("title").hashCode();
        }
        return hash;
    }

    private static void testForAllDataTypeValues(ResultSet rs, int cnt) throws SQLException {
        Assert.assertEquals((Object)"\"world\"", (Object)rs.getString("hello"));
        Assert.assertEquals((long)100L, (long)rs.getInt("id"));
        Assert.assertEquals((Object)"{\"hello\":\"world\",\"id\":100}", (Object)rs.getString("JSONField"));
        Assert.assertEquals((Object)String.format("String Val %s", cnt), (Object)rs.getString("StringField"));
        Assert.assertEquals((Object)"POINT(1 2)", (Object)rs.getString("GeographyField"));
        if (rs.getObject("IntegerArrayField") instanceof JsonStringArrayList) {
            JsonStringArrayList ary = (JsonStringArrayList)rs.getObject("IntegerArrayField");
            Assert.assertEquals((long)3L, (long)ary.size());
            Assert.assertEquals((long)1L, (long)((BigDecimal)ary.get(0)).intValue());
            Assert.assertEquals((long)2L, (long)((BigDecimal)ary.get(1)).intValue());
            Assert.assertEquals((long)3L, (long)((BigDecimal)ary.get(2)).intValue());
        }
        Assert.assertTrue(((double)(10000000L + (long)cnt) == rs.getDouble("BigNumericField") ? 1 : 0) != 0);
        Assert.assertEquals((long)(1 + cnt), (long)rs.getInt("IntegerField"));
        Assert.assertEquals((long)(100 + cnt), (long)rs.getLong("NumericField"));
        Assert.assertEquals((Object)"TestByteValue", (Object)new String(rs.getBytes("BytesField"), StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)rs.getBoolean("BooleanField_1"));
        Assert.assertEquals((Object)String.format("Str Val %s", cnt), (Object)rs.getString("StringField_1"));
        Assert.assertEquals((long)1649064795000L, (long)rs.getTimestamp("TimestampField").getTime());
        Assert.assertEquals((Object)Date.valueOf("2022-01-01").toString(), (Object)rs.getDate("DateField").toString());
        int offset = TimeZone.getTimeZone(ZoneId.systemDefault()).getOffset(new java.util.Date().getTime());
        Assert.assertEquals((long)(Time.valueOf(LocalTime.of(12, 11, 35)).getTime() + (long)offset), (long)rs.getTime("TimeField").getTime());
    }

    private static void populateTestRecords(String datasetName, String tableName) {
        TableId tableId = TableId.of((String)datasetName, (String)tableName);
        for (int batchCnt = 1; batchCnt <= 55; ++batchCnt) {
            ITNightlyBigQueryTest.addBatchRecords(tableId);
        }
    }

    private static void addBatchRecords(TableId tableId) {
        HashMap nullRow = new HashMap();
        try {
            InsertAllRequest.Builder reqBuilder = InsertAllRequest.newBuilder((TableId)tableId);
            if (rowCnt == 0) {
                reqBuilder.addRow(nullRow);
            }
            for (int i = 0; i < 10000; ++i) {
                reqBuilder.addRow(ITNightlyBigQueryTest.getNextRow());
            }
            InsertAllResponse response = bigquery.insertAll(reqBuilder.build());
            if (response.hasErrors()) {
                for (Map.Entry entry : response.getInsertErrors().entrySet()) {
                    logger.log(Level.WARNING, "Exception while adding records {0}", entry.getValue());
                }
                Assert.fail((String)"Response has errors");
            }
        }
        catch (BigQueryException e) {
            logger.log(Level.WARNING, "Exception while adding records {0}", e);
            Assert.fail((String)"Error in addBatchRecords");
        }
    }

    private static void createTable(String datasetName, String tableName, Schema schema) {
        try {
            TableId tableId = TableId.of((String)datasetName, (String)tableName);
            StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)schema);
            TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
            Table table = bigquery.create(tableInfo, new BigQuery.TableOption[0]);
            Assert.assertTrue((boolean)table.exists());
        }
        catch (BigQueryException e) {
            Assert.fail((String)("Table was not created. \n" + (Object)((Object)e)));
        }
    }

    public static void deleteTable(String datasetName, String tableName) {
        try {
            Assert.assertTrue((boolean)bigquery.delete(TableId.of((String)datasetName, (String)tableName)));
        }
        catch (BigQueryException e) {
            Assert.fail((String)("Table was not deleted. \n" + (Object)((Object)e)));
        }
    }

    public static void createDataset(String datasetName) {
        try {
            DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)datasetName).build();
            Dataset newDataset = bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
            Assert.assertNotNull((Object)newDataset.getDatasetId().getDataset());
        }
        catch (BigQueryException e) {
            Assert.fail((String)("Dataset was not created. \n" + (Object)((Object)e)));
        }
    }

    public static void deleteDataset(String datasetName) {
        try {
            DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)datasetName).build();
            Assert.assertTrue((boolean)bigquery.delete(datasetInfo.getDatasetId(), new BigQuery.DatasetDeleteOption[0]));
        }
        catch (BigQueryException e) {
            Assert.fail((String)("Dataset was not deleted. \n" + (Object)((Object)e)));
        }
    }

    private Connection getConnection() {
        ConnectionSettings connectionSettings = ConnectionSettings.newBuilder().setDefaultDataset(DatasetId.of((String)DATASET)).build();
        return bigquery.createConnection(connectionSettings);
    }

    private static Map<String, Object> getNextRow() {
        HashMap<String, Object> row = new HashMap<String, Object>();
        HashMap<String, Object> structVal = new HashMap<String, Object>();
        structVal.put("StringField", "Str Val " + ++rowCnt);
        structVal.put("BooleanField", false);
        row.put("RecordField", structVal);
        row.put("TimestampField", "2022-04-04 15:03:15.000 +05:30");
        row.put("StringField", "String Val " + rowCnt);
        row.put("IntegerArrayField", new int[]{1, 2, 3});
        row.put("BooleanField", true);
        row.put("BytesField", BYTES_BASE64);
        row.put("IntegerField", 1 + rowCnt);
        row.put("GeographyField", "POINT(1 2)");
        row.put("NumericField", 100 + rowCnt);
        row.put("BigNumericField", 10000000L + (long)rowCnt);
        row.put("TimeField", "12:11:35");
        row.put("DateField", "2022-01-01");
        row.put("JSONField", "{\"hello\":\"world\",\"id\":100}");
        row.put("IntervalField", "10000-0 3660000 87840000:0:0");
        return row;
    }

    static {
        POSITIONAL_QUERY = String.format("select RecordField.BooleanField, RecordField.StringField, StringField, BooleanField, BytesField, IntegerField, GeographyField, NumericField, BigNumericField, TimeField, DateField, TimestampField, JSONField from %s.%s where DateField = ? and BooleanField = ? and IntegerField > ? and NumericField > ? LIMIT %s", DATASET, TABLE, 300000);
        QUERY = String.format(BASE_QUERY, DATASET, TABLE, 500000);
        MULTI_QUERY = String.format(BASE_QUERY, DATASET, TABLE, 300000);
        INVALID_QUERY = String.format("select into %s.%s order by IntegerField asc LIMIT %s", DATASET, TABLE, 500000);
        BQ_SCHEMA = Schema.of((Field[])new Field[]{Field.newBuilder((String)"TimestampField", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("TimestampDescription").build(), Field.newBuilder((String)"StringField", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("StringDescription").build(), Field.newBuilder((String)"IntegerArrayField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).setDescription("IntegerArrayDescription").build(), Field.newBuilder((String)"BooleanField", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BooleanDescription").build(), Field.newBuilder((String)"BytesField", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BytesDescription").build(), Field.newBuilder((String)"RecordField", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.newBuilder((String)"StringField", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("StringDescription").build(), Field.newBuilder((String)"BooleanField", (StandardSQLTypeName)StandardSQLTypeName.BOOL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BooleanDescription").build()}).setMode(Field.Mode.NULLABLE).setDescription("RecordDescription").build(), Field.newBuilder((String)"IntegerField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("IntegerDescription").build(), Field.newBuilder((String)"GeographyField", (StandardSQLTypeName)StandardSQLTypeName.GEOGRAPHY, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("GeographyDescription").build(), Field.newBuilder((String)"NumericField", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("NumericDescription").build(), Field.newBuilder((String)"BigNumericField", (StandardSQLTypeName)StandardSQLTypeName.BIGNUMERIC, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("BigNumericDescription").build(), Field.newBuilder((String)"TimeField", (StandardSQLTypeName)StandardSQLTypeName.TIME, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("TimeDescription").build(), Field.newBuilder((String)"DateField", (StandardSQLTypeName)StandardSQLTypeName.DATE, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("DateDescription").build(), Field.newBuilder((String)"JSONField", (StandardSQLTypeName)StandardSQLTypeName.JSON, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("JSONFieldDescription").build(), Field.newBuilder((String)"IntervalField", (StandardSQLTypeName)StandardSQLTypeName.INTERVAL, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).setDescription("IntervalFieldDescription").build()});
    }
}

