/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.it;

import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.RemoteFunctionOptions;
import com.google.cloud.bigquery.Routine;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.connection.v1.CloudResourceProperties;
import com.google.cloud.bigquery.connection.v1.Connection;
import com.google.cloud.bigquery.connection.v1.CreateConnectionRequest;
import com.google.cloud.bigquery.connection.v1.DeleteConnectionRequest;
import com.google.cloud.bigquery.connection.v1.LocationName;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.cloud.bigqueryconnection.v1.ConnectionServiceClient;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITRemoteUDFTest {
    private static final String ID = UUID.randomUUID().toString().substring(0, 8);
    private static final String PROJECT_ID = ServiceOptions.getDefaultProjectId();
    private static final String CONNECTION_ID = "test-connection-id-" + ID;
    private static final String LOCATION = "US";
    private static final String PARENT = LocationName.of((String)PROJECT_ID, (String)"US").toString();
    private static final String REMOTE_ENDPOINT = "https://aaabbbccc-uc.a.run.app";
    private static final String ROUTINE_DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static ConnectionServiceClient client;
    private static Connection connection;
    private static BigQuery bigquery;

    @Before
    public void setUp() throws IOException {
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        client = ConnectionServiceClient.create();
        DatasetInfo info = DatasetInfo.newBuilder((String)ROUTINE_DATASET).setDescription("java routine lifecycle").build();
        bigquery.create(info, new BigQuery.DatasetOption[0]);
        CloudResourceProperties cloudResourceProperties = CloudResourceProperties.newBuilder().build();
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(PARENT).setConnection(Connection.newBuilder().setCloudResource(cloudResourceProperties).build()).setConnectionId(CONNECTION_ID).build();
        connection = client.createConnection(request);
    }

    @AfterClass
    public static void afterClass() {
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)ROUTINE_DATASET);
        }
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(connection.getName()).build();
        client.deleteConnection(request);
        client.close();
    }

    @Test
    public void testRoutineRemoteUDF() {
        String routineName = RemoteBigQueryHelper.generateRoutineName();
        RoutineId routineId = RoutineId.of((String)ROUTINE_DATASET, (String)routineName);
        HashMap<String, String> userDefinedContext = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        RemoteFunctionOptions remoteFunctionOptions = RemoteFunctionOptions.newBuilder().setEndpoint(REMOTE_ENDPOINT).setConnection(connection.getName()).setMaxBatchingRows(Long.valueOf(30L)).setUserDefinedContext((Map)userDefinedContext).build();
        RoutineInfo routineInfo = RoutineInfo.newBuilder((RoutineId)routineId).setRoutineType("SCALAR_FUNCTION").setArguments((List)ImmutableList.of((Object)RoutineArgument.newBuilder().setName("x").setDataType(StandardSQLDataType.newBuilder((String)"INT64").build()).build())).setRemoteFunctionOptions(remoteFunctionOptions).setReturnType(StandardSQLDataType.newBuilder((String)"INT64").build()).build();
        Routine routine = bigquery.create(routineInfo, new BigQuery.RoutineOption[0]);
        Assert.assertNotNull((Object)routine);
        Assert.assertEquals((Object)routine.getRoutineType(), (Object)"SCALAR_FUNCTION");
        Assert.assertEquals((Object)REMOTE_ENDPOINT, (Object)routine.getRemoteFunctionOptions().getEndpoint());
        Assert.assertEquals((Object)connection.getName(), (Object)routine.getRemoteFunctionOptions().getConnection());
    }
}

