/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.spi.v2;

import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.cloud.bigquery.spi.v2.HttpBigQueryRpc;
import com.google.common.truth.Truth;
import java.util.Collections;
import java.util.Map;
import org.junit.Test;

public class HttpBigQueryRpcTest {
    @Test
    public void testListToDataset() {
        DatasetReference datasetRef = new DatasetReference().setDatasetId("dataset-id").setProjectId("project-id");
        DatasetList.Datasets listDataSet = new DatasetList.Datasets().setDatasetReference(datasetRef).setId("project-id:dataset-id").setFriendlyName("friendly").setKind("bigquery#dataset").setLabels(Collections.singletonMap("foo", "bar")).setLocation("test-region-1");
        Dataset dataset = (Dataset)HttpBigQueryRpc.LIST_TO_DATASET.apply((Object)listDataSet);
        Truth.assertThat((String)dataset.getKind()).isEqualTo((Object)"bigquery#dataset");
        Truth.assertThat((String)dataset.getId()).isEqualTo((Object)"project-id:dataset-id");
        Truth.assertThat((String)dataset.getFriendlyName()).isEqualTo((Object)"friendly");
        Truth.assertThat((Map)dataset.getDatasetReference()).isEqualTo((Object)datasetRef);
        Truth.assertThat((Map)dataset.getLabels()).containsExactly((Object)"foo", (Object)"bar", new Object[0]);
        Truth.assertThat((String)dataset.getLocation()).isEqualTo((Object)"test-region-1");
    }
}

