/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1alpha2.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1alpha2.JsonWriterCache;
import com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto;
import com.google.cloud.bigquery.storage.v1alpha2.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1alpha2.SchemaCompatibility;
import com.google.cloud.bigquery.storage.v1alpha2.Storage;
import com.google.cloud.bigquery.storage.v1alpha2.StreamWriter;
import com.google.cloud.bigquery.storage.v1alpha2.WriterCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.json.JSONArray;

@Deprecated
public class DirectWriter {
    private static final Logger LOG = Logger.getLogger(DirectWriter.class.getName());
    private static WriterCache cache = null;
    private static JsonWriterCache jsonCache = null;
    private static Lock cacheLock = new ReentrantLock();
    private static Lock jsonCacheLock = new ReentrantLock();

    public static <T extends Message> ApiFuture<Long> append(String tableName, List<T> protoRows) throws IOException, InterruptedException, InvalidArgumentException {
        Preconditions.checkNotNull((Object)tableName, (Object)"TableName is null.");
        Preconditions.checkNotNull(protoRows, (Object)"ProtoRows is null.");
        if (protoRows.isEmpty()) {
            throw new InvalidArgumentException((Throwable)new Exception("Empty rows are not allowed"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
        }
        try {
            cacheLock.lock();
            if (cache == null) {
                cache = WriterCache.getInstance();
            }
        }
        finally {
            cacheLock.unlock();
        }
        StreamWriter writer = cache.getTableWriter(tableName, ((Message)protoRows.get(0)).getDescriptorForType());
        ProtoBufProto.ProtoRows.Builder rowsBuilder = ProtoBufProto.ProtoRows.newBuilder();
        Object descriptor = null;
        for (Message protoRow : protoRows) {
            rowsBuilder.addSerializedRows(protoRow.toByteString());
        }
        Storage.AppendRowsRequest.ProtoData.Builder data = Storage.AppendRowsRequest.ProtoData.newBuilder();
        data.setWriterSchema(ProtoSchemaConverter.convert(((Message)protoRows.get(0)).getDescriptorForType()));
        data.setRows(rowsBuilder.build());
        return ApiFutures.transform(writer.append(Storage.AppendRowsRequest.newBuilder().setProtoRows(data.build()).build()), (ApiFunction)new ApiFunction<Storage.AppendRowsResponse, Long>(){

            public Long apply(Storage.AppendRowsResponse appendRowsResponse) {
                return appendRowsResponse.getOffset();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static ApiFuture<Long> append(String tableName, JSONArray json) throws IOException, InterruptedException, InvalidArgumentException, Descriptors.DescriptorValidationException {
        Preconditions.checkNotNull((Object)tableName, (Object)"TableName is null.");
        Preconditions.checkNotNull((Object)json, (Object)"JSONArray is null.");
        if (json.length() == 0) {
            throw new InvalidArgumentException((Throwable)new Exception("Empty JSONArrays are not allowed"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
        }
        try {
            jsonCacheLock.lock();
            if (jsonCache == null) {
                jsonCache = JsonWriterCache.getInstance();
            }
        }
        finally {
            jsonCacheLock.unlock();
        }
        JsonStreamWriter writer = jsonCache.getTableWriter(tableName);
        return ApiFutures.transform(writer.append(json, -1L, false), (ApiFunction)new ApiFunction<Storage.AppendRowsResponse, Long>(){

            public Long apply(Storage.AppendRowsResponse appendRowsResponse) {
                return appendRowsResponse.getOffset();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    public static void testSetStub(BigQueryWriteClient stub, int maxTableEntry, SchemaCompatibility schemaCheck) {
        cache = WriterCache.getTestInstance(stub, maxTableEntry, schemaCheck);
        jsonCache = JsonWriterCache.getTestInstance(stub, maxTableEntry);
    }

    public static void clearCache() {
        cache.clear();
    }
}

