/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.AutoOneOf_StreamWriter_SingleConnectionOrConnectionPool;
import com.google.cloud.bigquery.storage.v1.AutoValue_StreamWriter_ConnectionPoolKey;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.ConnectionWorker;
import com.google.cloud.bigquery.storage.v1.ConnectionWorkerPool;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.WriteStreamView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamWriter
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StreamWriter.class.getName());
    private static String datasetsMatching = "projects/[^/]+/datasets/[^/]+/";
    private static Pattern streamPatternDatasets = Pattern.compile(datasetsMatching);
    private static String defaultStreamMatching = "/_default";
    private static Pattern streamPatternDefaultStream = Pattern.compile(defaultStreamMatching);
    private static Map<String, String> projectAndDatasetToLocation = new ConcurrentHashMap<String, String>();
    private final String streamName;
    private final ProtoSchema writerSchema;
    private final String location;
    private final String writerId = UUID.randomUUID().toString();
    private final SingleConnectionOrConnectionPool singleConnectionOrConnectionPool;
    private static int testOnlyClientCreatedTimes = 0;
    private static final Map<ConnectionPoolKey, ConnectionWorkerPool> connectionPoolMap = new ConcurrentHashMap<ConnectionPoolKey, ConnectionWorkerPool>();
    private final long creationTimestamp;

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    private StreamWriter(Builder builder) throws IOException {
        this.streamName = builder.streamName;
        this.writerSchema = builder.writerSchema;
        BigQueryWriteSettings clientSettings = this.getBigQueryWriteSettings(builder);
        if (!builder.enableConnectionPool) {
            this.location = builder.location;
            this.singleConnectionOrConnectionPool = SingleConnectionOrConnectionPool.ofSingleConnection(new ConnectionWorker(builder.streamName, builder.writerSchema, builder.maxInflightRequest, builder.maxInflightBytes, builder.maxRetryDuration, builder.limitExceededBehavior, builder.traceId, clientSettings));
        } else {
            String datasetAndProjectName;
            if (!StreamWriter.isDefaultStream(this.streamName)) {
                log.warning("Connection pool is only allowed in default stream! However received " + builder.streamName);
                throw new IllegalArgumentException("Trying to enable connection pool in non-default stream.");
            }
            BigQueryWriteClient client = builder.client != null ? builder.client : new BigQueryWriteClient(clientSettings);
            String location = builder.location;
            if ((location == null || location.isEmpty()) && (location = projectAndDatasetToLocation.computeIfAbsent(datasetAndProjectName = StreamWriter.extractDatasetAndProjectName(builder.streamName), key -> {
                GetWriteStreamRequest writeStreamRequest = GetWriteStreamRequest.newBuilder().setName(this.getStreamName()).setView(WriteStreamView.BASIC).build();
                WriteStream writeStream = client.getWriteStream(writeStreamRequest);
                TableSchema writeStreamTableSchema = writeStream.getTableSchema();
                String fetchedLocation = writeStream.getLocation();
                log.info(String.format("Fethed location %s for stream name %s, extracted project and dataset name: %s\"", fetchedLocation, this.streamName, datasetAndProjectName));
                return fetchedLocation;
            })).isEmpty()) {
                throw new IllegalStateException(String.format("The location is empty for both user passed in value and looked up value for stream: %s, extracted project and dataset name: %s", this.streamName, datasetAndProjectName));
            }
            this.location = location;
            this.singleConnectionOrConnectionPool = SingleConnectionOrConnectionPool.ofConnectionPool(connectionPoolMap.computeIfAbsent(ConnectionPoolKey.create(location), key -> new ConnectionWorkerPool(builder.maxInflightRequest, builder.maxInflightBytes, builder.maxRetryDuration, builder.limitExceededBehavior, builder.traceId, client.getSettings())));
            this.validateFetchedConnectonPool(builder);
            if (builder.client == null) {
                client.shutdown();
                try {
                    client.awaitTermination(150L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                client.close();
            }
        }
        this.creationTimestamp = System.nanoTime();
    }

    @VisibleForTesting
    static String extractDatasetAndProjectName(String streamName) {
        Matcher streamMatcher = streamPatternDatasets.matcher(streamName);
        if (streamMatcher.find()) {
            return streamMatcher.group();
        }
        throw new IllegalStateException(String.format("The passed in stream name does not match standard format %s", streamName));
    }

    @VisibleForTesting
    static boolean isDefaultStream(String streamName) {
        Matcher streamMatcher = streamPatternDefaultStream.matcher(streamName);
        return streamMatcher.find();
    }

    private BigQueryWriteSettings getBigQueryWriteSettings(Builder builder) throws IOException {
        if (builder.client != null) {
            return builder.client.getSettings();
        }
        return ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setTransportChannelProvider(builder.channelProvider)).setBackgroundExecutorProvider(builder.executorProvider)).setEndpoint(builder.endpoint)).build();
    }

    private void validateFetchedConnectonPool(Builder builder) {
        String paramsValidatedFailed = "";
        if (!Objects.equals(this.singleConnectionOrConnectionPool.connectionWorkerPool().getTraceId(), builder.traceId)) {
            paramsValidatedFailed = "Trace id";
        } else if (!Objects.equals(this.singleConnectionOrConnectionPool.connectionWorkerPool().limitExceededBehavior(), builder.limitExceededBehavior)) {
            paramsValidatedFailed = "Limit Exceeds Behavior";
        }
        if (!paramsValidatedFailed.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s used for the same connection pool for the same location must be the same!", paramsValidatedFailed));
        }
    }

    public ApiFuture<AppendRowsResponse> append(ProtoRows rows) {
        return this.append(rows, -1L);
    }

    public ApiFuture<AppendRowsResponse> append(ProtoRows rows, long offset) {
        return this.singleConnectionOrConnectionPool.append(this, rows, offset);
    }

    public long getInflightWaitSeconds() {
        return this.singleConnectionOrConnectionPool.getInflightWaitSeconds(this);
    }

    public String getWriterId() {
        return this.singleConnectionOrConnectionPool.getWriterId(this.writerId);
    }

    public String getStreamName() {
        return this.streamName;
    }

    public ProtoSchema getProtoSchema() {
        return this.writerSchema;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public void close() {
        this.singleConnectionOrConnectionPool.close(this);
    }

    public static Builder newBuilder(String streamName, BigQueryWriteClient client) {
        return new Builder(streamName, client);
    }

    public static Builder newBuilder(String streamName) {
        return new Builder(streamName);
    }

    public synchronized TableSchema getUpdatedSchema() {
        ConnectionWorker.TableSchemaAndTimestamp tableSchemaAndTimestamp = this.singleConnectionOrConnectionPool.getUpdatedSchema(this);
        if (tableSchemaAndTimestamp == null) {
            return null;
        }
        return this.creationTimestamp < tableSchemaAndTimestamp.updateTimeStamp() ? tableSchemaAndTimestamp.updatedSchema() : null;
    }

    long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @VisibleForTesting
    SingleConnectionOrConnectionPool.Kind getConnectionOperationType() {
        return this.singleConnectionOrConnectionPool.getKind();
    }

    @VisibleForTesting
    static int getTestOnlyClientCreatedTimes() {
        return testOnlyClientCreatedTimes;
    }

    @VisibleForTesting
    static void cleanUp() {
        testOnlyClientCreatedTimes = 0;
        connectionPoolMap.clear();
    }

    public static final class Builder {
        private static final long DEFAULT_MAX_INFLIGHT_REQUESTS = 1000L;
        private static final long DEFAULT_MAX_INFLIGHT_BYTES = 0x6400000L;
        private String streamName;
        private BigQueryWriteClient client;
        private ProtoSchema writerSchema = null;
        private long maxInflightRequest = 1000L;
        private long maxInflightBytes = 0x6400000L;
        private String endpoint = BigQueryWriteSettings.getDefaultEndpoint();
        private TransportChannelProvider channelProvider = BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        private CredentialsProvider credentialsProvider = BigQueryWriteSettings.defaultCredentialsProviderBuilder().build();
        private ExecutorProvider executorProvider = BigQueryWriteSettings.defaultExecutorProviderBuilder().build();
        private FlowController.LimitExceededBehavior limitExceededBehavior = FlowController.LimitExceededBehavior.Block;
        private String traceId = null;
        private TableSchema updatedTableSchema = null;
        private String location = null;
        private boolean enableConnectionPool = false;
        private Duration maxRetryDuration = Duration.ofMinutes(5L);

        private Builder(String streamName) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = null;
        }

        private Builder(String streamName, BigQueryWriteClient client) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = (BigQueryWriteClient)Preconditions.checkNotNull((Object)client);
        }

        public Builder setWriterSchema(ProtoSchema writerSchema) {
            this.writerSchema = writerSchema;
            return this;
        }

        public Builder setMaxInflightRequests(long value) {
            this.maxInflightRequest = value;
            return this;
        }

        public Builder setMaxInflightBytes(long value) {
            this.maxInflightBytes = value;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public Builder setEnableConnectionPool(boolean enableConnectionPool) {
            this.enableConnectionPool = enableConnectionPool;
            return this;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setTraceId(String traceId) {
            int colonIndex = traceId.indexOf(58);
            if (colonIndex == -1 || colonIndex == 0 || colonIndex == traceId.length() - 1) {
                throw new IllegalArgumentException("TraceId must follow the format of A:B. Actual:" + traceId);
            }
            this.traceId = traceId;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLimitExceededBehavior(FlowController.LimitExceededBehavior limitExceededBehavior) throws StatusRuntimeException {
            if (limitExceededBehavior == FlowController.LimitExceededBehavior.Ignore) {
                throw new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INVALID_ARGUMENT).withDescription("LimitExceededBehavior.Ignore is not supported on StreamWriter."));
            }
            this.limitExceededBehavior = limitExceededBehavior;
            return this;
        }

        public Builder setMaxRetryDuration(Duration maxRetryDuration) {
            this.maxRetryDuration = maxRetryDuration;
            return this;
        }

        public StreamWriter build() throws IOException {
            return new StreamWriter(this);
        }
    }

    @AutoOneOf(value=Kind.class)
    public static abstract class SingleConnectionOrConnectionPool {
        public abstract Kind getKind();

        public abstract ConnectionWorker connectionWorker();

        public abstract ConnectionWorkerPool connectionWorkerPool();

        public ApiFuture<AppendRowsResponse> append(StreamWriter streamWriter, ProtoRows protoRows, long offset) {
            if (this.getKind() == Kind.CONNECTION_WORKER) {
                return this.connectionWorker().append(streamWriter.getStreamName(), streamWriter.getProtoSchema(), protoRows, offset);
            }
            return this.connectionWorkerPool().append(streamWriter, protoRows, offset);
        }

        public void close(StreamWriter streamWriter) {
            if (this.getKind() == Kind.CONNECTION_WORKER) {
                this.connectionWorker().close();
            } else {
                this.connectionWorkerPool().close(streamWriter);
            }
        }

        long getInflightWaitSeconds(StreamWriter streamWriter) {
            if (this.getKind() == Kind.CONNECTION_WORKER_POOL) {
                return this.connectionWorkerPool().getInflightWaitSeconds(streamWriter);
            }
            return this.connectionWorker().getInflightWaitSeconds();
        }

        ConnectionWorker.TableSchemaAndTimestamp getUpdatedSchema(StreamWriter streamWriter) {
            if (this.getKind() == Kind.CONNECTION_WORKER_POOL) {
                return this.connectionWorkerPool().getUpdatedSchema(streamWriter);
            }
            return this.connectionWorker().getUpdatedSchema();
        }

        String getWriterId(String streamWriterId) {
            if (this.getKind() == Kind.CONNECTION_WORKER_POOL) {
                return streamWriterId;
            }
            return this.connectionWorker().getWriterId();
        }

        public static SingleConnectionOrConnectionPool ofSingleConnection(ConnectionWorker connection) {
            return AutoOneOf_StreamWriter_SingleConnectionOrConnectionPool.connectionWorker(connection);
        }

        public static SingleConnectionOrConnectionPool ofConnectionPool(ConnectionWorkerPool connectionPool) {
            return AutoOneOf_StreamWriter_SingleConnectionOrConnectionPool.connectionWorkerPool(connectionPool);
        }

        public static enum Kind {
            CONNECTION_WORKER,
            CONNECTION_WORKER_POOL;

        }
    }

    @AutoValue
    static abstract class ConnectionPoolKey {
        ConnectionPoolKey() {
        }

        abstract String location();

        public static ConnectionPoolKey create(String location) {
            return new AutoValue_StreamWriter_ConnectionPoolKey(location);
        }
    }
}

