/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.MockBigQueryWrite;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.WriteStreamName;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BigQueryWriteClientTest {
    private static MockBigQueryWrite mockBigQueryWrite;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private BigQueryWriteClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockBigQueryWrite = new MockBigQueryWrite();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockBigQueryWrite));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        BigQueryWriteSettings settings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = BigQueryWriteClient.create((BigQueryWriteSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createWriteStreamTest() throws Exception {
        WriteStream expectedResponse = WriteStream.newBuilder().setName(WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setCommitTime(Timestamp.newBuilder().build()).setTableSchema(TableSchema.newBuilder().build()).setLocation("location1901043637").build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        TableName parent = TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]");
        WriteStream writeStream = WriteStream.newBuilder().build();
        WriteStream actualResponse = this.client.createWriteStream(parent, writeStream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWriteStreamRequest actualRequest = (CreateWriteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)writeStream, (Object)actualRequest.getWriteStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWriteStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            TableName parent = TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]");
            WriteStream writeStream = WriteStream.newBuilder().build();
            this.client.createWriteStream(parent, writeStream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createWriteStreamTest2() throws Exception {
        WriteStream expectedResponse = WriteStream.newBuilder().setName(WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setCommitTime(Timestamp.newBuilder().build()).setTableSchema(TableSchema.newBuilder().build()).setLocation("location1901043637").build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        WriteStream writeStream = WriteStream.newBuilder().build();
        WriteStream actualResponse = this.client.createWriteStream(parent, writeStream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateWriteStreamRequest actualRequest = (CreateWriteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)writeStream, (Object)actualRequest.getWriteStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createWriteStreamExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            WriteStream writeStream = WriteStream.newBuilder().build();
            this.client.createWriteStream(parent, writeStream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void appendRowsTest() throws Exception {
        AppendRowsResponse expectedResponse = AppendRowsResponse.newBuilder().setUpdatedSchema(TableSchema.newBuilder().build()).addAllRowErrors(new ArrayList()).setWriteStream("writeStream1412231231").build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        AppendRowsRequest request = AppendRowsRequest.newBuilder().setWriteStream(WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]").toString()).setOffset(Int64Value.newBuilder().build()).setTraceId("traceId-1067401920").putAllMissingValueInterpretations(new HashMap()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.appendRowsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void appendRowsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        AppendRowsRequest request = AppendRowsRequest.newBuilder().setWriteStream(WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]").toString()).setOffset(Int64Value.newBuilder().build()).setTraceId("traceId-1067401920").putAllMissingValueInterpretations(new HashMap()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.appendRowsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getWriteStreamTest() throws Exception {
        WriteStream expectedResponse = WriteStream.newBuilder().setName(WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setCommitTime(Timestamp.newBuilder().build()).setTableSchema(TableSchema.newBuilder().build()).setLocation("location1901043637").build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        WriteStreamName name = WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]");
        WriteStream actualResponse = this.client.getWriteStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWriteStreamRequest actualRequest = (GetWriteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWriteStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            WriteStreamName name = WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]");
            this.client.getWriteStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getWriteStreamTest2() throws Exception {
        WriteStream expectedResponse = WriteStream.newBuilder().setName(WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]").toString()).setCreateTime(Timestamp.newBuilder().build()).setCommitTime(Timestamp.newBuilder().build()).setTableSchema(TableSchema.newBuilder().build()).setLocation("location1901043637").build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        WriteStream actualResponse = this.client.getWriteStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetWriteStreamRequest actualRequest = (GetWriteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getWriteStreamExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getWriteStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void finalizeWriteStreamTest() throws Exception {
        FinalizeWriteStreamResponse expectedResponse = FinalizeWriteStreamResponse.newBuilder().setRowCount(1340416618L).build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        WriteStreamName name = WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]");
        FinalizeWriteStreamResponse actualResponse = this.client.finalizeWriteStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FinalizeWriteStreamRequest actualRequest = (FinalizeWriteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void finalizeWriteStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            WriteStreamName name = WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]");
            this.client.finalizeWriteStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void finalizeWriteStreamTest2() throws Exception {
        FinalizeWriteStreamResponse expectedResponse = FinalizeWriteStreamResponse.newBuilder().setRowCount(1340416618L).build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        FinalizeWriteStreamResponse actualResponse = this.client.finalizeWriteStream(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FinalizeWriteStreamRequest actualRequest = (FinalizeWriteStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void finalizeWriteStreamExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.finalizeWriteStream(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCommitWriteStreamsTest() throws Exception {
        BatchCommitWriteStreamsResponse expectedResponse = BatchCommitWriteStreamsResponse.newBuilder().setCommitTime(Timestamp.newBuilder().build()).addAllStreamErrors(new ArrayList()).build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        TableName parent = TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]");
        BatchCommitWriteStreamsResponse actualResponse = this.client.batchCommitWriteStreams(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCommitWriteStreamsRequest actualRequest = (BatchCommitWriteStreamsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCommitWriteStreamsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            TableName parent = TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]");
            this.client.batchCommitWriteStreams(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCommitWriteStreamsTest2() throws Exception {
        BatchCommitWriteStreamsResponse expectedResponse = BatchCommitWriteStreamsResponse.newBuilder().setCommitTime(Timestamp.newBuilder().build()).addAllStreamErrors(new ArrayList()).build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        BatchCommitWriteStreamsResponse actualResponse = this.client.batchCommitWriteStreams(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCommitWriteStreamsRequest actualRequest = (BatchCommitWriteStreamsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCommitWriteStreamsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.batchCommitWriteStreams(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void flushRowsTest() throws Exception {
        FlushRowsResponse expectedResponse = FlushRowsResponse.newBuilder().setOffset(-1019779949L).build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        WriteStreamName writeStream = WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]");
        FlushRowsResponse actualResponse = this.client.flushRows(writeStream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FlushRowsRequest actualRequest = (FlushRowsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)writeStream.toString(), (Object)actualRequest.getWriteStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void flushRowsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            WriteStreamName writeStream = WriteStreamName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]", (String)"[STREAM]");
            this.client.flushRows(writeStream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void flushRowsTest2() throws Exception {
        FlushRowsResponse expectedResponse = FlushRowsResponse.newBuilder().setOffset(-1019779949L).build();
        mockBigQueryWrite.addResponse((AbstractMessage)expectedResponse);
        String writeStream = "writeStream1412231231";
        FlushRowsResponse actualResponse = this.client.flushRows(writeStream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryWrite.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FlushRowsRequest actualRequest = (FlushRowsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)writeStream, (Object)actualRequest.getWriteStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void flushRowsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryWrite.addException((Exception)exception);
        try {
            String writeStream = "writeStream1412231231";
            this.client.flushRows(writeStream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

