/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.it;

import com.google.cloud.bigquery.storage.v1beta2.AvroRows;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class SimpleRowReader {
    private final DatumReader<GenericData.Record> datumReader;
    private BinaryDecoder decoder = null;
    private GenericData.Record row = null;

    public SimpleRowReader(Schema schema) {
        Preconditions.checkNotNull((Object)schema);
        this.datumReader = new GenericDatumReader(schema);
    }

    public void processRows(AvroRows avroRows, AvroRowConsumer rowConsumer) throws IOException {
        Preconditions.checkNotNull((Object)avroRows);
        Preconditions.checkNotNull((Object)rowConsumer);
        this.decoder = DecoderFactory.get().binaryDecoder(avroRows.getSerializedBinaryRows().toByteArray(), this.decoder);
        while (!this.decoder.isEnd()) {
            this.row = (GenericData.Record)this.datumReader.read((Object)this.row, (Decoder)this.decoder);
            rowConsumer.accept(this.row);
        }
    }

    public static interface AvroRowConsumer {
        public void accept(GenericData.Record var1);
    }
}

