/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.JsonToProtoMessage;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.WriteStreamView;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStreamWriter
implements AutoCloseable {
    private static String streamPatternString = "projects/[^/]+/datasets/[^/]+/tables/[^/]+/streams/[^/]+";
    private static Pattern streamPattern = Pattern.compile(streamPatternString);
    private static final Logger LOG = Logger.getLogger(JsonStreamWriter.class.getName());
    private static final long UPDATE_SCHEMA_RETRY_INTERVAL_MILLIS = 30100L;
    private BigQueryWriteClient client;
    private String streamName;
    private StreamWriter streamWriter;
    private StreamWriter.Builder streamWriterBuilder;
    private Descriptors.Descriptor descriptor;
    private TableSchema tableSchema;
    private boolean ignoreUnknownFields = false;
    private boolean reconnectAfter10M = false;
    private long totalMessageSize = 0L;
    private long absTotal = 0L;
    private ProtoSchema protoSchema;
    private boolean enableConnectionPool = false;

    private JsonStreamWriter(Builder builder) throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(builder.tableSchema);
        this.streamWriterBuilder = builder.client == null ? StreamWriter.newBuilder(builder.streamName) : StreamWriter.newBuilder(builder.streamName, builder.client);
        this.protoSchema = ProtoSchemaConverter.convert(this.descriptor);
        this.totalMessageSize = this.protoSchema.getSerializedSize();
        this.client = builder.client;
        this.streamWriterBuilder.setWriterSchema(this.protoSchema);
        this.setStreamWriterSettings(builder.channelProvider, builder.credentialsProvider, builder.executorProvider, builder.endpoint, builder.flowControlSettings, builder.traceId);
        this.streamWriterBuilder.setEnableConnectionPool(builder.enableConnectionPool);
        this.streamWriterBuilder.setLocation(builder.location);
        this.streamWriter = this.streamWriterBuilder.build();
        this.streamName = builder.streamName;
        this.tableSchema = builder.tableSchema;
        this.ignoreUnknownFields = builder.ignoreUnknownFields;
        this.reconnectAfter10M = builder.reconnectAfter10M;
    }

    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr) throws IOException, Descriptors.DescriptorValidationException {
        return this.append(jsonArr, -1L);
    }

    private void refreshWriter(TableSchema updatedSchema) throws Descriptors.DescriptorValidationException, IOException {
        Preconditions.checkNotNull((Object)updatedSchema, (Object)"updatedSchema is null.");
        LOG.info("Refresh internal writer due to schema update, stream: " + this.streamName);
        this.streamWriter.close();
        this.tableSchema = updatedSchema;
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(updatedSchema);
        this.protoSchema = ProtoSchemaConverter.convert(this.descriptor);
        this.totalMessageSize = this.protoSchema.getSerializedSize();
        this.streamWriter = this.streamWriterBuilder.setWriterSchema(this.protoSchema).build();
    }

    private Message buildMessage(JSONObject json) throws InterruptedException, Descriptors.DescriptorValidationException, IOException {
        try {
            return JsonToProtoMessage.convertJsonToProtoMessage(this.descriptor, this.tableSchema, json, this.ignoreUnknownFields);
        }
        catch (Exceptions.JsonDataHasUnknownFieldException ex) {
            LOG.warning("Saw Json unknown field " + ex.getFieldName() + ", try to refresh the writer with updated schema, stream: " + this.streamName);
            GetWriteStreamRequest writeStreamRequest = GetWriteStreamRequest.newBuilder().setName(this.streamName).setView(WriteStreamView.FULL).build();
            WriteStream writeStream = this.client.getWriteStream(writeStreamRequest);
            this.refreshWriter(writeStream.getTableSchema());
            try {
                return JsonToProtoMessage.convertJsonToProtoMessage(this.descriptor, this.tableSchema, json, this.ignoreUnknownFields);
            }
            catch (Exceptions.JsonDataHasUnknownFieldException exex) {
                LOG.warning("First attempt failed, waiting for 30 seconds to retry, stream: " + this.streamName);
                Thread.sleep(30100L);
                writeStream = this.client.getWriteStream(writeStreamRequest);
                this.refreshWriter(writeStream.getTableSchema());
                return JsonToProtoMessage.convertJsonToProtoMessage(this.descriptor, this.tableSchema, json, this.ignoreUnknownFields);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr, long offset) throws IOException, Descriptors.DescriptorValidationException {
        JsonStreamWriter jsonStreamWriter = this;
        synchronized (jsonStreamWriter) {
            if (this.streamWriter.getUpdatedSchema() != null) {
                this.refreshWriter(this.streamWriter.getUpdatedSchema());
            }
            ProtoRows.Builder rowsBuilder = ProtoRows.newBuilder();
            long currentRequestSize = 0L;
            HashMap<Integer, String> rowIndexToErrorMessage = new HashMap<Integer, String>();
            for (int i = 0; i < jsonArr.length(); ++i) {
                JSONObject json = jsonArr.getJSONObject(i);
                try {
                    Message protoMessage = this.buildMessage(json);
                    rowsBuilder.addSerializedRows(protoMessage.toByteString());
                    currentRequestSize += (long)protoMessage.getSerializedSize();
                    continue;
                }
                catch (IllegalArgumentException exception) {
                    if (exception instanceof Exceptions.FieldParseError) {
                        Exceptions.FieldParseError ex = (Exceptions.FieldParseError)exception;
                        rowIndexToErrorMessage.put(i, "Field " + ex.getFieldName() + " failed to convert to " + ex.getBqType() + ". Error: " + ex.getCause().getMessage());
                        continue;
                    }
                    rowIndexToErrorMessage.put(i, exception.getMessage());
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (!rowIndexToErrorMessage.isEmpty()) {
                throw new Exceptions.AppendSerializationError(Code.INVALID_ARGUMENT.getNumber(), "Append serialization failed for writer: " + this.streamName, this.streamName, rowIndexToErrorMessage);
            }
            ApiFuture<AppendRowsResponse> appendResponseFuture = this.streamWriter.append(rowsBuilder.build(), offset);
            return appendResponseFuture;
        }
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getWriterId() {
        return this.streamWriter.getWriterId();
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getLocation() {
        return this.streamWriter.getLocation();
    }

    public long getInflightWaitSeconds() {
        return this.streamWriter.getInflightWaitSeconds();
    }

    public void setMissingValueInterpretationMap(Map<String, AppendRowsRequest.MissingValueInterpretation> missingValueInterpretationMap) {
        this.streamWriter.setMissingValueInterpretationMap(missingValueInterpretationMap);
    }

    public Map<String, AppendRowsRequest.MissingValueInterpretation> getMissingValueInterpretationMap() {
        return this.streamWriter.getMissingValueInterpretationMap();
    }

    private void setStreamWriterSettings(@Nullable TransportChannelProvider channelProvider, @Nullable CredentialsProvider credentialsProvider, @Nullable ExecutorProvider executorProvider, @Nullable String endpoint, @Nullable FlowControlSettings flowControlSettings, @Nullable String traceId) {
        if (channelProvider != null) {
            this.streamWriterBuilder.setChannelProvider(channelProvider);
        }
        if (credentialsProvider != null) {
            this.streamWriterBuilder.setCredentialsProvider(credentialsProvider);
        }
        if (executorProvider != null) {
            this.streamWriterBuilder.setExecutorProvider(executorProvider);
        }
        if (endpoint != null) {
            this.streamWriterBuilder.setEndpoint(endpoint);
        }
        if (traceId != null) {
            this.streamWriterBuilder.setTraceId("JsonWriter_" + traceId);
        } else {
            this.streamWriterBuilder.setTraceId("JsonWriter:null");
        }
        if (flowControlSettings != null) {
            if (flowControlSettings.getMaxOutstandingRequestBytes() != null) {
                this.streamWriterBuilder.setMaxInflightBytes(flowControlSettings.getMaxOutstandingRequestBytes());
            }
            if (flowControlSettings.getMaxOutstandingElementCount() != null) {
                this.streamWriterBuilder.setMaxInflightRequests(flowControlSettings.getMaxOutstandingElementCount());
            }
            if (flowControlSettings.getLimitExceededBehavior() != null) {
                this.streamWriterBuilder.setLimitExceededBehavior(flowControlSettings.getLimitExceededBehavior());
            }
        }
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        return new Builder(streamOrTableName, tableSchema, null);
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkNotNull((Object)client, (Object)"BigQuery client is null.");
        return new Builder(streamOrTableName, tableSchema, client);
    }

    public static Builder newBuilder(String streamOrTableName, BigQueryWriteClient client) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)client, (Object)"BigQuery client is null.");
        return new Builder(streamOrTableName, null, client);
    }

    @Override
    public void close() {
        this.streamWriter.close();
    }

    public boolean isClosed() {
        return this.streamWriter.isClosed();
    }

    public boolean isUserClosed() {
        return this.streamWriter.isUserClosed();
    }

    public static final class Builder {
        private String streamName;
        private BigQueryWriteClient client;
        private TableSchema tableSchema;
        private TransportChannelProvider channelProvider;
        private CredentialsProvider credentialsProvider;
        private ExecutorProvider executorProvider;
        private FlowControlSettings flowControlSettings;
        private String endpoint;
        private boolean createDefaultStream = false;
        private String traceId;
        private boolean ignoreUnknownFields = false;
        private boolean reconnectAfter10M = false;
        private boolean enableConnectionPool = false;
        private String location;
        private static String streamPatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)/streams/[^/]+";
        private static String tablePatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)";
        private static Pattern streamPattern = Pattern.compile(streamPatternString);
        private static Pattern tablePattern = Pattern.compile(tablePatternString);

        private Builder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client) {
            Matcher streamMatcher = streamPattern.matcher(streamOrTableName);
            if (!streamMatcher.matches()) {
                Matcher tableMatcher = tablePattern.matcher(streamOrTableName);
                if (!tableMatcher.matches()) {
                    throw new IllegalArgumentException("Invalid  name: " + streamOrTableName);
                }
                this.streamName = streamOrTableName + "/_default";
            } else {
                this.streamName = streamOrTableName;
            }
            this.client = client;
            if (tableSchema == null) {
                TableSchema writeStreamTableSchema;
                GetWriteStreamRequest writeStreamRequest = GetWriteStreamRequest.newBuilder().setName(this.getStreamName()).setView(WriteStreamView.FULL).build();
                WriteStream writeStream = this.client.getWriteStream(writeStreamRequest);
                this.tableSchema = writeStreamTableSchema = writeStream.getTableSchema();
                this.location = writeStream.getLocation();
            } else {
                this.tableSchema = tableSchema;
            }
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider, (Object)"ExecutorProvider is null.");
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings, (Object)"FlowControlSettings is null.");
            return this;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public Builder setTraceId(String traceId) {
            this.traceId = (String)Preconditions.checkNotNull((Object)traceId, (Object)"TraceId is null.");
            return this;
        }

        public Builder setIgnoreUnknownFields(boolean ignoreUnknownFields) {
            this.ignoreUnknownFields = ignoreUnknownFields;
            return this;
        }

        public Builder setReconnectAfter10M(boolean reconnectAfter10M) {
            this.reconnectAfter10M = false;
            return this;
        }

        public Builder setEnableConnectionPool(boolean enableConnectionPool) {
            this.enableConnectionPool = enableConnectionPool;
            return this;
        }

        public Builder setLocation(String location) {
            if (this.location != null && !this.location.equals(location)) {
                throw new IllegalArgumentException("Specified location " + location + " does not match the system value " + this.location);
            }
            this.location = location;
            return this;
        }

        public JsonStreamWriter build() throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
            return new JsonStreamWriter(this);
        }
    }
}

