/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteGrpc;
import com.google.cloud.bigquery.storage.v1.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Uninterruptibles;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

class FakeBigQueryWriteImpl
extends BigQueryWriteGrpc.BigQueryWriteImplBase {
    private static final Logger LOG = Logger.getLogger(FakeBigQueryWriteImpl.class.getName());
    private final LinkedBlockingQueue<AppendRowsRequest> requests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<GetWriteStreamRequest> writeRequests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<FlushRowsRequest> flushRequests = new LinkedBlockingQueue();
    private final List<Response> responses = Collections.synchronizedList(new ArrayList());
    private final LinkedBlockingQueue<WriteStream> writeResponses = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<FlushRowsResponse> flushResponses = new LinkedBlockingQueue();
    private final AtomicInteger nextMessageId = new AtomicInteger(1);
    private boolean autoPublishResponse;
    private ScheduledExecutorService executor = null;
    private Duration responseSleep = Duration.ZERO;
    private Semaphore responseSemaphore = new Semaphore(0, true);
    private long numberTimesToClose = 0L;
    private long closeAfter = 0L;
    private long recordCount = 0L;
    private long connectionCount = 0L;
    private long closeForeverAfter = 0L;
    private final Map<StreamObserver<AppendRowsResponse>, Boolean> connectionToFirstRequest = new ConcurrentHashMap<StreamObserver<AppendRowsResponse>, Boolean>();
    private Status failedStatus = Status.ABORTED;

    FakeBigQueryWriteImpl() {
    }

    public void getWriteStream(GetWriteStreamRequest request, StreamObserver<WriteStream> responseObserver) {
        Object response = this.writeResponses.remove();
        if (response instanceof WriteStream) {
            this.writeRequests.add(request);
            responseObserver.onNext((Object)((WriteStream)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException("Unrecognized response type"));
        }
    }

    public void flushRows(FlushRowsRequest request, StreamObserver<FlushRowsResponse> responseObserver) {
        Object response = this.writeResponses.remove();
        if (response instanceof FlushRowsResponse) {
            this.flushRequests.add(request);
            responseObserver.onNext((Object)((FlushRowsResponse)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException("Unrecognized response type"));
        }
    }

    public void waitForResponseScheduled() throws InterruptedException {
        this.responseSemaphore.acquire();
    }

    public long getConnectionCount() {
        return this.connectionCount;
    }

    public void setFailedStatus(Status failedStatus) {
        this.failedStatus = failedStatus;
    }

    public StreamObserver<AppendRowsRequest> appendRows(final StreamObserver<AppendRowsResponse> responseObserver) {
        ++this.connectionCount;
        this.connectionToFirstRequest.put(responseObserver, true);
        StreamObserver<AppendRowsRequest> requestObserver = new StreamObserver<AppendRowsRequest>(){

            public void onNext(AppendRowsRequest value) {
                LOG.fine("Get request:" + value.toString());
                FakeBigQueryWriteImpl.this.requests.add(value);
                FakeBigQueryWriteImpl.this.recordCount++;
                int offset = (int)(FakeBigQueryWriteImpl.this.recordCount - 1L);
                if (value.hasOffset() && value.getOffset().getValue() != -1L) {
                    offset = (int)value.getOffset().getValue();
                }
                if (FakeBigQueryWriteImpl.this.responseSleep.compareTo(Duration.ZERO) > 0) {
                    LOG.fine("Sleeping before response for " + FakeBigQueryWriteImpl.this.responseSleep.toString());
                    Uninterruptibles.sleepUninterruptibly((long)FakeBigQueryWriteImpl.this.responseSleep.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                if (((Boolean)FakeBigQueryWriteImpl.this.connectionToFirstRequest.get(responseObserver)).booleanValue() && (!value.getProtoRows().hasWriterSchema() || value.getWriteStream().isEmpty())) {
                    LOG.info(String.valueOf(!value.getProtoRows().hasWriterSchema() || value.getWriteStream().isEmpty()));
                    responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Unexpected first request: " + value.toString()).asException());
                    return;
                }
                FakeBigQueryWriteImpl.this.connectionToFirstRequest.put(responseObserver, false);
                if (FakeBigQueryWriteImpl.this.closeAfter > 0L && FakeBigQueryWriteImpl.this.recordCount % FakeBigQueryWriteImpl.this.closeAfter == 0L && (FakeBigQueryWriteImpl.this.numberTimesToClose == 0L || FakeBigQueryWriteImpl.this.connectionCount <= FakeBigQueryWriteImpl.this.numberTimesToClose)) {
                    LOG.info("Shutting down connection from test...");
                    responseObserver.onError((Throwable)FakeBigQueryWriteImpl.this.failedStatus.asException());
                } else if (FakeBigQueryWriteImpl.this.closeForeverAfter > 0L && FakeBigQueryWriteImpl.this.recordCount > FakeBigQueryWriteImpl.this.closeForeverAfter) {
                    LOG.info("Shutting down connection from test...");
                    responseObserver.onError((Throwable)FakeBigQueryWriteImpl.this.failedStatus.asException());
                } else {
                    Response response = (Response)FakeBigQueryWriteImpl.this.responses.get(offset);
                    FakeBigQueryWriteImpl.this.sendResponse(response, (StreamObserver<AppendRowsResponse>)responseObserver);
                }
            }

            public void onError(Throwable t) {
                responseObserver.onError(t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
        return requestObserver;
    }

    private void sendResponse(Response response, StreamObserver<AppendRowsResponse> responseObserver) {
        LOG.fine("Sending response: " + response.toString());
        if (response.isError()) {
            responseObserver.onError(response.getError());
        } else {
            responseObserver.onNext((Object)response.getResponse());
        }
    }

    public FakeBigQueryWriteImpl setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public FakeBigQueryWriteImpl setResponseSleep(Duration responseSleep) {
        this.responseSleep = responseSleep;
        return this;
    }

    public FakeBigQueryWriteImpl addResponse(AppendRowsResponse appendRowsResponse) {
        this.responses.add(new Response(appendRowsResponse));
        return this;
    }

    public FakeBigQueryWriteImpl addResponse(AppendRowsResponse.Builder appendResponseBuilder) {
        return this.addResponse(appendResponseBuilder.build());
    }

    public FakeBigQueryWriteImpl addWriteStreamResponse(WriteStream response) {
        this.writeResponses.add(response);
        return this;
    }

    public FakeBigQueryWriteImpl addFlushRowsResponse(FlushRowsResponse response) {
        this.flushResponses.add(response);
        return this;
    }

    public FakeBigQueryWriteImpl addConnectionError(Throwable error) {
        this.responses.add(new Response(error));
        return this;
    }

    public List<AppendRowsRequest> getCapturedRequests() {
        return new ArrayList<AppendRowsRequest>(this.requests);
    }

    public List<GetWriteStreamRequest> getCapturedWriteRequests() {
        return new ArrayList<GetWriteStreamRequest>(this.writeRequests);
    }

    public void reset() {
        this.requests.clear();
        this.responses.clear();
    }

    public void setCloseEveryNAppends(long closeAfter) {
        this.closeAfter = closeAfter;
    }

    public void setTimesToClose(long numberTimesToClose) {
        this.numberTimesToClose = numberTimesToClose;
    }

    public void setCloseForeverAfter(long closeForeverAfter) {
        this.closeForeverAfter = closeForeverAfter;
    }

    private static class Response {
        Optional<AppendRowsResponse> appendResponse;
        Optional<Throwable> error;

        public Response(AppendRowsResponse appendResponse) {
            this.appendResponse = Optional.of((Object)appendResponse);
            this.error = Optional.absent();
        }

        public Response(Throwable exception) {
            this.appendResponse = Optional.absent();
            this.error = Optional.of((Object)exception);
        }

        public AppendRowsResponse getResponse() {
            return (AppendRowsResponse)this.appendResponse.get();
        }

        public Throwable getError() {
            return (Throwable)this.error.get();
        }

        boolean isError() {
            return this.error.isPresent();
        }

        public String toString() {
            if (this.isError()) {
                return ((Throwable)this.error.get()).toString();
            }
            return ((AppendRowsResponse)this.appendResponse.get()).toString();
        }
    }
}

