/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.client.util.Sleeper;
import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.test.JsonTest;
import com.google.cloud.bigquery.storage.test.SchemaTest;
import com.google.cloud.bigquery.storage.test.Test;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1.ConnectionWorkerPool;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.FakeBigQueryWrite;
import com.google.cloud.bigquery.storage.v1.FakeScheduledExecutorService;
import com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalTime;

@RunWith(value=JUnit4.class)
public class JsonStreamWriterTest {
    private static final int NUMERIC_SCALE = 9;
    private static final String TEST_STREAM = "projects/p/datasets/d/tables/t/streams/_default";
    private static final String TEST_STREAM_2 = "projects/p/datasets/d2/tables/t2/streams/_default";
    private static final String TEST_TABLE = "projects/p/datasets/d/tables/t";
    private static LocalChannelProvider channelProvider;
    private FakeScheduledExecutorService fakeExecutor;
    private FakeBigQueryWrite testBigQueryWrite;
    private static MockServiceHelper serviceHelper;
    private BigQueryWriteClient client;
    private final TableFieldSchema FOO = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("foo").build();
    private final TableFieldSchema BAR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("bar").build();
    private final TableFieldSchema BAZ = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("baz").build();
    private final TableSchema TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, this.FOO).build();
    private final TableSchema TABLE_SCHEMA_2 = TableSchema.newBuilder().addFields(0, this.BAZ).build();
    private final TableSchema UPDATED_TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, this.FOO).addFields(1, this.BAR).build();
    private final TableSchema UPDATED_TABLE_SCHEMA_2 = TableSchema.newBuilder().addFields(0, this.FOO).addFields(1, this.BAR).addFields(2, this.BAZ).build();
    private final ProtoSchema PROTO_SCHEMA = ProtoSchemaConverter.convert((Descriptors.Descriptor)BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)this.TABLE_SCHEMA));
    private final ProtoSchema PROTO_SCHEMA_2 = ProtoSchemaConverter.convert((Descriptors.Descriptor)BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)this.TABLE_SCHEMA_2));
    private final ProtoSchema UPDATED_PROTO_SCHEMA = ProtoSchemaConverter.convert((Descriptors.Descriptor)BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)this.UPDATED_TABLE_SCHEMA));
    private final TableFieldSchema TEST_INT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_int").build();
    private final TableFieldSchema TEST_STRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.REPEATED).setName("test_string").build();

    @Before
    public void setUp() throws Exception {
        this.testBigQueryWrite = new FakeBigQueryWrite();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(this.testBigQueryWrite));
        serviceHelper.start();
        channelProvider = serviceHelper.createChannelProvider();
        this.fakeExecutor = new FakeScheduledExecutorService();
        this.testBigQueryWrite.setExecutor(this.fakeExecutor);
        BigQueryWriteSettings settings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = BigQueryWriteClient.create((BigQueryWriteSettings)settings);
        Instant time = Instant.now();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build();
        StreamWriter.cleanUp();
    }

    @After
    public void tearDown() throws Exception {
        serviceHelper.stop();
    }

    private JsonStreamWriter.Builder getTestJsonStreamWriterBuilder(String testStream, TableSchema BQTableSchema) {
        return JsonStreamWriter.newBuilder((String)testStream, (TableSchema)BQTableSchema, (BigQueryWriteClient)this.client).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().build());
    }

    @Test
    public void testTwoParamNewBuilder_nullSchema() {
        try {
            this.getTestJsonStreamWriterBuilder(null, this.TABLE_SCHEMA);
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"StreamOrTableName is null.");
        }
    }

    @Test
    public void testTwoParamNewBuilder_nullStream() {
        try {
            this.getTestJsonStreamWriterBuilder(TEST_STREAM, null);
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"TableSchema is null.");
        }
    }

    @Test
    public void testTwoParamNewBuilder() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();
        Assert.assertEquals((Object)TEST_STREAM, (Object)writer.getStreamName());
    }

    @Test
    public void testSingleAppendSimpleJson() throws Exception {
        Test.FooType expectedProto = Test.FooType.newBuilder().setFoo("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).setTraceId("test:empty").build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getTraceId(), (Object)"JsonWriter_test:empty");
        }
    }

    @Test
    public void testFlexibleColumnAppend() throws Exception {
        TableFieldSchema field = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("test-\u5217").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, field).build();
        Test.FlexibleType expectedProto = Test.FlexibleType.newBuilder().setColDGVzdC3LiJc("allen").build();
        JSONObject flexible = new JSONObject();
        flexible.put("test-\u5217", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)flexible);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).setTraceId("test:empty").build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getTraceId(), (Object)"JsonWriter_test:empty");
        }
    }

    @Test
    public void testSpecialTypeAppend() throws Exception {
        TableFieldSchema field = TableFieldSchema.newBuilder().setName("time").setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.REPEATED).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(field).build();
        JsonTest.TestTime expectedProto = JsonTest.TestTime.newBuilder().addTime(CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)1, (int)0, (int)1))).build();
        JSONObject foo = new JSONObject();
        foo.put("time", (Object)new JSONArray((Object)new String[]{"01:00:01"}));
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
        }
    }

    @Test
    public void testRepeatedByteStringAppend() throws Exception {
        BigDecimal bigDecimal2;
        TableFieldSchema NON_REPEATED_A = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REQUIRED).setName("a").build();
        TableFieldSchema NON_REPEATED_B = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REQUIRED).setName("b").build();
        TableFieldSchema NON_REPEATED_C = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REQUIRED).setName("c").build();
        TableFieldSchema REPEATED_A = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("aa").build();
        TableFieldSchema REPEATED_B = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REPEATED).setName("bb").build();
        TableFieldSchema REPEATED_C = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REPEATED).setName("cc").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, NON_REPEATED_A).addFields(1, NON_REPEATED_B).addFields(2, NON_REPEATED_C).addFields(3, REPEATED_A).addFields(4, REPEATED_B).addFields(5, REPEATED_C).build();
        BigDecimal bigDecimal1 = new BigDecimal(1.1);
        if (bigDecimal1.scale() > 9) {
            bigDecimal1 = bigDecimal1.setScale(9, RoundingMode.HALF_UP);
        }
        if ((bigDecimal2 = new BigDecimal(2.2)).scale() > 9) {
            bigDecimal2 = bigDecimal2.setScale(9, RoundingMode.HALF_UP);
        }
        JSONArray aaValue = new JSONArray();
        aaValue.put((Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)bigDecimal1));
        aaValue.put((Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)bigDecimal2));
        byte[] byteArray1 = "bb1".getBytes("UTF-8");
        byte[] byteArray2 = "bb2".getBytes("UTF-8");
        JSONArray bbValue = new JSONArray();
        bbValue.put((Object)ByteString.copyFrom((byte[])byteArray1));
        bbValue.put((Object)ByteString.copyFrom((byte[])byteArray2));
        ByteString byteString1 = ByteString.copyFrom((String)"cc1", (String)"UTF-8");
        ByteString byteString2 = ByteString.copyFrom((String)"cc2", (String)"UTF-8");
        JSONArray ccValue = new JSONArray();
        ccValue.put((Object)byteString1);
        ccValue.put((Object)byteString2);
        JSONObject foo = new JSONObject();
        foo.put("a", (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)bigDecimal1));
        foo.put("b", (Object)ByteString.copyFrom((byte[])byteArray1));
        foo.put("c", (Object)byteString1);
        foo.put("aa", (Object)aaValue);
        foo.put("bb", (Object)bbValue);
        foo.put("cc", (Object)ccValue);
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        Test.RepetitionType expectedProto = Test.RepetitionType.newBuilder().setA(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)bigDecimal1)).setB(ByteString.copyFrom((byte[])byteArray1)).setC(byteString1).addAa(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)bigDecimal1)).addAa(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)bigDecimal2)).addBb(ByteString.copyFrom((byte[])byteArray1)).addBb(ByteString.copyFrom((byte[])byteArray2)).addCc(byteString1).addCc(byteString2).build();
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
        }
    }

    @Test
    public void testSingleAppendMultipleSimpleJson() throws Exception {
        Test.FooType expectedProto = Test.FooType.newBuilder().setFoo("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"allen");
        JSONObject foo1 = new JSONObject();
        foo1.put("foo", (Object)"allen");
        JSONObject foo2 = new JSONObject();
        foo2.put("foo", (Object)"allen");
        JSONObject foo3 = new JSONObject();
        foo3.put("foo", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        jsonArr.put((Object)foo1);
        jsonArr.put((Object)foo2);
        jsonArr.put((Object)foo3);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)4L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getTraceId(), (Object)"JsonWriter:null");
            for (int i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(i), (Object)expectedProto.toByteString());
            }
        }
    }

    @Test
    public void testMultipleAppendSimpleJson() throws Exception {
        Test.FooType expectedProto = Test.FooType.newBuilder().setFoo("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)1L)).build()).build());
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)2L)).build()).build());
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)3L)).build()).build());
            for (int i = 0; i < 4; ++i) {
                ApiFuture appendFuture = writer.append(jsonArr);
                Assert.assertEquals((long)i, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
                appendFuture.get();
                Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(i).getProtoRows().getRows().getSerializedRowsCount());
                Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(i).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
            }
        }
    }

    @Test
    public void testAppendOutOfRangeException() throws Exception {
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setError(com.google.rpc.Status.newBuilder().setCode(11).build()).build());
            JSONObject foo = new JSONObject();
            foo.put("foo", (Object)"allen");
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            ApiFuture appendFuture = writer.append(jsonArr);
            try {
                appendFuture.get();
                Assert.fail((String)"expected ExecutionException");
            }
            catch (ExecutionException ex) {
                Assert.assertEquals((Object)ex.getCause().getMessage(), (Object)"OUT_OF_RANGE: ");
            }
        }
    }

    @Test
    public void testCreateDefaultStream_withNoSchemaPassedIn() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).addFields(1, this.TEST_STRING).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setLocation("aa").setTableSchema(tableSchema).build());
        try (JsonStreamWriter writer = JsonStreamWriter.newBuilder((String)TEST_TABLE, (BigQueryWriteClient)this.client).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().build()).build();){
            Assert.assertEquals((Object)"projects/p/datasets/d/tables/t/_default", (Object)writer.getStreamName());
            Assert.assertEquals((Object)"aa", (Object)writer.getLocation());
        }
    }

    @Test
    public void testCreateDefaultStream_withNoClientPassedIn() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).addFields(1, this.TEST_STRING).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setLocation("aa").setTableSchema(tableSchema).build());
        try (JsonStreamWriter writer = JsonStreamWriter.newBuilder((String)TEST_TABLE, (TableSchema)tableSchema).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().build()).setEnableConnectionPool(true).build();){
            Assert.assertEquals((Object)"projects/p/datasets/d/tables/t/_default", (Object)writer.getStreamName());
            Assert.assertEquals((Object)"aa", (Object)writer.getLocation());
        }
    }

    @Test
    public void testCreateDefaultStreamWrongLocation() {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).addFields(1, this.TEST_STRING).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setLocation("aa").setTableSchema(tableSchema).build());
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                JsonStreamWriter.newBuilder((String)JsonStreamWriterTest.TEST_TABLE, (BigQueryWriteClient)JsonStreamWriterTest.this.client).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setLocation("bb").build();
            }
        });
        Assert.assertEquals((Object)"Specified location bb does not match the system value aa", (Object)ex.getMessage());
    }

    @Test
    public void testSimpleSchemaUpdate() throws Exception {
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).setUpdatedSchema(this.UPDATED_TABLE_SCHEMA).build());
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(2L));
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(3L));
            JSONObject foo = new JSONObject();
            foo.put("foo", (Object)"aaa");
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            ApiFuture appendFuture1 = writer.append(jsonArr);
            ApiFuture appendFuture2 = writer.append(jsonArr);
            ApiFuture appendFuture3 = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(0), (Object)Test.FooType.newBuilder().setFoo("aaa").build().toByteString());
            Assert.assertEquals((long)2L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(1).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(1).getProtoRows().getRows().getSerializedRows(0), (Object)Test.FooType.newBuilder().setFoo("aaa").build().toByteString());
            JSONObject updatedFoo = new JSONObject();
            updatedFoo.put("foo", (Object)"aaa");
            updatedFoo.put("bar", (Object)"bbb");
            JSONArray updatedJsonArr = new JSONArray();
            updatedJsonArr.put((Object)updatedFoo);
            ApiFuture appendFuture4 = writer.append(updatedJsonArr);
            Assert.assertEquals((long)3L, (long)((AppendRowsResponse)appendFuture4.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)4L, (long)this.testBigQueryWrite.getAppendRequests().size());
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(3).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(3).getProtoRows().getRows().getSerializedRows(0), (Object)Test.UpdatedFooType.newBuilder().setFoo("aaa").setBar("bbb").build().toByteString());
            Assert.assertTrue((boolean)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().hasWriterSchema());
            Assert.assertTrue((this.testBigQueryWrite.getAppendRequests().get(2).getProtoRows().hasWriterSchema() || this.testBigQueryWrite.getAppendRequests().get(3).getProtoRows().hasWriterSchema() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWithoutIgnoreUnknownFieldsUpdateImmeidateSuccess() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).build();
        TableSchema updatedSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).addFields(1, TableFieldSchema.newBuilder().setName("test_string").setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE)).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setTableSchema(updatedSchema).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).build();){
            JSONObject foo = new JSONObject();
            foo.put("test_int", 10);
            JSONObject bar = new JSONObject();
            bar.put("test_string", (Object)"a");
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            jsonArr.put((Object)bar);
            ApiFuture appendFuture = writer.append(jsonArr);
            appendFuture.get();
        }
    }

    @Test
    public void testWithoutIgnoreUnknownFieldsUpdateSecondSuccess() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).build();
        TableSchema updatedSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).addFields(1, TableFieldSchema.newBuilder().setName("test_string").setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE)).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setTableSchema(tableSchema).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setTableSchema(updatedSchema).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).build();){
            JSONObject foo = new JSONObject();
            foo.put("test_int", 10);
            JSONObject bar = new JSONObject();
            bar.put("test_string", (Object)"a");
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            jsonArr.put((Object)bar);
            ApiFuture appendFuture = writer.append(jsonArr);
            appendFuture.get();
        }
    }

    @Test
    public void testSchemaUpdateInMultiplexing_singleConnection() throws Exception {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMinConnectionsPerRegion(1).setMaxConnectionsPerRegion(1).build());
        JsonStreamWriter writer1 = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).setEnableConnectionPool(true).setLocation("us").build();
        JsonStreamWriter writer2 = this.getTestJsonStreamWriterBuilder(TEST_STREAM_2, this.TABLE_SCHEMA_2).setEnableConnectionPool(true).setLocation("us").build();
        this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).setUpdatedSchema(this.UPDATED_TABLE_SCHEMA).setWriteStream(TEST_STREAM).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(2L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(3L));
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"aaa");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        JSONObject baz = new JSONObject();
        baz.put("baz", (Object)"bbb");
        JSONArray jsonArr2 = new JSONArray();
        jsonArr2.put((Object)baz);
        JSONObject updatedFoo = new JSONObject();
        updatedFoo.put("foo", (Object)"aaa");
        updatedFoo.put("bar", (Object)"bbb");
        JSONArray updatedJsonArr = new JSONArray();
        updatedJsonArr.put((Object)updatedFoo);
        ApiFuture appendFuture1 = writer1.append(jsonArr);
        ApiFuture appendFuture2 = writer2.append(jsonArr2);
        Sleeper.DEFAULT.sleep(300L);
        ApiFuture appendFuture3 = writer1.append(updatedJsonArr);
        ApiFuture appendFuture4 = writer1.append(jsonArr);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)2L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)3L, (long)((AppendRowsResponse)appendFuture4.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getWriterSchema(), (Object)this.PROTO_SCHEMA);
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(1).getProtoRows().getWriterSchema(), (Object)this.PROTO_SCHEMA_2);
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(2).getProtoRows().getWriterSchema(), (Object)this.UPDATED_PROTO_SCHEMA);
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(3).getProtoRows().getWriterSchema(), (Object)ProtoSchema.getDefaultInstance());
        writer1.close();
        writer2.close();
    }

    @Test
    public void testSchemaUpdateInMultiplexing_multipleWriterForSameStreamName() throws Exception {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMinConnectionsPerRegion(1).setMaxConnectionsPerRegion(1).build());
        JsonStreamWriter writer1 = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).setEnableConnectionPool(true).setLocation("us").build();
        JsonStreamWriter writer2 = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).setEnableConnectionPool(true).setLocation("us").build();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)1L)).build()).setUpdatedSchema(this.UPDATED_TABLE_SCHEMA).setWriteStream(TEST_STREAM).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(2L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(3L));
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"aaa");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        JSONObject updatedFoo = new JSONObject();
        updatedFoo.put("foo", (Object)"aaa");
        updatedFoo.put("bar", (Object)"bbb");
        JSONArray updatedJsonArr = new JSONArray();
        updatedJsonArr.put((Object)updatedFoo);
        ApiFuture appendFuture1 = writer1.append(jsonArr);
        ApiFuture appendFuture2 = writer2.append(jsonArr);
        Sleeper.DEFAULT.sleep(300L);
        ApiFuture appendFuture3 = writer1.append(updatedJsonArr);
        ApiFuture appendFuture4 = writer2.append(updatedJsonArr);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)2L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)3L, (long)((AppendRowsResponse)appendFuture4.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getWriterSchema(), (Object)this.PROTO_SCHEMA);
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(1).getProtoRows().getWriterSchema(), (Object)ProtoSchema.getDefaultInstance());
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(2).getProtoRows().getWriterSchema(), (Object)this.UPDATED_PROTO_SCHEMA);
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(3).getProtoRows().getWriterSchema(), (Object)ProtoSchema.getDefaultInstance());
        writer1.close();
        writer2.close();
    }

    @Test
    public void testSchemaUpdateInMultiplexing_IgnoreUpdateIfTimeStampNewer() throws Exception {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMinConnectionsPerRegion(1).setMaxConnectionsPerRegion(1).build());
        JsonStreamWriter writer1 = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).setEnableConnectionPool(true).setLocation("us").build();
        this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).setUpdatedSchema(this.UPDATED_TABLE_SCHEMA).setWriteStream(TEST_STREAM).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(2L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(3L));
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"aaa");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        JSONObject baz = new JSONObject();
        baz.put("baz", (Object)"bbb");
        JSONArray jsonArr2 = new JSONArray();
        jsonArr2.put((Object)baz);
        JSONObject updatedFoo = new JSONObject();
        updatedFoo.put("foo", (Object)"aaa");
        updatedFoo.put("bar", (Object)"bbb");
        JSONArray updatedJsonArr = new JSONArray();
        updatedJsonArr.put((Object)updatedFoo);
        ApiFuture appendFuture1 = writer1.append(jsonArr);
        Sleeper.DEFAULT.sleep(300L);
        ApiFuture appendFuture2 = writer1.append(updatedJsonArr);
        ApiFuture appendFuture3 = writer1.append(jsonArr);
        JsonStreamWriter writer2 = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA_2).setEnableConnectionPool(true).setLocation("us").build();
        ApiFuture appendFuture4 = writer2.append(jsonArr2);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)2L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)3L, (long)((AppendRowsResponse)appendFuture4.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getWriterSchema(), (Object)this.PROTO_SCHEMA);
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(1).getProtoRows().getWriterSchema(), (Object)this.UPDATED_PROTO_SCHEMA);
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(2).getProtoRows().getWriterSchema(), (Object)ProtoSchema.getDefaultInstance());
        Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(3).getProtoRows().getWriterSchema(), (Object)this.PROTO_SCHEMA_2);
        writer1.close();
        writer2.close();
    }

    @Test
    public void testWithoutIgnoreUnknownFieldsUpdateFail() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setTableSchema(tableSchema).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setTableSchema(tableSchema).build());
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).build();){
            JSONObject foo = new JSONObject();
            foo.put("test_int", 10);
            JSONObject bar = new JSONObject();
            bar.put("test_unknown", 10);
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            jsonArr.put((Object)bar);
            try {
                ApiFuture appendFuture = writer.append(jsonArr);
                Assert.fail((String)"expected ExecutionException");
            }
            catch (Exceptions.AppendSerializationError ex) {
                Assert.assertEquals((Object)"The source object has fields unknown to BigQuery: root.test_unknown.", ex.getRowIndexToErrorMessage().get(1));
                Assert.assertEquals((Object)TEST_STREAM, (Object)ex.getStreamName());
            }
        }
    }

    @Test
    public void testWithIgnoreUnknownFields() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).build();
        try (JsonStreamWriter writer = JsonStreamWriter.newBuilder((String)TEST_STREAM, (TableSchema)tableSchema).setChannelProvider((TransportChannelProvider)channelProvider).setIgnoreUnknownFields(true).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().build()).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().build());
            JSONObject foo = new JSONObject();
            foo.put("test_int", 10);
            JSONObject bar = new JSONObject();
            bar.put("test_unknown", 10);
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            jsonArr.put((Object)bar);
            ApiFuture appendFuture = writer.append(jsonArr);
            appendFuture.get();
        }
    }

    @Test
    public void testFlowControlSetting() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).build();
        try (final JsonStreamWriter writer = JsonStreamWriter.newBuilder((String)TEST_STREAM, (TableSchema)tableSchema).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().build()).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).setMaxOutstandingRequestBytes(Long.valueOf(1L)).build()).build();){
            JSONObject foo = new JSONObject();
            foo.put("test_int", 10);
            final JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            StatusRuntimeException ex = (StatusRuntimeException)Assert.assertThrows(StatusRuntimeException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    writer.append(jsonArr);
                }
            });
            Assert.assertEquals((Object)ex.getStatus().getCode(), (Object)Status.RESOURCE_EXHAUSTED.getCode());
            Assert.assertTrue((boolean)ex.getStatus().getDescription().contains("Exceeds client side inflight buffer, consider add more buffer or open more connections"));
        }
    }

    @Test
    public void testFlowControlSettingNoLimitBehavior() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).build();
        try (JsonStreamWriter writer = JsonStreamWriter.newBuilder((String)TEST_STREAM, (TableSchema)tableSchema).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().build()).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingRequestBytes(Long.valueOf(1L)).build()).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().build());
            JSONObject foo = new JSONObject();
            foo.put("test_int", 10);
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            ApiFuture appendFuture = writer.append(jsonArr);
            appendFuture.get();
        }
    }

    @Test
    public void testMultipleAppendSerializationErrors() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        Test.FooType expectedProto = Test.FooType.newBuilder().setFoo("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("not_foo", (Object)"allen");
        JSONObject foo1 = new JSONObject();
        foo1.put("foo", (Object)"allen");
        JSONObject foo2 = new JSONObject();
        foo2.put("foo", 666);
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        jsonArr.put((Object)foo1);
        jsonArr.put((Object)foo2);
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setTableSchema(this.TABLE_SCHEMA).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setTableSchema(this.TABLE_SCHEMA).build());
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            try {
                ApiFuture appendFuture = writer.append(jsonArr);
                Assert.fail((String)"expected AppendSerializationError");
            }
            catch (Exceptions.AppendSerializationError appendSerializationError) {
                Map rowIndexToErrorMessage = appendSerializationError.getRowIndexToErrorMessage();
                Assert.assertEquals((long)2L, (long)rowIndexToErrorMessage.size());
                Assert.assertEquals((Object)"The source object has fields unknown to BigQuery: root.not_foo.", rowIndexToErrorMessage.get(0));
                Assert.assertEquals((Object)"Field root.foo failed to convert to STRING. Error: JSONObject does not have a string field at root.foo.", rowIndexToErrorMessage.get(2));
            }
        }
    }

    @Test
    public void testBadStringToNumericRowError() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        TableSchema TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, TableFieldSchema.newBuilder().setName("test_field_type").setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).build()).build();
        SchemaTest.StringType expectedProto = SchemaTest.StringType.newBuilder().setTestFieldType("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("test_field_type", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, TABLE_SCHEMA).build();){
            try {
                ApiFuture appendFuture = writer.append(jsonArr);
                Assert.fail((String)"expected AppendSerializationError");
            }
            catch (Exceptions.AppendSerializationError appendSerializationError) {
                Map rowIndexToErrorMessage = appendSerializationError.getRowIndexToErrorMessage();
                Assert.assertEquals((long)1L, (long)rowIndexToErrorMessage.size());
                Assert.assertTrue((boolean)((String)rowIndexToErrorMessage.get(0)).startsWith("Field root.test_field_type failed to convert to NUMERIC. Error:"));
            }
        }
    }

    @Test
    public void testWriterId() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        JsonStreamWriter writer1 = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();
        Assert.assertFalse((boolean)writer1.getWriterId().isEmpty());
        JsonStreamWriter writer2 = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();
        Assert.assertFalse((boolean)writer2.getWriterId().isEmpty());
        Assert.assertNotEquals((Object)writer1.getWriterId(), (Object)writer2.getWriterId());
    }

    @Test
    public void testIsDone() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();
        Assert.assertFalse((boolean)writer.isClosed());
        writer.close();
        Assert.assertTrue((boolean)writer.isClosed());
        Assert.assertTrue((boolean)writer.isUserClosed());
    }

    private AppendRowsResponse createAppendResponse(long offset) {
        return AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)offset)).build()).build();
    }

    @Test
    public void testAppendWithMissingValueMap() throws Exception {
        TableFieldSchema field = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("test-\u5217").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, field).build();
        Test.FlexibleType expectedProto = Test.FlexibleType.newBuilder().setColDGVzdC3LiJc("allen").build();
        JSONObject flexible = new JSONObject();
        flexible.put("test-\u5217", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)flexible);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).setTraceId("test:empty").build();){
            HashMap<String, AppendRowsRequest.MissingValueInterpretation> missingValueMap = new HashMap<String, AppendRowsRequest.MissingValueInterpretation>();
            missingValueMap.put("col1", AppendRowsRequest.MissingValueInterpretation.NULL_VALUE);
            missingValueMap.put("col3", AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE);
            writer.setMissingValueInterpretationMap(missingValueMap);
            Assert.assertEquals(missingValueMap, (Object)writer.getMissingValueInterpretationMap());
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getMissingValueInterpretations(), missingValueMap);
        }
    }
}

