/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.client.util.Sleeper;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnknownException;
import com.google.cloud.bigquery.storage.test.Test;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.ConnectionWorker;
import com.google.cloud.bigquery.storage.v1.ConnectionWorkerPool;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.FakeBigQueryWrite;
import com.google.cloud.bigquery.storage.v1.FakeScheduledExecutorService;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1.StorageError;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.base.Strings;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class StreamWriterTest {
    private static final Logger log = Logger.getLogger(StreamWriterTest.class.getName());
    private static final String TEST_STREAM_1 = "projects/p/datasets/d1/tables/t1/streams/_default";
    private static final String TEST_STREAM_2 = "projects/p/datasets/d2/tables/t2/streams/_default";
    private static final String TEST_STREAM_3 = "projects/p/datasets/d3/tables/t3/streams/_default";
    private static final String TEST_STREAM_SHORTEN = "projects/p/datasets/d2/tables/t2/_default";
    private static final String EXPLICIT_STEAM = "projects/p/datasets/d1/tables/t1/streams/s1";
    private static final String TEST_TRACE_ID = "DATAFLOW:job_id";
    private FakeScheduledExecutorService fakeExecutor;
    private FakeBigQueryWrite testBigQueryWrite;
    private static MockServiceHelper serviceHelper;
    private BigQueryWriteClient client;
    private final TableFieldSchema FOO = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("foo").build();
    private final TableFieldSchema BAR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("bar").build();
    private final TableSchema TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, this.FOO).build();
    private final ProtoSchema PROTO_SCHEMA = ProtoSchemaConverter.convert((Descriptors.Descriptor)BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)this.TABLE_SCHEMA));
    private final TableSchema UPDATED_TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, this.FOO).addFields(1, this.BAR).build();
    private final ProtoSchema UPDATED_PROTO_SCHEMA = ProtoSchemaConverter.convert((Descriptors.Descriptor)BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)this.UPDATED_TABLE_SCHEMA));

    @Before
    public void setUp() throws Exception {
        this.testBigQueryWrite = new FakeBigQueryWrite();
        StreamWriter.setMaxRequestCallbackWaitTime((java.time.Duration)java.time.Duration.ofSeconds(10000L));
        ConnectionWorker.setMaxInflightQueueWaitTime((long)300000L);
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(this.testBigQueryWrite));
        serviceHelper.start();
        this.fakeExecutor = new FakeScheduledExecutorService();
        this.testBigQueryWrite.setExecutor(this.fakeExecutor);
        this.client = BigQueryWriteClient.create((BigQueryWriteSettings)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setTransportChannelProvider((TransportChannelProvider)serviceHelper.createChannelProvider())).build());
        StreamWriter.cleanUp();
    }

    @After
    public void tearDown() throws Exception {
        log.info("tearDown called");
        this.client.close();
        serviceHelper.stop();
        StreamWriter.cleanUp();
    }

    private StreamWriter getMultiplexingTestStreamWriter() throws IOException {
        return StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setTraceId(TEST_TRACE_ID).setLocation("US").setEnableConnectionPool(true).setMaxRetryDuration(java.time.Duration.ofSeconds(5L)).build();
    }

    private StreamWriter getTestStreamWriter() throws IOException {
        return StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setTraceId(TEST_TRACE_ID).setMaxRetryDuration(java.time.Duration.ofSeconds(5L)).build();
    }

    private ProtoSchema createProtoSchema() {
        return this.createProtoSchema("foo");
    }

    private ProtoSchema createProtoSchema(String fieldName) {
        return ProtoSchema.newBuilder().setProtoDescriptor(DescriptorProtos.DescriptorProto.newBuilder().setName("Message").addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName(fieldName).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setNumber(1).build()).build()).build();
    }

    private ProtoRows createProtoRows(String[] messages) {
        ProtoRows.Builder rowsBuilder = ProtoRows.newBuilder();
        for (String message : messages) {
            Test.FooType foo = Test.FooType.newBuilder().setFoo(message).build();
            rowsBuilder.addSerializedRows(foo.toByteString());
        }
        return rowsBuilder.build();
    }

    private AppendRowsResponse createAppendResponse(long offset) {
        return AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)offset)).build()).build();
    }

    private AppendRowsResponse createAppendResponseWithError(Status.Code code, String message) {
        return AppendRowsResponse.newBuilder().setError(com.google.rpc.Status.newBuilder().setCode(code.value()).setMessage(message)).build();
    }

    private ApiFuture<AppendRowsResponse> sendTestMessage(StreamWriter writer, String[] messages) {
        return writer.append(this.createProtoRows(messages));
    }

    private ApiFuture<AppendRowsResponse> sendTestMessage(StreamWriter writer, String[] messages, long offset) {
        return writer.append(this.createProtoRows(messages), offset);
    }

    private static <T extends Throwable> T assertFutureException(Class<T> expectedThrowable, final Future<?> future) {
        return (T)Assert.assertThrows(expectedThrowable, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                try {
                    future.get();
                }
                catch (ExecutionException ex) {
                    throw ex.getCause();
                }
            }
        });
    }

    private void verifyAppendIsBlocked(final StreamWriter writer) throws Exception {
        Thread appendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StreamWriterTest.this.sendTestMessage(writer, new String[]{"A"});
            }
        });
        appendThread.start();
        TimeUnit.SECONDS.sleep(2L);
        Assert.assertTrue((boolean)appendThread.isAlive());
        appendThread.interrupt();
    }

    private void verifyAppendRequests(long appendCount) {
        Assert.assertEquals((long)appendCount, (long)this.testBigQueryWrite.getAppendRequests().size());
        int i = 0;
        while ((long)i < appendCount) {
            AppendRowsRequest serverRequest = this.testBigQueryWrite.getAppendRequests().get(i);
            Assert.assertTrue((serverRequest.getProtoRows().getRows().getSerializedRowsCount() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)i, (long)serverRequest.getOffset().getValue());
            if (i == 0) {
                Assert.assertTrue((boolean)serverRequest.getProtoRows().hasWriterSchema());
                Assert.assertEquals((Object)serverRequest.getWriteStream(), (Object)TEST_STREAM_1);
                Assert.assertEquals((Object)serverRequest.getTraceId(), (Object)TEST_TRACE_ID);
            } else {
                Assert.assertFalse((boolean)serverRequest.getProtoRows().hasWriterSchema());
                Assert.assertEquals((Object)serverRequest.getWriteStream(), (Object)"");
                Assert.assertEquals((Object)serverRequest.getTraceId(), (Object)"");
            }
            ++i;
        }
    }

    public void testBuildBigQueryWriteClientInWriter() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setChannelProvider((TransportChannelProvider)serviceHelper.createChannelProvider()).setWriterSchema(this.createProtoSchema()).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        writer.close();
    }

    @Test
    public void testAppendSuccess() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        long appendCount = 100L;
        int i = 0;
        while ((long)i < appendCount) {
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            ++i;
        }
        ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
        int i2 = 0;
        while ((long)i2 < appendCount) {
            futures.add(writer.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)i2));
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < appendCount) {
            Assert.assertEquals((long)i2, (long)((AppendRowsResponse)((ApiFuture)futures.get(i2)).get()).getAppendResult().getOffset().getValue());
            ++i2;
        }
        this.verifyAppendRequests(appendCount);
        writer.close();
    }

    @Test
    public void testAppendSuccess_RetryDirectlyInCallback() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setTraceId(TEST_TRACE_ID).setMaxRetryDuration(java.time.Duration.ofSeconds(5L)).setMaxInflightRequests(5L).build();
        long appendCount = 20L;
        int i = 0;
        while ((long)i < appendCount) {
            if (i == 0) {
                this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponseWithError(Status.INVALID_ARGUMENT.getCode(), "test message"));
            }
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            ++i;
        }
        ProtoRows protoRows = this.createProtoRows(new String[]{String.valueOf(-1)});
        ApiFuture future = writer.append(protoRows, -1L);
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new AppendCompleteCallback(writer, protoRows), (Executor)MoreExecutors.directExecutor());
        StatusRuntimeException actualError = StreamWriterTest.assertFutureException(StatusRuntimeException.class, future);
        Sleeper.DEFAULT.sleep(1000L);
        writer.close();
    }

    @Test
    public void testUpdatedSchemaFetch_multiplexing() throws Exception {
        this.testUpdatedSchemaFetch(true);
    }

    @Test
    public void testUpdatedSchemaFetch_nonMultiplexing() throws Exception {
        this.testUpdatedSchemaFetch(false);
    }

    private void testUpdatedSchemaFetch(boolean enableMultiplexing) throws IOException, ExecutionException, InterruptedException {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setChannelProvider((TransportChannelProvider)serviceHelper.createChannelProvider()).setWriterSchema(this.PROTO_SCHEMA).setEnableConnectionPool(enableMultiplexing).setLocation("us").build();
        this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).setUpdatedSchema(this.UPDATED_TABLE_SCHEMA).setWriteStream(TEST_STREAM_1).build());
        Assert.assertEquals((Object)writer.getUpdatedSchema(), null);
        AppendRowsResponse response = (AppendRowsResponse)writer.append(this.createProtoRows(new String[]{String.valueOf(0)}), 0L).get();
        Assert.assertEquals((Object)writer.getUpdatedSchema(), (Object)this.UPDATED_TABLE_SCHEMA);
        StreamWriter writer2 = StreamWriter.newBuilder((String)TEST_STREAM_1).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setChannelProvider((TransportChannelProvider)serviceHelper.createChannelProvider()).setWriterSchema(this.PROTO_SCHEMA).setEnableConnectionPool(enableMultiplexing).setLocation("us").build();
        Assert.assertEquals((Object)writer2.getUpdatedSchema(), null);
    }

    @Test
    public void testNoSchema() throws Exception {
        StatusRuntimeException ex = (StatusRuntimeException)Assert.assertThrows(StatusRuntimeException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamWriter.newBuilder((String)StreamWriterTest.TEST_STREAM_1, (BigQueryWriteClient)StreamWriterTest.this.client).build();
            }
        });
        Assert.assertEquals((Object)ex.getStatus().getCode(), (Object)Status.INVALID_ARGUMENT.getCode());
        Assert.assertTrue((boolean)ex.getStatus().getDescription().contains("Writer schema must be provided"));
    }

    @Test
    public void testInvalidTraceId() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamWriter.newBuilder((String)StreamWriterTest.TEST_STREAM_1).setTraceId("abc");
            }
        });
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamWriter.newBuilder((String)StreamWriterTest.TEST_STREAM_1).setTraceId("abc:");
            }
        });
        Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamWriter.newBuilder((String)StreamWriterTest.TEST_STREAM_1).setTraceId(":abc");
            }
        });
    }

    @Test
    public void testEnableConnectionPoolOnExplicitStream() throws Exception {
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamWriter.newBuilder((String)StreamWriterTest.EXPLICIT_STEAM, (BigQueryWriteClient)StreamWriterTest.this.client).setEnableConnectionPool(true).build();
            }
        });
        Assert.assertTrue((boolean)ex.getMessage().contains("Trying to enable connection pool in non-default stream."));
    }

    @Test
    public void testShortenStreamNameAllowed() throws Exception {
        StreamWriter.newBuilder((String)TEST_STREAM_SHORTEN, (BigQueryWriteClient)this.client).setEnableConnectionPool(true).setLocation("us").build();
    }

    @Test
    public void testAppendSuccessAndConnectionError() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setTraceId(TEST_TRACE_ID).setMaxRetryDuration(java.time.Duration.ofMillis(1L)).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addException((Exception)Status.INTERNAL.asException());
        this.testBigQueryWrite.addException((Exception)Status.INTERNAL.asException());
        this.testBigQueryWrite.addException((Exception)Status.INTERNAL.asException());
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"B"});
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        ApiException actualError = StreamWriterTest.assertFutureException(ApiException.class, appendFuture2);
        Assert.assertEquals((Object)StatusCode.Code.INTERNAL, (Object)actualError.getStatusCode().getCode());
        writer.close();
    }

    @Test
    public void testAppendSuccessAndInStreamError() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponseWithError(Status.INVALID_ARGUMENT.getCode(), "test message"));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"B"});
        ApiFuture<AppendRowsResponse> appendFuture3 = this.sendTestMessage(writer, new String[]{"C"});
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        StatusRuntimeException actualError = StreamWriterTest.assertFutureException(StatusRuntimeException.class, appendFuture2);
        Assert.assertEquals((Object)Status.Code.INVALID_ARGUMENT, (Object)actualError.getStatus().getCode());
        Assert.assertEquals((Object)"test message", (Object)actualError.getStatus().getDescription());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue());
        writer.close();
    }

    @Test
    public void testAppendFailedSchemaError() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        StorageError storageError = StorageError.newBuilder().setCode(StorageError.StorageErrorCode.SCHEMA_MISMATCH_EXTRA_FIELDS).setEntity("foobar").build();
        com.google.rpc.Status statusProto = com.google.rpc.Status.newBuilder().setCode(StatusCode.Code.INVALID_ARGUMENT.getHttpStatusCode()).addDetails(Any.pack((Message)storageError)).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setError(statusProto).build());
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"B"});
        ApiFuture<AppendRowsResponse> appendFuture3 = this.sendTestMessage(writer, new String[]{"C"});
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Exceptions.SchemaMismatchedException actualError = StreamWriterTest.assertFutureException(Exceptions.SchemaMismatchedException.class, appendFuture2);
        Assert.assertEquals((Object)"foobar", (Object)actualError.getStreamName());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue());
        writer.close();
    }

    @Test
    public void testAppendFailRandomException() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal argument");
        this.testBigQueryWrite.addException(illegalArgumentException);
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        UnknownException actualError = StreamWriterTest.assertFutureException(UnknownException.class, appendFuture1);
        Assert.assertEquals((Object)StatusCode.Code.UNKNOWN, (Object)actualError.getStatusCode().getCode());
        writer.close();
    }

    @Test
    public void longIdleBetweenAppends() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        TimeUnit.SECONDS.sleep(3L);
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"B"});
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        writer.close();
    }

    @Test
    public void testAppendAfterUserClose() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        writer.close();
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"B"});
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Assert.assertTrue((boolean)appendFuture2.isDone());
        StatusRuntimeException actualError = StreamWriterTest.assertFutureException(StatusRuntimeException.class, appendFuture2);
        Assert.assertEquals((Object)Status.Code.FAILED_PRECONDITION, (Object)actualError.getStatus().getCode());
    }

    @Test
    public void testAppendAfterServerClose() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        this.testBigQueryWrite.addException((Exception)Status.INVALID_ARGUMENT.asException());
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        ApiException error1 = StreamWriterTest.assertFutureException(ApiException.class, appendFuture1);
        Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)error1.getStatusCode().getCode());
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"B"});
        Assert.assertTrue((boolean)appendFuture2.isDone());
        StatusRuntimeException error2 = StreamWriterTest.assertFutureException(StatusRuntimeException.class, appendFuture2);
        Assert.assertEquals((Object)Status.Code.FAILED_PRECONDITION, (Object)error2.getStatus().getCode());
        writer.close();
    }

    @Test
    public void userCloseWhileRequestInflight() throws Exception {
        final StreamWriter writer = this.getTestStreamWriter();
        this.testBigQueryWrite.setResponseSleep(Duration.ofSeconds((long)2L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        final ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        Thread closeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                writer.close();
            }
        });
        closeThread.start();
        Assert.assertThrows(TimeoutException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                appendFuture1.get(1L, TimeUnit.SECONDS);
            }
        });
        closeThread.join(2000L);
        Assert.assertTrue((boolean)appendFuture1.isDone());
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
    }

    @Test
    public void serverCloseWhileRequestsInflight() throws Exception {
        int i;
        StreamWriter writer = this.getTestStreamWriter();
        this.testBigQueryWrite.setResponseSleep(Duration.ofSeconds((long)2L));
        this.testBigQueryWrite.addException((Exception)Status.INVALID_ARGUMENT.asException());
        int appendCount = 10;
        ArrayList<ApiFuture<AppendRowsResponse>> futures = new ArrayList<ApiFuture<AppendRowsResponse>>();
        for (i = 0; i < appendCount; ++i) {
            futures.add(this.sendTestMessage(writer, new String[]{String.valueOf(i)}));
        }
        for (i = 0; i < appendCount; ++i) {
            ApiException actualError = StreamWriterTest.assertFutureException(ApiException.class, (Future)futures.get(i));
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)actualError.getStatusCode().getCode());
        }
        writer.close();
    }

    @Test
    public void testZeroMaxInflightRequests() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setMaxInflightRequests(0L).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.verifyAppendIsBlocked(writer);
        writer.close();
    }

    @Test
    public void testZeroMaxInflightBytes() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setMaxInflightBytes(0L).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.verifyAppendIsBlocked(writer);
        writer.close();
    }

    @Test
    public void testOneMaxInflightRequests() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setMaxInflightRequests(1L).build();
        this.testBigQueryWrite.setResponseSleep(Duration.ofSeconds((long)1L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        Assert.assertTrue((writer.getInflightWaitSeconds() >= 1L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        writer.close();
    }

    @Test
    public void testOneMaxInflightRequests_MultiplexingCase() throws Exception {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMaxConnectionsPerRegion(2).build());
        StreamWriter writer1 = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setLocation("US").setEnableConnectionPool(true).setMaxInflightRequests(1L).build();
        StreamWriter writer2 = StreamWriter.newBuilder((String)TEST_STREAM_2, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setMaxInflightRequests(1L).setEnableConnectionPool(true).setMaxInflightRequests(1L).setLocation("US").build();
        this.testBigQueryWrite.setResponseSleep(Duration.ofSeconds((long)1L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer1, new String[]{"A"});
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer2, new String[]{"A"});
        Assert.assertTrue((writer1.getInflightWaitSeconds() >= 1L ? 1 : 0) != 0);
        Assert.assertTrue((writer2.getInflightWaitSeconds() >= 1L ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        writer1.close();
        writer2.close();
    }

    @Test
    public void testProtoSchemaPiping_nonMultiplexingCase() throws Exception {
        ProtoSchema protoSchema = this.createProtoSchema();
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(protoSchema).setMaxInflightBytes(1L).build();
        long appendCount = 5L;
        int i = 0;
        while ((long)i < appendCount) {
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            ++i;
        }
        ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
        int i2 = 0;
        while ((long)i2 < appendCount) {
            futures.add(writer.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)i2));
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < appendCount) {
            Assert.assertEquals((long)i2, (long)((AppendRowsResponse)((ApiFuture)futures.get(i2)).get()).getAppendResult().getOffset().getValue());
            ++i2;
        }
        Assert.assertEquals((long)appendCount, (long)this.testBigQueryWrite.getAppendRequests().size());
        i2 = 0;
        while ((long)i2 < appendCount) {
            AppendRowsRequest appendRowsRequest = this.testBigQueryWrite.getAppendRequests().get(i2);
            Assert.assertEquals((long)i2, (long)appendRowsRequest.getOffset().getValue());
            if (i2 == 0) {
                appendRowsRequest.getProtoRows().getWriterSchema().equals((Object)protoSchema);
                Assert.assertEquals((Object)appendRowsRequest.getWriteStream(), (Object)TEST_STREAM_1);
            } else {
                appendRowsRequest.getProtoRows().getWriterSchema().equals((Object)ProtoSchema.getDefaultInstance());
            }
            ++i2;
        }
        writer.close();
    }

    @Test
    public void testProtoSchemaPiping_multiplexingCase() throws Exception {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMinConnectionsPerRegion(1).setMaxConnectionsPerRegion(1).build());
        ProtoSchema schema1 = this.createProtoSchema("Schema1");
        ProtoSchema schema2 = this.createProtoSchema("Schema2");
        StreamWriter writer1 = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(schema1).setLocation("US").setEnableConnectionPool(true).setMaxInflightRequests(1L).build();
        StreamWriter writer2 = StreamWriter.newBuilder((String)TEST_STREAM_2, (BigQueryWriteClient)this.client).setWriterSchema(schema2).setMaxInflightRequests(1L).setEnableConnectionPool(true).setLocation("US").build();
        long appendCountPerStream = 5L;
        int i = 0;
        while ((long)i < appendCountPerStream * 4L) {
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            ++i;
        }
        ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
        int i2 = 0;
        while ((long)i2 < appendCountPerStream) {
            futures.add(writer1.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)(i2 * 4)));
            futures.add(writer1.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)(i2 * 4 + 1)));
            futures.add(writer2.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)(i2 * 4 + 2)));
            futures.add(writer2.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)(i2 * 4 + 3)));
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < appendCountPerStream * 4L) {
            AppendRowsRequest appendRowsRequest = this.testBigQueryWrite.getAppendRequests().get(i2);
            Assert.assertEquals((long)i2, (long)appendRowsRequest.getOffset().getValue());
            if (i2 % 4 == 0) {
                Assert.assertEquals((Object)appendRowsRequest.getProtoRows().getWriterSchema(), (Object)schema1);
                Assert.assertEquals((Object)appendRowsRequest.getWriteStream(), (Object)TEST_STREAM_1);
            } else if (i2 % 4 == 1) {
                Assert.assertEquals((Object)appendRowsRequest.getProtoRows().getWriterSchema(), (Object)ProtoSchema.getDefaultInstance());
                if (i2 == 1) {
                    Assert.assertEquals((Object)appendRowsRequest.getWriteStream(), (Object)"");
                } else {
                    Assert.assertEquals((Object)appendRowsRequest.getWriteStream(), (Object)TEST_STREAM_1);
                }
            } else if (i2 % 4 == 2) {
                Assert.assertEquals((Object)appendRowsRequest.getProtoRows().getWriterSchema(), (Object)schema2);
                Assert.assertEquals((Object)appendRowsRequest.getWriteStream(), (Object)TEST_STREAM_2);
            } else {
                Assert.assertEquals((Object)appendRowsRequest.getProtoRows().getWriterSchema(), (Object)ProtoSchema.getDefaultInstance());
                Assert.assertEquals((Object)appendRowsRequest.getWriteStream(), (Object)TEST_STREAM_2);
            }
            ++i2;
        }
        writer1.close();
        writer2.close();
    }

    @Test
    public void testAppendsWithTinyMaxInflightBytes() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setMaxInflightBytes(1L).build();
        this.testBigQueryWrite.setResponseSleep(Duration.ofMillis((long)100L));
        long appendCount = 10L;
        int i = 0;
        while ((long)i < appendCount) {
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            ++i;
        }
        ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
        long appendStartTimeMs = System.currentTimeMillis();
        int i2 = 0;
        while ((long)i2 < appendCount) {
            futures.add(writer.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)i2));
            ++i2;
        }
        long appendElapsedMs = System.currentTimeMillis() - appendStartTimeMs;
        Assert.assertTrue((appendElapsedMs >= 1000L ? 1 : 0) != 0);
        int i3 = 0;
        while ((long)i3 < appendCount) {
            Assert.assertEquals((long)i3, (long)((AppendRowsResponse)((ApiFuture)futures.get(i3)).get()).getAppendResult().getOffset().getValue());
            ++i3;
        }
        Assert.assertEquals((long)appendCount, (long)this.testBigQueryWrite.getAppendRequests().size());
        i3 = 0;
        while ((long)i3 < appendCount) {
            Assert.assertEquals((long)i3, (long)this.testBigQueryWrite.getAppendRequests().get(i3).getOffset().getValue());
            ++i3;
        }
        writer.close();
    }

    @Test
    public void testAppendsWithTinyMaxInflightBytesThrow() throws Exception {
        final StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setMaxInflightBytes(1L).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build();
        Exceptions.InflightBytesLimitExceededException ex = (Exceptions.InflightBytesLimitExceededException)Assert.assertThrows(Exceptions.InflightBytesLimitExceededException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                writer.append(StreamWriterTest.this.createProtoRows(new String[]{String.valueOf(10)}), -1L);
            }
        });
        Assert.assertEquals((Object)ex.getStatus().getCode(), (Object)Status.RESOURCE_EXHAUSTED.getCode());
        Assert.assertTrue((boolean)ex.getStatus().getDescription().contains("Exceeds client side inflight buffer, consider add more buffer or open more connections"));
        Assert.assertEquals((Object)ex.getWriterId(), (Object)writer.getWriterId());
        Assert.assertEquals((long)1L, (long)ex.getCurrentLimit());
        writer.close();
    }

    @Test
    public void testLimitBehaviorIgnoreNotAccepted() throws Exception {
        StatusRuntimeException ex = (StatusRuntimeException)Assert.assertThrows(StatusRuntimeException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                StreamWriter writer = StreamWriter.newBuilder((String)StreamWriterTest.TEST_STREAM_1, (BigQueryWriteClient)StreamWriterTest.this.client).setWriterSchema(StreamWriterTest.this.createProtoSchema()).setMaxInflightBytes(1L).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build();
            }
        });
        Assert.assertEquals((Object)ex.getStatus().getCode(), (Object)Status.INVALID_ARGUMENT.getCode());
        Assert.assertTrue((boolean)ex.getStatus().getDescription().contains("LimitExceededBehavior.Ignore is not supported on StreamWriter."));
    }

    @Test
    public void testMessageTooLarge() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        String oversized = Strings.repeat((String)"a", (int)((int)(StreamWriter.getApiMaxRequestBytes() + 1L)));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{oversized});
        Assert.assertTrue((boolean)appendFuture1.isDone());
        StatusRuntimeException actualError = StreamWriterTest.assertFutureException(StatusRuntimeException.class, appendFuture1);
        Assert.assertEquals((Object)Status.Code.INVALID_ARGUMENT, (Object)actualError.getStatus().getCode());
        Assert.assertTrue((boolean)actualError.getStatus().getDescription().contains("MessageSize is too large"));
        writer.close();
    }

    @Test
    public void testThrowExceptionWhileWithinAppendLoop_MaxWaitTimeExceed() throws Exception {
        ProtoSchema schema1 = this.createProtoSchema("foo");
        StreamWriter.setMaxRequestCallbackWaitTime((java.time.Duration)java.time.Duration.ofSeconds(1L));
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(schema1).build();
        this.testBigQueryWrite.setResponseSleep(Duration.ofSeconds((long)3L));
        long appendCount = 10L;
        int i = 0;
        while ((long)i < appendCount) {
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            ++i;
        }
        ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
        int i2 = 0;
        while ((long)i2 < appendCount) {
            futures.add(writer.append(this.createProtoRows(new String[]{String.valueOf(i2)}), (long)i2));
            ++i2;
        }
        i2 = 0;
        while ((long)i2 < appendCount) {
            int finalI = i2++;
            ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ((AppendRowsResponse)((ApiFuture)futures.get(finalI)).get()).getAppendResult().getOffset().getValue());
            Truth.assertThat((Throwable)ex.getCause()).hasMessageThat().contains((CharSequence)"Request has waited in inflight queue");
        }
    }

    @Test
    public void testAppendWithResetSuccess() throws Exception {
        try (StreamWriter writer = this.getTestStreamWriter();){
            this.testBigQueryWrite.setCloseEveryNAppends(113L);
            long appendCount = 10000L;
            for (long i = 0L; i < appendCount; ++i) {
                this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            }
            ArrayList<ApiFuture<AppendRowsResponse>> futures = new ArrayList<ApiFuture<AppendRowsResponse>>();
            for (long i = 0L; i < appendCount; ++i) {
                futures.add(this.sendTestMessage(writer, new String[]{String.valueOf(i)}, i));
            }
            int i = 0;
            while ((long)i < appendCount) {
                Assert.assertEquals((long)((AppendRowsResponse)((ApiFuture)futures.get(i)).get()).getAppendResult().getOffset().getValue(), (long)i);
                ++i;
            }
            Assert.assertTrue((this.testBigQueryWrite.getConnectionCount() >= (long)((int)((double)appendCount / 113.0)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAppendWithResetNeverSuccess() throws Exception {
        try (StreamWriter writer = this.getTestStreamWriter();){
            this.testBigQueryWrite.setCloseForeverAfter(1L);
            long appendCount = 100L;
            for (long i = 0L; i < appendCount; ++i) {
                this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            }
            ArrayList<ApiFuture<AppendRowsResponse>> futures = new ArrayList<ApiFuture<AppendRowsResponse>>();
            for (long i = 0L; i < appendCount; ++i) {
                futures.add(this.sendTestMessage(writer, new String[]{String.valueOf(i)}, i));
            }
            Assert.assertEquals((long)((AppendRowsResponse)((ApiFuture)futures.get(0)).get()).getAppendResult().getOffset().getValue(), (long)0L);
            int i = 1;
            while ((long)i < appendCount) {
                StreamWriterTest.assertFutureException(AbortedException.class, (Future)futures.get(i));
                ++i;
            }
        }
    }

    @Test
    public void testAppendWithResetNeverSuccessWithMultiplexing() throws Exception {
        try (StreamWriter writer = this.getMultiplexingTestStreamWriter();){
            this.testBigQueryWrite.setCloseForeverAfter(1L);
            long appendCount = 100L;
            for (long i = 0L; i < appendCount; ++i) {
                this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(i));
            }
            ArrayList<ApiFuture<AppendRowsResponse>> futures = new ArrayList<ApiFuture<AppendRowsResponse>>();
            for (long i = 0L; i < appendCount; ++i) {
                futures.add(this.sendTestMessage(writer, new String[]{String.valueOf(i)}, i));
            }
            Assert.assertEquals((long)((AppendRowsResponse)((ApiFuture)futures.get(0)).get()).getAppendResult().getOffset().getValue(), (long)0L);
            int i = 1;
            while ((long)i < appendCount) {
                StreamWriterTest.assertFutureException(AbortedException.class, (Future)futures.get(i));
                ++i;
            }
        }
    }

    @Test
    public void testRetryAfterAllRecordsInflight() throws Exception {
        try (StreamWriter writer = this.getTestStreamWriter();){
            this.testBigQueryWrite.setCloseEveryNAppends(2L);
            this.testBigQueryWrite.setTimesToClose(1L);
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
            this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
            ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"}, 0L);
            ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"B"}, 1L);
            TimeUnit.SECONDS.sleep(1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        }
    }

    @Test
    public void testWriterClosedStream() throws Exception {
        try (StreamWriter writer = this.getTestStreamWriter();){
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    @Test
    public void testWriterAlreadyClosedException() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        writer.close();
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"}, 0L);
        Exceptions.StreamWriterClosedException actualError = StreamWriterTest.assertFutureException(Exceptions.StreamWriterClosedException.class, appendFuture1);
        Assert.assertTrue((boolean)(actualError instanceof StatusRuntimeException));
        Assert.assertEquals((Object)Status.Code.FAILED_PRECONDITION, (Object)actualError.getStatus().getCode());
        Assert.assertTrue((boolean)actualError.getStatus().getDescription().contains("User closed StreamWriter"));
        Assert.assertEquals((Object)actualError.getWriterId(), (Object)writer.getWriterId());
        Assert.assertEquals((Object)actualError.getStreamName(), (Object)writer.getStreamName());
    }

    @Test
    public void testWriterClosedException() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        this.testBigQueryWrite.addException((Exception)Status.INTERNAL.asException());
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"}, 0L);
        try {
            appendFuture1.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"A"}, 0L);
        Exceptions.StreamWriterClosedException actualError = StreamWriterTest.assertFutureException(Exceptions.StreamWriterClosedException.class, appendFuture2);
        Assert.assertTrue((boolean)(actualError instanceof StatusRuntimeException));
        Assert.assertEquals((Object)Status.Code.FAILED_PRECONDITION, (Object)actualError.getStatus().getCode());
        Assert.assertTrue((boolean)actualError.getStatus().getDescription().contains("Connection is closed"));
        Assert.assertEquals((Object)actualError.getWriterId(), (Object)writer.getWriterId());
        Assert.assertEquals((Object)actualError.getStreamName(), (Object)writer.getStreamName());
    }

    @Test
    public void testWriterId() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        StreamWriter writer1 = this.getTestStreamWriter();
        Assert.assertFalse((boolean)writer1.getWriterId().isEmpty());
        StreamWriter writer2 = this.getTestStreamWriter();
        Assert.assertFalse((boolean)writer2.getWriterId().isEmpty());
        Assert.assertNotEquals((Object)writer1.getWriterId(), (Object)writer2.getWriterId());
    }

    @Test
    public void testInitialization_operationKind() throws Exception {
        try (StreamWriter streamWriter = this.getMultiplexingTestStreamWriter();){
            Assert.assertEquals((Object)streamWriter.getConnectionOperationType(), (Object)StreamWriter.SingleConnectionOrConnectionPool.Kind.CONNECTION_WORKER_POOL);
        }
        streamWriter = this.getTestStreamWriter();
        var2_2 = null;
        try {
            Assert.assertEquals((Object)streamWriter.getConnectionOperationType(), (Object)StreamWriter.SingleConnectionOrConnectionPool.Kind.CONNECTION_WORKER);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (streamWriter != null) {
                if (var2_2 != null) {
                    try {
                        streamWriter.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    streamWriter.close();
                }
            }
        }
    }

    @Test
    public void testExtractDatasetName() throws Exception {
        Assert.assertEquals((Object)StreamWriter.extractDatasetAndProjectName((String)"projects/project1/datasets/dataset2/tables/something"), (Object)"projects/project1/datasets/dataset2/");
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> StreamWriter.extractDatasetAndProjectName((String)"wrong/projects/project1/wrong/datasets/dataset2/tables/something"));
        Assert.assertTrue((boolean)ex.getMessage().contains("The passed in stream name does not match"));
    }

    @Test
    public void testRetryInUnrecoverableStatus_MultiplexingCase() throws Exception {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMinConnectionsPerRegion(1).setMaxConnectionsPerRegion(4).build());
        ConnectionWorkerPool.enableTestingLogic();
        StreamWriter writer1 = this.getMultiplexingStreamWriter(TEST_STREAM_1);
        StreamWriter writer2 = this.getMultiplexingStreamWriter(TEST_STREAM_2);
        StreamWriter writer3 = this.getMultiplexingStreamWriter(TEST_STREAM_3);
        StreamWriter writer4 = this.getMultiplexingStreamWriter(TEST_STREAM_3);
        this.testBigQueryWrite.setCloseForeverAfter(2L);
        this.testBigQueryWrite.setTimesToClose(1L);
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer1, new String[]{"A"}, 0L);
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer2, new String[]{"B"}, 1L);
        ApiFuture<AppendRowsResponse> appendFuture3 = this.sendTestMessage(writer3, new String[]{"C"}, 2L);
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        Assert.assertThrows(ExecutionException.class, () -> Assert.assertEquals((long)2L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue()));
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getTotalConnectionCount(), (long)1L);
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getCreateConnectionCount(), (long)1L);
        this.testBigQueryWrite.setCloseForeverAfter(0L);
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(4L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(5L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(6L));
        ApiFuture<AppendRowsResponse> appendFuture4 = this.sendTestMessage(writer4, new String[]{"A"}, 2L);
        ApiFuture<AppendRowsResponse> appendFuture5 = this.sendTestMessage(writer1, new String[]{"A"}, 3L);
        ApiFuture<AppendRowsResponse> appendFuture6 = this.sendTestMessage(writer2, new String[]{"B"}, 4L);
        Assert.assertEquals((long)4L, (long)((AppendRowsResponse)appendFuture4.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)5L, (long)((AppendRowsResponse)appendFuture5.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)6L, (long)((AppendRowsResponse)appendFuture6.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getTotalConnectionCount(), (long)1L);
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getCreateConnectionCount(), (long)2L);
        writer1.close();
        writer2.close();
        writer3.close();
        writer4.close();
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getTotalConnectionCount(), (long)0L);
    }

    @Test
    public void testCloseWhileInUnrecoverableState() throws Exception {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMinConnectionsPerRegion(1).setMaxConnectionsPerRegion(4).build());
        ConnectionWorkerPool.enableTestingLogic();
        StreamWriter writer1 = this.getMultiplexingStreamWriter(TEST_STREAM_1);
        StreamWriter writer2 = this.getMultiplexingStreamWriter(TEST_STREAM_2);
        StreamWriter writer3 = this.getMultiplexingStreamWriter(TEST_STREAM_3);
        this.testBigQueryWrite.setCloseForeverAfter(2L);
        this.testBigQueryWrite.setTimesToClose(1L);
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer1, new String[]{"A"}, 0L);
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer2, new String[]{"B"}, 1L);
        ApiFuture<AppendRowsResponse> appendFuture3 = this.sendTestMessage(writer3, new String[]{"C"}, 2L);
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)appendFuture2.get()).getAppendResult().getOffset().getValue());
        Assert.assertThrows(ExecutionException.class, () -> Assert.assertEquals((long)2L, (long)((AppendRowsResponse)appendFuture3.get()).getAppendResult().getOffset().getValue()));
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getTotalConnectionCount(), (long)1L);
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getCreateConnectionCount(), (long)1L);
        writer1.close();
        writer2.close();
        Assert.assertEquals((long)writer1.getTestOnlyConnectionWorkerPool().getCreateConnectionCount(), (long)1L);
    }

    public StreamWriter getMultiplexingStreamWriter(String streamName) throws IOException {
        return StreamWriter.newBuilder((String)streamName, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setEnableConnectionPool(true).setMaxInflightRequests(10L).setLocation("US").setMaxRetryDuration(java.time.Duration.ofMillis(100L)).build();
    }

    @Test(timeout=10000L)
    public void testCloseDisconnectedStream() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setChannelProvider((TransportChannelProvider)serviceHelper.createChannelProvider()).setWriterSchema(this.createProtoSchema()).build();
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture1.get()).getAppendResult().getOffset().getValue());
        serviceHelper.stop();
        writer.close();
    }

    @Test
    public void testSetAndGetMissingValueInterpretationMap() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        HashMap<String, AppendRowsRequest.MissingValueInterpretation> missingValueMap = new HashMap<String, AppendRowsRequest.MissingValueInterpretation>();
        missingValueMap.put("col1", AppendRowsRequest.MissingValueInterpretation.NULL_VALUE);
        missingValueMap.put("col3", AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE);
        writer.setMissingValueInterpretationMap(missingValueMap);
        Assert.assertEquals(missingValueMap, (Object)writer.getMissingValueInterpretationMap());
    }

    @Test
    public void testAppendWithMissingValueMap() throws Exception {
        StreamWriter writer = this.getTestStreamWriter();
        long appendCount = 2L;
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(1L));
        ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
        futures.add(writer.append(this.createProtoRows(new String[]{String.valueOf(0)}), 0L));
        HashMap<String, AppendRowsRequest.MissingValueInterpretation> missingValueMap = new HashMap<String, AppendRowsRequest.MissingValueInterpretation>();
        missingValueMap.put("col1", AppendRowsRequest.MissingValueInterpretation.NULL_VALUE);
        missingValueMap.put("col3", AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE);
        writer.setMissingValueInterpretationMap(missingValueMap);
        futures.add(writer.append(this.createProtoRows(new String[]{String.valueOf(1)}), 1L));
        int i = 0;
        while ((long)i < appendCount) {
            Assert.assertEquals((long)i, (long)((AppendRowsResponse)((ApiFuture)futures.get(i)).get()).getAppendResult().getOffset().getValue());
            ++i;
        }
        this.verifyAppendRequests(appendCount);
        AppendRowsRequest request1 = this.testBigQueryWrite.getAppendRequests().get(0);
        AppendRowsRequest request2 = this.testBigQueryWrite.getAppendRequests().get(1);
        Assert.assertTrue((boolean)request1.getMissingValueInterpretations().isEmpty());
        Assert.assertEquals((Object)request2.getMissingValueInterpretations(), missingValueMap);
        writer.close();
    }

    @Test(timeout=10000L)
    public void testStreamWriterUserCloseMultiplexing() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setEnableConnectionPool(true).setLocation("us").build();
        writer.close();
        Assert.assertTrue((boolean)writer.isClosed());
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> appendFuture1.get());
        Assert.assertEquals((Object)Status.Code.FAILED_PRECONDITION, (Object)((StatusRuntimeException)ex.getCause()).getStatus().getCode());
        Assert.assertTrue((boolean)writer.isUserClosed());
    }

    @Test(timeout=10000L)
    public void testStreamWriterUserCloseNoMultiplexing() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).build();
        writer.close();
        Assert.assertTrue((boolean)writer.isClosed());
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> appendFuture1.get());
        Assert.assertEquals((Object)Status.Code.FAILED_PRECONDITION, (Object)((StatusRuntimeException)ex.getCause()).getStatus().getCode());
        Assert.assertTrue((boolean)writer.isUserClosed());
    }

    @Test(timeout=10000L)
    public void testStreamWriterPermanentErrorMultiplexing() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).setEnableConnectionPool(true).setLocation("us").build();
        this.testBigQueryWrite.setCloseForeverAfter(1L);
        this.testBigQueryWrite.setFailedStatus(Status.INVALID_ARGUMENT);
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        appendFuture1.get();
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"A"});
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> appendFuture2.get());
        Assert.assertTrue((boolean)(ex.getCause() instanceof InvalidArgumentException));
        Assert.assertFalse((boolean)writer.isClosed());
        Assert.assertFalse((boolean)writer.isUserClosed());
    }

    @Test(timeout=10000L)
    public void testStreamWriterPermanentErrorNoMultiplexing() throws Exception {
        StreamWriter writer = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)this.client).setWriterSchema(this.createProtoSchema()).build();
        this.testBigQueryWrite.setCloseForeverAfter(1L);
        this.testBigQueryWrite.setFailedStatus(Status.INVALID_ARGUMENT);
        this.testBigQueryWrite.addResponse((AbstractMessage)this.createAppendResponse(0L));
        ApiFuture<AppendRowsResponse> appendFuture1 = this.sendTestMessage(writer, new String[]{"A"});
        appendFuture1.get();
        ApiFuture<AppendRowsResponse> appendFuture2 = this.sendTestMessage(writer, new String[]{"A"});
        ExecutionException ex = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> appendFuture2.get());
        Assert.assertTrue((boolean)writer.isClosed());
        Assert.assertTrue((boolean)(ex.getCause() instanceof InvalidArgumentException));
        Assert.assertFalse((boolean)writer.isUserClosed());
    }

    @Test(timeout=10000L)
    public void testBuilderDefaultSetting() throws Exception {
        StreamWriter.Builder writerBuilder = StreamWriter.newBuilder((String)TEST_STREAM_1);
        BigQueryWriteSettings writeSettings = StreamWriter.getBigQueryWriteSettings((StreamWriter.Builder)writerBuilder);
        Assert.assertEquals((Object)BigQueryWriteSettings.defaultExecutorProviderBuilder().build().toString(), (Object)writeSettings.getBackgroundExecutorProvider().toString());
        Assert.assertEquals((Object)BigQueryWriteSettings.defaultCredentialsProviderBuilder().build().toString(), (Object)writeSettings.getCredentialsProvider().toString());
        Assert.assertTrue((boolean)(writeSettings.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider));
        Assert.assertEquals((Object)BigQueryWriteSettings.getDefaultEndpoint(), (Object)writeSettings.getEndpoint().toString());
    }

    @Test(timeout=10000L)
    public void testBuilderExplicitSetting() throws Exception {
        BigQueryWriteSettings clientSettings = ((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setEndpoint("xxx:345")).setBackgroundExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(4).build())).setTransportChannelProvider((TransportChannelProvider)serviceHelper.createChannelProvider())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        BigQueryWriteClient client = BigQueryWriteClient.create((BigQueryWriteSettings)clientSettings);
        StreamWriter.Builder writerWithClient = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)client);
        BigQueryWriteSettings writerSettings = StreamWriter.getBigQueryWriteSettings((StreamWriter.Builder)writerWithClient);
        Assert.assertEquals((Object)"xxx:345", (Object)writerSettings.getEndpoint());
        Assert.assertTrue((boolean)(writerSettings.getBackgroundExecutorProvider() instanceof InstantiatingExecutorProvider));
        Assert.assertEquals((long)4L, (long)((InstantiatingExecutorProvider)writerSettings.getBackgroundExecutorProvider()).getExecutorThreadCount());
        StreamWriter.Builder writerWithClientWithOverrides = StreamWriter.newBuilder((String)TEST_STREAM_1, (BigQueryWriteClient)client).setEndpoint("yyy:345").setExecutorProvider((ExecutorProvider)InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(14).build()).setChannelProvider((TransportChannelProvider)BigQueryWriteSettings.defaultGrpcTransportProviderBuilder().setKeepAliveTimeout(Duration.ofSeconds((long)500L)).build()).setCredentialsProvider((CredentialsProvider)BigQueryWriteSettings.defaultCredentialsProviderBuilder().setScopesToApply(Arrays.asList("A", "B")).build());
        BigQueryWriteSettings writerSettings2 = StreamWriter.getBigQueryWriteSettings((StreamWriter.Builder)writerWithClientWithOverrides);
        Assert.assertEquals((Object)"yyy:345", (Object)writerSettings2.getEndpoint());
        Assert.assertTrue((boolean)(writerSettings2.getBackgroundExecutorProvider() instanceof InstantiatingExecutorProvider));
        Assert.assertEquals((long)14L, (long)((InstantiatingExecutorProvider)writerSettings2.getBackgroundExecutorProvider()).getExecutorThreadCount());
        Assert.assertTrue((boolean)(writerSettings2.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider));
        Assert.assertEquals((Object)Duration.ofSeconds((long)500L), (Object)((InstantiatingGrpcChannelProvider)writerSettings2.getTransportChannelProvider()).getKeepAliveTimeout());
        Assert.assertTrue((boolean)(writerSettings2.getCredentialsProvider() instanceof GoogleCredentialsProvider));
        Assert.assertEquals((long)2L, (long)((GoogleCredentialsProvider)writerSettings2.getCredentialsProvider()).getScopesToApply().size());
    }

    static class AppendCompleteCallback
    implements ApiFutureCallback<AppendRowsResponse> {
        private final StreamWriter mainStreamWriter;
        private final ProtoRows protoRows;
        private int retryCount = 0;

        public AppendCompleteCallback(StreamWriter mainStreamWriter, ProtoRows protoRows) {
            this.mainStreamWriter = mainStreamWriter;
            this.protoRows = protoRows;
        }

        public void onSuccess(AppendRowsResponse response) {
        }

        public void onFailure(Throwable throwable) {
            for (int i = 0; i < 10; ++i) {
                this.mainStreamWriter.append(this.protoRows);
            }
        }
    }
}

