/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub.readrows;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadGrpc;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import com.google.common.collect.Queues;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.GrpcServerRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ReadRowsRetryTest {
    @Rule
    public GrpcServerRule serverRule = new GrpcServerRule();
    private TestBigQueryStorageService service;
    private BigQueryReadClient client;

    @Before
    public void setUp() throws IOException {
        this.service = new TestBigQueryStorageService();
        this.serverRule.getServiceRegistry().addService((BindableService)this.service);
        BigQueryReadSettings settings = ((BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.serverRule.getChannel())))).build();
        this.client = BigQueryReadClient.create((BigQueryReadSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void happyPathTest() {
        ReadRowsRequest request = RpcExpectation.createRequest("fake-stream", 0L);
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 0L).respondWithNumberOfRows(10).respondWithNumberOfRows(7));
        Assert.assertEquals((long)17L, (long)this.getRowCount(request));
    }

    @Test
    public void immediateRetryTest() {
        ReadRowsRequest request = RpcExpectation.createRequest("fake-stream", 0L);
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 0L).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 0L).respondWithNumberOfRows(10).respondWithNumberOfRows(7));
        Assert.assertEquals((long)17L, (long)this.getRowCount(request));
    }

    @Test
    public void multipleRetryTestWithZeroInitialOffset() {
        ReadRowsRequest request = RpcExpectation.createRequest("fake-stream", 0L);
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 0L).respondWithNumberOfRows(5).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 5L).respondWithNumberOfRows(10).respondWithNumberOfRows(7).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 22L).respondWithNumberOfRows(6));
        Assert.assertEquals((long)28L, (long)this.getRowCount(request));
    }

    @Test
    public void multipleRetryTestWithNonZeroInitialOffset() {
        ReadRowsRequest request = RpcExpectation.createRequest("fake-stream", 17L);
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 17L).respondWithNumberOfRows(5).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 22L).respondWithNumberOfRows(10).respondWithNumberOfRows(7).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 39L).respondWithNumberOfRows(3));
        Assert.assertEquals((long)25L, (long)this.getRowCount(request));
    }

    @Test
    public void errorAtTheVeryEndTest() {
        ReadRowsRequest request = RpcExpectation.createRequest("fake-stream", 0L);
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 0L).respondWithNumberOfRows(10).respondWithNumberOfRows(7).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("fake-stream", 17L).respondWithNumberOfRows(0));
        Assert.assertEquals((long)17L, (long)this.getRowCount(request));
    }

    private int getRowCount(ReadRowsRequest request) {
        ServerStream serverStream = this.client.readRowsCallable().call((Object)request);
        int rowCount = 0;
        for (ReadRowsResponse readRowsResponse : serverStream) {
            rowCount = (int)((long)rowCount + readRowsResponse.getRowCount());
        }
        return rowCount;
    }

    private static class RpcExpectation {
        ReadRowsRequest expectedRequest;
        Status.Code statusCode = Status.Code.OK;
        List<ReadRowsResponse> responses = new ArrayList<ReadRowsResponse>();

        private RpcExpectation() {
        }

        static RpcExpectation create() {
            return new RpcExpectation();
        }

        static ReadRowsRequest createRequest(String streamName, long offset) {
            return ReadRowsRequest.newBuilder().setReadStream(streamName).setOffset(offset).build();
        }

        static ReadRowsResponse createResponse(int numberOfRows) {
            return ReadRowsResponse.newBuilder().setRowCount((long)numberOfRows).build();
        }

        RpcExpectation expectRequest(String streamName, long offset) {
            this.expectedRequest = RpcExpectation.createRequest(streamName, offset);
            return this;
        }

        RpcExpectation respondWithNumberOfRows(int numberOfRows) {
            this.responses.add(RpcExpectation.createResponse(numberOfRows));
            return this;
        }

        RpcExpectation respondWithStatus(Status.Code code) {
            this.statusCode = code;
            return this;
        }
    }

    private static class TestBigQueryStorageService
    extends BigQueryReadGrpc.BigQueryReadImplBase {
        Queue<RpcExpectation> expectations = Queues.newArrayDeque();
        int currentRequestIndex = -1;

        private TestBigQueryStorageService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            RpcExpectation expectedRpc = this.expectations.poll();
            ++this.currentRequestIndex;
            Assert.assertNotNull((String)("Unexpected request #" + this.currentRequestIndex + ": " + request.toString()), (Object)expectedRpc);
            Assert.assertEquals((String)("Expected request #" + this.currentRequestIndex + " does not match actual request: " + request.toString()), (Object)expectedRpc.expectedRequest, (Object)request);
            for (ReadRowsResponse response : expectedRpc.responses) {
                responseObserver.onNext((Object)response);
            }
            if (expectedRpc.statusCode.toStatus().isOk()) {
                responseObserver.onCompleted();
            } else {
                responseObserver.onError((Throwable)expectedRpc.statusCode.toStatus().asRuntimeException());
            }
        }
    }
}

