/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ResourceExhaustedException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1beta2.MockBigQueryRead;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.ReadSession;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Duration;
import com.google.protobuf.Parser;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BigQueryReadClientTest {
    private static MockBigQueryRead mockBigQueryRead;
    private static MockServiceHelper serviceHelper;
    private BigQueryReadClient client;
    private LocalChannelProvider channelProvider;
    private int retryCount;
    private Status.Code lastRetryStatusCode;

    @BeforeClass
    public static void startStaticServer() {
        mockBigQueryRead = new MockBigQueryRead();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockBigQueryRead));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        this.retryCount = 0;
        this.lastRetryStatusCode = Status.Code.OK;
        BigQueryReadSettings settings = ((BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setReadRowsRetryAttemptListener(new BigQueryReadSettings.RetryAttemptListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRetryAttempt(Status prevStatus, Metadata prevMetadata) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    BigQueryReadClientTest.this.retryCount = BigQueryReadClientTest.this.retryCount + 1;
                    BigQueryReadClientTest.this.lastRetryStatusCode = prevStatus.getCode();
                }
            }
        }).build();
        this.client = BigQueryReadClient.create((BigQueryReadSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createReadSessionTest() {
        String name = "name3373707";
        String table = "table110115790";
        ReadSession expectedResponse = ReadSession.newBuilder().setName(name).setTable(table).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ReadSession readSession = ReadSession.newBuilder().build();
        int maxStreamCount = 940837515;
        ReadSession actualResponse = this.client.createReadSession(parent, readSession, maxStreamCount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryRead.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReadSessionRequest actualRequest = (CreateReadSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)readSession, (Object)actualRequest.getReadSession());
        Assert.assertEquals((long)maxStreamCount, (long)actualRequest.getMaxStreamCount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReadSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryRead.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ReadSession readSession = ReadSession.newBuilder().build();
            int maxStreamCount = 940837515;
            this.client.createReadSession(parent, readSession, maxStreamCount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void readRowsTest() throws Exception {
        long rowCount = 1340416618L;
        ReadRowsResponse expectedResponse = ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
        Assert.assertEquals((long)this.retryCount, (long)0L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.OK);
    }

    @Test
    public void readRowsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryRead.addException((Exception)exception);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
        Assert.assertEquals((long)this.retryCount, (long)0L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.OK);
    }

    @Test
    public void readRowsRetryingEOSExceptionTest() throws ExecutionException, InterruptedException {
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Received unexpected EOS on DATA frame from server")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        mockBigQueryRead.addException((Exception)exception);
        long rowCount = 1340416618L;
        ReadRowsResponse expectedResponse = ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((long)this.retryCount, (long)1L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.INTERNAL);
    }

    @Test
    public void readRowsRetryingHttp2StreamRstTest() throws ExecutionException, InterruptedException {
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("HTTP/2 error code: INTERNAL_ERROR\nReceived Rst Stream")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        mockBigQueryRead.addException((Exception)exception);
        long rowCount = 1340416618L;
        ReadRowsResponse expectedResponse = ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((long)this.retryCount, (long)1L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.INTERNAL);
    }

    @Test
    public void readRowsNoRetryForResourceExhaustedWithoutRetryInfo() throws ExecutionException, InterruptedException {
        ResourceExhaustedException exception = new ResourceExhaustedException((Throwable)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED.withDescription("You are out of quota X")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.RESOURCE_EXHAUSTED), false);
        mockBigQueryRead.addException((Exception)exception);
        long rowCount = 1340416618L;
        ReadRowsResponse expectedResponse = ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ResourceExhaustedException));
            ResourceExhaustedException apiException = (ResourceExhaustedException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.RESOURCE_EXHAUSTED, (Object)apiException.getStatusCode().getCode());
        }
        Assert.assertEquals((long)this.retryCount, (long)0L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.OK);
    }

    @Test
    public void readRowsNoRetryForResourceExhaustedWithRetryInfo() throws ExecutionException, InterruptedException {
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setSeconds(2L).setNanos(456).build()).build();
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"google.rpc.retryinfo-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<RetryInfo>(){

            public byte[] toBytes(RetryInfo value) {
                return value.toByteArray();
            }

            public RetryInfo parseBytes(byte[] serialized) {
                try {
                    Parser parser = RetryInfo.newBuilder().build().getParserForType();
                    return (RetryInfo)parser.parseFrom(serialized);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }), (Object)retryInfo);
        ResourceExhaustedException exception = new ResourceExhaustedException((Throwable)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED.withDescription("Try again in a bit"), metadata), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.RESOURCE_EXHAUSTED), false);
        mockBigQueryRead.addException((Exception)exception);
        long rowCount = 1340416618L;
        ReadRowsResponse expectedResponse = ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((long)this.retryCount, (long)1L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.RESOURCE_EXHAUSTED);
    }
}

