/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.cloud.bigquery.storage.test.Test;
import com.google.cloud.bigquery.storage.v1beta2.ProtoSchema;
import com.google.cloud.bigquery.storage.v1beta2.ProtoSchemaConverter;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import org.junit.Assert;
import org.junit.Test;

public class ProtoSchemaConverterTest {
    @Test
    public void convertSimple() {
        Test.AllSupportedTypes testProto = Test.AllSupportedTypes.newBuilder().setStringValue("abc").build();
        ProtoSchema protoSchema = ProtoSchemaConverter.convert((Descriptors.Descriptor)testProto.getDescriptorForType());
        Assert.assertEquals((Object)"name: \"com_google_cloud_bigquery_storage_test_AllSupportedTypes\"\nfield {\n  name: \"int32_value\"\n  number: 1\n  label: LABEL_OPTIONAL\n  type: TYPE_INT32\n}\nfield {\n  name: \"int64_value\"\n  number: 2\n  label: LABEL_OPTIONAL\n  type: TYPE_INT64\n}\nfield {\n  name: \"uint32_value\"\n  number: 3\n  label: LABEL_OPTIONAL\n  type: TYPE_UINT32\n}\nfield {\n  name: \"uint64_value\"\n  number: 4\n  label: LABEL_OPTIONAL\n  type: TYPE_UINT64\n}\nfield {\n  name: \"float_value\"\n  number: 5\n  label: LABEL_OPTIONAL\n  type: TYPE_FLOAT\n}\nfield {\n  name: \"double_value\"\n  number: 6\n  label: LABEL_OPTIONAL\n  type: TYPE_DOUBLE\n}\nfield {\n  name: \"bool_value\"\n  number: 7\n  label: LABEL_OPTIONAL\n  type: TYPE_BOOL\n}\nfield {\n  name: \"enum_value\"\n  number: 8\n  label: LABEL_OPTIONAL\n  type: TYPE_ENUM\n  type_name: \"com_google_cloud_bigquery_storage_test_TestEnum_E.TestEnum\"\n}\nfield {\n  name: \"string_value\"\n  number: 9\n  label: LABEL_REQUIRED\n  type: TYPE_STRING\n}\nnested_type {\n  name: \"com_google_cloud_bigquery_storage_test_TestEnum_E\"\n  enum_type {\n    name: \"TestEnum\"\n    value {\n      name: \"TestEnum0\"\n      number: 0\n    }\n    value {\n      name: \"TestEnum1\"\n      number: 1\n    }\n  }\n}\n", (Object)protoSchema.getProtoDescriptor().toString());
    }

    @Test
    public void convertNested() {
        Test.ComplicateType testProto = Test.ComplicateType.newBuilder().build();
        ProtoSchema protoSchema = ProtoSchemaConverter.convert((Descriptors.Descriptor)testProto.getDescriptorForType());
        Assert.assertEquals((Object)"name: \"com_google_cloud_bigquery_storage_test_ComplicateType\"\nfield {\n  name: \"nested_repeated_type\"\n  number: 1\n  label: LABEL_REPEATED\n  type: TYPE_MESSAGE\n  type_name: \"com_google_cloud_bigquery_storage_test_NestedType\"\n}\nfield {\n  name: \"inner_type\"\n  number: 2\n  label: LABEL_OPTIONAL\n  type: TYPE_MESSAGE\n  type_name: \"com_google_cloud_bigquery_storage_test_InnerType\"\n}\nnested_type {\n  name: \"com_google_cloud_bigquery_storage_test_InnerType\"\n  field {\n    name: \"value\"\n    number: 1\n    label: LABEL_REPEATED\n    type: TYPE_STRING\n  }\n}\nnested_type {\n  name: \"com_google_cloud_bigquery_storage_test_NestedType\"\n  field {\n    name: \"inner_type\"\n    number: 1\n    label: LABEL_REPEATED\n    type: TYPE_MESSAGE\n    type_name: \"com_google_cloud_bigquery_storage_test_InnerType\"\n  }\n}\n", (Object)protoSchema.getProtoDescriptor().toString());
    }

    @Test
    public void convertRecursive() {
        try {
            Test.RecursiveType testProto = Test.RecursiveType.newBuilder().build();
            ProtoSchema protoSchema = ProtoSchemaConverter.convert((Descriptors.Descriptor)testProto.getDescriptorForType());
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException e) {
            Assert.assertEquals((Object)"Recursive type is not supported:com.google.cloud.bigquery.storage.test.RecursiveType", (Object)e.getMessage());
        }
    }

    @Test
    public void convertRecursiveTopMessage() {
        try {
            Test.RecursiveTypeTopMessage testProto = Test.RecursiveTypeTopMessage.newBuilder().build();
            ProtoSchema protoSchema = ProtoSchemaConverter.convert((Descriptors.Descriptor)testProto.getDescriptorForType());
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException e) {
            Assert.assertEquals((Object)"Recursive type is not supported:com.google.cloud.bigquery.storage.test.RecursiveTypeTopMessage", (Object)e.getMessage());
        }
    }

    @Test
    public void convertDuplicateType() {
        Test.DuplicateType testProto = Test.DuplicateType.newBuilder().build();
        ProtoSchema protoSchema = ProtoSchemaConverter.convert((Descriptors.Descriptor)testProto.getDescriptorForType());
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().setName("foo.proto").addMessageType(protoSchema.getProtoDescriptor()).build();
        try {
            Descriptors.FileDescriptor fs = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            Descriptors.Descriptor type = fs.findMessageTypeByName(protoSchema.getProtoDescriptor().getName());
            Assert.assertEquals((long)4L, (long)type.getFields().size());
        }
        catch (Descriptors.DescriptorValidationException ex) {
            Assert.fail((String)("Got unexpected exception: " + ex.getMessage()));
        }
    }
}

