/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteGrpc;
import com.google.cloud.bigquery.storage.v1.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.rpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

class FakeBigQueryWriteImpl
extends BigQueryWriteGrpc.BigQueryWriteImplBase {
    private static final Logger LOG = Logger.getLogger(FakeBigQueryWriteImpl.class.getName());
    private final List<Supplier<Response>> responses = Collections.synchronizedList(new ArrayList());
    private final LinkedBlockingQueue<AppendRowsRequest> requests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<GetWriteStreamRequest> writeRequests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<FlushRowsRequest> flushRequests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<WriteStream> writeResponses = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<FlushRowsResponse> flushResponses = new LinkedBlockingQueue();
    private final AtomicInteger nextMessageId = new AtomicInteger(1);
    private boolean autoPublishResponse;
    private ScheduledExecutorService executor = null;
    private Duration responseSleep = Duration.ZERO;
    private Semaphore responseSemaphore = new Semaphore(0, true);
    private long numberTimesToClose = 0L;
    private long closeAfter = 0L;
    private long recordCount = 0L;
    private long connectionCount = 0L;
    private long closeForeverAfter = 0L;
    private int responseIndex = 0;
    private long expectedOffset = 0L;
    private boolean verifyOffset = false;
    private boolean returnErrorDuringExclusiveStreamRetry = false;
    private boolean returnErrorUntilRetrySuccess = false;
    private Response retryResponse;
    private long retryingOffset = -1L;
    private final Map<StreamObserver<AppendRowsResponse>, Boolean> connectionToFirstRequest = new ConcurrentHashMap<StreamObserver<AppendRowsResponse>, Boolean>();
    private io.grpc.Status failedStatus = io.grpc.Status.ABORTED;

    FakeBigQueryWriteImpl() {
    }

    public void getWriteStream(GetWriteStreamRequest request, StreamObserver<WriteStream> responseObserver) {
        Object response = this.writeResponses.remove();
        if (response instanceof WriteStream) {
            this.writeRequests.add(request);
            responseObserver.onNext((Object)((WriteStream)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException("Unrecognized response type"));
        }
    }

    public void flushRows(FlushRowsRequest request, StreamObserver<FlushRowsResponse> responseObserver) {
        Object response = this.writeResponses.remove();
        if (response instanceof FlushRowsResponse) {
            this.flushRequests.add(request);
            responseObserver.onNext((Object)((FlushRowsResponse)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException("Unrecognized response type"));
        }
    }

    public void waitForResponseScheduled() throws InterruptedException {
        this.responseSemaphore.acquire();
    }

    public long getConnectionCount() {
        return this.connectionCount;
    }

    public void setFailedStatus(io.grpc.Status failedStatus) {
        this.failedStatus = failedStatus;
    }

    private Response determineResponse(long offset) {
        Response response;
        if (this.returnErrorUntilRetrySuccess && offset != this.retryingOffset) {
            response = this.retryResponse;
        } else {
            response = this.responses.get(Math.toIntExact(offset)).get();
            if (this.returnErrorUntilRetrySuccess && !response.getResponse().hasError()) {
                this.retryingOffset = -1L;
                this.retryResponse = null;
            }
        }
        boolean bl = this.returnErrorUntilRetrySuccess = this.returnErrorDuringExclusiveStreamRetry && response.getResponse().hasError();
        if (this.retryingOffset == -1L && this.returnErrorUntilRetrySuccess) {
            this.retryingOffset = offset;
            this.retryResponse = response;
        }
        return response;
    }

    public StreamObserver<AppendRowsRequest> appendRows(final StreamObserver<AppendRowsResponse> responseObserver) {
        ++this.connectionCount;
        this.connectionToFirstRequest.put(responseObserver, true);
        StreamObserver<AppendRowsRequest> requestObserver = new StreamObserver<AppendRowsRequest>(){

            public void onNext(AppendRowsRequest value) {
                FakeBigQueryWriteImpl.this.recordCount++;
                FakeBigQueryWriteImpl.this.requests.add(value);
                long offset = value.getOffset().getValue();
                if (offset == -1L || !value.hasOffset()) {
                    offset = FakeBigQueryWriteImpl.this.responseIndex;
                }
                FakeBigQueryWriteImpl.this.responseIndex++;
                if (FakeBigQueryWriteImpl.this.responseSleep.compareTo(Duration.ZERO) > 0) {
                    LOG.info("Sleeping before response for " + FakeBigQueryWriteImpl.this.responseSleep.toString());
                    Uninterruptibles.sleepUninterruptibly((long)FakeBigQueryWriteImpl.this.responseSleep.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                if (((Boolean)FakeBigQueryWriteImpl.this.connectionToFirstRequest.get(responseObserver)).booleanValue() && (!value.getProtoRows().hasWriterSchema() || value.getWriteStream().isEmpty())) {
                    LOG.info(String.valueOf(!value.getProtoRows().hasWriterSchema() || value.getWriteStream().isEmpty()));
                    responseObserver.onError((Throwable)io.grpc.Status.INVALID_ARGUMENT.withDescription("Unexpected first request: " + value.toString()).asException());
                    return;
                }
                FakeBigQueryWriteImpl.this.connectionToFirstRequest.put(responseObserver, false);
                if (FakeBigQueryWriteImpl.this.closeAfter > 0L && (long)FakeBigQueryWriteImpl.this.responseIndex % FakeBigQueryWriteImpl.this.closeAfter == 0L && FakeBigQueryWriteImpl.this.recordCount % FakeBigQueryWriteImpl.this.closeAfter == 0L && (FakeBigQueryWriteImpl.this.numberTimesToClose == 0L || FakeBigQueryWriteImpl.this.connectionCount <= FakeBigQueryWriteImpl.this.numberTimesToClose)) {
                    LOG.info("Shutting down connection from test...");
                    responseObserver.onError((Throwable)FakeBigQueryWriteImpl.this.failedStatus.asException());
                } else if (FakeBigQueryWriteImpl.this.closeForeverAfter > 0L && FakeBigQueryWriteImpl.this.recordCount > FakeBigQueryWriteImpl.this.closeForeverAfter) {
                    LOG.info("Shutting down connection from test...");
                    responseObserver.onError((Throwable)FakeBigQueryWriteImpl.this.failedStatus.asException());
                } else {
                    Response response = FakeBigQueryWriteImpl.this.determineResponse(offset);
                    if (FakeBigQueryWriteImpl.this.verifyOffset && !response.getResponse().hasError() && response.getResponse().getAppendResult().getOffset().getValue() > -1L) {
                        if (response.getResponse().getAppendResult().getOffset().getValue() != FakeBigQueryWriteImpl.this.expectedOffset) {
                            Status status = Status.newBuilder().setCode(13).build();
                            response = new Response(AppendRowsResponse.newBuilder().setError(status).build());
                        } else {
                            LOG.info(String.format("asserted offset: %s expected: %s", response.getResponse().getAppendResult().getOffset().getValue(), FakeBigQueryWriteImpl.this.expectedOffset));
                            LOG.info(String.format("sending response: %s", response.getResponse()));
                            FakeBigQueryWriteImpl.this.expectedOffset++;
                        }
                    }
                    FakeBigQueryWriteImpl.this.sendResponse(response, (StreamObserver<AppendRowsResponse>)responseObserver);
                }
            }

            public void onError(Throwable t) {
                responseObserver.onError(t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
        return requestObserver;
    }

    private void sendResponse(Response response, StreamObserver<AppendRowsResponse> responseObserver) {
        if (response.isError()) {
            responseObserver.onError(response.getError());
        } else {
            responseObserver.onNext((Object)response.getResponse());
        }
    }

    public FakeBigQueryWriteImpl setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public FakeBigQueryWriteImpl setResponseSleep(Duration responseSleep) {
        this.responseSleep = responseSleep;
        return this;
    }

    public void addResponse(AppendRowsResponse appendRowsResponse) {
        this.responses.add(() -> new Response(appendRowsResponse));
    }

    public void addResponse(Supplier<Response> response) {
        this.responses.add(response);
    }

    public FakeBigQueryWriteImpl addWriteStreamResponse(WriteStream response) {
        this.writeResponses.add(response);
        return this;
    }

    public FakeBigQueryWriteImpl addFlushRowsResponse(FlushRowsResponse response) {
        this.flushResponses.add(response);
        return this;
    }

    public FakeBigQueryWriteImpl addConnectionError(Throwable error) {
        this.responses.add(() -> new Response(error));
        return this;
    }

    public void addException(Status status) {
        this.responses.add(() -> new Response(AppendRowsResponse.newBuilder().setError(status).build()));
    }

    public void addNonRetriableError(Status status) {
        this.responses.add(() -> new Response(AppendRowsResponse.newBuilder().setError(status).build()));
    }

    public void setVerifyOffset(boolean verifyOffset) {
        this.verifyOffset = verifyOffset;
    }

    public void setReturnErrorDuringExclusiveStreamRetry(boolean retryOnError) {
        this.returnErrorDuringExclusiveStreamRetry = retryOnError;
    }

    public List<AppendRowsRequest> getCapturedRequests() {
        return new ArrayList<AppendRowsRequest>(this.requests);
    }

    public List<GetWriteStreamRequest> getCapturedWriteRequests() {
        return new ArrayList<GetWriteStreamRequest>(this.writeRequests);
    }

    public void reset() {
        this.requests.clear();
        this.responses.clear();
    }

    public void setCloseEveryNAppends(long closeAfter) {
        this.closeAfter = closeAfter;
    }

    public void setTimesToClose(long numberTimesToClose) {
        this.numberTimesToClose = numberTimesToClose;
    }

    public void setCloseForeverAfter(long closeForeverAfter) {
        this.closeForeverAfter = closeForeverAfter;
    }

    public static class Response {
        Optional<AppendRowsResponse> appendResponse;
        Optional<Throwable> error;

        public Response(AppendRowsResponse appendResponse) {
            this.appendResponse = Optional.of((Object)appendResponse);
            this.error = Optional.absent();
        }

        public Response(Throwable exception) {
            this.appendResponse = Optional.absent();
            this.error = Optional.of((Object)exception);
        }

        public AppendRowsResponse getResponse() {
            return (AppendRowsResponse)this.appendResponse.get();
        }

        public Throwable getError() {
            return (Throwable)this.error.get();
        }

        boolean isError() {
            return this.error.isPresent();
        }

        public String toString() {
            if (this.isError()) {
                return ((Throwable)this.error.get()).toString();
            }
            return ((AppendRowsResponse)this.appendResponse.get()).toString();
        }
    }
}

