/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ResourceExhaustedException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.MockBigQueryStorage;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.Parser;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BigQueryStorageClientTest {
    private static MockBigQueryStorage mockBigQueryStorage;
    private static MockServiceHelper serviceHelper;
    private BigQueryStorageClient client;
    private LocalChannelProvider channelProvider;
    private int retryCount;
    private Status.Code lastRetryStatusCode;

    @BeforeClass
    public static void startStaticServer() {
        mockBigQueryStorage = new MockBigQueryStorage();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockBigQueryStorage));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        this.retryCount = 0;
        this.lastRetryStatusCode = Status.Code.OK;
        BigQueryStorageSettings settings = ((BigQueryStorageSettings.Builder)((BigQueryStorageSettings.Builder)BigQueryStorageSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setReadRowsRetryAttemptListener(new BigQueryStorageSettings.RetryAttemptListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRetryAttempt(Status prevStatus, Metadata prevMetadata) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    BigQueryStorageClientTest.this.retryCount += 1;
                    BigQueryStorageClientTest.this.lastRetryStatusCode = prevStatus.getCode();
                }
            }
        }).build();
        this.client = BigQueryStorageClient.create((BigQueryStorageSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createReadSessionTest() {
        String name = "name3373707";
        Storage.ReadSession expectedResponse = Storage.ReadSession.newBuilder().setName(name).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().build();
        String parent = "parent-995424086";
        int requestedStreams = 1017221410;
        Storage.ReadSession actualResponse = this.client.createReadSession(tableReference, parent, requestedStreams);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.CreateReadSessionRequest actualRequest = (Storage.CreateReadSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)tableReference, (Object)actualRequest.getTableReference());
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((long)requestedStreams, (long)actualRequest.getRequestedStreams());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReadSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().build();
            String parent = "parent-995424086";
            int requestedStreams = 1017221410;
            this.client.createReadSession(tableReference, parent, requestedStreams);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void readRowsTest() throws Exception {
        Storage.ReadRowsResponse expectedResponse = Storage.ReadRowsResponse.newBuilder().build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.StreamPosition readPosition = Storage.StreamPosition.newBuilder().build();
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().setReadPosition(readPosition).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
        Assert.assertEquals((long)this.retryCount, (long)0L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.OK);
    }

    @Test
    public void readRowsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        Storage.StreamPosition readPosition = Storage.StreamPosition.newBuilder().build();
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().setReadPosition(readPosition).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
        Assert.assertEquals((long)this.retryCount, (long)0L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.OK);
    }

    @Test
    public void batchCreateReadSessionStreamsTest() {
        Storage.BatchCreateReadSessionStreamsResponse expectedResponse = Storage.BatchCreateReadSessionStreamsResponse.newBuilder().build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.ReadSession session = Storage.ReadSession.newBuilder().build();
        int requestedStreams = 1017221410;
        Storage.BatchCreateReadSessionStreamsResponse actualResponse = this.client.batchCreateReadSessionStreams(session, requestedStreams);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.BatchCreateReadSessionStreamsRequest actualRequest = (Storage.BatchCreateReadSessionStreamsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)actualRequest.getSession());
        Assert.assertEquals((long)requestedStreams, (long)actualRequest.getRequestedStreams());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateReadSessionStreamsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            Storage.ReadSession session = Storage.ReadSession.newBuilder().build();
            int requestedStreams = 1017221410;
            this.client.batchCreateReadSessionStreams(session, requestedStreams);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void finalizeStreamTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.Stream stream = Storage.Stream.newBuilder().build();
        this.client.finalizeStream(stream);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.FinalizeStreamRequest actualRequest = (Storage.FinalizeStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)stream, (Object)actualRequest.getStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void finalizeStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            Storage.Stream stream = Storage.Stream.newBuilder().build();
            this.client.finalizeStream(stream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void splitReadStreamTest() {
        Storage.SplitReadStreamResponse expectedResponse = Storage.SplitReadStreamResponse.newBuilder().build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.Stream originalStream = Storage.Stream.newBuilder().build();
        Storage.SplitReadStreamResponse actualResponse = this.client.splitReadStream(originalStream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.SplitReadStreamRequest actualRequest = (Storage.SplitReadStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)originalStream, (Object)actualRequest.getOriginalStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void splitReadStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            Storage.Stream originalStream = Storage.Stream.newBuilder().build();
            this.client.splitReadStream(originalStream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void readRowsRetryingEOSExceptionTest() throws ExecutionException, InterruptedException {
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Received unexpected EOS on DATA frame from server")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        mockBigQueryStorage.addException((Exception)exception);
        long rowCount = 1340416618L;
        Storage.ReadRowsResponse expectedResponse = Storage.ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((long)this.retryCount, (long)1L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.INTERNAL);
    }

    @Test
    public void readRowsRetryingHttp2StreamRstTest() throws ExecutionException, InterruptedException {
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("HTTP/2 error code: INTERNAL_ERROR\nReceived Rst Stream")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        mockBigQueryStorage.addException((Exception)exception);
        long rowCount = 1340416618L;
        Storage.ReadRowsResponse expectedResponse = Storage.ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((long)this.retryCount, (long)1L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.INTERNAL);
    }

    @Test
    public void readRowsNoRetryForResourceExhaustedWithoutRetryInfo() throws ExecutionException, InterruptedException {
        ResourceExhaustedException exception = new ResourceExhaustedException((Throwable)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED.withDescription("You are out of quota X")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.RESOURCE_EXHAUSTED), false);
        mockBigQueryStorage.addException((Exception)exception);
        long rowCount = 1340416618L;
        Storage.ReadRowsResponse expectedResponse = Storage.ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ResourceExhaustedException));
            ResourceExhaustedException apiException = (ResourceExhaustedException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.RESOURCE_EXHAUSTED, (Object)apiException.getStatusCode().getCode());
        }
        Assert.assertEquals((long)this.retryCount, (long)0L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.OK);
    }

    @Test
    public void readRowsNoRetryForResourceExhaustedWithRetryInfo() throws ExecutionException, InterruptedException {
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setSeconds(123L).setNanos(456).build()).build();
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"google.rpc.retryinfo-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<RetryInfo>(){

            public byte[] toBytes(RetryInfo value) {
                return value.toByteArray();
            }

            public RetryInfo parseBytes(byte[] serialized) {
                try {
                    Parser parser = RetryInfo.newBuilder().build().getParserForType();
                    return (RetryInfo)parser.parseFrom(serialized);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }), (Object)retryInfo);
        ResourceExhaustedException exception = new ResourceExhaustedException((Throwable)new StatusRuntimeException(Status.RESOURCE_EXHAUSTED.withDescription("Try again in a bit"), metadata), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.RESOURCE_EXHAUSTED), false);
        mockBigQueryStorage.addException((Exception)exception);
        long rowCount = 1340416618L;
        Storage.ReadRowsResponse expectedResponse = Storage.ReadRowsResponse.newBuilder().setRowCount(rowCount).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((long)this.retryCount, (long)1L);
        Assert.assertEquals((Object)this.lastRetryStatusCode, (Object)Status.Code.RESOURCE_EXHAUSTED);
    }
}

