/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.cloud.bigquery.storage.v1.stub.EnhancedBigQueryReadStubSettings;
import com.google.common.truth.Truth;
import java.time.Duration;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class EnhancedBigQueryReadStubSettingsTest {
    @Test
    public void testSettingsArePreserved() {
        String endpoint = "some.other.host:123";
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        Duration watchdogInterval = Duration.ofSeconds(12L);
        WatchdogProvider watchdogProvider = (WatchdogProvider)Mockito.mock(WatchdogProvider.class);
        EnhancedBigQueryReadStubSettings.Builder builder = (EnhancedBigQueryReadStubSettings.Builder)((EnhancedBigQueryReadStubSettings.Builder)((EnhancedBigQueryReadStubSettings.Builder)((EnhancedBigQueryReadStubSettings.Builder)EnhancedBigQueryReadStubSettings.newBuilder().setEndpoint(endpoint)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogCheckIntervalDuration(watchdogInterval)).setStreamWatchdogProvider(watchdogProvider);
        this.verifyBuilder(builder, endpoint, credentialsProvider, watchdogInterval, watchdogProvider);
        this.verifySettings(builder.build(), endpoint, credentialsProvider, watchdogInterval, watchdogProvider);
        this.verifyBuilder(builder.build().toBuilder(), endpoint, credentialsProvider, watchdogInterval, watchdogProvider);
    }

    private void verifyBuilder(EnhancedBigQueryReadStubSettings.Builder builder, String endpoint, CredentialsProvider credentialsProvider, Duration watchdogInterval, WatchdogProvider watchdogProvider) {
        Truth.assertThat((String)builder.getEndpoint()).isEqualTo((Object)endpoint);
        Truth.assertThat((Object)builder.getCredentialsProvider()).isEqualTo((Object)credentialsProvider);
        Truth.assertThat((Comparable)builder.getStreamWatchdogCheckIntervalDuration()).isEqualTo((Object)watchdogInterval);
        Truth.assertThat((Object)builder.getStreamWatchdogProvider()).isEqualTo((Object)watchdogProvider);
        InstantiatingGrpcChannelProvider channelProvider = (InstantiatingGrpcChannelProvider)builder.getTransportChannelProvider();
        Truth.assertThat((Integer)channelProvider.toBuilder().getMaxInboundMessageSize()).isEqualTo((Object)Integer.MAX_VALUE);
    }

    private void verifySettings(EnhancedBigQueryReadStubSettings settings, String endpoint, CredentialsProvider credentialsProvider, Duration watchdogInterval, WatchdogProvider watchdogProvider) {
        Truth.assertThat((String)settings.getEndpoint()).isEqualTo((Object)endpoint);
        Truth.assertThat((Object)settings.getCredentialsProvider()).isEqualTo((Object)credentialsProvider);
        Truth.assertThat((Comparable)settings.getStreamWatchdogCheckIntervalDuration()).isEqualTo((Object)watchdogInterval);
        Truth.assertThat((Object)settings.getStreamWatchdogProvider()).isEqualTo((Object)watchdogProvider);
        InstantiatingGrpcChannelProvider channelProvider = (InstantiatingGrpcChannelProvider)settings.getTransportChannelProvider();
        Truth.assertThat((Integer)channelProvider.toBuilder().getMaxInboundMessageSize()).isEqualTo((Object)Integer.MAX_VALUE);
    }

    @Test
    public void testCreateReadSessionSettings() {
        UnaryCallSettings.Builder builder = EnhancedBigQueryReadStubSettings.newBuilder().createReadSessionSettings();
        this.verifyRetrySettings(builder.getRetryableCodes(), builder.getRetrySettings());
    }

    @Test
    public void testReadRowsSettings() {
        ServerStreamingCallSettings.Builder builder = EnhancedBigQueryReadStubSettings.newBuilder().readRowsSettings();
        Truth.assertThat((Iterable)builder.getRetryableCodes()).contains((Object)StatusCode.Code.UNAVAILABLE);
        RetrySettings retrySettings = builder.getRetrySettings();
        Truth.assertThat((Comparable)retrySettings.getInitialRetryDelayDuration()).isEqualTo((Object)Duration.ofMillis(100L));
        Truth.assertThat((Double)retrySettings.getRetryDelayMultiplier()).isWithin(1.0E-6).of(1.3);
        Truth.assertThat((Comparable)retrySettings.getMaxRetryDelayDuration()).isEqualTo((Object)Duration.ofMinutes(1L));
        Truth.assertThat((Comparable)retrySettings.getInitialRpcTimeoutDuration()).isEqualTo((Object)Duration.ofDays(1L));
        Truth.assertThat((Double)retrySettings.getRpcTimeoutMultiplier()).isWithin(1.0E-6).of(1.0);
        Truth.assertThat((Comparable)retrySettings.getMaxRpcTimeoutDuration()).isEqualTo((Object)Duration.ofDays(1L));
        Truth.assertThat((Comparable)retrySettings.getTotalTimeoutDuration()).isEqualTo((Object)Duration.ofDays(1L));
        Truth.assertThat((Comparable)builder.getIdleTimeoutDuration()).isEqualTo((Object)Duration.ZERO);
    }

    @Test
    public void testSplitReadStreamSettings() {
        UnaryCallSettings.Builder builder = EnhancedBigQueryReadStubSettings.newBuilder().splitReadStreamSettings();
        this.verifyRetrySettings(builder.getRetryableCodes(), builder.getRetrySettings());
    }

    private void verifyRetrySettings(Set<StatusCode.Code> retryCodes, RetrySettings retrySettings) {
        Truth.assertThat(retryCodes).contains((Object)StatusCode.Code.UNAVAILABLE);
        Truth.assertThat((Comparable)retrySettings.getTotalTimeoutDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Comparable)retrySettings.getInitialRetryDelayDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Double)retrySettings.getRetryDelayMultiplier()).isAtLeast((Comparable)Double.valueOf(1.0));
        Truth.assertThat((Comparable)retrySettings.getMaxRetryDelayDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Comparable)retrySettings.getInitialRpcTimeoutDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Double)retrySettings.getRpcTimeoutMultiplier()).isAtLeast((Comparable)Double.valueOf(1.0));
        Truth.assertThat((Comparable)retrySettings.getMaxRpcTimeoutDuration()).isGreaterThan((Comparable)Duration.ZERO);
    }
}

