/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.util;

import com.google.cloud.bigquery.storage.util.Errors;
import com.google.protobuf.Duration;
import com.google.protobuf.Parser;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ErrorsTest {
    @Test
    public void testRetryableInternalForRstErrors() {
        Assert.assertTrue((boolean)Errors.isRetryableInternalStatus((Status)Status.INTERNAL.withDescription("HTTP/2 error code: INTERNAL_ERROR\nReceived Rst stream")));
        Assert.assertTrue((boolean)Errors.isRetryableInternalStatus((Status)Status.INTERNAL.withDescription("RST_STREAM closed stream. HTTP/2 error code: INTERNAL_ERROR")));
        Assert.assertTrue((boolean)Errors.isRetryableInternalStatus((Status)Status.INTERNAL.withDescription("Rst Stream")));
    }

    @Test
    public void testNonRetryableInternalError() {
        Assert.assertFalse((boolean)Errors.isRetryableInternalStatus((Status)Status.INTERNAL));
        Assert.assertFalse((boolean)Errors.isRetryableInternalStatus((Status)Status.INTERNAL.withDescription("Server error.")));
    }

    @Test
    public void testNonRetryableOtherError() {
        Assert.assertFalse((boolean)Errors.isRetryableInternalStatus((Status)Status.DATA_LOSS.withDescription("RST_STREAM closed stream. HTTP/2 error code: INTERNAL_ERROR")));
    }

    @Test
    public void testIsRetryableStatus() {
        Errors.IsRetryableStatusResult result = Errors.isRetryableStatus((Status)Status.INTERNAL.withDescription("HTTP/2 error code: INTERNAL_ERROR\nReceived Rst stream"), null);
        Assert.assertTrue((boolean)result.isRetryable);
        Assert.assertNull((Object)result.retryDelay);
        result = Errors.isRetryableStatus((Status)Status.INTERNAL.withDescription("RST_STREAM closed stream. HTTP/2 error code: INTERNAL_ERROR"), null);
        Assert.assertTrue((boolean)result.isRetryable);
        Assert.assertNull((Object)result.retryDelay);
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"some-key-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<Integer>(){

            public byte[] toBytes(Integer value) {
                return new byte[0];
            }

            public Integer parseBytes(byte[] serialized) {
                return new Integer(1);
            }
        }), (Object)new Integer(2));
        result = Errors.isRetryableStatus((Status)Status.RESOURCE_EXHAUSTED.withDescription("You have run out of X quota"), (Metadata)metadata);
        Assert.assertFalse((boolean)result.isRetryable);
        Assert.assertNull((Object)result.retryDelay);
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setSeconds(123L).setNanos(456).build()).build();
        metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"google.rpc.retryinfo-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<RetryInfo>(){

            public byte[] toBytes(RetryInfo value) {
                return value.toByteArray();
            }

            public RetryInfo parseBytes(byte[] serialized) {
                try {
                    Parser parser = RetryInfo.newBuilder().build().getParserForType();
                    return (RetryInfo)parser.parseFrom(serialized);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }), (Object)retryInfo);
        result = Errors.isRetryableStatus((Status)Status.RESOURCE_EXHAUSTED.withDescription("Stop for a while"), (Metadata)metadata);
        Assert.assertTrue((boolean)result.isRetryable);
        Assert.assertEquals((Object)result.retryDelay, (Object)java.time.Duration.ofSeconds(123L, 456L));
    }
}

