/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.test.JsonTest;
import com.google.cloud.bigquery.storage.test.SchemaTest;
import com.google.cloud.bigquery.storage.v1.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BQTableSchemaToProtoDescriptorTest {
    private static ImmutableMap<TableFieldSchema.Type, Descriptors.Descriptor> BQTableTypeToCorrectProtoDescriptorTest = new ImmutableMap.Builder().put((Object)TableFieldSchema.Type.BOOL, (Object)SchemaTest.BoolType.getDescriptor()).put((Object)TableFieldSchema.Type.BYTES, (Object)SchemaTest.BytesType.getDescriptor()).put((Object)TableFieldSchema.Type.DATE, (Object)SchemaTest.Int32Type.getDescriptor()).put((Object)TableFieldSchema.Type.DATETIME, (Object)SchemaTest.Int64Type.getDescriptor()).put((Object)TableFieldSchema.Type.DOUBLE, (Object)SchemaTest.DoubleType.getDescriptor()).put((Object)TableFieldSchema.Type.GEOGRAPHY, (Object)SchemaTest.StringType.getDescriptor()).put((Object)TableFieldSchema.Type.INT64, (Object)SchemaTest.Int64Type.getDescriptor()).put((Object)TableFieldSchema.Type.NUMERIC, (Object)SchemaTest.BytesType.getDescriptor()).put((Object)TableFieldSchema.Type.STRING, (Object)SchemaTest.StringType.getDescriptor()).put((Object)TableFieldSchema.Type.TIME, (Object)SchemaTest.Int64Type.getDescriptor()).put((Object)TableFieldSchema.Type.TIMESTAMP, (Object)SchemaTest.Int64Type.getDescriptor()).build();

    private void mapDescriptorToCount(Descriptors.Descriptor descriptor, HashMap<String, Integer> map) {
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            if (field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) continue;
            Descriptors.Descriptor subDescriptor = field.getMessageType();
            String messageName = subDescriptor.getName();
            if (map.containsKey(messageName)) {
                map.put(messageName, map.get(messageName) + 1);
            } else {
                map.put(messageName, 1);
            }
            this.mapDescriptorToCount(subDescriptor, map);
        }
    }

    private void isDescriptorEqual(Descriptors.Descriptor convertedProto, Descriptors.Descriptor originalProto) {
        Assert.assertEquals((long)convertedProto.getFields().size(), (long)originalProto.getFields().size());
        for (Descriptors.FieldDescriptor convertedField : convertedProto.getFields()) {
            Descriptors.FieldDescriptor originalField = originalProto.findFieldByName(convertedField.getName());
            Assert.assertNotNull((Object)originalField);
            Descriptors.FieldDescriptor.Type convertedType = convertedField.getType();
            Descriptors.FieldDescriptor.Type originalType = originalField.getType();
            Assert.assertEquals((String)convertedField.getName(), (Object)convertedType, (Object)originalType);
            Assert.assertTrue((originalField.isRepeated() == convertedField.isRepeated() && originalField.isRequired() == convertedField.isRequired() && originalField.isOptional() == convertedField.isOptional() ? 1 : 0) != 0);
            if (convertedType != Descriptors.FieldDescriptor.Type.MESSAGE) continue;
            this.isDescriptorEqual(convertedField.getMessageType(), originalField.getMessageType());
        }
    }

    @Test
    public void testSimpleTypes() throws Exception {
        for (Map.Entry entry : BQTableTypeToCorrectProtoDescriptorTest.entrySet()) {
            TableFieldSchema tableFieldSchema = TableFieldSchema.newBuilder().setType((TableFieldSchema.Type)entry.getKey()).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_field_type").build();
            TableSchema tableSchema = TableSchema.newBuilder().addFields(0, tableFieldSchema).build();
            Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
            this.isDescriptorEqual(descriptor, (Descriptors.Descriptor)entry.getValue());
        }
    }

    @Test
    public void testRange() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(TableFieldSchema.newBuilder().setName("range_date").setType(TableFieldSchema.Type.RANGE).setMode(TableFieldSchema.Mode.NULLABLE).setRangeElementType(TableFieldSchema.FieldElementType.newBuilder().setType(TableFieldSchema.Type.DATE).build()).build()).addFields(TableFieldSchema.newBuilder().setName("range_datetime").setType(TableFieldSchema.Type.RANGE).setMode(TableFieldSchema.Mode.NULLABLE).setRangeElementType(TableFieldSchema.FieldElementType.newBuilder().setType(TableFieldSchema.Type.DATETIME).build()).build()).addFields(TableFieldSchema.newBuilder().setName("range_timestamp").setType(TableFieldSchema.Type.RANGE).setMode(TableFieldSchema.Mode.NULLABLE).setRangeElementType(TableFieldSchema.FieldElementType.newBuilder().setType(TableFieldSchema.Type.TIMESTAMP).build()).build()).addFields(TableFieldSchema.newBuilder().setName("range_date_miXEd_caSE").setType(TableFieldSchema.Type.RANGE).setMode(TableFieldSchema.Mode.NULLABLE).setRangeElementType(TableFieldSchema.FieldElementType.newBuilder().setType(TableFieldSchema.Type.DATE).build()).build()).addFields(TableFieldSchema.newBuilder().setName("range_datetime_miXEd_caSE").setType(TableFieldSchema.Type.RANGE).setMode(TableFieldSchema.Mode.NULLABLE).setRangeElementType(TableFieldSchema.FieldElementType.newBuilder().setType(TableFieldSchema.Type.DATETIME).build()).build()).addFields(TableFieldSchema.newBuilder().setName("range_timestamp_miXEd_caSE").setType(TableFieldSchema.Type.RANGE).setMode(TableFieldSchema.Mode.NULLABLE).setRangeElementType(TableFieldSchema.FieldElementType.newBuilder().setType(TableFieldSchema.Type.TIMESTAMP).build()).build()).build();
        Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
        this.isDescriptorEqual(descriptor, JsonTest.TestRange.getDescriptor());
    }

    @Test
    public void testStructSimple() throws Exception {
        TableFieldSchema stringType = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_field_type").build();
        TableFieldSchema tableFieldSchema = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_field_type").addFields(0, stringType).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, tableFieldSchema).build();
        Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
        this.isDescriptorEqual(descriptor, SchemaTest.MessageType.getDescriptor());
    }

    @Test
    public void testStructComplex() throws Exception {
        TableFieldSchema test_int = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_int").build();
        TableFieldSchema test_string = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.REPEATED).setName("test_string").build();
        TableFieldSchema test_bytes = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REQUIRED).setName("test_bytes").build();
        TableFieldSchema test_bool = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BOOL).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bool").build();
        TableFieldSchema test_double = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DOUBLE).setMode(TableFieldSchema.Mode.REPEATED).setName("test_double").build();
        TableFieldSchema test_date = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATE).setMode(TableFieldSchema.Mode.REQUIRED).setName("test_date").build();
        TableFieldSchema test_datetime = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_datetime").build();
        TableFieldSchema test_datetime_str = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.REPEATED).setName("test_datetime_str").build();
        TableFieldSchema ComplexLvl22 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.REQUIRED).addFields(0, test_int).setName("complex_lvl2").build();
        TableFieldSchema ComplexLvl12 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.REQUIRED).addFields(0, test_int).addFields(1, ComplexLvl22).setName("complex_lvl1").build();
        TableFieldSchema TEST_NUMERIC = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric").build();
        TableFieldSchema TEST_GEO = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.GEOGRAPHY).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_geo").build();
        TableFieldSchema TEST_TIMESTAMP = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.TIMESTAMP).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_timestamp").build();
        TableFieldSchema TEST_TIME = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_time").build();
        TableFieldSchema TEST_TIME_STR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_time_str").build();
        TableFieldSchema TEST_NUMERIC_REPEATED = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("test_numeric_repeated").build();
        TableFieldSchema TEST_NUMERIC_STR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_str").build();
        TableFieldSchema TEST_NUMERIC_SHORT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_short").build();
        TableFieldSchema TEST_NUMERIC_INT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_int").build();
        TableFieldSchema TEST_NUMERIC_LONG = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_long").build();
        TableFieldSchema TEST_NUMERIC_FLOAT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_float").build();
        TableFieldSchema TEST_NUMERIC_DOUBLE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_double").build();
        TableFieldSchema TEST_BIGNUMERIC = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BIGNUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric").build();
        TableFieldSchema TEST_BIGNUMERIC_STR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BIGNUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("test_bignumeric_str").build();
        TableFieldSchema TEST_BIGNUMERIC_SHORT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BIGNUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_short").build();
        TableFieldSchema TEST_BIGNUMERIC_INT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BIGNUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_int").build();
        TableFieldSchema TEST_BIGNUMERIC_LONG = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BIGNUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_long").build();
        TableFieldSchema TEST_BIGNUMERIC_FLOAT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BIGNUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_float").build();
        TableFieldSchema TEST_BIGNUMERIC_DOUBLE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BIGNUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_double").build();
        TableFieldSchema TEST_INTERVAL = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INTERVAL).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_interval").build();
        TableFieldSchema TEST_JSON = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.JSON).setMode(TableFieldSchema.Mode.REPEATED).setName("test_json").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, test_int).addFields(1, test_string).addFields(2, test_bytes).addFields(3, test_bool).addFields(4, test_double).addFields(5, test_date).addFields(6, test_datetime).addFields(7, test_datetime_str).addFields(8, ComplexLvl12).addFields(9, ComplexLvl22).addFields(10, TEST_NUMERIC).addFields(11, TEST_GEO).addFields(12, TEST_TIMESTAMP).addFields(13, TEST_TIME).addFields(14, TEST_TIME_STR).addFields(15, TEST_NUMERIC_REPEATED).addFields(16, TEST_NUMERIC_STR).addFields(17, TEST_NUMERIC_SHORT).addFields(18, TEST_NUMERIC_INT).addFields(19, TEST_NUMERIC_LONG).addFields(20, TEST_NUMERIC_FLOAT).addFields(21, TEST_NUMERIC_DOUBLE).addFields(22, TEST_BIGNUMERIC).addFields(23, TEST_BIGNUMERIC_STR).addFields(24, TEST_BIGNUMERIC_SHORT).addFields(25, TEST_BIGNUMERIC_INT).addFields(26, TEST_BIGNUMERIC_LONG).addFields(27, TEST_BIGNUMERIC_FLOAT).addFields(28, TEST_BIGNUMERIC_DOUBLE).addFields(29, TEST_INTERVAL).addFields(30, TEST_JSON).build();
        Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
        this.isDescriptorEqual(descriptor, JsonTest.ComplexRoot.getDescriptor());
    }

    @Test
    public void testCasingComplexStruct() throws Exception {
        TableFieldSchema required = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.REQUIRED).setName("tEsT_ReQuIrEd").build();
        TableFieldSchema repeated = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.REPEATED).setName("tESt_repEATed").build();
        TableFieldSchema optional = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_opTIONal").build();
        TableFieldSchema test_int = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("TEST_INT").build();
        TableFieldSchema test_string = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.REPEATED).setName("TEST_STRING").build();
        TableFieldSchema test_bytes = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REQUIRED).setName("TEST_BYTES").build();
        TableFieldSchema test_bool = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BOOL).setMode(TableFieldSchema.Mode.NULLABLE).setName("TEST_BOOL").build();
        TableFieldSchema test_double = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DOUBLE).setMode(TableFieldSchema.Mode.REPEATED).setName("TEST_DOUBLE").build();
        TableFieldSchema test_date = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATE).setMode(TableFieldSchema.Mode.REQUIRED).setName("TEST_DATE").build();
        TableFieldSchema option_test = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.REQUIRED).addFields(0, required).addFields(1, repeated).addFields(2, optional).setName("option_test").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, test_int).addFields(1, test_string).addFields(2, test_bytes).addFields(3, test_bool).addFields(4, test_double).addFields(5, test_date).addFields(6, option_test).build();
        Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
        this.isDescriptorEqual(descriptor, JsonTest.CasingComplex.getDescriptor());
    }

    @Test
    public void testOptions() throws Exception {
        TableFieldSchema required = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.REQUIRED).setName("test_required").build();
        TableFieldSchema repeated = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.REPEATED).setName("test_repeated").build();
        TableFieldSchema optional = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_optional").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, required).addFields(1, repeated).addFields(2, optional).build();
        Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
        this.isDescriptorEqual(descriptor, JsonTest.OptionTest.getDescriptor());
    }

    @Test
    public void testDescriptorReuseDuringCreation() throws Exception {
        TableFieldSchema test_int = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_int").build();
        TableFieldSchema reuse_lvl2 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.NULLABLE).setName("reuse_lvl2").addFields(0, test_int).build();
        TableFieldSchema reuse_lvl1 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.NULLABLE).setName("reuse_lvl1").addFields(0, test_int).addFields(0, reuse_lvl2).build();
        TableFieldSchema reuse_lvl1_1 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.NULLABLE).setName("reuse_lvl1_1").addFields(0, test_int).addFields(0, reuse_lvl2).build();
        TableFieldSchema reuse_lvl1_2 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.NULLABLE).setName("reuse_lvl1_2").addFields(0, test_int).addFields(0, reuse_lvl2).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, reuse_lvl1).addFields(1, reuse_lvl1_1).addFields(2, reuse_lvl1_2).build();
        Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
        HashMap<String, Integer> descriptorToCount = new HashMap<String, Integer>();
        this.mapDescriptorToCount(descriptor, descriptorToCount);
        Assert.assertEquals((long)descriptorToCount.size(), (long)2L);
        Assert.assertTrue((boolean)descriptorToCount.containsKey("root__reuse_lvl1"));
        Assert.assertEquals((long)descriptorToCount.get("root__reuse_lvl1").intValue(), (long)3L);
        Assert.assertTrue((boolean)descriptorToCount.containsKey("root__reuse_lvl1__reuse_lvl2"));
        Assert.assertEquals((long)descriptorToCount.get("root__reuse_lvl1__reuse_lvl2").intValue(), (long)3L);
        this.isDescriptorEqual(descriptor, JsonTest.ReuseRoot.getDescriptor());
    }

    @Test
    public void testNestedFlexibleFieldName() throws Exception {
        TableFieldSchema stringField = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("str-\u5217").build();
        TableFieldSchema intField = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("int-\u5217").build();
        TableFieldSchema nestedField = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.NULLABLE).setName("nested-\u5217").addFields(0, intField).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, stringField).addFields(1, nestedField).build();
        Descriptors.Descriptor descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor((TableSchema)tableSchema);
        this.isDescriptorEqual(descriptor, SchemaTest.TestNestedFlexibleFieldName.getDescriptor());
    }
}

