/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnimplementedException;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadGrpc;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResourceHeaderTest {
    private static final String TEST_TABLE_REFERENCE = "projects/project/datasets/dataset/tables/table";
    private static final String TEST_STREAM_NAME = "streamName";
    private static final String NAME = "resource-header-test:123";
    private static final String HEADER_NAME = "x-goog-request-params";
    private static final Pattern READ_SESSION_NAME_PATTERN = Pattern.compile(".*read_session\\.table=projects%2Fproject%2Fdatasets%2Fdataset%2Ftables%2Ftable.*");
    private static final Pattern READ_STREAM_PATTERN = Pattern.compile(".*read_stream=streamName.*");
    private static final Pattern STREAM_NAME_PATTERN = Pattern.compile(".*name=streamName.*");
    private static final String TEST_HEADER_NAME = "simple-header-name";
    private static final String TEST_HEADER_VALUE = "simple-header-value";
    private static final Pattern TEST_PATTERN = Pattern.compile(".*simple-header-value.*");
    private static InProcessServer<?> server;
    private LocalChannelProvider channelProvider;
    private BigQueryReadClient client;

    @BeforeClass
    public static void setUpClass() throws Exception {
        server = new InProcessServer((BindableService)new BigQueryReadGrpc.BigQueryReadImplBase(){}, NAME);
        server.start();
    }

    @Before
    public void setUp() throws Exception {
        this.channelProvider = LocalChannelProvider.create((String)NAME);
        BigQueryReadSettings.Builder settingsBuilder = (BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{TEST_HEADER_NAME, TEST_HEADER_VALUE}))).setTransportChannelProvider((TransportChannelProvider)this.channelProvider);
        this.client = BigQueryReadClient.create((BigQueryReadSettings)settingsBuilder.build());
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        server.stop();
        server.blockUntilShutdown();
    }

    @Test
    public void createReadSessionTest() {
        try {
            this.client.createReadSession("parents/project", ReadSession.newBuilder().setTable(TEST_TABLE_REFERENCE).build(), 1);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(READ_SESSION_NAME_PATTERN);
    }

    @Test
    public void readRowsTest() {
        try {
            ReadRowsRequest request = ReadRowsRequest.newBuilder().setReadStream(TEST_STREAM_NAME).setOffset(125L).build();
            this.client.readRowsCallable().call((Object)request);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(READ_STREAM_PATTERN);
    }

    @Test
    public void splitReadStreamTest() {
        try {
            this.client.splitReadStream(SplitReadStreamRequest.newBuilder().setName(TEST_STREAM_NAME).build());
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(STREAM_NAME_PATTERN);
    }

    private void verifyHeaderSent(Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            boolean headerSent = this.channelProvider.isHeaderSent(HEADER_NAME, pattern);
            Truth.assertWithMessage((String)"Generated header was sent").that(Boolean.valueOf(headerSent)).isTrue();
        }
        boolean testHeaderSent = this.channelProvider.isHeaderSent(TEST_HEADER_NAME, TEST_PATTERN);
        Truth.assertWithMessage((String)"Provided header was sent").that(Boolean.valueOf(testHeaderSent)).isTrue();
    }
}

