/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.cloud.bigquery.storage.v1beta2.CivilTimeEncoder;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CivilTimeEncoderTest {
    private static final Logger LOG = Logger.getLogger(CivilTimeEncoderTest.class.getName());

    @Test
    public void encodeAndDecodePacked64TimeMicros_validTime() {
        Assert.assertEquals((long)0L, (long)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime((LocalTime)LocalTime.of(0, 0, 0, 0)));
        Assert.assertEquals((Object)LocalTime.of(0, 0, 0, 0), (Object)CivilTimeEncoder.decodePacked64TimeMicrosLocalTime((long)0L));
        Assert.assertEquals((long)69209016L, (long)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime((LocalTime)LocalTime.of(0, 1, 2, 3000000)));
        Assert.assertEquals((Object)LocalTime.of(0, 1, 2, 3000000), (Object)CivilTimeEncoder.decodePacked64TimeMicrosLocalTime((long)69209016L));
        Assert.assertEquals((long)0xC00000000L, (long)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime((LocalTime)LocalTime.of(12, 0, 0, 0)));
        Assert.assertEquals((Object)LocalTime.of(12, 0, 0, 0), (Object)CivilTimeEncoder.decodePacked64TimeMicrosLocalTime((long)0xC00000000L));
        Assert.assertEquals((long)56789843584L, (long)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime((LocalTime)LocalTime.of(13, 14, 15, 16000000)));
        Assert.assertEquals((Object)LocalTime.of(13, 14, 15, 16000000), (Object)CivilTimeEncoder.decodePacked64TimeMicrosLocalTime((long)56789843584L));
        Assert.assertEquals((long)102806535768L, (long)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime((LocalTime)LocalTime.of(23, 59, 59, 999000000)));
        Assert.assertEquals((Object)LocalTime.of(23, 59, 59, 999000000), (Object)CivilTimeEncoder.decodePacked64TimeMicrosLocalTime((long)102806535768L));
    }

    @Test
    public void encodePacked64TimeMicros_giveErrorWhenPrecisionIsLost() {
        try {
            Assert.assertEquals((long)0L, (long)CivilTimeEncoder.encodePacked64TimeMicrosLocalTime((LocalTime)LocalTime.of(0, 0, 0, 999)));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64TimeMicros_invalidBitField_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64TimeMicros((long)0x2000000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals(null, (Object)e.getMessage());
        }
    }

    @Test
    public void decodePacked64TimeMicros_invalidMicroOfSecond_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64TimeMicros((long)1000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals(null, (Object)e.getMessage());
        }
    }

    @Test
    public void decodePacked64TimeMicros_invalidSecondOfMinute_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64TimeMicros((long)0x3C00000L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid value for SecondOfMinute (valid values 0 - 59): 60", (Object)e.getMessage());
        }
    }

    @Test
    public void decodePacked64TimeMicros_invalidMinuteOfHour_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64TimeMicros((long)0xF0000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64TimeMicros_invalidHourOfDay_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64TimeMicros((long)0x1800000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid value for HourOfDay (valid values 0 - 23): 24", (Object)e.getMessage());
        }
    }

    @Test
    public void encodeAndDecodePacked64DatetimeMicros_validDateTime() {
        Assert.assertEquals((long)0x442000000000L, (long)CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime((LocalDateTime)LocalDateTime.of(1, 1, 1, 0, 0, 0, 0)));
        Assert.assertEquals((Object)LocalDateTime.of(1, 1, 1, 0, 0, 0, 0), (Object)CivilTimeEncoder.decodePacked64DatetimeMicrosLocalDateTime((long)0x442000000000L));
        Assert.assertEquals((long)79577223269304L, (long)CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime((LocalDateTime)LocalDateTime.of(1, 2, 3, 0, 1, 2, 3000000)));
        Assert.assertEquals((Object)LocalDateTime.of(1, 2, 3, 0, 1, 2, 3000000), (Object)CivilTimeEncoder.decodePacked64DatetimeMicrosLocalDateTime((long)79577223269304L));
        Assert.assertEquals((long)74955769249792L, (long)CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime((LocalDateTime)LocalDateTime.of(1, 1, 1, 12, 0, 0, 0)));
        Assert.assertEquals((Object)LocalDateTime.of(1, 1, 1, 12, 0, 0, 0), (Object)CivilTimeEncoder.decodePacked64DatetimeMicrosLocalDateTime((long)74955769249792L));
        Assert.assertEquals((long)74961019485824L, (long)CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime((LocalDateTime)LocalDateTime.of(1, 1, 1, 13, 14, 15, 16000000)));
        Assert.assertEquals((Object)LocalDateTime.of(1, 1, 1, 13, 14, 15, 16000000), (Object)CivilTimeEncoder.decodePacked64DatetimeMicrosLocalDateTime((long)74961019485824L));
        Assert.assertEquals((long)703674213004688984L, (long)CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime((LocalDateTime)LocalDateTime.of(9999, 12, 31, 23, 59, 59, 999000000)));
        Assert.assertEquals((Object)LocalDateTime.of(9999, 12, 31, 23, 59, 59, 999000000), (Object)CivilTimeEncoder.decodePacked64DatetimeMicrosLocalDateTime((long)703674213004688984L));
    }

    @Test
    public void encodePacked64DateTimeMicros_giveErrorWhenPrecisionIsLost() {
        try {
            CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime((LocalDateTime)LocalDateTime.of(1, 1, 1, 0, 0, 0, 999));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void encodePacked64DatetimeMicros_invalidYear_throwsIllegalArgumentException() {
        LocalDateTime dateTime = LocalDateTime.of(10000, 1, 1, 0, 0, 0, 0);
        try {
            CivilTimeEncoder.encodePacked64DatetimeMicrosLocalDateTime((LocalDateTime)dateTime);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_validBitFieldDatetimeMicros() {
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidBitField() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)1099583062016L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidMicroOfSecond_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)74904230642240L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidSecondOfMinute_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)74904292556800L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidMinuteOfHour_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)74908256174080L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidHourOfDay_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)75007308857344L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidDayOfMonth_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)0x440000000000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidMonthOfYear_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)127680787775488L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void decodePacked64DatetimeMicros_invalidYear_throwsIllegalArgumentException() {
        try {
            CivilTimeEncoder.decodePacked64DatetimeMicros((long)703691977262104576L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

