/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnimplementedException;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadGrpc;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadSession;
import com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.WriteStream;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResourceHeaderTest {
    private static final String TEST_TABLE_REFERENCE = "projects/project/datasets/dataset/tables/table";
    private static final String WRITE_STREAM_NAME = "projects/project/datasets/dataset/tables/table/streams/stream";
    private static final String TEST_STREAM_NAME = "streamName";
    private static final String NAME = "resource-header-test:123";
    private static final String HEADER_NAME = "x-goog-request-params";
    private static final Pattern READ_SESSION_NAME_PATTERN = Pattern.compile(".*read_session\\.table=projects%2Fproject%2Fdatasets%2Fdataset%2Ftables%2Ftable.*");
    private static final Pattern PARENT_PATTERN = Pattern.compile(".*parent=projects%2Fproject%2Fdatasets%2Fdataset%2Ftables%2Ftable.*");
    private static final Pattern NAME_PATTERN = Pattern.compile(".*name=projects%2Fproject%2Fdatasets%2Fdataset%2Ftables%2Ftable%2Fstreams%2Fstream.*");
    private static final Pattern WRITE_STREAM_PATTERN = Pattern.compile(".*write_stream=projects%2Fproject%2Fdatasets%2Fdataset%2Ftables%2Ftable%2Fstreams%2Fstream.*");
    private static final Pattern READ_STREAM_PATTERN = Pattern.compile(".*read_stream=streamName.*");
    private static final Pattern STREAM_NAME_PATTERN = Pattern.compile(".*name=streamName.*");
    private static final String TEST_HEADER_NAME = "simple-header-name";
    private static final String TEST_HEADER_VALUE = "simple-header-value";
    private static final Pattern TEST_PATTERN = Pattern.compile(".*simple-header-value.*");
    private static InProcessServer<?> server;
    private LocalChannelProvider channelProvider;
    private LocalChannelProvider channelProvider2;
    private BigQueryReadClient client;
    private BigQueryWriteClient writeClient;

    @BeforeClass
    public static void setUpClass() throws Exception {
        server = new InProcessServer((BindableService)new BigQueryReadGrpc.BigQueryReadImplBase(){}, NAME);
        server.start();
    }

    @Before
    public void setUp() throws Exception {
        this.channelProvider = LocalChannelProvider.create((String)NAME);
        BigQueryReadSettings.Builder settingsBuilder = (BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)((BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{TEST_HEADER_NAME, TEST_HEADER_VALUE}))).setTransportChannelProvider((TransportChannelProvider)this.channelProvider);
        this.client = BigQueryReadClient.create((BigQueryReadSettings)settingsBuilder.build());
        this.channelProvider2 = LocalChannelProvider.create((String)NAME);
        BigQueryWriteSettings.Builder writeSettingsBuilder = (BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setTransportChannelProvider((TransportChannelProvider)this.channelProvider2);
        this.writeClient = BigQueryWriteClient.create((BigQueryWriteSettings)writeSettingsBuilder.build());
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        server.stop();
        server.blockUntilShutdown();
    }

    @Test
    public void createReadSessionTest() {
        try {
            this.client.createReadSession("parents/project", ReadSession.newBuilder().setTable(TEST_TABLE_REFERENCE).build(), 1);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(READ_SESSION_NAME_PATTERN);
    }

    @Test
    public void readRowsTest() {
        try {
            ReadRowsRequest request = ReadRowsRequest.newBuilder().setReadStream(TEST_STREAM_NAME).setOffset(125L).build();
            this.client.readRowsCallable().call((Object)request);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(READ_STREAM_PATTERN);
    }

    @Test
    public void splitReadStreamTest() {
        try {
            this.client.splitReadStream(SplitReadStreamRequest.newBuilder().setName(TEST_STREAM_NAME).build());
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(STREAM_NAME_PATTERN);
    }

    @Test
    public void createWriteStreamTest() {
        try {
            this.writeClient.createWriteStream(TEST_TABLE_REFERENCE, WriteStream.newBuilder().setType(WriteStream.Type.BUFFERED).build());
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        boolean headerSent = this.channelProvider2.isHeaderSent(HEADER_NAME, PARENT_PATTERN);
        Truth.assertWithMessage((String)"Generated header was sent").that(Boolean.valueOf(headerSent)).isTrue();
    }

    @Test
    public void getWriteStreamTest() {
        try {
            this.writeClient.getWriteStream(WRITE_STREAM_NAME);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        boolean headerSent = this.channelProvider2.isHeaderSent(HEADER_NAME, NAME_PATTERN);
        Truth.assertWithMessage((String)"Generated header was sent").that(Boolean.valueOf(headerSent)).isTrue();
    }

    private void verifyHeaderSent(Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            boolean headerSent = this.channelProvider.isHeaderSent(HEADER_NAME, pattern);
            Truth.assertWithMessage((String)"Generated header was sent").that(Boolean.valueOf(headerSent)).isTrue();
        }
        boolean testHeaderSent = this.channelProvider.isHeaderSent(TEST_HEADER_NAME, TEST_PATTERN);
        Truth.assertWithMessage((String)"Provided header was sent").that(Boolean.valueOf(testHeaderSent)).isTrue();
    }
}

