/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.it;

import com.google.cloud.bigquery.FieldElementType;
import com.google.cloud.bigquery.Range;
import com.google.cloud.bigquery.storage.v1.ArrowRecordBatch;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;

public class SimpleRowReaderArrow
implements AutoCloseable {
    BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private final VectorSchemaRoot root;
    private final VectorLoader loader;

    public SimpleRowReaderArrow(ArrowSchema arrowSchema) throws IOException {
        Schema schema = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(arrowSchema.getSerializedSchema().toByteArray())));
        Preconditions.checkNotNull((Object)schema);
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
        for (Field field : schema.getFields()) {
            vectors.add(field.createVector(this.allocator));
        }
        this.root = new VectorSchemaRoot(vectors);
        this.loader = new VectorLoader(this.root);
    }

    public void processRows(ArrowRecordBatch batch, ArrowBatchConsumer batchConsumer) throws IOException {
        org.apache.arrow.vector.ipc.message.ArrowRecordBatch deserializedBatch = MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel((ReadableByteChannel)new ByteArrayReadableSeekableByteChannel(batch.getSerializedRecordBatch().toByteArray())), (BufferAllocator)this.allocator);
        this.loader.load(deserializedBatch);
        deserializedBatch.close();
        batchConsumer.accept(this.root);
        this.root.clear();
    }

    @Override
    public void close() {
        this.root.close();
        this.allocator.close();
    }

    public static interface ArrowBatchConsumer {
        public void accept(VectorSchemaRoot var1);
    }

    public static class ArrowRangeBatchConsumer
    implements ArrowBatchConsumer {
        private final ImmutableMap<String, Range> expectedRangeDateValues;
        private final ImmutableMap<String, Range> expectedRangeDatetimeValues;
        private final ImmutableMap<String, Range> expectedRangeTimestampValues;

        public ArrowRangeBatchConsumer(ImmutableMap<String, Range> expectedRangeDateValues, ImmutableMap<String, Range> expectedRangeDatetimeValues, ImmutableMap<String, Range> expectedRangeTimestampValues) {
            this.expectedRangeDateValues = expectedRangeDateValues;
            this.expectedRangeDatetimeValues = expectedRangeDatetimeValues;
            this.expectedRangeTimestampValues = expectedRangeTimestampValues;
        }

        @Override
        public void accept(VectorSchemaRoot root) {
            StructVector dateVector = (StructVector)root.getVector("date");
            for (int i = 0; i < dateVector.valueCount; ++i) {
                Field field = root.getSchema().findField(dateVector.getName());
                Truth.assertThat((Comparable)field.getType().getTypeID()).isEqualTo((Object)ArrowType.ArrowTypeID.Struct);
                Map value = dateVector.getObject(i);
                Range.Builder rangeBuilder = Range.newBuilder();
                if (value.get("start") != null) {
                    rangeBuilder.setStart(((Integer)value.get("start")).toString());
                }
                if (value.get("end") != null) {
                    rangeBuilder.setEnd(((Integer)value.get("end")).toString());
                }
                rangeBuilder.setType(ArrowRangeBatchConsumer.toFieldElementType((Field)field.getChildren().get(0)));
                Truth.assertThat((Object)rangeBuilder.build()).isIn((Iterable)this.expectedRangeDateValues.values());
            }
            StructVector datetimeVector = (StructVector)root.getVector("datetime");
            for (int i = 0; i < datetimeVector.valueCount; ++i) {
                Field field = root.getSchema().findField(datetimeVector.getName());
                Truth.assertThat((Comparable)field.getType().getTypeID()).isEqualTo((Object)ArrowType.ArrowTypeID.Struct);
                Map value = datetimeVector.getObject(i);
                Range.Builder rangeBuilder = Range.newBuilder();
                if (value.get("start") != null) {
                    rangeBuilder.setStart(((LocalDateTime)value.get("start")).toString());
                }
                if (value.get("end") != null) {
                    rangeBuilder.setEnd(((LocalDateTime)value.get("end")).toString());
                }
                rangeBuilder.setType(ArrowRangeBatchConsumer.toFieldElementType((Field)field.getChildren().get(0)));
                Truth.assertThat((Object)rangeBuilder.build()).isIn((Iterable)this.expectedRangeDatetimeValues.values());
            }
            StructVector timestampVector = (StructVector)root.getVector("timestamp");
            for (int i = 0; i < timestampVector.valueCount; ++i) {
                Field field = root.getSchema().findField(timestampVector.getName());
                Truth.assertThat((Comparable)field.getType().getTypeID()).isEqualTo((Object)ArrowType.ArrowTypeID.Struct);
                Map value = timestampVector.getObject(i);
                Range.Builder rangeBuilder = Range.newBuilder();
                if (value.get("start") != null) {
                    rangeBuilder.setStart(((Long)value.get("start")).toString());
                }
                if (value.get("end") != null) {
                    rangeBuilder.setEnd(((Long)value.get("end")).toString());
                }
                rangeBuilder.setType(ArrowRangeBatchConsumer.toFieldElementType((Field)field.getChildren().get(0)));
                Truth.assertThat((Object)rangeBuilder.build()).isIn((Iterable)this.expectedRangeTimestampValues.values());
            }
        }

        private static FieldElementType toFieldElementType(Field field) {
            switch (field.getType().getTypeID()) {
                case Date: {
                    return FieldElementType.newBuilder().setType("DATE").build();
                }
                case Timestamp: {
                    String timezone = ((ArrowType.Timestamp)field.getType()).getTimezone();
                    if (timezone == null) {
                        return FieldElementType.newBuilder().setType("DATETIME").build();
                    }
                    return FieldElementType.newBuilder().setType("TIMESTAMP").build();
                }
            }
            return null;
        }
    }
}

