/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.RequestProfiler;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RequestProfilerTest {
    private static final Logger log = Logger.getLogger(RequestProfiler.class.getName());
    private RequestProfiler.RequestProfilerHook profilerHook = new RequestProfiler.RequestProfilerHook(true);

    @Before
    public void setup() {
        RequestProfiler.disableAndResetProfiler();
        this.profilerHook.enableProfiler();
    }

    @After
    public void close() {
        RequestProfiler.disableAndResetProfiler();
    }

    @Test
    public void testNormalCase() throws Exception {
        this.profilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_1");
        this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, "request_1");
        this.profilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, "request_1");
        this.profilerHook.startOperation(RequestProfiler.OperationName.RESPONSE_LATENCY, "request_1");
        this.profilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_2");
        this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, "request_2");
        this.profilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, "request_2");
        this.profilerHook.endOperation(RequestProfiler.OperationName.RESPONSE_LATENCY, "request_1");
        this.profilerHook.startOperation(RequestProfiler.OperationName.RESPONSE_LATENCY, "request_2");
        this.profilerHook.endOperation(RequestProfiler.OperationName.RESPONSE_LATENCY, "request_2");
        this.profilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_2");
        this.profilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_1");
        String reportText = this.profilerHook.flushAndGenerateReportText();
        log.info(reportText);
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_1 with total time"));
        Assert.assertTrue((boolean)reportText.contains("Operation name json_to_proto_conversion starts at"));
        Assert.assertTrue((boolean)reportText.contains("Operation name response_latency starts at"));
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_2 with total time"));
        reportText = this.profilerHook.flushAndGenerateReportText();
        Assert.assertTrue((boolean)reportText.contains("0 requests finished during"));
    }

    @Test
    public void mixFinishedAndUnfinishedRequest() throws Exception {
        this.profilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_1");
        this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, "request_1");
        this.profilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, "request_1");
        this.profilerHook.startOperation(RequestProfiler.OperationName.RESPONSE_LATENCY, "request_1");
        this.profilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_2");
        this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, "request_2");
        String reportText = this.profilerHook.flushAndGenerateReportText();
        Assert.assertTrue((boolean)reportText.contains("0 requests finished during"));
        this.profilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_1");
        reportText = this.profilerHook.flushAndGenerateReportText();
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_1 with total time"));
        this.profilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, "request_2");
        reportText = this.profilerHook.flushAndGenerateReportText();
        Assert.assertTrue((!reportText.contains("Request uuid: request_1 with total time") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_2 with total time"));
        reportText = this.profilerHook.flushAndGenerateReportText();
        Assert.assertTrue((boolean)reportText.contains("0 requests finished during"));
    }

    @Test
    public void concurrentProfilingTest_1000ReqsRunTogether() throws Exception {
        int totalRequest = 1000;
        ListeningExecutorService threadPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TestThread").build()));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        ImmutableSet slowRequestIndex = ImmutableSet.of((Object)10, (Object)15, (Object)20, (Object)25, (Object)30, (Object)40, (Object[])new Integer[]{50});
        int i = 0;
        while (i < totalRequest) {
            int finalI = i++;
            futures.add(threadPool.submit(() -> {
                String uuid = String.format("request_%s", finalI);
                this.profilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, uuid);
                this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                if (slowRequestIndex.contains((Object)finalI)) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(finalI * 100);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.profilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                this.profilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                this.profilerHook.startOperation(RequestProfiler.OperationName.WAIT_QUEUE, uuid);
                this.profilerHook.endOperation(RequestProfiler.OperationName.WAIT_QUEUE, uuid);
                this.profilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, uuid);
            }));
        }
        for (i = 0; i < futures.size(); ++i) {
            ((Future)futures.get(i)).get();
        }
        String reportText = this.profilerHook.flushAndGenerateReportText();
        Assert.assertTrue((boolean)reportText.contains("During the last 60000 milliseconds at system time"));
        Assert.assertTrue((boolean)reportText.contains("in total 1000 requests finished"));
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_50 with total time"));
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_40 with total time"));
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_30 with total time"));
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_25 with total time"));
        Assert.assertTrue((boolean)reportText.contains("Request uuid: request_20 with total time"));
    }

    @Test
    public void concurrentProfilingTest_RunWhileFlushing() throws Exception {
        int totalRequest = 1000;
        ListeningExecutorService threadPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TestThread").build()));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        ImmutableSet slowRequestIndex = ImmutableSet.of((Object)10, (Object)15, (Object)20, (Object)25, (Object)30, (Object)40, (Object[])new Integer[]{50});
        int i = 0;
        while (i < totalRequest) {
            int finalI = i++;
            futures.add(threadPool.submit(() -> {
                try {
                    String uuid = String.format("request_%s", finalI);
                    this.profilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, uuid);
                    this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                    if (slowRequestIndex.contains((Object)finalI)) {
                        TimeUnit.MILLISECONDS.sleep(finalI * 100);
                    }
                    this.profilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                    this.profilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                    this.profilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, uuid);
                    this.profilerHook.startOperation(RequestProfiler.OperationName.WAIT_QUEUE, uuid);
                    this.profilerHook.endOperation(RequestProfiler.OperationName.WAIT_QUEUE, uuid);
                    this.profilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, uuid);
                    String string = this.profilerHook.flushAndGenerateReportText();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        for (i = 0; i < futures.size(); ++i) {
            ((Future)futures.get(i)).get();
        }
        String reportText = this.profilerHook.flushAndGenerateReportText();
        Assert.assertTrue((boolean)reportText.contains("0 requests finished during"));
    }
}

