/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.storage.test.Test;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.it.ITBigQueryWriteQuotaRetryTest;
import com.google.cloud.bigquery.storage.v1.it.WriteRetryTestUtil;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.common.truth.Truth;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITBigQueryWriteNonQuotaRetryTest {
    private static final Logger LOG = Logger.getLogger(ITBigQueryWriteQuotaRetryTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String TABLE = "testtable";
    private static final String DESCRIPTION = "BigQuery Write Java manual client test dataset";
    private static final String NON_QUOTA_RETRY_PROJECT_ID = "bq-write-api-java-retry-test";
    private static BigQueryWriteClient client;
    private static BigQuery bigquery;

    @BeforeClass
    public static void beforeClass() throws IOException {
        client = BigQueryWriteClient.create();
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)DATASET).setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        LOG.info("Created test dataset: " + DATASET);
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    @AfterClass
    public static void afterClass() {
        if (client != null) {
            client.close();
        }
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
            LOG.info("Deleted test dataset: " + DATASET);
        }
    }

    ProtoRows CreateProtoRows(String[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (String message : messages) {
            Test.FooType foo = Test.FooType.newBuilder().setFoo(message).build();
            rows.addSerializedRows(foo.toByteString());
        }
        return rows.build();
    }

    @Test
    public void testJsonStreamWriterCommittedStreamWithNonQuotaRetry() throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        WriteRetryTestUtil.runExclusiveRetryTest(bigquery, client, DATASET, NON_QUOTA_RETRY_PROJECT_ID, WriteStream.Type.COMMITTED, 901, 1);
    }

    @Test
    public void testJsonStreamWriterDefaultStreamWithNonQuotaRetry() throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        WriteRetryTestUtil.runDefaultRetryTest(bigquery, client, DATASET, NON_QUOTA_RETRY_PROJECT_ID, 901, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultRequestLimit() throws IOException, InterruptedException, ExecutionException {
        DatasetId datasetId = DatasetId.of((String)NON_QUOTA_RETRY_PROJECT_ID, (String)RemoteBigQueryHelper.generateDatasetName());
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((DatasetId)datasetId).build();
        bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        try {
            String tableName = "no_error_table";
            TableId tableId = TableId.of((String)datasetId.getProject(), (String)datasetId.getDataset(), (String)tableName);
            Field col1 = Field.newBuilder((String)"col1", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
            Schema originalSchema = Schema.of((Field[])new Field[]{col1});
            TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)originalSchema)).build();
            bigquery.create(tableInfo, new BigQuery.TableOption[0]);
            ProtoSchema schema = ProtoSchema.newBuilder().setProtoDescriptor(DescriptorProtos.DescriptorProto.newBuilder().setName("testProto").addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("col1").setNumber(1).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).build()).build()).build();
            TableName parent = TableName.of((String)datasetId.getProject(), (String)datasetId.getDataset(), (String)tableName);
            try (StreamWriter streamWriter = StreamWriter.newBuilder((String)(parent.toString() + "/_default")).setWriterSchema(schema).build();){
                ApiFuture response = streamWriter.append(this.CreateProtoRows(new String[]{new String(new char[0x1300000]).replace("\u0000", "a")}));
                try {
                    AppendRowsResponse resp = (AppendRowsResponse)response.get();
                    LOG.info("Message succeded.  Dataset info: " + datasetInfo.toString() + " tableinfo: " + tableInfo.toString() + " parent: " + parent + "streamWriter: " + streamWriter.toString() + "response: " + resp);
                    Assert.fail((String)"Large request should fail with InvalidArgumentError");
                }
                catch (ExecutionException ex) {
                    LOG.info("Message failed.  Dataset info: " + datasetInfo.toString() + " tableinfo: " + tableInfo.toString() + " parent: " + parent + "streamWriter: " + streamWriter);
                    Assert.assertEquals(StatusRuntimeException.class, ex.getCause().getClass());
                    StatusRuntimeException actualError = (StatusRuntimeException)ex.getCause();
                    if (actualError.getStatus().getCode() != Status.Code.INTERNAL) {
                        Assert.assertEquals((Object)Status.Code.INVALID_ARGUMENT, (Object)actualError.getStatus().getCode());
                        Truth.assertThat((Boolean)actualError.getStatus().getDescription().contains("AppendRows request too large: 19923131 limit 10485760"));
                    }
                }
            }
        }
        finally {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)datasetId.toString());
        }
    }
}

