/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.it;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.it.WriteRetryTestUtil;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITBigQueryWriteQuotaRetryTest {
    private static final Logger LOG = Logger.getLogger(ITBigQueryWriteQuotaRetryTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String TABLE = "testtable";
    private static final String DESCRIPTION = "BigQuery Write Java manual client test dataset";
    private static final String QUOTA_RETRY_PROJECT_ID = "bq-writeapi-java-quota-retry";
    private static BigQueryWriteClient client;
    private static BigQuery bigquery;

    @BeforeClass
    public static void beforeClass() throws IOException {
        client = BigQueryWriteClient.create();
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)DATASET).setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        LOG.info("Created test dataset: " + DATASET);
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    @AfterClass
    public static void afterClass() {
        if (client != null) {
            client.close();
        }
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
            LOG.info("Deleted test dataset: " + DATASET);
        }
    }

    @Test
    public void testJsonStreamWriterCommittedStreamWithQuotaRetry() throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        WriteRetryTestUtil.runExclusiveRetryTest(bigquery, client, DATASET, QUOTA_RETRY_PROJECT_ID, WriteStream.Type.COMMITTED, 901, 1);
    }

    @Test
    public void testJsonStreamWriterDefaultStreamWithQuotaRetry() throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        WriteRetryTestUtil.runDefaultRetryTest(bigquery, client, DATASET, QUOTA_RETRY_PROJECT_ID, 901, 1);
    }
}

