/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnimplementedException;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteGrpc;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WriteHeaderTest {
    private static final String TEST_TABLE_REFERENCE = "projects/project/datasets/dataset/tables/table";
    private static final String TEST_STREAM_NAME = "streamName";
    private static final String NAME = "write-header-test:456";
    private static final String TEST_HEADER_NAME = "simple-header-name";
    private static final String TEST_HEADER_VALUE = "simple-header-value";
    private static final Pattern TEST_PATTERN = Pattern.compile(".*simple-header-value.*");
    private static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final String USER_AGENT_HEADER_VALUE = "justChecking";
    private static final Pattern USER_AGENT_PATTERN = Pattern.compile(".*justChecking.*");
    private static InProcessServer<?> server;
    private LocalChannelProvider channelProvider;
    private BigQueryWriteClient client;

    @BeforeClass
    public static void setUpClass() throws Exception {
        server = new InProcessServer((BindableService)new BigQueryWriteGrpc.BigQueryWriteImplBase(){}, NAME);
        server.start();
    }

    @Before
    public void setUp() throws Exception {
        this.channelProvider = LocalChannelProvider.create((String)NAME);
        BigQueryWriteSettings.Builder settingsBuilder = (BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{TEST_HEADER_NAME, TEST_HEADER_VALUE, USER_AGENT_HEADER_NAME, USER_AGENT_HEADER_VALUE}))).setTransportChannelProvider((TransportChannelProvider)this.channelProvider);
        this.client = BigQueryWriteClient.create((BigQueryWriteSettings)settingsBuilder.build());
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        server.stop();
        server.blockUntilShutdown();
    }

    @Test
    public void createWriteStreamTest() {
        CreateWriteStreamRequest request = CreateWriteStreamRequest.newBuilder().setParent(TEST_TABLE_REFERENCE).setWriteStream(WriteStream.newBuilder().build()).build();
        try {
            this.client.createWriteStream(request);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyWriteHeaderSent();
    }

    @Test
    public void writeRowsTest() {
        BidiStreamingCallable callable = this.client.appendRowsCallable();
        ApiCallContext apiCallContext = null;
        ClientStream clientStream = callable.splitCall((ResponseObserver)new ResponseObserver<AppendRowsResponse>(){

            public void onStart(StreamController controller) {
            }

            public void onResponse(AppendRowsResponse response) {
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
            }
        }, apiCallContext);
        AppendRowsRequest request = AppendRowsRequest.newBuilder().setWriteStream(TEST_STREAM_NAME).build();
        try {
            clientStream.send((Object)request);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyWriteHeaderSent();
    }

    private void verifyWriteHeaderSent() {
        boolean testHeaderSent = this.channelProvider.isHeaderSent(TEST_HEADER_NAME, TEST_PATTERN);
        Truth.assertWithMessage((String)"Test header was sent").that(Boolean.valueOf(testHeaderSent)).isTrue();
        boolean userAgentHeaderSent = this.channelProvider.isHeaderSent(USER_AGENT_HEADER_NAME, USER_AGENT_PATTERN);
        Truth.assertWithMessage((String)"User Agent header was sent").that(Boolean.valueOf(userAgentHeaderSent)).isTrue();
    }
}

