/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.BatchCreateMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.BatchDeleteMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.BatchUpdateMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.ListMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionServiceClient;
import com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionServiceSettings;
import com.google.cloud.bigquery.storage.v1alpha.MockMetastorePartitionService;
import com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest;
import com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsResponse;
import com.google.cloud.bigquery.storage.v1alpha.TableName;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetastorePartitionServiceClientTest {
    private static MockMetastorePartitionService mockMetastorePartitionService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private MetastorePartitionServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockMetastorePartitionService = new MockMetastorePartitionService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockMetastorePartitionService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        MetastorePartitionServiceSettings settings = ((MetastorePartitionServiceSettings.Builder)((MetastorePartitionServiceSettings.Builder)MetastorePartitionServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = MetastorePartitionServiceClient.create((MetastorePartitionServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void batchCreateMetastorePartitionsTest() throws Exception {
        BatchCreateMetastorePartitionsResponse expectedResponse = BatchCreateMetastorePartitionsResponse.newBuilder().addAllPartitions(new ArrayList()).build();
        mockMetastorePartitionService.addResponse((AbstractMessage)expectedResponse);
        BatchCreateMetastorePartitionsRequest request = BatchCreateMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllRequests(new ArrayList()).setSkipExistingPartitions(true).setTraceId("traceId-1067401920").build();
        BatchCreateMetastorePartitionsResponse actualResponse = this.client.batchCreateMetastorePartitions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastorePartitionService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchCreateMetastorePartitionsRequest actualRequest = (BatchCreateMetastorePartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getRequestsList(), (Object)actualRequest.getRequestsList());
        Assert.assertEquals((Object)request.getSkipExistingPartitions(), (Object)actualRequest.getSkipExistingPartitions());
        Assert.assertEquals((Object)request.getTraceId(), (Object)actualRequest.getTraceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateMetastorePartitionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastorePartitionService.addException((Exception)exception);
        try {
            BatchCreateMetastorePartitionsRequest request = BatchCreateMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllRequests(new ArrayList()).setSkipExistingPartitions(true).setTraceId("traceId-1067401920").build();
            this.client.batchCreateMetastorePartitions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchDeleteMetastorePartitionsTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockMetastorePartitionService.addResponse((AbstractMessage)expectedResponse);
        BatchDeleteMetastorePartitionsRequest request = BatchDeleteMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllPartitionValues(new ArrayList()).setTraceId("traceId-1067401920").build();
        this.client.batchDeleteMetastorePartitions(request);
        List<AbstractMessage> actualRequests = mockMetastorePartitionService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchDeleteMetastorePartitionsRequest actualRequest = (BatchDeleteMetastorePartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getPartitionValuesList(), (Object)actualRequest.getPartitionValuesList());
        Assert.assertEquals((Object)request.getTraceId(), (Object)actualRequest.getTraceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchDeleteMetastorePartitionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastorePartitionService.addException((Exception)exception);
        try {
            BatchDeleteMetastorePartitionsRequest request = BatchDeleteMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllPartitionValues(new ArrayList()).setTraceId("traceId-1067401920").build();
            this.client.batchDeleteMetastorePartitions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchUpdateMetastorePartitionsTest() throws Exception {
        BatchUpdateMetastorePartitionsResponse expectedResponse = BatchUpdateMetastorePartitionsResponse.newBuilder().addAllPartitions(new ArrayList()).build();
        mockMetastorePartitionService.addResponse((AbstractMessage)expectedResponse);
        BatchUpdateMetastorePartitionsRequest request = BatchUpdateMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllRequests(new ArrayList()).setTraceId("traceId-1067401920").build();
        BatchUpdateMetastorePartitionsResponse actualResponse = this.client.batchUpdateMetastorePartitions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastorePartitionService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchUpdateMetastorePartitionsRequest actualRequest = (BatchUpdateMetastorePartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getRequestsList(), (Object)actualRequest.getRequestsList());
        Assert.assertEquals((Object)request.getTraceId(), (Object)actualRequest.getTraceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchUpdateMetastorePartitionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastorePartitionService.addException((Exception)exception);
        try {
            BatchUpdateMetastorePartitionsRequest request = BatchUpdateMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllRequests(new ArrayList()).setTraceId("traceId-1067401920").build();
            this.client.batchUpdateMetastorePartitions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMetastorePartitionsTest() throws Exception {
        ListMetastorePartitionsResponse expectedResponse = ListMetastorePartitionsResponse.newBuilder().build();
        mockMetastorePartitionService.addResponse((AbstractMessage)expectedResponse);
        TableName parent = TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]");
        ListMetastorePartitionsResponse actualResponse = this.client.listMetastorePartitions(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastorePartitionService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMetastorePartitionsRequest actualRequest = (ListMetastorePartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMetastorePartitionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastorePartitionService.addException((Exception)exception);
        try {
            TableName parent = TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]");
            this.client.listMetastorePartitions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMetastorePartitionsTest2() throws Exception {
        ListMetastorePartitionsResponse expectedResponse = ListMetastorePartitionsResponse.newBuilder().build();
        mockMetastorePartitionService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ListMetastorePartitionsResponse actualResponse = this.client.listMetastorePartitions(parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastorePartitionService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMetastorePartitionsRequest actualRequest = (ListMetastorePartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMetastorePartitionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastorePartitionService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listMetastorePartitions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void streamMetastorePartitionsTest() throws Exception {
        StreamMetastorePartitionsResponse expectedResponse = StreamMetastorePartitionsResponse.newBuilder().setTotalPartitionsStreamedCount(-1442980886L).setTotalPartitionsInsertedCount(-1900870109L).build();
        mockMetastorePartitionService.addResponse((AbstractMessage)expectedResponse);
        StreamMetastorePartitionsRequest request = StreamMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllMetastorePartitions(new ArrayList()).setSkipExistingPartitions(true).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamMetastorePartitionsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void streamMetastorePartitionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastorePartitionService.addException((Exception)exception);
        StreamMetastorePartitionsRequest request = StreamMetastorePartitionsRequest.newBuilder().setParent(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).addAllMetastorePartitions(new ArrayList()).setSkipExistingPartitions(true).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.streamMetastorePartitionsCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

