/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.test.JsonTest;
import com.google.cloud.bigquery.storage.test.Test;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1beta2.FakeBigQueryWrite;
import com.google.cloud.bigquery.storage.v1beta2.FakeScheduledExecutorService;
import com.google.cloud.bigquery.storage.v1beta2.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1beta2.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1beta2.TableSchema;
import com.google.cloud.bigquery.storage.v1beta2.WriteStream;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JsonStreamWriterTest {
    private static final Logger LOG = Logger.getLogger(JsonStreamWriterTest.class.getName());
    private static final String TEST_STREAM = "projects/p/datasets/d/tables/t/streams/s";
    private static final String TEST_TABLE = "projects/p/datasets/d/tables/t";
    private static final ExecutorProvider SINGLE_THREAD_EXECUTOR = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(1).build();
    private static LocalChannelProvider channelProvider;
    private FakeScheduledExecutorService fakeExecutor;
    private FakeBigQueryWrite testBigQueryWrite;
    private static MockServiceHelper serviceHelper;
    private final TableFieldSchema FOO = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("foo").build();
    private final TableSchema TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, this.FOO).build();
    private final TableFieldSchema BAR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("bar").build();
    private final TableFieldSchema BAZ = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("baz").build();
    private final TableSchema UPDATED_TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, this.FOO).addFields(1, this.BAR).build();
    private final TableSchema UPDATED_TABLE_SCHEMA_2 = TableSchema.newBuilder().addFields(0, this.FOO).addFields(1, this.BAR).addFields(2, this.BAZ).build();
    private final TableFieldSchema TEST_INT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_int").build();
    private final TableFieldSchema TEST_STRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.REPEATED).setName("test_string").build();

    @Before
    public void setUp() throws Exception {
        this.testBigQueryWrite = new FakeBigQueryWrite();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(this.testBigQueryWrite));
        serviceHelper.start();
        channelProvider = serviceHelper.createChannelProvider();
        this.fakeExecutor = new FakeScheduledExecutorService();
        this.testBigQueryWrite.setExecutor(this.fakeExecutor);
        Instant time = Instant.now();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build();
        for (int i = 0; i < 4; ++i) {
            this.testBigQueryWrite.addResponse((AbstractMessage)WriteStream.newBuilder().setName(TEST_STREAM).setCreateTime(timestamp).build());
        }
    }

    @After
    public void tearDown() throws Exception {
        serviceHelper.stop();
    }

    private JsonStreamWriter.Builder getTestJsonStreamWriterBuilder(String testStream, TableSchema BQTableSchema) {
        return JsonStreamWriter.newBuilder((String)testStream, (TableSchema)BQTableSchema).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
    }

    @Test
    public void testTwoParamNewBuilder_nullSchema() {
        try {
            this.getTestJsonStreamWriterBuilder(null, this.TABLE_SCHEMA);
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"StreamOrTableName is null.");
        }
    }

    @Test
    public void testTwoParamNewBuilder_nullStream() {
        try {
            this.getTestJsonStreamWriterBuilder(TEST_STREAM, null);
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"TableSchema is null.");
        }
    }

    @Test
    public void testTwoParamNewBuilder() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();
        Assert.assertEquals((Object)TEST_STREAM, (Object)writer.getStreamName());
    }

    @Test
    public void testSingleAppendSimpleJson() throws Exception {
        Test.FooType expectedProto = Test.FooType.newBuilder().setFoo("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).setTraceId("test:empty").build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getTraceId(), (Object)"JsonWriterBeta_test:empty");
        }
    }

    @Test
    public void testSpecialTypeAppend() throws Exception {
        TableFieldSchema field = TableFieldSchema.newBuilder().setName("time").setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.REPEATED).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(field).build();
        JsonTest.TestTime expectedProto = JsonTest.TestTime.newBuilder().addTime(CivilTimeEncoder.encodePacked64TimeMicrosLocalTime((LocalTime)LocalTime.of(1, 0, 1))).build();
        JSONObject foo = new JSONObject();
        foo.put("time", (Object)new JSONArray((Object)new String[]{"01:00:01"}));
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, tableSchema).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
        }
    }

    @Test
    public void testSingleAppendMultipleSimpleJson() throws Exception {
        Test.FooType expectedProto = Test.FooType.newBuilder().setFoo("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"allen");
        JSONObject foo1 = new JSONObject();
        foo1.put("foo", (Object)"allen");
        JSONObject foo2 = new JSONObject();
        foo2.put("foo", (Object)"allen");
        JSONObject foo3 = new JSONObject();
        foo3.put("foo", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        jsonArr.put((Object)foo1);
        jsonArr.put((Object)foo2);
        jsonArr.put((Object)foo3);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            ApiFuture appendFuture = writer.append(jsonArr);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
            appendFuture.get();
            Assert.assertEquals((long)4L, (long)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRowsCount());
            Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getTraceId(), (Object)"JsonWriterBeta:null");
            for (int i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(0).getProtoRows().getRows().getSerializedRows(i), (Object)expectedProto.toByteString());
            }
        }
    }

    @Test
    public void testMultipleAppendSimpleJson() throws Exception {
        Test.FooType expectedProto = Test.FooType.newBuilder().setFoo("allen").build();
        JSONObject foo = new JSONObject();
        foo.put("foo", (Object)"allen");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)0L)).build()).build());
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)1L)).build()).build());
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)2L)).build()).build());
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setAppendResult(AppendRowsResponse.AppendResult.newBuilder().setOffset(Int64Value.of((long)3L)).build()).build());
            for (int i = 0; i < 4; ++i) {
                ApiFuture appendFuture = writer.append(jsonArr);
                Assert.assertEquals((long)i, (long)((AppendRowsResponse)appendFuture.get()).getAppendResult().getOffset().getValue());
                appendFuture.get();
                Assert.assertEquals((long)1L, (long)this.testBigQueryWrite.getAppendRequests().get(i).getProtoRows().getRows().getSerializedRowsCount());
                Assert.assertEquals((Object)this.testBigQueryWrite.getAppendRequests().get(i).getProtoRows().getRows().getSerializedRows(0), (Object)expectedProto.toByteString());
            }
        }
    }

    @Test
    public void testAppendOutOfRangeException() throws Exception {
        try (JsonStreamWriter writer = this.getTestJsonStreamWriterBuilder(TEST_STREAM, this.TABLE_SCHEMA).build();){
            this.testBigQueryWrite.addResponse((AbstractMessage)AppendRowsResponse.newBuilder().setError(Status.newBuilder().setCode(11).build()).build());
            JSONObject foo = new JSONObject();
            foo.put("foo", (Object)"allen");
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            ApiFuture appendFuture = writer.append(jsonArr);
            try {
                appendFuture.get();
                Assert.fail((String)"expected ExecutionException");
            }
            catch (ExecutionException ex) {
                Assert.assertEquals((Object)ex.getCause().getMessage(), (Object)"OUT_OF_RANGE: ");
            }
        }
    }

    @Test
    public void testCreateDefaultStream() throws Exception {
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, this.TEST_INT).addFields(1, this.TEST_STRING).build();
        try (JsonStreamWriter writer = JsonStreamWriter.newBuilder((String)TEST_TABLE, (TableSchema)tableSchema).setChannelProvider((TransportChannelProvider)channelProvider).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).build();){
            Assert.assertEquals((Object)"projects/p/datasets/d/tables/t/_default", (Object)writer.getStreamName());
        }
    }
}

