/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.test.SchemaTest;
import com.google.cloud.bigquery.storage.v1.BigQuerySchemaUtil;
import com.google.protobuf.Descriptors;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQuerySchemaUtilTest
extends TestCase {
    @Test
    public void testIsProtoCompatible() {
        List<String> protoCompatibleNames = Arrays.asList("col_1", "name", "_0_");
        List<String> protoIncompatibleNames = Arrays.asList("0_col", "()", "\u5217", "a-1");
        protoCompatibleNames.stream().forEach(name -> BigQuerySchemaUtilTest.assertTrue((boolean)BigQuerySchemaUtil.isProtoCompatible((String)name)));
        protoIncompatibleNames.stream().forEach(name -> BigQuerySchemaUtilTest.assertFalse((boolean)BigQuerySchemaUtil.isProtoCompatible((String)name)));
    }

    public void testGeneratePlaceholderFieldName() {
        BigQuerySchemaUtilTest.assertEquals((String)"col_c3RyLeWIlw", (String)BigQuerySchemaUtil.generatePlaceholderFieldName((String)"str-\u5217"));
        BigQuerySchemaUtilTest.assertEquals((String)"col_fi9_Lw", (String)BigQuerySchemaUtil.generatePlaceholderFieldName((String)"~/~/"));
    }

    public void testGetFieldName() {
        Descriptors.Descriptor flexibleDescriptor = SchemaTest.TestNestedFlexibleFieldName.getDescriptor();
        BigQuerySchemaUtilTest.assertEquals((String)"str-\u5217", (String)BigQuerySchemaUtil.getFieldName((Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)flexibleDescriptor.getFields().get(0))));
        BigQuerySchemaUtilTest.assertEquals((String)"nested-\u5217", (String)BigQuerySchemaUtil.getFieldName((Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)flexibleDescriptor.getFields().get(1))));
        Descriptors.Descriptor descriptor = SchemaTest.TestNestedFlexibleFieldName.getDescriptor();
        BigQuerySchemaUtilTest.assertEquals((String)"int32_value", (String)BigQuerySchemaUtil.getFieldName((Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)descriptor.getFields().get(0))));
        BigQuerySchemaUtilTest.assertEquals((String)"int64_value", (String)BigQuerySchemaUtil.getFieldName((Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)descriptor.getFields().get(1))));
    }
}

