/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.it;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITBigQueryStorageLongRunningTest {
    private static final Logger LOG = Logger.getLogger(ITBigQueryStorageLongRunningTest.class.getName());
    private static final String LONG_TESTS_ENABLED_PROPERTY = "bigquery.storage.enable_long_running_tests";
    private static final String LONG_TESTS_DISABLED_MESSAGE = String.format("BigQuery Storage long running tests are not enabled and will be skipped. To enable them, set system property '%s' to true.", "bigquery.storage.enable_long_running_tests");
    private static BigQueryStorageClient client;
    private static String parentProjectId;

    @BeforeClass
    public static void beforeClass() throws IOException {
        Assume.assumeTrue((String)LONG_TESTS_DISABLED_MESSAGE, (boolean)Boolean.getBoolean(LONG_TESTS_ENABLED_PROPERTY));
        client = BigQueryStorageClient.create();
        parentProjectId = String.format("projects/%s", ServiceOptions.getDefaultProjectId());
        LOG.info(String.format("%s tests running with parent project: %s", ITBigQueryStorageLongRunningTest.class.getSimpleName(), parentProjectId));
    }

    @AfterClass
    public static void afterClass() {
        if (client != null) {
            client.close();
        }
    }

    @Test
    public void testLongRunningReadSession() throws InterruptedException, ExecutionException {
        TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().setProjectId("bigquery-public-data").setDatasetId("samples").setTableId("wikipedia").build();
        Storage.ReadSession session = client.createReadSession(tableReference, parentProjectId, 5);
        Assert.assertEquals((String)String.format("Did not receive expected number of streams for table reference '%s' CreateReadSession response:%n%s", TextFormat.shortDebugString((MessageOrBuilder)tableReference), session.toString()), (long)5L, (long)session.getStreamsCount());
        ArrayList<1> tasks = new ArrayList<1>(session.getStreamsCount());
        for (final Storage.Stream stream : session.getStreamsList()) {
            tasks.add(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return ITBigQueryStorageLongRunningTest.this.readAllRowsFromStream(stream);
                }
            });
        }
        ExecutorService executor = Executors.newFixedThreadPool(tasks.size());
        List results = executor.invokeAll(tasks);
        long rowCount = 0L;
        for (Future result : results) {
            rowCount += ((Long)result.get()).longValue();
        }
        Assert.assertEquals((long)313797035L, (long)rowCount);
    }

    private long readAllRowsFromStream(Storage.Stream stream) {
        Storage.StreamPosition readPosition = Storage.StreamPosition.newBuilder().setStream(stream).build();
        Storage.ReadRowsRequest readRowsRequest = Storage.ReadRowsRequest.newBuilder().setReadPosition(readPosition).build();
        long rowCount = 0L;
        ServerStream serverStream = client.readRowsCallable().call((Object)readRowsRequest);
        for (Storage.ReadRowsResponse response : serverStream) {
            rowCount += response.getRowCount();
        }
        LOG.info(String.format("Read total of %d rows from stream '%s'.", rowCount, stream.getName()));
        return rowCount;
    }
}

