/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.test.Test;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1beta2.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1beta2.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1beta2.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1beta2.ProtoRows;
import com.google.cloud.bigquery.storage.v1beta2.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1beta2.StreamWriterV2;
import com.google.cloud.bigquery.storage.v1beta2.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1beta2.TableName;
import com.google.cloud.bigquery.storage.v1beta2.TableSchema;
import com.google.cloud.bigquery.storage.v1beta2.WriteStream;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.common.truth.Truth;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.threeten.bp.LocalDateTime;

public class ITBigQueryWriteManualClientTest {
    private static final Logger LOG = Logger.getLogger(ITBigQueryWriteManualClientTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String DATASET_EU = RemoteBigQueryHelper.generateDatasetName();
    private static final String TABLE = "testtable";
    private static final String TABLE2 = "complicatedtable";
    private static final String DESCRIPTION = "BigQuery Write Java manual client test dataset";
    private static BigQueryWriteClient client;
    private static TableInfo tableInfo;
    private static TableInfo tableInfo2;
    private static TableInfo tableInfoEU;
    private static String tableId;
    private static String tableId2;
    private static String tableIdEU;
    private static BigQuery bigquery;

    @BeforeClass
    public static void beforeClass() throws IOException {
        client = BigQueryWriteClient.create();
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)DATASET).setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        LOG.info("Created test dataset: " + DATASET);
        tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()}))).build();
        Field.Builder innerTypeFieldBuilder = Field.newBuilder((String)"inner_type", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{Field.newBuilder((String)"value", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build()});
        tableInfo2 = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE2), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"nested_repeated_type", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{innerTypeFieldBuilder.setMode(Field.Mode.REPEATED).build()}).setMode(Field.Mode.REPEATED).build(), innerTypeFieldBuilder.setMode(Field.Mode.NULLABLE).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        bigquery.create(tableInfo2, new BigQuery.TableOption[0]);
        tableId = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET, TABLE);
        tableId2 = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET, TABLE2);
        DatasetInfo datasetInfoEU = DatasetInfo.newBuilder((String)DATASET_EU).setLocation("EU").setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfoEU, new BigQuery.DatasetOption[0]);
        tableInfoEU = TableInfo.newBuilder((TableId)TableId.of((String)DATASET_EU, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).build()}))).build();
        tableIdEU = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET_EU, TABLE);
        bigquery.create(tableInfoEU, new BigQuery.TableOption[0]);
    }

    @AfterClass
    public static void afterClass() {
        if (client != null) {
            client.close();
        }
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
            LOG.info("Deleted test dataset: " + DATASET);
        }
    }

    ProtoRows CreateProtoRows(String[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (String message : messages) {
            Test.FooType foo = Test.FooType.newBuilder().setFoo(message).build();
            rows.addSerializedRows(foo.toByteString());
        }
        return rows.build();
    }

    ProtoRows CreateProtoRowsComplex(String[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (String message : messages) {
            Test.ComplicateType foo = Test.ComplicateType.newBuilder().setInnerType(Test.InnerType.newBuilder().addValue(message).addValue(message).build()).build();
            rows.addSerializedRows(foo.toByteString());
        }
        return rows.build();
    }

    @Test
    public void testBatchWriteWithCommittedStreamEU() throws IOException, InterruptedException, ExecutionException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableIdEU).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        StreamWriterV2 streamWriter = StreamWriterV2.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();
        LOG.info("Sending one message");
        ApiFuture response = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), 0L);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
        LOG.info("Sending two more messages");
        ApiFuture response1 = streamWriter.append(this.CreateProtoRows(new String[]{"bbb", "ccc"}), 1L);
        ApiFuture response2 = streamWriter.append(this.CreateProtoRows(new String[]{"ddd"}), 3L);
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)3L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
        TableResult result = bigquery.listTableData(tableInfoEU.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
        Iterator iter = result.getValues().iterator();
        Assert.assertEquals((Object)"aaa", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
        Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
        Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
        Assert.assertEquals((Object)"ddd", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
        Assert.assertEquals((Object)false, (Object)iter.hasNext());
    }

    @Test
    public void testJsonStreamWriterCommittedStream() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "JsonTable";
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_str", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_numerics", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_datetime", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).build();){
            LOG.info("Sending one message");
            JSONObject row1 = new JSONObject();
            row1.put("test_str", (Object)"aaa");
            row1.put("test_numerics", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("123.4")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-9000000")).toByteArray()}));
            row1.put("test_datetime", CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2020, (int)10, (int)1, (int)12, (int)0)));
            JSONArray jsonArr1 = new JSONArray((Object)new JSONObject[]{row1});
            ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
            JSONObject row2 = new JSONObject();
            row1.put("test_str", (Object)"bbb");
            JSONObject row3 = new JSONObject();
            row2.put("test_str", (Object)"ccc");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)row1);
            jsonArr2.put((Object)row2);
            JSONObject row4 = new JSONObject();
            row4.put("test_str", (Object)"ddd");
            JSONArray jsonArr3 = new JSONArray();
            jsonArr3.put((Object)row4);
            LOG.info("Sending two more messages");
            ApiFuture response2 = jsonStreamWriter.append(jsonArr2, -1L);
            LOG.info("Sending one more message");
            ApiFuture response3 = jsonStreamWriter.append(jsonArr3, -1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)3L, (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"-9000000", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"2020-10-01T12:00:00", (Object)currentRow.get(2).getStringValue());
            Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ddd", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
        }
    }

    @Test
    public void testJsonStreamWriterWithDefaultStream() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "JsonTableDefaultStream";
        TableFieldSchema TEST_STRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_str").build();
        TableFieldSchema TEST_NUMERIC = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("test_numerics").build();
        TableFieldSchema TEST_DATE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_datetime").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, TEST_STRING).addFields(1, TEST_DATE).addFields(2, TEST_NUMERIC).build();
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_str", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_numerics", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_datetime", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)parent.toString(), (TableSchema)tableSchema).build();){
            LOG.info("Sending one message");
            JSONObject row1 = new JSONObject();
            row1.put("test_str", (Object)"aaa");
            row1.put("test_numerics", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("123.4")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-9000000")).toByteArray()}));
            row1.put("test_datetime", CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2020, (int)10, (int)1, (int)12, (int)0)));
            JSONArray jsonArr1 = new JSONArray((Object)new JSONObject[]{row1});
            ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
            JSONObject row2 = new JSONObject();
            row1.put("test_str", (Object)"bbb");
            JSONObject row3 = new JSONObject();
            row2.put("test_str", (Object)"ccc");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)row1);
            jsonArr2.put((Object)row2);
            JSONObject row4 = new JSONObject();
            row4.put("test_str", (Object)"ddd");
            JSONArray jsonArr3 = new JSONArray();
            jsonArr3.put((Object)row4);
            LOG.info("Sending two more messages");
            ApiFuture response2 = jsonStreamWriter.append(jsonArr2, -1L);
            LOG.info("Sending one more message");
            ApiFuture response3 = jsonStreamWriter.append(jsonArr3, -1L);
            Assert.assertFalse((boolean)((AppendRowsResponse)response2.get()).getAppendResult().hasOffset());
            Assert.assertFalse((boolean)((AppendRowsResponse)response3.get()).getAppendResult().hasOffset());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"-9000000", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"2020-10-01T12:00:00", (Object)currentRow.get(2).getStringValue());
            Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ddd", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
        }
    }

    @Test
    public void testComplicateSchemaWithPendingStream() throws IOException, InterruptedException, ExecutionException {
        LOG.info("Create a write stream");
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId2).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.PENDING).build()).build());
        FinalizeWriteStreamResponse finalizeResponse = FinalizeWriteStreamResponse.getDefaultInstance();
        try (StreamWriterV2 streamWriter = StreamWriterV2.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.ComplicateType.getDescriptor())).build();){
            LOG.info("Sending two messages");
            ApiFuture response = streamWriter.append(this.CreateProtoRowsComplex(new String[]{"aaa"}), 0L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
            ApiFuture response2 = streamWriter.append(this.CreateProtoRowsComplex(new String[]{"bbb"}), 1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
            TableResult result = bigquery.listTableData(tableInfo2.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
            LOG.info("Finalize a write stream");
            finalizeResponse = client.finalizeWriteStream(FinalizeWriteStreamRequest.newBuilder().setName(writeStream.getName()).build());
            ApiFuture response3 = streamWriter.append(this.CreateProtoRows(new String[]{"ccc"}), 2L);
            try {
                response3.get();
                Assert.fail((String)"Append to finalized stream should fail.");
            }
            catch (Exception expected) {
                LOG.info("Got exception: " + expected.toString());
            }
        }
        Assert.assertEquals((long)2L, (long)finalizeResponse.getRowCount());
        LOG.info("Commit a write stream");
        BatchCommitWriteStreamsResponse batchCommitWriteStreamsResponse = client.batchCommitWriteStreams(BatchCommitWriteStreamsRequest.newBuilder().setParent(tableId2).addWriteStreams(writeStream.getName()).build());
        Assert.assertEquals((Object)true, (Object)batchCommitWriteStreamsResponse.hasCommitTime());
        TableResult queryResult = bigquery.query(QueryJobConfiguration.newBuilder((String)("SELECT * from " + DATASET + '.' + TABLE2)).build(), new BigQuery.JobOption[0]);
        Iterator queryIter = queryResult.getValues().iterator();
        Assert.assertTrue((boolean)queryIter.hasNext());
        Assert.assertEquals((Object)"[FieldValue{attribute=REPEATED, value=[FieldValue{attribute=PRIMITIVE, value=aaa}, FieldValue{attribute=PRIMITIVE, value=aaa}]}]", (Object)((FieldValueList)queryIter.next()).get(1).getRepeatedValue().toString());
        Assert.assertEquals((Object)"[FieldValue{attribute=REPEATED, value=[FieldValue{attribute=PRIMITIVE, value=bbb}, FieldValue{attribute=PRIMITIVE, value=bbb}]}]", (Object)((FieldValueList)queryIter.next()).get(1).getRepeatedValue().toString());
        Assert.assertFalse((boolean)queryIter.hasNext());
    }

    @Test
    public void testStreamError() throws IOException, InterruptedException, ExecutionException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriterV2 streamWriter = StreamWriterV2.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();){
            ApiFuture response = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
            ApiFuture response2 = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), 100L);
            try {
                response2.get();
                Assert.fail((String)"Should fail");
            }
            catch (ExecutionException e) {
                Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"OUT_OF_RANGE: The offset is beyond stream, expected offset 1, received 100");
            }
            ApiFuture response3 = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), -1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
        }
    }

    @Test
    public void testStreamReconnect() throws IOException, InterruptedException, ExecutionException {
        ApiFuture response;
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriterV2 streamWriter = StreamWriterV2.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();){
            response = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), 0L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
        }
        streamWriter = StreamWriterV2.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();
        try {
            Thread.sleep(5000L);
            response = streamWriter.append(this.CreateProtoRows(new String[]{"bbb"}), 1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
        }
        finally {
            if (streamWriter != null) {
                streamWriter.close();
            }
        }
    }
}

